/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.introduce;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.idea.analysis.AnalyzerUtilKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.refactoring.introduce.ExtractableSubstringInfo;
import org.jetbrains.kotlin.idea.refactoring.introduce.ExtractableSubstringInfoKt;
import org.jetbrains.kotlin.idea.resolve.FrontendServiceHelpersKt;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u001eJ\u0006\u0010%\u001a\u00020&J\u0010\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\u0006H\u0002R\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\rR\u0011\u0010\u0019\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\rR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/introduce/ExtractableSubstringInfo;", "", "startEntry", "Lorg/jetbrains/kotlin/psi/KtStringTemplateEntry;", "endEntry", "prefix", "", "suffix", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/psi/KtStringTemplateEntry;Lorg/jetbrains/kotlin/psi/KtStringTemplateEntry;Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/kotlin/types/KotlinType;)V", "content", "getContent", "()Ljava/lang/String;", "contentRange", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/TextRange;", "getContentRange", "()Lcom/intellij/openapi/util/TextRange;", "getEndEntry", "()Lorg/jetbrains/kotlin/psi/KtStringTemplateEntry;", "entries", "Lkotlin/sequences/Sequence;", "getEntries", "()Lkotlin/sequences/Sequence;", "getPrefix", "relativeContentRange", "getRelativeContentRange", "getStartEntry", "getSuffix", "template", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "getTemplate", "()Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "getType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "copy", "newTemplate", "createExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "guessLiteralType", "literal", "ide-common"})
public final class ExtractableSubstringInfo {
    @NotNull
    private final KtStringTemplateEntry startEntry;
    @NotNull
    private final KtStringTemplateEntry endEntry;
    @NotNull
    private final String prefix;
    @NotNull
    private final String suffix;
    @NotNull
    private final KtStringTemplateExpression template;
    @NotNull
    private final String content;
    @NotNull
    private final KotlinType type;

    /*
     * WARNING - void declaration
     */
    public ExtractableSubstringInfo(@NotNull KtStringTemplateEntry startEntry, @NotNull KtStringTemplateEntry endEntry, @NotNull String prefix, @NotNull String suffix, @Nullable KotlinType type2) {
        void $this$content_u24lambda_u2d0;
        Intrinsics.checkNotNullParameter(startEntry, "startEntry");
        Intrinsics.checkNotNullParameter(endEntry, "endEntry");
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        Intrinsics.checkNotNullParameter(suffix, "suffix");
        this.startEntry = startEntry;
        this.endEntry = endEntry;
        this.prefix = prefix;
        this.suffix = suffix;
        Object object = this.startEntry.getParent();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtStringTemplateExpression");
        }
        this.template = (KtStringTemplateExpression)object;
        object = SequencesKt.joinToString$default(SequencesKt.map(this.getEntries(), content.1.INSTANCE), "", null, null, 0, null, null, 62, null);
        boolean bl = false;
        boolean bl2 = false;
        Object object2 = object;
        ExtractableSubstringInfo extractableSubstringInfo = this;
        boolean bl3 = false;
        void var11_12 = $this$content_u24lambda_u2d0;
        int n = this.getPrefix().length();
        int n2 = $this$content_u24lambda_u2d0.length() - this.getSuffix().length();
        boolean bl4 = false;
        void v0 = var11_12;
        if (v0 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = v0.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue(string2, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string3 = string2;
        extractableSubstringInfo.content = string3;
        object = type2;
        this.type = object == null ? this.guessLiteralType(this.content) : object;
    }

    public /* synthetic */ ExtractableSubstringInfo(KtStringTemplateEntry ktStringTemplateEntry, KtStringTemplateEntry ktStringTemplateEntry2, String string2, String string3, KotlinType kotlinType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            kotlinType = null;
        }
        this(ktStringTemplateEntry, ktStringTemplateEntry2, string2, string3, kotlinType);
    }

    @NotNull
    public final KtStringTemplateEntry getStartEntry() {
        return this.startEntry;
    }

    @NotNull
    public final KtStringTemplateEntry getEndEntry() {
        return this.endEntry;
    }

    @NotNull
    public final String getPrefix() {
        return this.prefix;
    }

    @NotNull
    public final String getSuffix() {
        return this.suffix;
    }

    private final KotlinType guessLiteralType(String literal) {
        ResolutionFacade facade = ResolutionUtils.getResolutionFacade(this.template);
        ModuleDescriptor module2 = facade.getModuleDescriptor();
        SimpleType simpleType2 = module2.getBuiltIns().getStringType();
        Intrinsics.checkNotNullExpressionValue(simpleType2, "module.builtIns.stringType");
        SimpleType stringType = simpleType2;
        if (!Intrinsics.areEqual(this.startEntry, this.endEntry) || !(this.startEntry instanceof KtLiteralStringTemplateEntry)) {
            return stringType;
        }
        KtExpression ktExpression = KtPsiFactoryKt.KtPsiFactory$default(this.startEntry, false, 2, null).createExpressionIfPossible(literal);
        if (ktExpression == null) {
            return stringType;
        }
        KtExpression expr = ktExpression;
        BindingContext context2 = facade.analyze(this.template, BodyResolveMode.PARTIAL);
        LexicalScope scope2 = ScopeUtils.getResolutionScope(this.template, context2, facade);
        BindingContext tempContext = AnalyzerUtilKt.analyzeInContext$default(expr, scope2, this.template, null, null, null, false, null, null, 252, null);
        DelegatingBindingTrace trace = new DelegatingBindingTrace(tempContext, "Evaluate '" + literal + '\'', false, null, false, null, 60, null);
        LanguageVersionSettings languageVersionSettings = FrontendServiceHelpersKt.getLanguageVersionSettings(facade);
        CompileTimeConstant value2 = ConstantExpressionEvaluator.evaluateExpression$default(new ConstantExpressionEvaluator(module2, languageVersionSettings, facade.getProject()), expr, trace, null, 4, null);
        if (value2 == null || value2.isError()) {
            return stringType;
        }
        SimpleType simpleType3 = TypeUtils.NO_EXPECTED_TYPE;
        Intrinsics.checkNotNullExpressionValue(simpleType3, "NO_EXPECTED_TYPE");
        return value2.toConstantValue(simpleType3).getType(module2);
    }

    @NotNull
    public final KtStringTemplateExpression getTemplate() {
        return this.template;
    }

    @NotNull
    public final String getContent() {
        return this.content;
    }

    @NotNull
    public final KotlinType getType() {
        return this.type;
    }

    @NotNull
    public final TextRange getContentRange() {
        return new TextRange(PsiUtilsKt.getStartOffset(this.startEntry) + this.prefix.length(), PsiUtilsKt.getEndOffset(this.endEntry) - this.suffix.length());
    }

    @NotNull
    public final TextRange getRelativeContentRange() {
        TextRange textRange = this.getContentRange().shiftRight(-PsiUtilsKt.getStartOffset(this.template));
        Intrinsics.checkNotNullExpressionValue(textRange, "contentRange.shiftRight(-template.startOffset)");
        return textRange;
    }

    @NotNull
    public final Sequence<KtStringTemplateEntry> getEntries() {
        return SequencesKt.generateSequence(this.startEntry, (Function1)new Function1<KtStringTemplateEntry, KtStringTemplateEntry>(this){
            final /* synthetic */ ExtractableSubstringInfo this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final KtStringTemplateEntry invoke(@NotNull KtStringTemplateEntry it) {
                KtStringTemplateEntry ktStringTemplateEntry;
                Intrinsics.checkNotNullParameter(it, "it");
                if (!Intrinsics.areEqual(it, this.this$0.getEndEntry())) {
                    PsiElement $this$nextSiblingOfSameType$iv = it;
                    boolean $i$f$nextSiblingOfSameType = false;
                    ktStringTemplateEntry = PsiTreeUtil.getNextSiblingOfType($this$nextSiblingOfSameType$iv, KtStringTemplateEntry.class);
                } else {
                    ktStringTemplateEntry = null;
                }
                return ktStringTemplateEntry;
            }
        });
    }

    @NotNull
    public final KtExpression createExpression() {
        String quote = this.template.getFirstChild().getText();
        String literalValue = KotlinBuiltIns.isString(this.type) ? quote + this.content + quote : this.content;
        KtExpression ktExpression = KtPsiFactoryKt.KtPsiFactory$default(this.startEntry, false, 2, null).createExpression(literalValue);
        boolean bl = false;
        boolean bl2 = false;
        KtExpression $this$createExpression_u24lambda_u2d1 = ktExpression;
        boolean bl3 = false;
        ExtractableSubstringInfoKt.setExtractableSubstringInfo($this$createExpression_u24lambda_u2d1, this);
        return ktExpression;
    }

    @NotNull
    public final ExtractableSubstringInfo copy(@NotNull KtStringTemplateExpression newTemplate) {
        Intrinsics.checkNotNullParameter(newTemplate, "newTemplate");
        KtStringTemplateEntry[] ktStringTemplateEntryArray = this.template.getEntries();
        Intrinsics.checkNotNullExpressionValue(ktStringTemplateEntryArray, "template.entries");
        KtStringTemplateEntry[] oldEntries = ktStringTemplateEntryArray;
        KtStringTemplateEntry[] ktStringTemplateEntryArray2 = newTemplate.getEntries();
        Intrinsics.checkNotNullExpressionValue(ktStringTemplateEntryArray2, "newTemplate.entries");
        KtStringTemplateEntry[] newEntries = ktStringTemplateEntryArray2;
        int startIndex = ArraysKt.indexOf(oldEntries, this.startEntry);
        int endIndex = ArraysKt.indexOf(oldEntries, this.endEntry);
        if (startIndex < 0 || startIndex >= newEntries.length || endIndex < 0 || endIndex >= newEntries.length) {
            throw new AssertionError((Object)("Old template(" + startIndex + ".." + endIndex + "): " + this.template.getText() + ", new template: " + newTemplate.getText()));
        }
        KtStringTemplateEntry ktStringTemplateEntry = newEntries[startIndex];
        Intrinsics.checkNotNullExpressionValue(ktStringTemplateEntry, "newEntries[startIndex]");
        KtStringTemplateEntry ktStringTemplateEntry2 = ktStringTemplateEntry;
        ktStringTemplateEntry = newEntries[endIndex];
        Intrinsics.checkNotNullExpressionValue(ktStringTemplateEntry, "newEntries[endIndex]");
        return new ExtractableSubstringInfo(ktStringTemplateEntry2, ktStringTemplateEntry, this.prefix, this.suffix, this.type);
    }
}

