/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.ICReporter;
import org.jetbrains.kotlin.incremental.BuildUtilKt;
import org.jetbrains.kotlin.incremental.FileUtilsKt;
import org.jetbrains.kotlin.incremental.IncrementalCacheCommon;
import org.jetbrains.kotlin.incremental.IncrementalCachesManager;
import org.jetbrains.kotlin.incremental.LookupSymbol;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\u0018\u00002\u00020\u0001B'\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\bJ\u0014\u0010\u0013\u001a\u00020\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J\u0014\u0010\u0017\u001a\u00020\u000f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0015J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u001bR\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/incremental/DirtyFilesContainer;", "", "caches", "Lorg/jetbrains/kotlin/incremental/IncrementalCachesManager;", "reporter", "Lorg/jetbrains/kotlin/build/report/ICReporter;", "sourceFilesExtensions", "", "", "(Lorg/jetbrains/kotlin/incremental/IncrementalCachesManager;Lorg/jetbrains/kotlin/build/report/ICReporter;Ljava/util/List;)V", "myDirtyFiles", "Ljava/util/HashSet;", "Ljava/io/File;", "Lkotlin/collections/HashSet;", "add", "", "files", "", "reason", "addByDirtyClasses", "dirtyClassesFqNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "addByDirtySymbols", "lookupSymbols", "Lorg/jetbrains/kotlin/incremental/LookupSymbol;", "toMutableList", "", "incremental-compilation-impl"})
public final class DirtyFilesContainer {
    @NotNull
    private final IncrementalCachesManager<?> caches;
    @NotNull
    private final ICReporter reporter;
    @NotNull
    private final List<String> sourceFilesExtensions;
    @NotNull
    private final HashSet<File> myDirtyFiles;

    public DirtyFilesContainer(@NotNull IncrementalCachesManager<?> caches, @NotNull ICReporter reporter2, @NotNull List<String> sourceFilesExtensions) {
        Intrinsics.checkNotNullParameter(caches, "caches");
        Intrinsics.checkNotNullParameter(reporter2, "reporter");
        Intrinsics.checkNotNullParameter(sourceFilesExtensions, "sourceFilesExtensions");
        this.caches = caches;
        this.reporter = reporter2;
        this.sourceFilesExtensions = sourceFilesExtensions;
        this.myDirtyFiles = new HashSet();
    }

    @NotNull
    public final List<File> toMutableList() {
        return new ArrayList(this.myDirtyFiles);
    }

    /*
     * WARNING - void declaration
     */
    public final void add(@NotNull Iterable<? extends File> files2, @Nullable String reason) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(files2, "files");
        Iterable<? extends File> $this$filter$iv = files2;
        boolean $i$f$filter = false;
        Iterable<? extends File> iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!FileUtilsKt.isKotlinFile(it, this.sourceFilesExtensions)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List existingKotlinFiles = (List)destination$iv$iv;
        Collection collection = existingKotlinFiles;
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.myDirtyFiles.addAll(existingKotlinFiles);
            if (reason != null) {
                this.reporter.reportMarkDirty(existingKotlinFiles, reason);
            }
        }
    }

    public final void addByDirtySymbols(@NotNull Collection<LookupSymbol> lookupSymbols) {
        Intrinsics.checkNotNullParameter(lookupSymbols, "lookupSymbols");
        if (lookupSymbols.isEmpty()) {
            return;
        }
        Set dirtyFilesFromLookups = BuildUtilKt.mapLookupSymbolsToFiles$default(this.caches.getLookupCache(), lookupSymbols, this.reporter, null, 8, null);
        this.add(dirtyFilesFromLookups, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void addByDirtyClasses(@NotNull Collection<FqName> dirtyClassesFqNames) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(dirtyClassesFqNames, "dirtyClassesFqNames");
        if (dirtyClassesFqNames.isEmpty()) {
            return;
        }
        Iterable $this$flatMap$iv = dirtyClassesFqNames;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            FqName it = (FqName)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = BuildUtilKt.withSubtypes(it, (Iterable<? extends IncrementalCacheCommon>)CollectionsKt.listOf(this.caches.getPlatformCache()));
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List fqNamesWithSubtypes = (List)destination$iv$iv;
        Set dirtyFilesFromFqNames = BuildUtilKt.mapClassesFqNamesToFiles$default(CollectionsKt.listOf(this.caches.getPlatformCache()), fqNamesWithSubtypes, this.reporter, null, 8, null);
        this.add(dirtyFilesFromFqNames, null);
    }
}

