/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.UnsignedTypes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImpl;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImplKt;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0002\u001a\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u00102\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\f\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u0013\u001a\u001c\u0010\u0014\u001a\u00020\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0001H\u0002\u001a\n\u0010\u001a\u001a\u00020\u0015*\u00020\u0016\u001a\n\u0010\u001a\u001a\u00020\u0015*\u00020\u0013\u001a\n\u0010\u001b\u001a\u00020\u0015*\u00020\u0013\u001a\n\u0010\u001c\u001a\u00020\u0015*\u00020\u0013\u001a\n\u0010\u001d\u001a\u00020\u0015*\u00020\u0013\u001a\n\u0010\u001e\u001a\u00020\u0015*\u00020\u0016\u001a\n\u0010\u001e\u001a\u00020\u0015*\u00020\u0013\u001a\n\u0010\u001f\u001a\u00020\u0015*\u00020\u0016\u001a\n\u0010\u001f\u001a\u00020\u0015*\u00020\u0013\u001a\n\u0010 \u001a\u00020\u0015*\u00020\u0013\u001a\n\u0010!\u001a\u00020\u0015*\u00020\u0013\u001a\n\u0010\"\u001a\u00020\u0015*\u00020\u0013\u001a\n\u0010#\u001a\u00020\u0015*\u00020\u0013\u001a\n\u0010$\u001a\u00020\u0015*\u00020\u0013\u001a!\u0010%\u001a\u00020\u0015*\u00020\u00132\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\u00150'H\u0082\b\u001a\n\u0010)\u001a\u00020\u0015*\u00020\u0013\u001a\n\u0010*\u001a\u00020\u0015*\u00020\u0013\u001a&\u0010+\u001a\u00020\u0013*\u00020\u00132\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u00102\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010\u001a\u001e\u0010+\u001a\u00020\u0013*\u00020\u00132\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020\u001300\u001a\u0010\u00102\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010*\u00020\u0013\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"kotlinCoroutinesPackageFqn", "Lorg/jetbrains/kotlin/name/FqName;", "kotlinPackageFqn", "getKotlinPackageFqn", "()Lorg/jetbrains/kotlin/name/FqName;", "kotlinReflectionPackageFqn", "collectAllSupertypes", "", "irType", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "result", "", "getAllSubstitutedSupertypes", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getImmediateSupertypes", "", "getPrimitiveArrayElementType", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isClassWithNamePrefix", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "prefix", "", "packageFqName", "isFunction", "isFunctionOrKFunction", "isFunctionTypeOrSubtype", "isInterface", "isKFunction", "isKSuspendFunction", "isPrimitiveArray", "isSuspendFunction", "isSuspendFunctionOrKFunction", "isSuspendFunctionTypeOrSubtype", "isThrowable", "isTypeFromKotlinPackage", "namePredicate", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/Name;", "isTypeParameter", "isUnsigned", "substitute", "params", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "arguments", "substitutionMap", "", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "superTypes", "ir.backend.common"})
public final class IrTypeUtilsKt {
    @NotNull
    private static final FqName kotlinPackageFqn;
    @NotNull
    private static final FqName kotlinReflectionPackageFqn;
    @NotNull
    private static final FqName kotlinCoroutinesPackageFqn;

    @NotNull
    public static final FqName getKotlinPackageFqn() {
        return kotlinPackageFqn;
    }

    public static final boolean isFunction(@NotNull IrType $this$isFunction) {
        Intrinsics.checkNotNullParameter($this$isFunction, "<this>");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$isFunction);
        return Intrinsics.areEqual(irClassifierSymbol == null ? null : Boolean.valueOf(IrTypeUtilsKt.isClassWithNamePrefix(irClassifierSymbol, "Function", kotlinPackageFqn)), true);
    }

    public static final boolean isKFunction(@NotNull IrType $this$isKFunction) {
        Intrinsics.checkNotNullParameter($this$isKFunction, "<this>");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$isKFunction);
        return Intrinsics.areEqual(irClassifierSymbol == null ? null : Boolean.valueOf(IrTypeUtilsKt.isClassWithNamePrefix(irClassifierSymbol, "KFunction", kotlinReflectionPackageFqn)), true);
    }

    public static final boolean isSuspendFunction(@NotNull IrType $this$isSuspendFunction) {
        Intrinsics.checkNotNullParameter($this$isSuspendFunction, "<this>");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$isSuspendFunction);
        return Intrinsics.areEqual(irClassifierSymbol == null ? null : Boolean.valueOf(IrTypeUtilsKt.isClassWithNamePrefix(irClassifierSymbol, "SuspendFunction", kotlinCoroutinesPackageFqn)), true);
    }

    public static final boolean isKSuspendFunction(@NotNull IrType $this$isKSuspendFunction) {
        Intrinsics.checkNotNullParameter($this$isKSuspendFunction, "<this>");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$isKSuspendFunction);
        return Intrinsics.areEqual(irClassifierSymbol == null ? null : Boolean.valueOf(IrTypeUtilsKt.isClassWithNamePrefix(irClassifierSymbol, "KSuspendFunction", kotlinReflectionPackageFqn)), true);
    }

    public static final boolean isFunction(@NotNull IrClassifierSymbol $this$isFunction) {
        Intrinsics.checkNotNullParameter($this$isFunction, "<this>");
        return IrTypeUtilsKt.isClassWithNamePrefix($this$isFunction, "Function", kotlinPackageFqn);
    }

    public static final boolean isKFunction(@NotNull IrClassifierSymbol $this$isKFunction) {
        Intrinsics.checkNotNullParameter($this$isKFunction, "<this>");
        return IrTypeUtilsKt.isClassWithNamePrefix($this$isKFunction, "KFunction", kotlinReflectionPackageFqn);
    }

    public static final boolean isKSuspendFunction(@NotNull IrClassifierSymbol $this$isKSuspendFunction) {
        Intrinsics.checkNotNullParameter($this$isKSuspendFunction, "<this>");
        return IrTypeUtilsKt.isClassWithNamePrefix($this$isKSuspendFunction, "KSuspendFunction", kotlinReflectionPackageFqn);
    }

    private static final boolean isClassWithNamePrefix(IrClassifierSymbol $this$isClassWithNamePrefix, String prefix, FqName packageFqName) {
        IrPackageFragment irPackageFragment;
        IrDeclarationWithName declaration2 = (IrDeclarationWithName)((Object)$this$isClassWithNamePrefix.getOwner());
        String string2 = declaration2.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "declaration.name.asString()");
        String name2 = string2;
        if (!StringsKt.startsWith$default(name2, prefix, false, 2, null)) {
            return false;
        }
        IrDeclarationParent irDeclarationParent = declaration2.getParent();
        IrPackageFragment irPackageFragment2 = irPackageFragment = irDeclarationParent instanceof IrPackageFragment ? (IrPackageFragment)irDeclarationParent : null;
        if (irPackageFragment == null) {
            return false;
        }
        IrPackageFragment parent2 = irPackageFragment;
        return Intrinsics.areEqual(parent2.getFqName(), packageFqName);
    }

    @NotNull
    public static final List<IrType> superTypes(@NotNull IrType $this$superTypes) {
        Intrinsics.checkNotNullParameter($this$superTypes, "<this>");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$superTypes);
        List<IrType> list2 = irClassifierSymbol == null ? null : org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.superTypes(irClassifierSymbol);
        return list2 == null ? CollectionsKt.emptyList() : list2;
    }

    public static final boolean isFunctionTypeOrSubtype(@NotNull IrType $this$isFunctionTypeOrSubtype) {
        Intrinsics.checkNotNullParameter($this$isFunctionTypeOrSubtype, "<this>");
        Boolean bl = DFS.ifAny((Collection)CollectionsKt.listOf($this$isFunctionTypeOrSubtype), isFunctionTypeOrSubtype.1.INSTANCE, isFunctionTypeOrSubtype.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(bl, "ifAny(listOf(this), IrType::superTypes, IrType::isFunction)");
        return bl;
    }

    public static final boolean isSuspendFunctionTypeOrSubtype(@NotNull IrType $this$isSuspendFunctionTypeOrSubtype) {
        Intrinsics.checkNotNullParameter($this$isSuspendFunctionTypeOrSubtype, "<this>");
        Boolean bl = DFS.ifAny((Collection)CollectionsKt.listOf($this$isSuspendFunctionTypeOrSubtype), isSuspendFunctionTypeOrSubtype.1.INSTANCE, isSuspendFunctionTypeOrSubtype.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(bl, "ifAny(listOf(this), IrType::superTypes, IrType::isSuspendFunction)");
        return bl;
    }

    public static final boolean isTypeParameter(@NotNull IrType $this$isTypeParameter) {
        Intrinsics.checkNotNullParameter($this$isTypeParameter, "<this>");
        return IrTypesKt.getClassifierOrNull($this$isTypeParameter) instanceof IrTypeParameterSymbol;
    }

    public static final boolean isInterface(@NotNull IrType $this$isInterface) {
        IrClass irClass2;
        Intrinsics.checkNotNullParameter($this$isInterface, "<this>");
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull($this$isInterface);
        return (irClassSymbol == null ? null : ((irClass2 = (IrClass)irClassSymbol.getOwner()) == null ? null : irClass2.getKind())) == ClassKind.INTERFACE;
    }

    public static final boolean isFunctionOrKFunction(@NotNull IrType $this$isFunctionOrKFunction) {
        Intrinsics.checkNotNullParameter($this$isFunctionOrKFunction, "<this>");
        return IrTypeUtilsKt.isFunction($this$isFunctionOrKFunction) || IrTypeUtilsKt.isKFunction($this$isFunctionOrKFunction);
    }

    public static final boolean isSuspendFunctionOrKFunction(@NotNull IrType $this$isSuspendFunctionOrKFunction) {
        Intrinsics.checkNotNullParameter($this$isSuspendFunctionOrKFunction, "<this>");
        return IrTypeUtilsKt.isSuspendFunction($this$isSuspendFunctionOrKFunction) || IrTypeUtilsKt.isKSuspendFunction($this$isSuspendFunctionOrKFunction);
    }

    public static final boolean isThrowable(@NotNull IrType $this$isThrowable) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isThrowable, "<this>");
        IrType $this$isTypeFromKotlinPackage$iv = $this$isThrowable;
        boolean $i$f$isTypeFromKotlinPackage = false;
        if ($this$isTypeFromKotlinPackage$iv instanceof IrSimpleType) {
            IrClassSymbol irClassSymbol;
            Object object = ((IrSimpleType)$this$isTypeFromKotlinPackage$iv).getClassifier();
            IrClassSymbol irClassSymbol2 = irClassSymbol = object instanceof IrClassSymbol ? (IrClassSymbol)object : null;
            if (irClassSymbol == null) {
                bl = false;
            } else {
                IrClassSymbol classClassifier$iv = irClassSymbol;
                Name name2 = ((IrClass)classClassifier$iv.getOwner()).getName();
                boolean bl2 = false;
                if (!Intrinsics.areEqual(name2.asString(), "Throwable")) {
                    bl = false;
                } else {
                    IrDeclarationParent irDeclarationParent = ((IrClass)classClassifier$iv.getOwner()).getParent();
                    Object object2 = object = irDeclarationParent instanceof IrPackageFragment ? (IrPackageFragment)irDeclarationParent : null;
                    if (object == null) {
                        bl = false;
                    } else {
                        Object parent$iv = object;
                        bl = Intrinsics.areEqual(((IrPackageFragment)parent$iv).getFqName(), IrTypeUtilsKt.getKotlinPackageFqn());
                    }
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isUnsigned(@NotNull IrType $this$isUnsigned) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isUnsigned, "<this>");
        IrType $this$isTypeFromKotlinPackage$iv = $this$isUnsigned;
        boolean $i$f$isTypeFromKotlinPackage = false;
        if ($this$isTypeFromKotlinPackage$iv instanceof IrSimpleType) {
            IrClassSymbol irClassSymbol;
            Object object = ((IrSimpleType)$this$isTypeFromKotlinPackage$iv).getClassifier();
            IrClassSymbol irClassSymbol2 = irClassSymbol = object instanceof IrClassSymbol ? (IrClassSymbol)object : null;
            if (irClassSymbol == null) {
                bl = false;
            } else {
                IrClassSymbol classClassifier$iv = irClassSymbol;
                Name name2 = ((IrClass)classClassifier$iv.getOwner()).getName();
                boolean bl2 = false;
                if (!UnsignedTypes.INSTANCE.isShortNameOfUnsignedType(name2)) {
                    bl = false;
                } else {
                    IrDeclarationParent irDeclarationParent = ((IrClass)classClassifier$iv.getOwner()).getParent();
                    Object object2 = object = irDeclarationParent instanceof IrPackageFragment ? (IrPackageFragment)irDeclarationParent : null;
                    if (object == null) {
                        bl = false;
                    } else {
                        Object parent$iv = object;
                        bl = Intrinsics.areEqual(((IrPackageFragment)parent$iv).getFqName(), IrTypeUtilsKt.getKotlinPackageFqn());
                    }
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isPrimitiveArray(@NotNull IrType $this$isPrimitiveArray) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isPrimitiveArray, "<this>");
        IrType $this$isTypeFromKotlinPackage$iv = $this$isPrimitiveArray;
        boolean $i$f$isTypeFromKotlinPackage = false;
        if ($this$isTypeFromKotlinPackage$iv instanceof IrSimpleType) {
            IrClassSymbol irClassSymbol;
            Object object = ((IrSimpleType)$this$isTypeFromKotlinPackage$iv).getClassifier();
            IrClassSymbol irClassSymbol2 = irClassSymbol = object instanceof IrClassSymbol ? (IrClassSymbol)object : null;
            if (irClassSymbol == null) {
                bl = false;
            } else {
                IrClassSymbol classClassifier$iv = irClassSymbol;
                Name it = ((IrClass)classClassifier$iv.getOwner()).getName();
                boolean bl2 = false;
                if (!StandardNames.FqNames.primitiveArrayTypeShortNames.contains(it)) {
                    bl = false;
                } else {
                    IrDeclarationParent irDeclarationParent = ((IrClass)classClassifier$iv.getOwner()).getParent();
                    Object object2 = object = irDeclarationParent instanceof IrPackageFragment ? (IrPackageFragment)irDeclarationParent : null;
                    if (object == null) {
                        bl = false;
                    } else {
                        Object parent$iv = object;
                        bl = Intrinsics.areEqual(((IrPackageFragment)parent$iv).getFqName(), IrTypeUtilsKt.getKotlinPackageFqn());
                    }
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public static final PrimitiveType getPrimitiveArrayElementType(@NotNull IrType $this$getPrimitiveArrayElementType) {
        PrimitiveType primitiveType;
        IrSimpleType irSimpleType;
        Intrinsics.checkNotNullParameter($this$getPrimitiveArrayElementType, "<this>");
        IrSimpleType irSimpleType2 = irSimpleType = $this$getPrimitiveArrayElementType instanceof IrSimpleType ? (IrSimpleType)$this$getPrimitiveArrayElementType : null;
        if (irSimpleType == null) {
            primitiveType = null;
        } else {
            FqName fqName2;
            IrSimpleType irSimpleType3 = irSimpleType;
            boolean bl = false;
            boolean bl2 = false;
            IrSimpleType it = irSimpleType3;
            boolean bl3 = false;
            Object object = it.getClassifier().getOwner();
            Object object2 = object instanceof IrClass ? (IrClass)object : null;
            FqName fqName3 = fqName2 = object2 == null ? null : IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)object2);
            if (fqName2 == null) {
                primitiveType = null;
            } else {
                object2 = fqName2.toUnsafe();
                if (object2 == null) {
                    primitiveType = null;
                } else {
                    object = object2;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Object fqn = object;
                    boolean bl6 = false;
                    primitiveType = StandardNames.FqNames.arrayClassFqNameToPrimitiveType.get(fqn);
                }
            }
        }
        return primitiveType;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IrType substitute(@NotNull IrType $this$substitute, @NotNull List<? extends IrTypeParameter> params, @NotNull List<? extends IrType> arguments2) {
        Collection<IrTypeParameterSymbol> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter($this$substitute, "<this>");
        Intrinsics.checkNotNullParameter(params, "params");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Iterable iterable = params;
        IrType irType = $this$substitute;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrTypeParameter irTypeParameter2 = (IrTypeParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            IrTypeParameterSymbol irTypeParameterSymbol = (IrTypeParameterSymbol)it.getSymbol();
            collection.add(irTypeParameterSymbol);
        }
        collection = (List)destination$iv$iv;
        return IrTypeUtilsKt.substitute(irType, MapsKt.toMap(CollectionsKt.zip((Iterable)collection, (Iterable)arguments2)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IrType substitute(@NotNull IrType $this$substitute, @NotNull Map<IrTypeParameterSymbol, ? extends IrType> substitutionMap) {
        void $this$mapTo$iv$iv;
        IrConstructorCall irConstructorCall;
        Collection collection;
        IrClassifierSymbol $this$mapTo$iv$iv22;
        Intrinsics.checkNotNullParameter($this$substitute, "<this>");
        Intrinsics.checkNotNullParameter(substitutionMap, "substitutionMap");
        if (!($this$substitute instanceof IrSimpleType) || substitutionMap.isEmpty()) {
            return $this$substitute;
        }
        Object $this$map$iv = $this$substitute.getAnnotations();
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv322 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv22.iterator();
        while (iterator2.hasNext()) {
            void p1;
            void p0;
            void it;
            Object item$iv$iv = iterator2.next();
            IrConstructorCall irConstructorCall2 = (IrConstructorCall)item$iv$iv;
            collection = destination$iv$iv322;
            boolean bl = false;
            IrElement $this$deepCopyWithSymbols_u24default$iv = (IrElement)it;
            IrDeclarationParent initialParent$iv = null;
            boolean $i$f$deepCopyWithSymbols = false;
            DeepCopySymbolRemapper symbolRemapper$iv = new DeepCopySymbolRemapper(null, 1, null);
            IrElementVisitorVoidKt.acceptVoid($this$deepCopyWithSymbols_u24default$iv, symbolRemapper$iv);
            DeepCopyTypeRemapper typeRemapper$iv = new DeepCopyTypeRemapper(symbolRemapper$iv);
            TypeRemapper typeRemapper = typeRemapper$iv;
            SymbolRemapper symbolRemapper = symbolRemapper$iv;
            IrElement irElement = $this$deepCopyWithSymbols_u24default$iv;
            DeepCopyIrTreeWithSymbols deepCopyIrTreeWithSymbols = new DeepCopyIrTreeWithSymbols((SymbolRemapper)p0, (TypeRemapper)p1);
            IrElement irElement2 = PatchDeclarationParentsKt.patchDeclarationParents(irElement.transform(deepCopyIrTreeWithSymbols, null), initialParent$iv);
            if (irElement2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConstructorCall");
            }
            irConstructorCall = (IrConstructorCall)((IrElement)((IrConstructorCall)irElement2));
            collection.add(irConstructorCall);
        }
        List newAnnotations = (List)destination$iv$iv322;
        Object $i$f$map22 = substitutionMap;
        $this$mapTo$iv$iv22 = ((IrSimpleType)$this$substitute).getClassifier();
        boolean destination$iv$iv322 = false;
        $this$map$iv = $i$f$map22.get($this$mapTo$iv$iv22);
        if ($this$map$iv != null) {
            $i$f$map22 = $this$map$iv;
            boolean $this$mapTo$iv$iv22 = false;
            destination$iv$iv322 = false;
            Object substitutedType = $i$f$map22;
            boolean bl = false;
            return IrTypesKt.addAnnotations(IrTypesKt.withHasQuestionMark((IrType)substitutedType, ((IrSimpleType)$this$substitute).getHasQuestionMark() || substitutedType instanceof IrSimpleType && ((IrSimpleType)substitutedType).getHasQuestionMark()), newAnnotations);
        }
        Iterable $this$map$iv2 = ((IrSimpleType)$this$substitute).getArguments();
        boolean $i$f$map = false;
        Iterable destination$iv$iv322 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrTypeArgument bl = (IrTypeArgument)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            irConstructorCall = it instanceof IrTypeProjection ? (IrTypeArgument)IrSimpleTypeImplKt.makeTypeProjection(IrTypeUtilsKt.substitute(((IrTypeProjection)it).getType(), substitutionMap), ((IrTypeProjection)it).getVariance()) : it;
            collection.add(irConstructorCall);
        }
        List newArguments2 = (List)destination$iv$iv;
        return new IrSimpleTypeImpl(((IrSimpleType)$this$substitute).getClassifier(), ((IrSimpleType)$this$substitute).getHasQuestionMark(), newArguments2, newAnnotations, null, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<IrSimpleType> getImmediateSupertypes(IrSimpleType irType) {
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        IrType irType2;
        IrType it;
        Collection collection;
        void $this$mapTo$iv$iv;
        IrClass irClass2 = IrTypesKt.getClass(irType);
        if (irClass2 == null) {
            throw new AssertionError((Object)Intrinsics.stringPlus("Not a class type: ", RenderIrElementKt.render(irType)));
        }
        IrClass irClass3 = irClass2;
        List<IrType> originalSupertypes = irClass3.getSuperTypes();
        Iterable $this$map$iv = irType.getArguments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            IrType irType3 = IrTypesKt.getTypeOrNull((IrTypeArgument)((Object)it));
            if (irType3 == null) {
                throw new AssertionError((Object)Intrinsics.stringPlus("*-projection in supertype arguments: ", RenderIrElementKt.render(irType)));
            }
            irType2 = irType3;
            collection.add(irType2);
        }
        List arguments2 = (List)destination$iv$iv;
        $this$map$iv = originalSupertypes;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IrType)element$iv$iv;
            boolean bl = false;
            if (!(IrTypesKt.getClassOrNull(it) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void superType;
            it = (IrType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            irType2 = (IrSimpleType)IrTypeUtilsKt.substitute((IrType)superType, irClass3.getTypeParameters(), arguments2);
            collection.add(irType2);
        }
        return (List)destination$iv$iv;
    }

    private static final void collectAllSupertypes(IrSimpleType irType, Set<IrSimpleType> result2) {
        List<IrSimpleType> immediateSupertypes = IrTypeUtilsKt.getImmediateSupertypes(irType);
        result2.addAll((Collection<IrSimpleType>)immediateSupertypes);
        for (IrSimpleType supertype2 : immediateSupertypes) {
            IrTypeUtilsKt.collectAllSupertypes(supertype2, result2);
        }
    }

    @NotNull
    public static final Set<IrSimpleType> getAllSubstitutedSupertypes(@NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        HashSet result2 = new HashSet();
        IrTypeUtilsKt.collectAllSupertypes(IrUtilsKt.getDefaultType(irClass2), result2);
        return result2;
    }

    static {
        FqName fqName2 = FqName.fromSegments(CollectionsKt.listOf("kotlin"));
        Intrinsics.checkNotNullExpressionValue(fqName2, "fromSegments(listOf(\"kotlin\"))");
        kotlinPackageFqn = fqName2;
        fqName2 = kotlinPackageFqn.child(Name.identifier("reflect"));
        Intrinsics.checkNotNullExpressionValue(fqName2, "kotlinPackageFqn.child(Name.identifier(\"reflect\"))");
        kotlinReflectionPackageFqn = fqName2;
        fqName2 = kotlinPackageFqn.child(Name.identifier("coroutines"));
        Intrinsics.checkNotNullExpressionValue(fqName2, "kotlinPackageFqn.child(Name.identifier(\"coroutines\"))");
        kotlinCoroutinesPackageFqn = fqName2;
    }
}

