/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.floats;

import java.io.Serializable;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Arrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Hash;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.floats.FloatComparator;

public final class FloatArrays {
    public static final float[] EMPTY_ARRAY = new float[0];
    public static final float[] DEFAULT_EMPTY_ARRAY = new float[0];
    protected static final Segment POISON_PILL = new Segment(-1, -1, -1);
    public static final Hash.Strategy<float[]> HASH_STRATEGY = new ArrayHashStrategy();

    public static void ensureOffsetLength(float[] a, int offset2, int length) {
        Arrays.ensureOffsetLength(a.length, offset2, length);
    }

    private static void insertionSort(float[] a, int from, int to, FloatComparator comp2) {
        int i = from;
        while (++i < to) {
            float t = a[i];
            int j = i;
            float u = a[j - 1];
            while (comp2.compare(t, u) < 0) {
                a[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }

    private static void insertionSort(float[] a, int from, int to) {
        int i = from;
        while (++i < to) {
            float t = a[i];
            int j = i;
            float u = a[j - 1];
            while (Float.compare(t, u) < 0) {
                a[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }

    public static void mergeSort(float[] a, int from, int to, float[] supp) {
        int len = to - from;
        if (len < 16) {
            FloatArrays.insertionSort(a, from, to);
            return;
        }
        int mid = from + to >>> 1;
        FloatArrays.mergeSort(supp, from, mid, a);
        FloatArrays.mergeSort(supp, mid, to, a);
        if (Float.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, a, from, len);
            return;
        }
        int p = from;
        int q = mid;
        for (int i = from; i < to; ++i) {
            a[i] = q >= to || p < mid && Float.compare(supp[p], supp[q]) <= 0 ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(float[] a, int from, int to) {
        FloatArrays.mergeSort(a, from, to, (float[])a.clone());
    }

    public static void mergeSort(float[] a, int from, int to, FloatComparator comp2, float[] supp) {
        int len = to - from;
        if (len < 16) {
            FloatArrays.insertionSort(a, from, to, comp2);
            return;
        }
        int mid = from + to >>> 1;
        FloatArrays.mergeSort(supp, from, mid, comp2, a);
        FloatArrays.mergeSort(supp, mid, to, comp2, a);
        if (comp2.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, a, from, len);
            return;
        }
        int p = from;
        int q = mid;
        for (int i = from; i < to; ++i) {
            a[i] = q >= to || p < mid && comp2.compare(supp[p], supp[q]) <= 0 ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(float[] a, int from, int to, FloatComparator comp2) {
        FloatArrays.mergeSort(a, from, to, comp2, (float[])a.clone());
    }

    public static void stableSort(float[] a, int from, int to) {
        FloatArrays.mergeSort(a, from, to);
    }

    public static void stableSort(float[] a) {
        FloatArrays.stableSort(a, 0, a.length);
    }

    public static void stableSort(float[] a, int from, int to, FloatComparator comp2) {
        FloatArrays.mergeSort(a, from, to, comp2);
    }

    public static void stableSort(float[] a, FloatComparator comp2) {
        FloatArrays.stableSort(a, 0, a.length, comp2);
    }

    protected static final class Segment {
        protected final int offset;
        protected final int length;
        protected final int level;

        protected Segment(int offset2, int length, int level) {
            this.offset = offset2;
            this.length = length;
            this.level = level;
        }

        public String toString() {
            return "Segment [offset=" + this.offset + ", length=" + this.length + ", level=" + this.level + "]";
        }
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<float[]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(float[] o) {
            return java.util.Arrays.hashCode(o);
        }

        @Override
        public boolean equals(float[] a, float[] b) {
            return java.util.Arrays.equals(a, b);
        }
    }
}

