/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.compiler.plugin.definitions;

import java.util.HashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.api.ResultWithDiagnostics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.definitions.DefinitionsKt;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.ScriptDependenciesProvider;
import org.jetbrains.kotlin.scripting.resolve.KtFileScriptSource;
import org.jetbrains.kotlin.scripting.resolve.RefineCompilationConfigurationKt;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;
import org.jetbrains.kotlin.scripting.resolve.ScriptReportSink;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\t\u0018\u00010\bj\u0004\u0018\u0001`\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\t\u0018\u00010\bj\u0004\u0018\u0001`\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016RF\u0010\u0005\u001a:\u0012\u0004\u0012\u00020\u0007\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\t\u0018\u00010\bj\u0004\u0018\u0001`\n0\u0006j\u001c\u0012\u0004\u0012\u00020\u0007\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\t\u0018\u00010\bj\u0004\u0018\u0001`\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/definitions/CliScriptDependenciesProvider;", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDependenciesProvider;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Ljava/util/HashMap;", "", "Lkotlin/script/experimental/api/ResultWithDiagnostics;", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationWrapper;", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationResult;", "Lkotlin/collections/HashMap;", "cacheLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "calculateRefinedConfiguration", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "getScriptConfigurationResult", "kotlin-scripting-compiler"})
public final class CliScriptDependenciesProvider
extends ScriptDependenciesProvider {
    @NotNull
    private final ReentrantReadWriteLock cacheLock;
    @NotNull
    private final HashMap<String, ResultWithDiagnostics<ScriptCompilationConfigurationWrapper>> cache;

    public CliScriptDependenciesProvider(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull(project, "project");
        super(project);
        this.cacheLock = new ReentrantReadWriteLock();
        boolean bl = false;
        this.cache = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ResultWithDiagnostics<ScriptCompilationConfigurationWrapper> getScriptConfigurationResult(@NotNull KtFile file2) {
        ResultWithDiagnostics<ScriptCompilationConfigurationWrapper> resultWithDiagnostics;
        Intrinsics.checkParameterIsNotNull(file2, "file");
        ReentrantReadWriteLock reentrantReadWriteLock = this.cacheLock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl3 = false;
            resultWithDiagnostics = this.calculateRefinedConfiguration(file2);
        }
        finally {
            readLock.unlock();
        }
        return resultWithDiagnostics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ResultWithDiagnostics<ScriptCompilationConfigurationWrapper> calculateRefinedConfiguration(KtFile file2) {
        ResultWithDiagnostics<ScriptCompilationConfigurationWrapper> resultWithDiagnostics;
        String path2 = file2.getVirtualFilePath();
        ResultWithDiagnostics<ScriptCompilationConfigurationWrapper> cached2 = this.cache.get(path2);
        if (cached2 != null) {
            resultWithDiagnostics = cached2;
        } else {
            ScriptDefinition scriptDef = DefinitionsKt.findScriptDefinition(file2);
            if (scriptDef != null) {
                int n;
                int n2;
                ResultWithDiagnostics<ScriptCompilationConfigurationWrapper> result2 = RefineCompilationConfigurationKt.refineScriptCompilationConfiguration(new KtFileScriptSource(file2, null, 2, null), scriptDef, this.getProject());
                Object object = ServiceManager.getService(this.getProject(), ScriptReportSink.class);
                if (object != null) {
                    VirtualFile virtualFile2 = file2.getVirtualFile();
                    Intrinsics.checkExpressionValueIsNotNull(virtualFile2, "file.virtualFile");
                    object.attachReports(virtualFile2, result2.getReports());
                }
                object = this.cacheLock;
                boolean bl = false;
                boolean bl2 = false;
                ReentrantReadWriteLock.ReadLock readLock = ((ReentrantReadWriteLock)object).readLock();
                int n3 = ((ReentrantReadWriteLock)object).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)object).getReadHoldCount() : 0;
                boolean bl3 = false;
                int n4 = 0;
                n4 = 0;
                int n5 = n3;
                while (n4 < n5) {
                    n2 = n4++;
                    n = 0;
                    readLock.unlock();
                }
                ReentrantReadWriteLock.WriteLock writeLock = ((ReentrantReadWriteLock)object).writeLock();
                writeLock.lock();
                try {
                    boolean bl4 = false;
                    ResultWithDiagnostics<ScriptCompilationConfigurationWrapper> resultWithDiagnostics2 = this.cache.put(path2, result2);
                }
                finally {
                    n5 = 0;
                    n2 = 0;
                    n2 = 0;
                    n = n3;
                    while (n2 < n) {
                        int n6 = n2++;
                        boolean bl5 = false;
                        readLock.lock();
                    }
                    writeLock.unlock();
                }
                resultWithDiagnostics = result2;
            } else {
                resultWithDiagnostics = null;
            }
        }
        return resultWithDiagnostics;
    }
}

