/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.substitutions;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.checker.TypeCheckingProcedure;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a$\u0010\u0000\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u001a\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u001a$\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f\u001a\u0018\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f\u00a8\u0006\u000f"}, d2={"getCallableSubstitution", "", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "Lorg/jetbrains/kotlin/types/TypeProjection;", "baseCallable", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "derivedCallable", "getCallableSubstitutor", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "getTypeSubstitution", "Ljava/util/LinkedHashMap;", "baseType", "Lorg/jetbrains/kotlin/types/KotlinType;", "derivedType", "getTypeSubstitutor", "ide-common"})
public final class SubstitutionUtilsKt {
    @Nullable
    public static final LinkedHashMap<TypeConstructor, TypeProjection> getTypeSubstitution(@NotNull KotlinType baseType, @NotNull KotlinType derivedType) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter(baseType, "baseType");
        Intrinsics.checkNotNullParameter(derivedType, "derivedType");
        KotlinType kotlinType2 = TypeCheckingProcedure.findCorrespondingSupertype(derivedType, baseType);
        if (kotlinType2 == null) {
            return null;
        }
        KotlinType substitutedType = kotlinType = kotlinType2;
        LinkedHashMap<TypeConstructor, TypeProjection> substitution2 = new LinkedHashMap<TypeConstructor, TypeProjection>(substitutedType.getArguments().size());
        List<TypeParameterDescriptor> object2 = baseType.getConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue(object2, "baseType.constructor.parameters");
        for (Pair pair : CollectionsKt.zip((Iterable)object2, (Iterable)substitutedType.getArguments())) {
            TypeParameterDescriptor param = (TypeParameterDescriptor)pair.component1();
            TypeProjection arg = (TypeProjection)pair.component2();
            Map map2 = substitution2;
            TypeConstructor typeConstructor2 = param.getTypeConstructor();
            Intrinsics.checkNotNullExpressionValue(typeConstructor2, "param.typeConstructor");
            boolean bl = false;
            map2.put(typeConstructor2, arg);
        }
        return substitution2;
    }

    @Nullable
    public static final Map<TypeConstructor, TypeProjection> getCallableSubstitution(@NotNull CallableDescriptor baseCallable, @NotNull CallableDescriptor derivedCallable) {
        ClassDescriptor classDescriptor2;
        Intrinsics.checkNotNullParameter(baseCallable, "baseCallable");
        Intrinsics.checkNotNullParameter(derivedCallable, "derivedCallable");
        DeclarationDescriptor declarationDescriptor = baseCallable.getContainingDeclaration();
        ClassDescriptor classDescriptor3 = classDescriptor2 = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor2 == null) {
            return null;
        }
        ClassDescriptor baseClass2 = classDescriptor2;
        Object object = derivedCallable.getContainingDeclaration();
        DeclarationDescriptor declarationDescriptor2 = declarationDescriptor = object instanceof ClassDescriptor ? (ClassDescriptor)object : null;
        if (declarationDescriptor == null) {
            return null;
        }
        DeclarationDescriptor derivedClass = declarationDescriptor;
        SimpleType object22 = baseClass2.getDefaultType();
        Intrinsics.checkNotNullExpressionValue(object22, "baseClass.defaultType");
        KotlinType kotlinType = object22;
        SimpleType simpleType2 = derivedClass.getDefaultType();
        Intrinsics.checkNotNullExpressionValue(simpleType2, "derivedClass.defaultType");
        object = SubstitutionUtilsKt.getTypeSubstitution(kotlinType, simpleType2);
        if (object == null) {
            return null;
        }
        Iterator substitution2 = object;
        List<TypeParameterDescriptor> list2 = baseCallable.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "baseCallable.typeParameters");
        Iterable iterable = list2;
        List<TypeParameterDescriptor> list3 = derivedCallable.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list3, "derivedCallable.typeParameters");
        for (Pair pair : CollectionsKt.zip(iterable, (Iterable)list3)) {
            TypeParameterDescriptor baseParam = (TypeParameterDescriptor)pair.component1();
            TypeParameterDescriptor derivedParam = (TypeParameterDescriptor)pair.component2();
            Map map2 = (Map)((Object)substitution2);
            TypeConstructor typeConstructor2 = baseParam.getTypeConstructor();
            Intrinsics.checkNotNullExpressionValue(typeConstructor2, "baseParam.typeConstructor");
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(derivedParam.getDefaultType());
            boolean bl = false;
            map2.put(typeConstructor2, typeProjectionImpl);
        }
        return (Map)((Object)substitution2);
    }

    @Nullable
    public static final TypeSubstitutor getCallableSubstitutor(@NotNull CallableDescriptor baseCallable, @NotNull CallableDescriptor derivedCallable) {
        TypeSubstitutor typeSubstitutor2;
        Intrinsics.checkNotNullParameter(baseCallable, "baseCallable");
        Intrinsics.checkNotNullParameter(derivedCallable, "derivedCallable");
        Map<TypeConstructor, TypeProjection> map2 = SubstitutionUtilsKt.getCallableSubstitution(baseCallable, derivedCallable);
        if (map2 == null) {
            typeSubstitutor2 = null;
        } else {
            Map<TypeConstructor, TypeProjection> map3 = map2;
            boolean bl = false;
            boolean bl2 = false;
            Map<TypeConstructor, TypeProjection> it = map3;
            boolean bl3 = false;
            typeSubstitutor2 = TypeSubstitutor.create(it);
        }
        return typeSubstitutor2;
    }

    @Nullable
    public static final TypeSubstitutor getTypeSubstitutor(@NotNull KotlinType baseType, @NotNull KotlinType derivedType) {
        TypeSubstitutor typeSubstitutor2;
        Intrinsics.checkNotNullParameter(baseType, "baseType");
        Intrinsics.checkNotNullParameter(derivedType, "derivedType");
        LinkedHashMap<TypeConstructor, TypeProjection> linkedHashMap = SubstitutionUtilsKt.getTypeSubstitution(baseType, derivedType);
        if (linkedHashMap == null) {
            typeSubstitutor2 = null;
        } else {
            LinkedHashMap<TypeConstructor, TypeProjection> linkedHashMap2 = linkedHashMap;
            boolean bl = false;
            boolean bl2 = false;
            LinkedHashMap<TypeConstructor, TypeProjection> it = linkedHashMap2;
            boolean bl3 = false;
            typeSubstitutor2 = TypeSubstitutor.create((Map<TypeConstructor, TypeProjection>)it);
        }
        return typeSubstitutor2;
    }
}

