/*
 * Decompiled with CFR 0.152.
 */
package org.jline.utils;

import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.Colors;

public class StyleResolver {
    private static final Logger log = Logger.getLogger(StyleResolver.class.getName());
    private final Function<String, String> source;

    public StyleResolver(Function<String, String> source) {
        this.source = Objects.requireNonNull(source);
    }

    private static Integer color(String name2) {
        int flags = 0;
        if ((name2 = name2.toLowerCase(Locale.US)).charAt(0) == '!') {
            name2 = name2.substring(1, name2.length());
            flags = 8;
        } else if (name2.startsWith("bright-")) {
            name2 = name2.substring(7, name2.length());
            flags = 8;
        } else if (name2.charAt(0) == '~') {
            try {
                name2 = name2.substring(1, name2.length());
                return Colors.rgbColor(name2);
            }
            catch (IllegalArgumentException e) {
                log.warning("Invalid style-color name: " + name2);
                return null;
            }
        }
        switch (name2) {
            case "black": 
            case "k": {
                return flags + 0;
            }
            case "red": 
            case "r": {
                return flags + 1;
            }
            case "green": 
            case "g": {
                return flags + 2;
            }
            case "yellow": 
            case "y": {
                return flags + 3;
            }
            case "blue": 
            case "b": {
                return flags + 4;
            }
            case "magenta": 
            case "m": {
                return flags + 5;
            }
            case "cyan": 
            case "c": {
                return flags + 6;
            }
            case "white": 
            case "w": {
                return flags + 7;
            }
        }
        return null;
    }

    public AttributedStyle resolve(String spec) {
        int i;
        Objects.requireNonNull(spec);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Resolve: " + spec);
        }
        if ((i = spec.indexOf(":-")) != -1) {
            String[] parts2 = spec.split(":-");
            return this.resolve(parts2[0].trim(), parts2[1].trim());
        }
        return this.apply(AttributedStyle.DEFAULT, spec);
    }

    public AttributedStyle resolve(String spec, String defaultSpec) {
        AttributedStyle style;
        Objects.requireNonNull(spec);
        if (log.isLoggable(Level.FINEST)) {
            log.finest(String.format("Resolve: %s; default: %s", spec, defaultSpec));
        }
        if ((style = this.apply(AttributedStyle.DEFAULT, spec)) == AttributedStyle.DEFAULT && defaultSpec != null) {
            style = this.apply(style, defaultSpec);
        }
        return style;
    }

    private AttributedStyle apply(AttributedStyle style, String spec) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Apply: " + spec);
        }
        for (String item : spec.split(",")) {
            if ((item = item.trim()).isEmpty()) continue;
            style = item.startsWith(".") ? this.applyReference(style, item) : (item.contains(":") ? this.applyColor(style, item) : (item.matches("[0-9]+(;[0-9]+)*") ? this.applyAnsi(style, item) : this.applyNamed(style, item)));
        }
        return style;
    }

    private AttributedStyle applyAnsi(AttributedStyle style, String spec) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Apply-ansi: " + spec);
        }
        return new AttributedStringBuilder().style(style).ansiAppend("\u001b[" + spec + "m").style();
    }

    private AttributedStyle applyReference(AttributedStyle style, String spec) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Apply-reference: " + spec);
        }
        if (spec.length() == 1) {
            log.warning("Invalid style-reference; missing discriminator: " + spec);
        } else {
            String name2 = spec.substring(1, spec.length());
            String resolvedSpec = this.source.apply(name2);
            if (resolvedSpec != null) {
                return this.apply(style, resolvedSpec);
            }
        }
        return style;
    }

    private AttributedStyle applyNamed(AttributedStyle style, String name2) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Apply-named: " + name2);
        }
        switch (name2.toLowerCase(Locale.US)) {
            case "default": {
                return AttributedStyle.DEFAULT;
            }
            case "bold": {
                return style.bold();
            }
            case "faint": {
                return style.faint();
            }
            case "italic": {
                return style.italic();
            }
            case "underline": {
                return style.underline();
            }
            case "blink": {
                return style.blink();
            }
            case "inverse": {
                return style.inverse();
            }
            case "inverse-neg": 
            case "inverseneg": {
                return style.inverseNeg();
            }
            case "conceal": {
                return style.conceal();
            }
            case "crossed-out": 
            case "crossedout": {
                return style.crossedOut();
            }
            case "hidden": {
                return style.hidden();
            }
        }
        log.warning("Unknown style: " + name2);
        return style;
    }

    private AttributedStyle applyColor(AttributedStyle style, String spec) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Apply-color: " + spec);
        }
        String[] parts2 = spec.split(":", 2);
        String colorMode = parts2[0].trim();
        String colorName = parts2[1].trim();
        Integer color = StyleResolver.color(colorName);
        if (color == null) {
            log.warning("Invalid color-name: " + colorName);
        } else {
            switch (colorMode.toLowerCase(Locale.US)) {
                case "foreground": 
                case "fg": 
                case "f": {
                    return style.foreground(color);
                }
                case "background": 
                case "bg": 
                case "b": {
                    return style.background(color);
                }
            }
            log.warning("Invalid color-mode: " + colorMode);
        }
        return style;
    }
}

