/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.inject.spi;

import java.lang.annotation.Annotation;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.inject.Binder;
import org.jetbrains.kotlin.com.google.inject.Scope;
import org.jetbrains.kotlin.com.google.inject.spi.Element;
import org.jetbrains.kotlin.com.google.inject.spi.ElementVisitor;

public final class ScopeBinding
implements Element {
    private final Object source;
    private final Class<? extends Annotation> annotationType;
    private final Scope scope;

    ScopeBinding(Object source, Class<? extends Annotation> annotationType, Scope scope2) {
        this.source = Preconditions.checkNotNull(source, "source");
        this.annotationType = Preconditions.checkNotNull(annotationType, "annotationType");
        this.scope = Preconditions.checkNotNull(scope2, "scope");
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public Class<? extends Annotation> getAnnotationType() {
        return this.annotationType;
    }

    public Scope getScope() {
        return this.scope;
    }

    @Override
    public <T> T acceptVisitor(ElementVisitor<T> visitor2) {
        return visitor2.visit(this);
    }

    @Override
    public void applyTo(Binder binder) {
        binder.withSource(this.getSource()).bindScope(this.annotationType, this.scope);
    }
}

