/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.inject.util;

import java.util.HashSet;
import java.util.Set;
import org.jetbrains.kotlin.com.google.common.base.Objects;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableSet;
import org.jetbrains.kotlin.com.google.common.collect.Sets;
import org.jetbrains.kotlin.com.google.inject.Inject;
import org.jetbrains.kotlin.com.google.inject.Injector;
import org.jetbrains.kotlin.com.google.inject.Provider;
import org.jetbrains.kotlin.com.google.inject.spi.Dependency;
import org.jetbrains.kotlin.com.google.inject.spi.InjectionPoint;
import org.jetbrains.kotlin.com.google.inject.spi.ProviderWithDependencies;

public final class Providers {
    private Providers() {
    }

    public static <T> Provider<T> of(T instance) {
        return new ConstantProvider(instance);
    }

    public static <T> Provider<T> guicify(javax.inject.Provider<T> provider2) {
        if (provider2 instanceof Provider) {
            return (Provider)provider2;
        }
        javax.inject.Provider<T> delegate2 = Preconditions.checkNotNull(provider2, "provider");
        Set<InjectionPoint> injectionPoints = InjectionPoint.forInstanceMethodsAndFields(provider2.getClass());
        if (injectionPoints.isEmpty()) {
            return new GuicifiedProvider(delegate2);
        }
        HashSet<Dependency<?>> mutableDeps = Sets.newHashSet();
        for (InjectionPoint ip : injectionPoints) {
            mutableDeps.addAll(ip.getDependencies());
        }
        ImmutableSet dependencies2 = ImmutableSet.copyOf(mutableDeps);
        return new GuicifiedProviderWithDependencies(dependencies2, delegate2);
    }

    private static final class GuicifiedProviderWithDependencies<T>
    extends GuicifiedProvider<T>
    implements ProviderWithDependencies<T> {
        private final Set<Dependency<?>> dependencies;

        private GuicifiedProviderWithDependencies(Set<Dependency<?>> dependencies2, javax.inject.Provider<T> delegate2) {
            super(delegate2);
            this.dependencies = dependencies2;
        }

        @Inject
        void initialize(Injector injector) {
            injector.injectMembers(this.delegate);
        }

        @Override
        public Set<Dependency<?>> getDependencies() {
            return this.dependencies;
        }
    }

    private static class GuicifiedProvider<T>
    implements Provider<T> {
        protected final javax.inject.Provider<T> delegate;

        private GuicifiedProvider(javax.inject.Provider<T> delegate2) {
            this.delegate = delegate2;
        }

        @Override
        public T get() {
            return this.delegate.get();
        }

        public String toString() {
            return "guicified(" + this.delegate + ")";
        }

        public boolean equals(Object obj) {
            return obj instanceof GuicifiedProvider && Objects.equal(this.delegate, ((GuicifiedProvider)obj).delegate);
        }

        public int hashCode() {
            return Objects.hashCode(this.delegate);
        }
    }

    private static final class ConstantProvider<T>
    implements Provider<T> {
        private final T instance;

        private ConstantProvider(T instance) {
            this.instance = instance;
        }

        @Override
        public T get() {
            return this.instance;
        }

        public String toString() {
            return "of(" + this.instance + ")";
        }

        public boolean equals(Object obj) {
            return obj instanceof ConstantProvider && Objects.equal(this.instance, ((ConstantProvider)obj).instance);
        }

        public int hashCode() {
            return Objects.hashCode(this.instance);
        }
    }
}

