/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrBuildersKt;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.interpreter.IrTreeBuildUtilsKt;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.js.config.RuntimeDiagnostic;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/BooleanPropertyInExternalLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "ExternalBooleanPropertyProcessor", "backend.js"})
public final class BooleanPropertyInExternalLowering
implements BodyLoweringPass {
    @NotNull
    private final JsIrBackendContext context;

    public BooleanPropertyInExternalLowering(@NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter(irBody, "irBody");
        Intrinsics.checkNotNullParameter(container, "container");
        if (!this.context.getSafeExternalBoolean() && this.context.getSafeExternalBooleanDiagnostic() == null) {
            return;
        }
        IrElementTransformerVoidKt.transformChildrenVoid(irBody, new ExternalBooleanPropertyProcessor(this.context));
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        BodyLoweringPass.DefaultImpls.lower(this, irFile);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u000eH\u0002R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/BooleanPropertyInExternalLowering$ExternalBooleanPropertyProcessor;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "booleanType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "getBooleanType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "safeExternalBoolean", "", "getSafeExternalBoolean", "()Z", "safeExternalBooleanDiagnostic", "Lorg/jetbrains/kotlin/js/config/RuntimeDiagnostic;", "getSafeExternalBooleanDiagnostic", "()Lorg/jetbrains/kotlin/js/config/RuntimeDiagnostic;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "diagnosticMethod", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "backend.js"})
    private static final class ExternalBooleanPropertyProcessor
    extends IrElementTransformerVoid {
        @NotNull
        private final JsIrBackendContext context;

        public ExternalBooleanPropertyProcessor(@NotNull JsIrBackendContext context2) {
            Intrinsics.checkNotNullParameter(context2, "context");
            this.context = context2;
        }

        private final boolean getSafeExternalBoolean() {
            return this.context.getSafeExternalBoolean();
        }

        private final RuntimeDiagnostic getSafeExternalBooleanDiagnostic() {
            return this.context.getSafeExternalBooleanDiagnostic();
        }

        private final IrType getBooleanType() {
            return this.context.getIrBuiltIns().getBooleanType();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public IrExpression visitCall(@NotNull IrCall expression2) {
            IrDeclarationReference irDeclarationReference;
            IrCall irCall;
            void this_$iv$iv;
            IrSimpleFunctionSymbol function2;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
            IrSimpleFunctionSymbol symbol2 = expression2.getSymbol();
            IrSimpleFunction callee = (IrSimpleFunction)symbol2.getOwner();
            IrPropertySymbol irPropertySymbol = callee.getCorrespondingPropertySymbol();
            if (irPropertySymbol == null) {
                return expression2;
            }
            IrProperty property2 = (IrProperty)irPropertySymbol.getOwner();
            if (!IrUtilsKt.isEffectivelyExternal(property2)) {
                return expression2;
            }
            if (!Intrinsics.areEqual(callee, property2.getGetter())) {
                return expression2;
            }
            if (!Intrinsics.areEqual(callee.getReturnType(), this.getBooleanType())) {
                return expression2;
            }
            Object object = this.getSafeExternalBooleanDiagnostic();
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = function2 = object == null ? null : this.diagnosticMethod((RuntimeDiagnostic)((Object)object));
            if (!this.getSafeExternalBoolean() && function2 == null) {
                return expression2;
            }
            if (this.getSafeExternalBoolean() && function2 == null) {
                RuntimeDiagnostic $this$visitCall_u24lambda_u2d0 = object = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.context.getIntrinsics().getJsNativeBoolean(), null, null, null, 14, null);
                boolean bl = false;
                ((IrFunctionAccessExpression)((Object)$this$visitCall_u24lambda_u2d0)).putValueArgument(0, expression2);
                return (IrExpression)object;
            }
            IrBuilderWithScope $this$irBlock_u24default$iv = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)symbol2, 0, 0, 6, null);
            int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
            IrStatementOrigin origin$iv = null;
            IrType resultType$iv = null;
            boolean $i$f$irBlock = false;
            IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
            boolean $i$f$block = false;
            void $this$visitCall_u24lambda_u2d3 = this_$iv$iv;
            boolean bl = false;
            IrVariable tmp = IrBuildersKt.createTmpVariable$default((IrStatementsBuilder)$this$visitCall_u24lambda_u2d3, (IrExpression)expression2, null, false, null, null, 30, null);
            IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = function2;
            Intrinsics.checkNotNull(irSimpleFunctionSymbol2);
            IrCall $this$visitCall_u24lambda_u2d3_u24lambda_u2d1 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, irSimpleFunctionSymbol2, null, null, null, 14, null);
            boolean bl2 = false;
            FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable(property2);
            $this$visitCall_u24lambda_u2d3_u24lambda_u2d1.putValueArgument(0, IrTreeBuildUtilsKt.toIrConst$default(fqName2 == null ? null : fqName2.asString(), $this$visitCall_u24lambda_u2d3.getContext().getIrBuiltIns().getStringType(), 0, 0, 6, null));
            $this$visitCall_u24lambda_u2d3_u24lambda_u2d1.putValueArgument(1, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$visitCall_u24lambda_u2d3, tmp));
            IrCall call2 = irCall;
            $this$visitCall_u24lambda_u2d3.unaryPlus(call2);
            if (this.getSafeExternalBoolean()) {
                IrCall irCall2;
                IrCall $this$visitCall_u24lambda_u2d3_u24lambda_u2d2 = irCall2 = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.context.getIntrinsics().getJsNativeBoolean(), null, null, null, 14, null);
                boolean bl3 = false;
                $this$visitCall_u24lambda_u2d3_u24lambda_u2d2.putValueArgument(0, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$visitCall_u24lambda_u2d3, tmp));
                irDeclarationReference = irCall2;
            } else {
                irDeclarationReference = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$visitCall_u24lambda_u2d3, tmp);
            }
            IrDeclarationReference newBooleanGet = irDeclarationReference;
            $this$visitCall_u24lambda_u2d3.unaryPlus(newBooleanGet);
            return this_$iv$iv.doBuild();
        }

        private final IrSimpleFunctionSymbol diagnosticMethod(RuntimeDiagnostic $this$diagnosticMethod) {
            IrSimpleFunctionSymbol irSimpleFunctionSymbol;
            RuntimeDiagnostic runtimeDiagnostic = $this$diagnosticMethod;
            int n = WhenMappings.$EnumSwitchMapping$0[runtimeDiagnostic.ordinal()];
            switch (n) {
                case 1: {
                    irSimpleFunctionSymbol = this.context.getIntrinsics().getJsBooleanInExternalLog();
                    break;
                }
                case 2: {
                    irSimpleFunctionSymbol = this.context.getIntrinsics().getJsBooleanInExternalException();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return irSimpleFunctionSymbol;
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[RuntimeDiagnostic.values().length];
                nArray[RuntimeDiagnostic.LOG.ordinal()] = 1;
                nArray[RuntimeDiagnostic.EXCEPTION.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

