/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.backend.common.lower.AnnotationImplementationTransformer;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\rH\u0016J\u0018\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/JsAnnotationImplementationTransformer;", "Lorg/jetbrains/kotlin/backend/common/lower/AnnotationImplementationTransformer;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "jsContext", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "arraysContentEquals", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "getJsContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "generatedEquals", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "irBuilder", "Lorg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder;", "type", "arg1", "arg2", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "visitClassNew", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitConstructorCall", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "backend.js"})
public final class JsAnnotationImplementationTransformer
extends AnnotationImplementationTransformer
implements DeclarationTransformer {
    @NotNull
    private final JsIrBackendContext jsContext;
    @NotNull
    private final Map<IrType, IrSimpleFunctionSymbol> arraysContentEquals;

    public JsAnnotationImplementationTransformer(@NotNull JsIrBackendContext jsContext) {
        Intrinsics.checkNotNullParameter(jsContext, "jsContext");
        super(jsContext, null);
        this.jsContext = jsContext;
        Map<IrType, IrSimpleFunctionSymbol> map2 = this.jsContext.getIr().getSymbols().getArraysContentEquals();
        if (map2 == null) {
            JsAnnotationImplementationTransformer jsAnnotationImplementationTransformer = this;
            boolean bl = false;
            String string2 = "contentEquals symbols should be defined in JS IR context";
            JsAnnotationImplementationTransformer jsAnnotationImplementationTransformer2 = jsAnnotationImplementationTransformer;
            String string3 = string2;
            throw new IllegalArgumentException(string3.toString());
        }
        this.arraysContentEquals = map2;
    }

    @NotNull
    public final JsIrBackendContext getJsContext() {
        return this.jsContext;
    }

    @Override
    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        return declaration2 instanceof IrClass && IrUtilsKt.isAnnotationClass((IrClass)declaration2) ? CollectionsKt.listOf(this.visitClassNew((IrClass)declaration2)) : null;
    }

    @Override
    @NotNull
    public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return expression2;
    }

    @Override
    @NotNull
    public IrClass visitClassNew(@NotNull IrClass declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        if (!IrUtilsKt.isAnnotationClass(declaration2)) {
            return declaration2;
        }
        List<IrProperty> properties2 = this.getAnnotationProperties(declaration2);
        this.getContext().getIrFactory().getStageController().unrestrictDeclarationListsAccess((Function0)new Function0<Unit>(this, declaration2, properties2){
            final /* synthetic */ JsAnnotationImplementationTransformer this$0;
            final /* synthetic */ IrClass $declaration;
            final /* synthetic */ List<IrProperty> $properties;
            {
                this.this$0 = $receiver;
                this.$declaration = $declaration;
                this.$properties = $properties;
                super(0);
            }

            public final void invoke() {
                this.this$0.implementEqualsAndHashCode(this.$declaration, this.$declaration, this.$properties, this.$properties);
            }
        });
        return declaration2;
    }

    @Override
    @NotNull
    public IrExpression generatedEquals(@NotNull IrBlockBodyBuilder irBuilder, @NotNull IrType type2, @NotNull IrExpression arg1, @NotNull IrExpression arg2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter(irBuilder, "irBuilder");
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(arg1, "arg1");
        Intrinsics.checkNotNullParameter(arg2, "arg2");
        if (IrTypePredicatesKt.isArray(type2) || IrTypeUtilsKt.isPrimitiveArray(type2)) {
            IrSimpleFunctionSymbol requiredSymbol;
            Object object;
            IrSimpleFunctionSymbol irSimpleFunctionSymbol;
            if (IrTypeUtilsKt.isPrimitiveArray(type2)) {
                irSimpleFunctionSymbol = this.arraysContentEquals.get(type2);
            } else {
                Object v1;
                block7: {
                    Iterable $this$singleOrNull$iv = this.arraysContentEquals.entrySet();
                    boolean $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (Object element$iv : $this$singleOrNull$iv) {
                        Map.Entry $dstr$k$_u24__u24 = (Map.Entry)element$iv;
                        boolean bl = false;
                        IrType k = (IrType)$dstr$k$_u24__u24.getKey();
                        if (!IrTypePredicatesKt.isArray(k)) continue;
                        if (found$iv) {
                            v1 = null;
                            break block7;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v1 = !found$iv ? null : single$iv;
                }
                object = v1;
                irSimpleFunctionSymbol = requiredSymbol = object == null ? null : (IrSimpleFunctionSymbol)object.getValue();
            }
            if (requiredSymbol == null) {
                throw new IllegalStateException(Intrinsics.stringPlus("Can't find an Arrays.contentEquals method for array type ", RenderIrElementKt.render(type2)).toString());
            }
            object = ExpressionHelpersKt.irCall((IrBuilderWithScope)irBuilder, requiredSymbol);
            IrCall $this$generatedEquals_u24lambda_u2d2 = object;
            boolean bl = false;
            $this$generatedEquals_u24lambda_u2d2.setExtensionReceiver(arg1);
            $this$generatedEquals_u24lambda_u2d2.putValueArgument(0, arg2);
            irExpression = (IrExpression)object;
        } else {
            irExpression = super.generatedEquals(irBuilder, type2, arg1, arg2);
        }
        return irExpression;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        DeclarationTransformer.DefaultImpls.lower(this, irFile);
    }

    @Override
    public boolean getWithLocalDeclarations() {
        return DeclarationTransformer.DefaultImpls.getWithLocalDeclarations(this);
    }
}

