/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.http.protocol;

import java.io.IOException;
import org.jetbrains.kotlin.org.apache.http.HttpClientConnection;
import org.jetbrains.kotlin.org.apache.http.HttpEntityEnclosingRequest;
import org.jetbrains.kotlin.org.apache.http.HttpException;
import org.jetbrains.kotlin.org.apache.http.HttpRequest;
import org.jetbrains.kotlin.org.apache.http.HttpResponse;
import org.jetbrains.kotlin.org.apache.http.HttpVersion;
import org.jetbrains.kotlin.org.apache.http.ProtocolException;
import org.jetbrains.kotlin.org.apache.http.ProtocolVersion;
import org.jetbrains.kotlin.org.apache.http.protocol.HttpContext;
import org.jetbrains.kotlin.org.apache.http.protocol.HttpProcessor;
import org.jetbrains.kotlin.org.apache.http.util.Args;

public class HttpRequestExecutor {
    private final int waitForContinue;

    public HttpRequestExecutor(int waitForContinue) {
        this.waitForContinue = Args.positive(waitForContinue, "Wait for continue time");
    }

    public HttpRequestExecutor() {
        this(3000);
    }

    protected boolean canResponseHaveBody(HttpRequest request, HttpResponse response) {
        if ("HEAD".equalsIgnoreCase(request.getRequestLine().getMethod())) {
            return false;
        }
        int status2 = response.getStatusLine().getStatusCode();
        return status2 >= 200 && status2 != 204 && status2 != 304 && status2 != 205;
    }

    public HttpResponse execute(HttpRequest request, HttpClientConnection conn, HttpContext context2) throws IOException, HttpException {
        Args.notNull(request, "HTTP request");
        Args.notNull(conn, "Client connection");
        Args.notNull(context2, "HTTP context");
        try {
            HttpResponse response = this.doSendRequest(request, conn, context2);
            if (response == null) {
                response = this.doReceiveResponse(request, conn, context2);
            }
            return response;
        }
        catch (IOException ex) {
            HttpRequestExecutor.closeConnection(conn);
            throw ex;
        }
        catch (HttpException ex) {
            HttpRequestExecutor.closeConnection(conn);
            throw ex;
        }
        catch (RuntimeException ex) {
            HttpRequestExecutor.closeConnection(conn);
            throw ex;
        }
    }

    private static void closeConnection(HttpClientConnection conn) {
        try {
            conn.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void preProcess(HttpRequest request, HttpProcessor processor2, HttpContext context2) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        Args.notNull(processor2, "HTTP processor");
        Args.notNull(context2, "HTTP context");
        context2.setAttribute("http.request", request);
        processor2.process(request, context2);
    }

    protected HttpResponse doSendRequest(HttpRequest request, HttpClientConnection conn, HttpContext context2) throws IOException, HttpException {
        Args.notNull(request, "HTTP request");
        Args.notNull(conn, "Client connection");
        Args.notNull(context2, "HTTP context");
        HttpResponse response = null;
        context2.setAttribute("http.connection", conn);
        context2.setAttribute("http.request_sent", Boolean.FALSE);
        conn.sendRequestHeader(request);
        if (request instanceof HttpEntityEnclosingRequest) {
            boolean sendentity = true;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            if (((HttpEntityEnclosingRequest)request).expectContinue() && !ver.lessEquals(HttpVersion.HTTP_1_0)) {
                conn.flush();
                if (conn.isResponseAvailable(this.waitForContinue)) {
                    int status2;
                    response = conn.receiveResponseHeader();
                    if (this.canResponseHaveBody(request, response)) {
                        conn.receiveResponseEntity(response);
                    }
                    if ((status2 = response.getStatusLine().getStatusCode()) < 200) {
                        if (status2 != 100) {
                            throw new ProtocolException("Unexpected response: " + response.getStatusLine());
                        }
                        response = null;
                    } else {
                        sendentity = false;
                    }
                }
            }
            if (sendentity) {
                conn.sendRequestEntity((HttpEntityEnclosingRequest)request);
            }
        }
        conn.flush();
        context2.setAttribute("http.request_sent", Boolean.TRUE);
        return response;
    }

    protected HttpResponse doReceiveResponse(HttpRequest request, HttpClientConnection conn, HttpContext context2) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        Args.notNull(conn, "Client connection");
        Args.notNull(context2, "HTTP context");
        HttpResponse response = null;
        int statusCode = 0;
        while (response == null || statusCode < 200) {
            response = conn.receiveResponseHeader();
            statusCode = response.getStatusLine().getStatusCode();
            if (statusCode < 100) {
                throw new ProtocolException("Invalid response: " + response.getStatusLine());
            }
            if (!this.canResponseHaveBody(request, response)) continue;
            conn.receiveResponseEntity(response);
        }
        return response;
    }

    public void postProcess(HttpResponse response, HttpProcessor processor2, HttpContext context2) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        Args.notNull(processor2, "HTTP processor");
        Args.notNull(context2, "HTTP context");
        context2.setAttribute("http.response", response);
        processor2.process(response, context2);
    }
}

