/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.kotlin.org.apache.maven.model.InputLocation;
import org.jetbrains.kotlin.org.apache.maven.model.InputLocationTracker;

public class PatternSet
implements Serializable,
Cloneable,
InputLocationTracker {
    private List<String> includes;
    private List<String> excludes;
    private Map<Object, InputLocation> locations;
    private InputLocation location;
    private InputLocation includesLocation;
    private InputLocation excludesLocation;

    public PatternSet clone() {
        try {
            PatternSet copy2 = (PatternSet)super.clone();
            if (this.includes != null) {
                copy2.includes = new ArrayList<String>();
                copy2.includes.addAll(this.includes);
            }
            if (this.excludes != null) {
                copy2.excludes = new ArrayList<String>();
                copy2.excludes.addAll(this.excludes);
            }
            if (copy2.locations != null) {
                copy2.locations = new LinkedHashMap<Object, InputLocation>(copy2.locations);
            }
            return copy2;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public List<String> getExcludes() {
        if (this.excludes == null) {
            this.excludes = new ArrayList<String>();
        }
        return this.excludes;
    }

    public List<String> getIncludes() {
        if (this.includes == null) {
            this.includes = new ArrayList<String>();
        }
        return this.includes;
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            String string2 = (String)key;
            int n = -1;
            switch (string2.hashCode()) {
                case 0: {
                    if (!string2.equals("")) break;
                    n = 0;
                    break;
                }
                case 90259659: {
                    if (!string2.equals("includes")) break;
                    n = 1;
                    break;
                }
                case 1994055129: {
                    if (!string2.equals("excludes")) break;
                    n = 2;
                }
            }
            switch (n) {
                case 0: {
                    return this.location;
                }
                case 1: {
                    return this.includesLocation;
                }
                case 2: {
                    return this.excludesLocation;
                }
            }
            return this.getOtherLocation(key);
        }
        return this.getOtherLocation(key);
    }

    public void setLocation(Object key, InputLocation location2) {
        if (key instanceof String) {
            String string2 = (String)key;
            int n = -1;
            switch (string2.hashCode()) {
                case 0: {
                    if (!string2.equals("")) break;
                    n = 0;
                    break;
                }
                case 90259659: {
                    if (!string2.equals("includes")) break;
                    n = 1;
                    break;
                }
                case 1994055129: {
                    if (!string2.equals("excludes")) break;
                    n = 2;
                }
            }
            switch (n) {
                case 0: {
                    this.location = location2;
                    return;
                }
                case 1: {
                    this.includesLocation = location2;
                    return;
                }
                case 2: {
                    this.excludesLocation = location2;
                    return;
                }
            }
            this.setOtherLocation(key, location2);
            return;
        }
        this.setOtherLocation(key, location2);
    }

    public void setOtherLocation(Object key, InputLocation location2) {
        if (location2 != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put(key, location2);
        }
    }

    private InputLocation getOtherLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("PatternSet [includes: {");
        for (String str : this.getIncludes()) {
            sb.append(str).append(", ");
        }
        if (sb.substring(sb.length() - 2).equals(", ")) {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append("}, excludes: {");
        for (String str : this.getExcludes()) {
            sb.append(str).append(", ");
        }
        if (sb.substring(sb.length() - 2).equals(", ")) {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append("}]");
        return sb.toString();
    }
}

