/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Properties;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.Artifact;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.SimpleLocalRepositoryManager;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.TrackingFileManager;
import org.jetbrains.kotlin.org.eclipse.aether.repository.LocalArtifactRegistration;
import org.jetbrains.kotlin.org.eclipse.aether.repository.LocalArtifactRequest;
import org.jetbrains.kotlin.org.eclipse.aether.repository.LocalArtifactResult;
import org.jetbrains.kotlin.org.eclipse.aether.repository.RemoteRepository;
import org.jetbrains.kotlin.org.eclipse.aether.util.ConfigUtils;

class EnhancedLocalRepositoryManager
extends SimpleLocalRepositoryManager {
    private final String trackingFilename;
    private final TrackingFileManager trackingFileManager;

    EnhancedLocalRepositoryManager(File basedir, RepositorySystemSession session2) {
        super(basedir, "enhanced");
        String filename = ConfigUtils.getString(session2, "", "aether.enhancedLocalRepository.trackingFilename");
        if (filename.length() <= 0 || filename.contains("/") || filename.contains("\\") || filename.contains("..")) {
            filename = "_remote.repositories";
        }
        this.trackingFilename = filename;
        this.trackingFileManager = new TrackingFileManager();
    }

    @Override
    public LocalArtifactResult find(RepositorySystemSession session2, LocalArtifactRequest request) {
        String path2 = this.getPathForArtifact(request.getArtifact(), false);
        File file2 = new File(this.getRepository().getBasedir(), path2);
        LocalArtifactResult result2 = new LocalArtifactResult(request);
        if (file2.isFile()) {
            result2.setFile(file2);
            Properties props = this.readRepos(file2);
            if (props.get(this.getKey(file2, "")) != null) {
                result2.setAvailable(true);
            } else {
                String context2 = request.getContext();
                for (RemoteRepository repository : request.getRepositories()) {
                    if (props.get(this.getKey(file2, this.getRepositoryKey(repository, context2))) == null) continue;
                    result2.setAvailable(true);
                    result2.setRepository(repository);
                    break;
                }
                if (!result2.isAvailable() && !this.isTracked(props, file2)) {
                    result2.setAvailable(true);
                }
            }
        }
        return result2;
    }

    @Override
    public void add(RepositorySystemSession session2, LocalArtifactRegistration request) {
        Collection<String> repositories = request.getRepository() == null ? Collections.singleton("") : this.getRepositoryKeys(request.getRepository(), request.getContexts());
        this.addArtifact(request.getArtifact(), repositories, request.getRepository() == null);
    }

    private Collection<String> getRepositoryKeys(RemoteRepository repository, Collection<String> contexts) {
        HashSet<String> keys2 = new HashSet<String>();
        if (contexts != null) {
            for (String context2 : contexts) {
                keys2.add(this.getRepositoryKey(repository, context2));
            }
        }
        return keys2;
    }

    private void addArtifact(Artifact artifact, Collection<String> repositories, boolean local) {
        String path2 = this.getPathForArtifact(Objects.requireNonNull(artifact, "artifact cannot be null"), local);
        File file2 = new File(this.getRepository().getBasedir(), path2);
        this.addRepo(file2, repositories);
    }

    private Properties readRepos(File artifactFile) {
        File trackingFile = this.getTrackingFile(artifactFile);
        Properties props = this.trackingFileManager.read(trackingFile);
        return props != null ? props : new Properties();
    }

    private void addRepo(File artifactFile, Collection<String> repositories) {
        HashMap<String, String> updates = new HashMap<String, String>();
        for (String repository : repositories) {
            updates.put(this.getKey(artifactFile, repository), "");
        }
        File trackingFile = this.getTrackingFile(artifactFile);
        this.trackingFileManager.update(trackingFile, updates);
    }

    private File getTrackingFile(File artifactFile) {
        return new File(artifactFile.getParentFile(), this.trackingFilename);
    }

    private String getKey(File file2, String repository) {
        return file2.getName() + '>' + repository;
    }

    private boolean isTracked(Properties props, File file2) {
        if (props != null) {
            String keyPrefix = file2.getName() + '>';
            for (Object key : props.keySet()) {
                if (!key.toString().startsWith(keyPrefix)) continue;
                return true;
            }
        }
        return false;
    }
}

