/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.sisu.inject;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

final class MildElements<T>
extends AbstractCollection<T> {
    private final ReferenceQueue<T> queue = new ReferenceQueue();
    final List<Reference<T>> list;
    private final boolean soft;

    MildElements(List<Reference<T>> list2, boolean soft) {
        this.list = list2;
        this.soft = soft;
    }

    @Override
    public boolean add(T element) {
        this.compact();
        return this.list.add(this.soft ? new Soft<T>(element, this.queue, this.list.size()) : new Weak<T>(element, this.queue, this.list.size()));
    }

    @Override
    public int size() {
        this.compact();
        return this.list.size();
    }

    @Override
    public Iterator<T> iterator() {
        this.compact();
        return new Itr();
    }

    private void compact() {
        Reference<T> ref;
        while ((ref = this.queue.poll()) != null) {
            this.evict(ref);
        }
    }

    void evict(Reference<? extends T> ref) {
        Reference<T> last2;
        int index2 = ((Indexable)((Object)ref)).index(-1);
        if (index2 >= 0 && ref != (last2 = this.list.remove(this.list.size() - 1))) {
            ((Indexable)((Object)last2)).index(index2);
            this.list.set(index2, last2);
        }
    }

    private static interface Indexable {
        public int index(int var1);
    }

    final class Itr
    implements Iterator<T> {
        private int index;
        private T nextElement;
        private boolean haveElement;

        Itr() {
        }

        @Override
        public boolean hasNext() {
            while (this.nextElement == null && this.index < MildElements.this.list.size()) {
                this.nextElement = MildElements.this.list.get(this.index++).get();
            }
            return this.nextElement != null;
        }

        @Override
        public T next() {
            this.haveElement = this.hasNext();
            if (this.haveElement) {
                Object element = this.nextElement;
                this.nextElement = null;
                return element;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (!this.haveElement) {
                throw new IllegalStateException();
            }
            MildElements.this.evict(MildElements.this.list.get(--this.index));
            this.haveElement = false;
        }
    }

    private static final class Soft<T>
    extends SoftReference<T>
    implements Indexable {
        private int index;

        Soft(T value2, ReferenceQueue<T> queue, int index2) {
            super(value2, queue);
            this.index = index2;
        }

        @Override
        public int index(int newIndex) {
            int oldIndex = this.index;
            this.index = newIndex;
            return oldIndex;
        }
    }

    private static final class Weak<T>
    extends WeakReference<T>
    implements Indexable {
        private int index;

        Weak(T value2, ReferenceQueue<T> queue, int index2) {
            super(value2, queue);
            this.index = index2;
        }

        @Override
        public int index(int newIndex) {
            int oldIndex = this.index;
            this.index = newIndex;
            return oldIndex;
        }
    }
}

