/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.sisu.plexus;

import java.util.List;
import org.jetbrains.kotlin.com.google.inject.TypeLiteral;
import org.jetbrains.kotlin.com.google.inject.spi.InjectionListener;
import org.jetbrains.kotlin.com.google.inject.spi.TypeEncounter;
import org.jetbrains.kotlin.org.eclipse.sisu.bean.BeanBinder;
import org.jetbrains.kotlin.org.eclipse.sisu.bean.BeanManager;
import org.jetbrains.kotlin.org.eclipse.sisu.bean.PropertyBinder;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusBeanMetadata;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusBeanSource;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusPropertyBinder;

final class PlexusBeanBinder
implements InjectionListener<Object>,
BeanBinder {
    private final BeanManager manager;
    private final PlexusBeanSource[] sources;

    PlexusBeanBinder(BeanManager manager, List<PlexusBeanSource> sources) {
        this.manager = manager;
        this.sources = sources.toArray(new PlexusBeanSource[sources.size()]);
    }

    @Override
    public <B> PropertyBinder bindBean(TypeLiteral<B> type2, TypeEncounter<B> encounter) {
        Class<B> clazz = type2.getRawType();
        if (this.manager != null && this.manager.manage(clazz)) {
            encounter.register(this);
        }
        PlexusBeanSource[] plexusBeanSourceArray = this.sources;
        int n = this.sources.length;
        int n2 = 0;
        while (n2 < n) {
            PlexusBeanSource source = plexusBeanSourceArray[n2];
            PlexusBeanMetadata metadata2 = source.getBeanMetadata(clazz);
            if (metadata2 != null) {
                return new PlexusPropertyBinder(this.manager, encounter, metadata2);
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void afterInjection(Object bean) {
        this.manager.manage(bean);
    }
}

