/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.sisu.plexus;

import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.jetbrains.kotlin.com.google.inject.Injector;
import org.jetbrains.kotlin.com.google.inject.Key;
import org.jetbrains.kotlin.com.google.inject.Singleton;
import org.jetbrains.kotlin.com.google.inject.TypeLiteral;
import org.jetbrains.kotlin.com.google.inject.spi.TypeConverterBinding;
import org.jetbrains.kotlin.org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jetbrains.kotlin.org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.jetbrains.kotlin.org.codehaus.plexus.util.xml.pull.MXParser;
import org.jetbrains.kotlin.org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.jetbrains.kotlin.org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.jetbrains.kotlin.org.eclipse.sisu.bean.BeanProperties;
import org.jetbrains.kotlin.org.eclipse.sisu.bean.BeanProperty;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.Logs;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.TypeArguments;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusBeanConverter;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.Roles;

@Singleton
public final class PlexusXmlBeanConverter
implements PlexusBeanConverter {
    private static final String CONVERSION_ERROR = "Cannot convert: \"%s\" to: %s";
    private final Collection<TypeConverterBinding> typeConverterBindings;

    @Inject
    PlexusXmlBeanConverter(Injector injector) {
        this.typeConverterBindings = injector.getTypeConverterBindings();
    }

    public Object convert(TypeLiteral role, String value2) {
        if (value2.trim().startsWith("<")) {
            try {
                MXParser parser = new MXParser();
                parser.setInput(new StringReader(value2));
                parser.nextTag();
                return this.parse(parser, role);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format(CONVERSION_ERROR, value2, role), e);
            }
        }
        return this.convertText(value2, role);
    }

    private Object parse(MXParser parser, TypeLiteral<?> toType) throws Exception {
        parser.require(2, null, null);
        Class<?> rawType = toType.getRawType();
        if (Xpp3Dom.class.isAssignableFrom(rawType)) {
            return PlexusXmlBeanConverter.parseXpp3Dom(parser);
        }
        if (Properties.class.isAssignableFrom(rawType)) {
            return PlexusXmlBeanConverter.parseProperties(parser);
        }
        if (Map.class.isAssignableFrom(rawType)) {
            return this.parseMap(parser, TypeArguments.get(toType.getSupertype(Map.class), 1));
        }
        if (Collection.class.isAssignableFrom(rawType)) {
            return this.parseCollection(parser, TypeArguments.get(toType.getSupertype(Collection.class), 0));
        }
        if (rawType.isArray()) {
            return this.parseArray(parser, TypeArguments.get(toType, 0));
        }
        return this.parseBean(parser, toType, rawType);
    }

    private static Xpp3Dom parseXpp3Dom(XmlPullParser parser) throws Exception {
        return Xpp3DomBuilder.build(parser);
    }

    private static Properties parseProperties(XmlPullParser parser) throws Exception {
        Properties properties2 = PlexusXmlBeanConverter.newImplementation(parser, Properties.class);
        while (parser.nextTag() == 2) {
            parser.nextTag();
            if ("name".equals(parser.getName())) {
                String name2 = parser.nextText();
                parser.nextTag();
                properties2.put(name2, parser.nextText());
            } else {
                String value2 = parser.nextText();
                parser.nextTag();
                properties2.put(parser.nextText(), value2);
            }
            parser.nextTag();
        }
        return properties2;
    }

    private Map<String, Object> parseMap(MXParser parser, TypeLiteral<?> toType) throws Exception {
        Map map2 = PlexusXmlBeanConverter.newImplementation(parser, HashMap.class);
        while (parser.nextTag() == 2) {
            map2.put(parser.getName(), this.parse(parser, toType));
        }
        return map2;
    }

    private Collection<Object> parseCollection(MXParser parser, TypeLiteral<?> toType) throws Exception {
        Collection collection = PlexusXmlBeanConverter.newImplementation(parser, ArrayList.class);
        while (parser.nextTag() == 2) {
            collection.add(this.parse(parser, toType));
        }
        return collection;
    }

    private Object parseArray(MXParser parser, TypeLiteral<?> toType) throws Exception {
        Collection<Object> collection = this.parseCollection(parser, toType);
        Object array2 = Array.newInstance(toType.getRawType(), collection.size());
        int i = 0;
        for (Object element : collection) {
            Array.set(array2, i++, element);
        }
        return array2;
    }

    private Object parseBean(MXParser parser, TypeLiteral<?> toType, Class<?> rawType) throws Exception {
        Class<?> clazz = PlexusXmlBeanConverter.loadImplementation(PlexusXmlBeanConverter.parseImplementation(parser), rawType);
        if (parser.next() == 4) {
            String text2 = parser.getText();
            if (parser.next() != 2) {
                return this.convertText(text2, clazz == rawType ? toType : TypeLiteral.get(clazz));
            }
        }
        if (String.class == clazz) {
            while (parser.getEventType() == 2) {
                String pos = parser.getPositionDescription();
                Logs.warn("Expected TEXT, not XML: {}", pos, new Throwable());
                parser.skipSubTree();
                parser.nextTag();
            }
            return "";
        }
        Object bean = PlexusXmlBeanConverter.newImplementation(clazz);
        HashMap<String, BeanProperty> propertyMap = new HashMap<String, BeanProperty>();
        for (BeanProperty property2 : new BeanProperties(clazz)) {
            String name2 = property2.getName();
            if (propertyMap.containsKey(name2)) continue;
            propertyMap.put(name2, property2);
        }
        while (parser.getEventType() == 2) {
            BeanProperty property2;
            property2 = (BeanProperty)propertyMap.get(Roles.camelizeName(parser.getName()));
            if (property2 != null) {
                property2.set(bean, this.parse(parser, property2.getType()));
                parser.nextTag();
                continue;
            }
            throw new XmlPullParserException("Unknown bean property: " + parser.getName(), parser, null);
        }
        return bean;
    }

    private static String parseImplementation(XmlPullParser parser) {
        return parser.getAttributeValue(null, "implementation");
    }

    private static Class<?> loadImplementation(String name2, Class<?> defaultClazz) {
        ClassLoader peer;
        if (name2 == null) {
            return defaultClazz;
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        if (tccl != null) {
            try {
                return tccl.loadClass(name2);
            }
            catch (Exception exception) {
            }
            catch (LinkageError linkageError) {}
        }
        if ((peer = defaultClazz.getClassLoader()) != null) {
            try {
                return peer.loadClass(name2);
            }
            catch (Exception exception) {
            }
            catch (LinkageError linkageError) {}
        }
        try {
            return Class.forName(name2);
        }
        catch (Exception e) {
            throw new TypeNotPresentException(name2, e);
        }
        catch (LinkageError e) {
            throw new TypeNotPresentException(name2, e);
        }
    }

    private static <T> T newImplementation(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot create instance of: " + clazz, e);
        }
        catch (LinkageError e) {
            throw new IllegalArgumentException("Cannot create instance of: " + clazz, e);
        }
    }

    private static <T> T newImplementation(Class<T> clazz, String value2) {
        try {
            return clazz.getConstructor(String.class).newInstance(value2);
        }
        catch (Exception e) {
            Throwable cause = e instanceof InvocationTargetException ? e.getCause() : e;
            throw new IllegalArgumentException(String.format(CONVERSION_ERROR, value2, clazz), cause);
        }
        catch (LinkageError e) {
            throw new IllegalArgumentException(String.format(CONVERSION_ERROR, value2, clazz), e);
        }
    }

    private static <T> T newImplementation(XmlPullParser parser, Class<T> defaultClazz) {
        return (T)PlexusXmlBeanConverter.newImplementation(PlexusXmlBeanConverter.loadImplementation(PlexusXmlBeanConverter.parseImplementation(parser), defaultClazz));
    }

    private Object convertText(String value2, TypeLiteral<?> toType) {
        String text2 = value2.trim();
        Class<String> rawType = toType.getRawType();
        if (rawType.isAssignableFrom(String.class)) {
            return text2;
        }
        TypeLiteral<?> boxedType = rawType.isPrimitive() ? Key.get(rawType).getTypeLiteral() : toType;
        for (TypeConverterBinding b : this.typeConverterBindings) {
            if (!b.getTypeMatcher().matches(boxedType)) continue;
            return b.getTypeConverter().convert(text2, toType);
        }
        return text2.length() == 0 ? PlexusXmlBeanConverter.newImplementation(rawType) : PlexusXmlBeanConverter.newImplementation(rawType, text2);
    }
}

