/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runners;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.junit.internal.runners.InitializationError;
import org.junit.internal.runners.TestClassRunner;
import org.junit.runner.Request;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Suite
extends TestClassRunner {
    public Suite(Class<?> klass) throws InitializationError {
        this(klass, Suite.getAnnotatedClasses(klass));
    }

    public Suite(Class<?> klass, Class[] annotatedClasses) throws InitializationError {
        super(klass, Request.classes(klass.getName(), annotatedClasses).getRunner());
    }

    private static Class[] getAnnotatedClasses(Class<?> klass) throws InitializationError {
        SuiteClasses annotation2 = klass.getAnnotation(SuiteClasses.class);
        if (annotation2 == null) {
            throw new InitializationError(String.format("class '%s' must have a SuiteClasses annotation", klass.getName()));
        }
        return annotation2.value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface SuiteClasses {
        public Class[] value();
    }
}

