/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.renamer;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.java.decompiler.main.extern.IIdentifierRenamer;

public class ConverterHelper
implements IIdentifierRenamer {
    private static final Set<String> KEYWORDS = new HashSet<String>(Arrays.asList("abstract", "do", "if", "package", "synchronized", "boolean", "double", "implements", "private", "this", "break", "else", "import", "protected", "throw", "byte", "extends", "instanceof", "public", "throws", "case", "false", "int", "return", "transient", "catch", "final", "interface", "short", "true", "char", "finally", "long", "static", "try", "class", "float", "native", "strictfp", "void", "const", "for", "new", "super", "volatile", "continue", "goto", "null", "switch", "while", "default", "assert", "enum"));
    private static final Set<String> RESERVED_WINDOWS_NAMESPACE = new HashSet<String>(Arrays.asList("aux", "prn", "aux", "nul", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9"));
    private int classCounter = 0;
    private int fieldCounter = 0;
    private int methodCounter = 0;
    private final Set<String> setNonStandardClassNames = new HashSet<String>();

    @Override
    public boolean toBeRenamed(IIdentifierRenamer.Type elementType, String className, String element, String descriptor) {
        String value = elementType == IIdentifierRenamer.Type.ELEMENT_CLASS ? className : element;
        return value == null || value.length() == 0 || value.length() <= 2 || KEYWORDS.contains(value) || Character.isDigit(value.charAt(0)) || elementType == IIdentifierRenamer.Type.ELEMENT_CLASS && RESERVED_WINDOWS_NAMESPACE.contains(value.toLowerCase());
    }

    @Override
    public String getNextClassName(String fullName, String shortName) {
        int index;
        if (shortName == null) {
            return "class_" + this.classCounter++;
        }
        for (index = 0; index < shortName.length() && Character.isDigit(shortName.charAt(index)); ++index) {
        }
        if (index == 0 || index == shortName.length()) {
            return "class_" + this.classCounter++;
        }
        String name = shortName.substring(index);
        if (this.setNonStandardClassNames.contains(name)) {
            return "Inner" + name + "_" + this.classCounter++;
        }
        this.setNonStandardClassNames.add(name);
        return "Inner" + name;
    }

    @Override
    public String getNextFieldName(String className, String field, String descriptor) {
        return "field_" + this.fieldCounter++;
    }

    @Override
    public String getNextMethodName(String className, String method, String descriptor) {
        return "method_" + this.methodCounter++;
    }

    public static String getSimpleClassName(String fullName) {
        return fullName.substring(fullName.lastIndexOf(47) + 1);
    }

    public static String replaceSimpleClassName(String fullName, String newName) {
        return fullName.substring(0, fullName.lastIndexOf(47) + 1) + newName;
    }
}

