/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.Collection;
import java.util.List;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.FunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.SuspendFunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyGetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.TypeEnhancementKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmDescriptorTypeWriter;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmTypeFactory;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingConfiguration;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingConfigurationImpl;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingMode;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.platform.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.InlineClassesUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmClassName;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.IntersectionTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.utils.FunctionsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeSignatureMappingKt {
    private static final String CONTINUATION_INTERNAL_NAME;

    private static final <T> T boxTypeIfNeeded(@NotNull JvmTypeFactory<T> $receiver, T possiblyPrimitiveType, boolean needBoxedType) {
        return needBoxedType ? $receiver.boxType(possiblyPrimitiveType) : possiblyPrimitiveType;
    }

    @NotNull
    public static final <T> T mapType(@NotNull KotlinType kotlinType, @NotNull JvmTypeFactory<T> factory, @NotNull TypeMappingMode mode, @NotNull TypeMappingConfiguration<? extends T> typeMappingConfiguration, @Nullable JvmDescriptorTypeWriter<T> descriptorTypeWriter, @NotNull Function3<? super KotlinType, ? super T, ? super TypeMappingMode, Unit> writeGenericType) {
        Intrinsics.checkParameterIsNotNull((Object)kotlinType, (String)"kotlinType");
        Intrinsics.checkParameterIsNotNull(factory, (String)"factory");
        Intrinsics.checkParameterIsNotNull((Object)mode, (String)"mode");
        Intrinsics.checkParameterIsNotNull(typeMappingConfiguration, (String)"typeMappingConfiguration");
        Intrinsics.checkParameterIsNotNull(writeGenericType, (String)"writeGenericType");
        if (FunctionTypesKt.isSuspendFunctionType(kotlinType)) {
            return TypeSignatureMappingKt.mapType(SuspendFunctionTypesKt.transformSuspendFunctionToRuntimeFunctionType(kotlinType), factory, mode, typeMappingConfiguration, descriptorTypeWriter, writeGenericType);
        }
        T t = TypeSignatureMappingKt.mapBuiltInType(kotlinType, factory, mode);
        if (t != null) {
            T t2;
            T builtInType = t2 = t;
            T jvmType = TypeSignatureMappingKt.boxTypeIfNeeded(factory, builtInType, mode.getNeedPrimitiveBoxing());
            writeGenericType.invoke((Object)kotlinType, jvmType, (Object)mode);
            return jvmType;
        }
        TypeConstructor constructor = kotlinType.getConstructor();
        if (constructor instanceof IntersectionTypeConstructor) {
            Collection<KotlinType> collection = ((IntersectionTypeConstructor)constructor).getSupertypes();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"constructor.supertypes");
            KotlinType commonSupertype = typeMappingConfiguration.commonSupertype(collection);
            return TypeSignatureMappingKt.mapType(TypeUtilsKt.replaceArgumentsWithStarProjections(commonSupertype), factory, mode, typeMappingConfiguration, descriptorTypeWriter, writeGenericType);
        }
        ClassifierDescriptor classifierDescriptor = constructor.getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            throw (Throwable)new UnsupportedOperationException("no descriptor for type constructor of " + kotlinType);
        }
        ClassifierDescriptor descriptor2 = classifierDescriptor;
        if (ErrorUtils.isError(descriptor2)) {
            T jvmType = factory.createObjectType("error/NonExistentClass");
            ClassifierDescriptor classifierDescriptor2 = descriptor2;
            if (classifierDescriptor2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            typeMappingConfiguration.processErrorType(kotlinType, (ClassDescriptor)classifierDescriptor2);
            JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter = descriptorTypeWriter;
            if (jvmDescriptorTypeWriter != null) {
                jvmDescriptorTypeWriter.writeClass(jvmType);
            }
            return jvmType;
        }
        if (descriptor2 instanceof ClassDescriptor && KotlinBuiltIns.isArray(kotlinType)) {
            T arrayElementType;
            if (kotlinType.getArguments().size() != 1) {
                throw (Throwable)new UnsupportedOperationException("arrays must have one type argument");
            }
            TypeProjection memberProjection = kotlinType.getArguments().get(0);
            KotlinType memberType = memberProjection.getType();
            if (memberProjection.getProjectionKind() == Variance.IN_VARIANCE) {
                arrayElementType = factory.createObjectType("java/lang/Object");
                JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter = descriptorTypeWriter;
                if (jvmDescriptorTypeWriter != null) {
                    JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter2;
                    JvmDescriptorTypeWriter<Object> $receiver = jvmDescriptorTypeWriter2 = jvmDescriptorTypeWriter;
                    $receiver.writeArrayType();
                    $receiver.writeClass(arrayElementType);
                    $receiver.writeArrayEnd();
                }
            } else {
                JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter = descriptorTypeWriter;
                if (jvmDescriptorTypeWriter != null) {
                    jvmDescriptorTypeWriter.writeArrayType();
                }
                KotlinType kotlinType2 = memberType;
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"memberType");
                Variance variance = memberProjection.getProjectionKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)variance), (String)"memberProjection.projectionKind");
                arrayElementType = TypeSignatureMappingKt.mapType(kotlinType2, factory, mode.toGenericArgumentMode(variance), typeMappingConfiguration, descriptorTypeWriter, writeGenericType);
                JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter3 = descriptorTypeWriter;
                if (jvmDescriptorTypeWriter3 != null) {
                    jvmDescriptorTypeWriter3.writeArrayEnd();
                }
            }
            return factory.createFromString("[" + factory.toString(arrayElementType));
        }
        if (descriptor2 instanceof ClassDescriptor) {
            T t3;
            KotlinType typeForMapping;
            if (((ClassDescriptor)descriptor2).isInline() && !mode.getNeedInlineClassWrapping() && (typeForMapping = TypeSignatureMappingKt.computeUnderlyingType(kotlinType)) != null) {
                TypeMappingMode newMode = InlineClassesUtilsKt.isInlineClassType(typeForMapping) ? mode : mode.wrapInlineClassesMode();
                return TypeSignatureMappingKt.mapType(typeForMapping, factory, newMode, typeMappingConfiguration, descriptorTypeWriter, writeGenericType);
            }
            if (mode.isForAnnotationParameter() && KotlinBuiltIns.isKClass((ClassDescriptor)descriptor2)) {
                t3 = factory.getJavaLangClassType();
            } else {
                ClassDescriptor classDescriptor = ((ClassDescriptor)descriptor2).getOriginal();
                Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor, (String)"descriptor.original");
                t3 = typeMappingConfiguration.getPredefinedTypeForClass(classDescriptor);
                if (t3 == null) {
                    ClassDescriptor classDescriptor2;
                    if (((ClassDescriptor)descriptor2).getKind() == ClassKind.ENUM_ENTRY) {
                        DeclarationDescriptor declarationDescriptor = ((ClassDescriptor)descriptor2).getContainingDeclaration();
                        if (declarationDescriptor == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                        }
                        classDescriptor2 = (ClassDescriptor)declarationDescriptor;
                    } else {
                        classDescriptor2 = (ClassDescriptor)descriptor2;
                    }
                    ClassDescriptor enumClassIfEnumEntry = classDescriptor2;
                    ClassDescriptor classDescriptor3 = enumClassIfEnumEntry.getOriginal();
                    Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor3, (String)"enumClassIfEnumEntry.original");
                    t3 = factory.createObjectType(TypeSignatureMappingKt.computeInternalName(classDescriptor3, typeMappingConfiguration));
                }
            }
            T jvmType = t3;
            writeGenericType.invoke((Object)kotlinType, jvmType, (Object)mode);
            return jvmType;
        }
        if (descriptor2 instanceof TypeParameterDescriptor) {
            JvmDescriptorTypeWriter<T> jvmDescriptorTypeWriter = null;
            Function3<Object, Object, Object, Unit> function3 = FunctionsKt.getDO_NOTHING_3();
            Object type2 = TypeSignatureMappingKt.mapType(TypeSignatureMappingKt.getRepresentativeUpperBound((TypeParameterDescriptor)descriptor2), factory, mode, typeMappingConfiguration, jvmDescriptorTypeWriter, function3);
            JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter4 = descriptorTypeWriter;
            if (jvmDescriptorTypeWriter4 != null) {
                Name name = descriptor2.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"descriptor.getName()");
                jvmDescriptorTypeWriter4.writeTypeVariable(name, type2);
            }
            return (T)type2;
        }
        throw (Throwable)new UnsupportedOperationException("Unknown type " + kotlinType);
    }

    @NotNull
    public static /* synthetic */ Object mapType$default(KotlinType kotlinType, JvmTypeFactory jvmTypeFactory, TypeMappingMode typeMappingMode, TypeMappingConfiguration typeMappingConfiguration, JvmDescriptorTypeWriter jvmDescriptorTypeWriter, Function3 function3, int n, Object object) {
        if ((n & 0x20) != 0) {
            function3 = FunctionsKt.getDO_NOTHING_3();
        }
        return TypeSignatureMappingKt.mapType(kotlinType, jvmTypeFactory, typeMappingMode, typeMappingConfiguration, jvmDescriptorTypeWriter, function3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasVoidReturnType(@NotNull CallableDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        if (descriptor2 instanceof ConstructorDescriptor) {
            return true;
        }
        KotlinType kotlinType = descriptor2.getReturnType();
        if (kotlinType == null) {
            Intrinsics.throwNpe();
        }
        if (!KotlinBuiltIns.isUnit(kotlinType)) return false;
        KotlinType kotlinType2 = descriptor2.getReturnType();
        if (kotlinType2 == null) {
            Intrinsics.throwNpe();
        }
        if (TypeUtils.isNullableType(kotlinType2)) return false;
        if (descriptor2 instanceof PropertyGetterDescriptor) return false;
        return true;
    }

    private static final <T> T mapBuiltInType(KotlinType type2, JvmTypeFactory<T> typeFactory, TypeMappingMode mode) {
        ClassId classId;
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor descriptor2 = classDescriptor;
        if (descriptor2 == SuspendFunctionTypesKt.getFAKE_CONTINUATION_CLASS_DESCRIPTOR()) {
            String string = CONTINUATION_INTERNAL_NAME;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"CONTINUATION_INTERNAL_NAME");
            return typeFactory.createObjectType(string);
        }
        PrimitiveType primitiveType = KotlinBuiltIns.getPrimitiveType(descriptor2);
        if (primitiveType != null) {
            JvmPrimitiveType jvmPrimitiveType = JvmPrimitiveType.get(primitiveType);
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)jvmPrimitiveType), (String)"JvmPrimitiveType.get(primitiveType)");
            String string = jvmPrimitiveType.getDesc();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JvmPrimitiveType.get(primitiveType).desc");
            T jvmType = typeFactory.createFromString(string);
            boolean isNullableInJava = TypeUtils.isNullableType(type2) || TypeEnhancementKt.hasEnhancedNullability(type2);
            return TypeSignatureMappingKt.boxTypeIfNeeded(typeFactory, jvmType, isNullableInJava);
        }
        PrimitiveType arrayElementType = KotlinBuiltIns.getPrimitiveArrayType(descriptor2);
        if (arrayElementType != null) {
            StringBuilder stringBuilder = new StringBuilder().append("[");
            JvmPrimitiveType jvmPrimitiveType = JvmPrimitiveType.get(arrayElementType);
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)jvmPrimitiveType), (String)"JvmPrimitiveType.get(arrayElementType)");
            return typeFactory.createFromString(stringBuilder.append(jvmPrimitiveType.getDesc()).toString());
        }
        if (KotlinBuiltIns.isUnderKotlinPackage(descriptor2) && (classId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(DescriptorUtilsKt.getFqNameUnsafe(descriptor2))) != null) {
            if (!mode.getKotlinCollectionsToJavaCollections()) {
                boolean bl;
                block11: {
                    Iterable $receiver$iv = JavaToKotlinClassMap.INSTANCE.getMutabilityMappings();
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $receiver$iv) {
                            JavaToKotlinClassMap.PlatformMutabilityMapping it = (JavaToKotlinClassMap.PlatformMutabilityMapping)element$iv;
                            if (!Intrinsics.areEqual((Object)it.getJavaClass(), (Object)classId)) continue;
                            bl = true;
                            break block11;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return null;
                }
            }
            JvmClassName jvmClassName = JvmClassName.byClassId(classId);
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"JvmClassName.byClassId(classId)");
            String string = jvmClassName.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JvmClassName.byClassId(classId).internalName");
            return typeFactory.createObjectType(string);
        }
        return null;
    }

    private static final KotlinType computeUnderlyingType(KotlinType inlineClassType) {
        if (!TypeSignatureMappingKt.shouldUseUnderlyingType(inlineClassType)) {
            return null;
        }
        Object object = InlineClassesUtilsKt.unsubstitutedUnderlyingType(inlineClassType);
        if (object == null || (object = ((KotlinType)object).getConstructor()) == null || (object = object.getDeclarationDescriptor()) == null) {
            return null;
        }
        Object descriptor2 = object;
        return descriptor2 instanceof TypeParameterDescriptor ? TypeSignatureMappingKt.getRepresentativeUpperBound((TypeParameterDescriptor)descriptor2) : InlineClassesUtilsKt.substitutedUnderlyingType(inlineClassType);
    }

    private static final boolean shouldUseUnderlyingType(KotlinType inlineClassType) {
        KotlinType kotlinType = InlineClassesUtilsKt.unsubstitutedUnderlyingType(inlineClassType);
        if (kotlinType == null) {
            return false;
        }
        KotlinType underlyingType = kotlinType;
        return !inlineClassType.isMarkedNullable() || !TypeUtils.isNullableType(underlyingType) && !KotlinBuiltIns.isPrimitiveType(underlyingType);
    }

    @NotNull
    public static final String computeInternalName(@NotNull ClassDescriptor klass, @NotNull TypeMappingConfiguration<?> typeMappingConfiguration) {
        Intrinsics.checkParameterIsNotNull((Object)klass, (String)"klass");
        Intrinsics.checkParameterIsNotNull(typeMappingConfiguration, (String)"typeMappingConfiguration");
        DeclarationDescriptor container = klass.getContainingDeclaration();
        Name name = SpecialNames.safeIdentifier(klass.getName());
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"SpecialNames.safeIdentifier(klass.name)");
        String name2 = name.getIdentifier();
        if (container instanceof PackageFragmentDescriptor) {
            String string;
            FqName fqName2 = ((PackageFragmentDescriptor)container).getFqName();
            if (fqName2.isRoot()) {
                String string2 = name2;
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                String string3 = fqName2.asString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"fqName.asString()");
                string = stringBuilder.append(StringsKt.replace$default((String)string3, (char)'.', (char)'/', (boolean)false, (int)4, null)).append('/').append(name2).toString();
            }
            return string;
        }
        DeclarationDescriptor declarationDescriptor = container;
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        if (classDescriptor == null) {
            throw (Throwable)new IllegalArgumentException("Unexpected container: " + container + " for " + klass);
        }
        ClassDescriptor containerClass = classDescriptor;
        String string = typeMappingConfiguration.getPredefinedInternalNameForClass(containerClass);
        if (string == null) {
            string = TypeSignatureMappingKt.computeInternalName(containerClass, typeMappingConfiguration);
        }
        String containerInternalName = string;
        return containerInternalName + "$" + name2;
    }

    @NotNull
    public static /* synthetic */ String computeInternalName$default(ClassDescriptor classDescriptor, TypeMappingConfiguration typeMappingConfiguration, int n, Object object) {
        if ((n & 2) != 0) {
            typeMappingConfiguration = TypeMappingConfigurationImpl.INSTANCE;
        }
        return TypeSignatureMappingKt.computeInternalName(classDescriptor, typeMappingConfiguration);
    }

    private static final KotlinType getRepresentativeUpperBound(TypeParameterDescriptor descriptor2) {
        KotlinType kotlinType;
        Object v4;
        List<KotlinType> upperBounds2;
        block4: {
            boolean bl;
            upperBounds2 = descriptor2.getUpperBounds();
            boolean bl2 = bl = !upperBounds2.isEmpty();
            if (_Assertions.ENABLED && !bl) {
                String string = "Upper bounds should not be empty: " + descriptor2;
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            List<KotlinType> list = upperBounds2;
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"upperBounds");
            Iterable $receiver$iv = list;
            for (Object element$iv : $receiver$iv) {
                ClassDescriptor classDescriptor;
                KotlinType it = (KotlinType)element$iv;
                ClassifierDescriptor classifierDescriptor = it.getConstructor().getDeclarationDescriptor();
                if (!(classifierDescriptor instanceof ClassDescriptor)) {
                    classifierDescriptor = null;
                }
                boolean bl3 = (ClassDescriptor)classifierDescriptor == null ? false : classDescriptor.getKind() != ClassKind.INTERFACE && classDescriptor.getKind() != ClassKind.ANNOTATION_CLASS;
                if (!bl3) continue;
                v4 = element$iv;
                break block4;
            }
            v4 = null;
        }
        if ((kotlinType = (KotlinType)v4) == null) {
            Object object = CollectionsKt.first(upperBounds2);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"upperBounds.first()");
            kotlinType = (KotlinType)object;
        }
        return kotlinType;
    }

    static {
        JvmClassName jvmClassName = JvmClassName.byClassId(ClassId.topLevel(DescriptorUtils.CONTINUATION_INTERFACE_FQ_NAME));
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"JvmClassName.byClassId(C\u2026ATION_INTERFACE_FQ_NAME))");
        CONTINUATION_INTERNAL_NAME = jvmClassName.getInternalName();
    }
}

