/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.model.functors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.contracts.model.Computation;
import org.jetbrains.kotlin.contracts.model.ConditionalEffect;
import org.jetbrains.kotlin.contracts.model.ESEffect;
import org.jetbrains.kotlin.contracts.model.ESExpression;
import org.jetbrains.kotlin.contracts.model.ESValue;
import org.jetbrains.kotlin.contracts.model.functors.AbstractReducingFunctor;
import org.jetbrains.kotlin.contracts.model.structure.ESConstant;
import org.jetbrains.kotlin.contracts.model.structure.ESIs;
import org.jetbrains.kotlin.contracts.model.structure.ESReturns;
import org.jetbrains.kotlin.contracts.model.structure.OperatorsKt;
import org.jetbrains.kotlin.contracts.model.structure.ValuesKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bH\u0014J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0010\u001a\u00020\u000eJ \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/contracts/model/functors/IsFunctor;", "Lorg/jetbrains/kotlin/contracts/model/functors/AbstractReducingFunctor;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "isNegated", "", "(Lorg/jetbrains/kotlin/types/KotlinType;Z)V", "()Z", "getType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "doInvocation", "", "Lorg/jetbrains/kotlin/contracts/model/ESEffect;", "arguments", "Lorg/jetbrains/kotlin/contracts/model/Computation;", "invokeWithArguments", "arg", "invokeWithValue", "Lorg/jetbrains/kotlin/contracts/model/ConditionalEffect;", "value", "Lorg/jetbrains/kotlin/contracts/model/ESValue;", "additionalCondition", "Lorg/jetbrains/kotlin/contracts/model/ESExpression;", "resolution"})
public final class IsFunctor
extends AbstractReducingFunctor {
    @NotNull
    private final KotlinType type;
    private final boolean isNegated;

    @Override
    @NotNull
    protected List<ESEffect> doInvocation(@NotNull List<? extends Computation> arguments2) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        boolean bl2 = bl = arguments2.size() == 1;
        if (_Assertions.ENABLED && !bl) {
            String string = "Wrong size of arguments list for Unary operator: expected 1, got " + arguments2.size();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return this.invokeWithArguments(arguments2.get(0));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ESEffect> invokeWithArguments(@NotNull Computation arg) {
        List list2;
        Intrinsics.checkParameterIsNotNull(arg, "arg");
        if (arg instanceof ESValue) {
            list2 = this.invokeWithValue((ESValue)arg, null);
        } else {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)arg.getEffects();
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                ESEffect it = (ESEffect)element$iv$iv;
                Iterable list$iv$iv = !(it instanceof ConditionalEffect) || !(((ConditionalEffect)it).getSimpleEffect() instanceof ESReturns) || Intrinsics.areEqual(((ESReturns)((ConditionalEffect)it).getSimpleEffect()).getValue(), ESConstant.Companion.getWILDCARD()) ? CollectionsKt.listOf(it) : this.invokeWithValue(((ESReturns)((ConditionalEffect)it).getSimpleEffect()).getValue(), ((ConditionalEffect)it).getCondition());
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        }
        return list2;
    }

    private final List<ConditionalEffect> invokeWithValue(ESValue value, ESExpression additionalCondition) {
        ESIs trueIs = new ESIs(value, this);
        ESIs falseIs = new ESIs(value, new IsFunctor(this.type, !this.isNegated));
        ConditionalEffect trueResult = new ConditionalEffect(OperatorsKt.and(trueIs, additionalCondition), new ESReturns(ValuesKt.lift(true)));
        ConditionalEffect falseResult = new ConditionalEffect(OperatorsKt.and(falseIs, additionalCondition), new ESReturns(ValuesKt.lift(false)));
        return CollectionsKt.listOf(new ConditionalEffect[]{trueResult, falseResult});
    }

    @NotNull
    public final KotlinType getType() {
        return this.type;
    }

    public final boolean isNegated() {
        return this.isNegated;
    }

    public IsFunctor(@NotNull KotlinType type2, boolean isNegated) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        this.type = type2;
        this.isNegated = isNegated;
    }
}

