/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.facade;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PsiFileImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.backend.common.output.SimpleOutputBinaryFile;
import org.jetbrains.kotlin.backend.common.output.SimpleOutputFile;
import org.jetbrains.kotlin.backend.common.output.SimpleOutputFileCollection;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.js.backend.JsToStringGenerationVisitor;
import org.jetbrains.kotlin.js.backend.NoOpSourceLocationConsumer;
import org.jetbrains.kotlin.js.backend.SourceLocationConsumer;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.config.SourceMapSourceEmbedding;
import org.jetbrains.kotlin.js.facade.SourceMapBuilderConsumer;
import org.jetbrains.kotlin.js.sourceMap.SourceFilePathResolver;
import org.jetbrains.kotlin.js.sourceMap.SourceMap3Builder;
import org.jetbrains.kotlin.js.util.TextOutput;
import org.jetbrains.kotlin.js.util.TextOutputImpl;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.serialization.js.JsModuleDescriptor;
import org.jetbrains.kotlin.serialization.js.JsSerializerProtocol;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializationUtil;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadataUtils;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001:\u0002\u0007\bB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/js/facade/TranslationResult;", "", "diagnostics", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "(Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;)V", "getDiagnostics", "()Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "Fail", "Success", "js.translator"})
public abstract class TranslationResult {
    @NotNull
    private final Diagnostics diagnostics;

    @NotNull
    public final Diagnostics getDiagnostics() {
        return this.diagnostics;
    }

    protected TranslationResult(@NotNull Diagnostics diagnostics2) {
        Intrinsics.checkParameterIsNotNull(diagnostics2, "diagnostics");
        this.diagnostics = diagnostics2;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/js/facade/TranslationResult$Fail;", "Lorg/jetbrains/kotlin/js/facade/TranslationResult;", "diagnostics", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "(Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;)V", "js.translator"})
    public static final class Fail
    extends TranslationResult {
        public Fail(@NotNull Diagnostics diagnostics2) {
            Intrinsics.checkParameterIsNotNull(diagnostics2, "diagnostics");
            super(diagnostics2);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0018\u001a\u00020\fH\u0007J\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\"\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010!2\b\u0010#\u001a\u0004\u0018\u00010!J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/js/facade/TranslationResult$Success;", "Lorg/jetbrains/kotlin/js/facade/TranslationResult;", "config", "Lorg/jetbrains/kotlin/js/config/JsConfig;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "program", "Lorg/jetbrains/kotlin/js/backend/ast/JsProgram;", "diagnostics", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "importedModules", "", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "(Lorg/jetbrains/kotlin/js/config/JsConfig;Ljava/util/List;Lorg/jetbrains/kotlin/js/backend/ast/JsProgram;Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;Ljava/util/List;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "getBindingContext", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "getModuleDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "getProgram", "()Lorg/jetbrains/kotlin/js/backend/ast/JsProgram;", "getCode", "", "output", "Lorg/jetbrains/kotlin/js/util/TextOutput;", "sourceLocationConsumer", "Lorg/jetbrains/kotlin/js/backend/SourceLocationConsumer;", "getOutputFiles", "Lorg/jetbrains/kotlin/backend/common/output/OutputFileCollection;", "outputFile", "Ljava/io/File;", "outputPrefixFile", "outputPostfixFile", "kjsmFileForPackage", "Lorg/jetbrains/kotlin/backend/common/output/SimpleOutputBinaryFile;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "bytes", "", "js.translator"})
    public static final class Success
    extends TranslationResult {
        private final JsConfig config;
        private final List<KtFile> files;
        @NotNull
        private final JsProgram program;
        private final List<String> importedModules;
        @NotNull
        private final ModuleDescriptor moduleDescriptor;
        @NotNull
        private final BindingContext bindingContext;

        @NotNull
        public final String getCode() {
            TextOutputImpl output = new TextOutputImpl();
            this.getCode(output, null);
            String string = output.toString();
            Intrinsics.checkExpressionValueIsNotNull(string, "output.toString()");
            return string;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final OutputFileCollection getOutputFiles(@NotNull File outputFile, @Nullable File outputPrefixFile, @Nullable File outputPostfixFile) {
            Object virtualFile2;
            ModuleKind it;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Object object;
            Object prefix;
            SourceMapBuilderConsumer sourceMapBuilderConsumer;
            Intrinsics.checkParameterIsNotNull(outputFile, "outputFile");
            TextOutputImpl output = new TextOutputImpl();
            SourceMap3Builder sourceMapBuilder = new SourceMap3Builder(outputFile, output, this.config.getSourceMapPrefix());
            if (this.config.getConfiguration().getBoolean(JSConfigurationKeys.SOURCE_MAP)) {
                SourceMapSourceEmbedding sourceMapContentEmbedding = this.config.getSourceMapContentEmbedding();
                SourceFilePathResolver pathResolver = SourceFilePathResolver.create(this.config);
                sourceMapBuilderConsumer = new SourceMapBuilderConsumer(new File("."), sourceMapBuilder, pathResolver, sourceMapContentEmbedding == SourceMapSourceEmbedding.ALWAYS, sourceMapContentEmbedding != SourceMapSourceEmbedding.NEVER);
            } else {
                sourceMapBuilderConsumer = null;
            }
            SourceMapBuilderConsumer sourceMapBuilderConsumer2 = sourceMapBuilderConsumer;
            this.getCode(output, sourceMapBuilderConsumer2);
            if (sourceMapBuilderConsumer2 != null) {
                sourceMapBuilder.addLink();
            }
            String code = output.toString();
            Object object2 = outputPrefixFile;
            if (object2 == null || (object2 = FilesKt.readText$default((File)object2, null, 1, null)) == null) {
                object2 = prefix = "";
            }
            if ((object = outputPostfixFile) == null || (object = FilesKt.readText$default((File)object, null, 1, null)) == null) {
                object = "";
            }
            Object postfix = object;
            Iterable iterable = $receiver$iv = (Iterable)this.files;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                File file2;
                KtFile ktFile = (KtFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                PsiFile psiFile = ((PsiFileImpl)((Object)it)).getOriginalFile();
                Intrinsics.checkExpressionValueIsNotNull(psiFile, "it.originalFile");
                virtualFile2 = psiFile.getVirtualFile();
                if (virtualFile2 == null) {
                    file2 = new File(((PsiFileImpl)((Object)it)).getName());
                } else {
                    File file3 = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile2);
                    file2 = file3;
                    Intrinsics.checkExpressionValueIsNotNull(file3, "VfsUtilCore.virtualToIoFile(virtualFile)");
                }
                File file4 = file2;
                collection.add(file4);
            }
            List sourceFiles2 = (List)destination$iv$iv;
            String string = outputFile.getName();
            Intrinsics.checkExpressionValueIsNotNull(string, "outputFile.name");
            SimpleOutputFile jsFile = new SimpleOutputFile(sourceFiles2, string, (String)prefix + code + (String)postfix);
            ArrayList<OutputFile> outputFiles = CollectionsKt.arrayListOf(jsFile);
            if (this.config.getConfiguration().getBoolean(JSConfigurationKeys.META_INFO)) {
                Object item$iv$iv;
                String string2 = outputFile.getName();
                Intrinsics.checkExpressionValueIsNotNull(string2, "outputFile.name");
                String metaFileName = KotlinJavascriptMetadataUtils.INSTANCE.replaceSuffix(string2);
                String string3 = this.config.getModuleId();
                Intrinsics.checkExpressionValueIsNotNull(string3, "config.moduleId");
                ModuleKind moduleKind = this.config.getModuleKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleKind, "config.moduleKind");
                item$iv$iv = this.importedModules;
                it = moduleKind;
                virtualFile2 = this.moduleDescriptor;
                JsModuleDescriptor<Object> moduleDescription = new JsModuleDescriptor<Object>(string3, it, (List<String>)item$iv$iv, virtualFile2);
                CompilerConfiguration compilerConfiguration = this.config.getConfiguration();
                Intrinsics.checkExpressionValueIsNotNull(compilerConfiguration, "config.configuration");
                LanguageVersionSettings settings2 = CommonConfigurationKeysKt.getLanguageVersionSettings(compilerConfiguration);
                KotlinJavascriptSerializationUtil.SerializedMetadata serializedMetadata = KotlinJavascriptSerializationUtil.INSTANCE.serializeMetadata(this.bindingContext, moduleDescription, settings2);
                String metaFileContent = serializedMetadata.asString();
                ArrayList sourceFilesForMetaFile = new ArrayList(sourceFiles2);
                SimpleOutputFile jsMetaFile = new SimpleOutputFile(sourceFilesForMetaFile, metaFileName, metaFileContent);
                outputFiles.add(jsMetaFile);
                for (KotlinJavascriptSerializationUtil.SerializedMetadata.SerializedPackage serializedPackage : serializedMetadata.serializedPackages()) {
                    SimpleOutputBinaryFile outputBinaryFile = this.kjsmFileForPackage(serializedPackage.getFqName(), serializedPackage.getBytes());
                    outputFiles.add(outputBinaryFile);
                }
            }
            if (sourceMapBuilderConsumer2 != null) {
                sourceMapBuilder.skipLinesAtBeginning(StringUtil.getLineBreakCount((CharSequence)prefix));
                File file5 = sourceMapBuilder.getOutFile();
                Intrinsics.checkExpressionValueIsNotNull(file5, "sourceMapBuilder.outFile");
                String string4 = file5.getName();
                Intrinsics.checkExpressionValueIsNotNull(string4, "sourceMapBuilder.outFile.name");
                String string5 = sourceMapBuilder.build();
                Intrinsics.checkExpressionValueIsNotNull(string5, "sourceMapBuilder.build()");
                SimpleOutputFile sourceMapFile = new SimpleOutputFile(sourceFiles2, string4, string5);
                outputFiles.add(sourceMapFile);
                sourceMapBuilder.addLink();
            }
            return new SimpleOutputFileCollection((List<? extends OutputFile>)outputFiles);
        }

        /*
         * WARNING - void declaration
         */
        private final SimpleOutputBinaryFile kjsmFileForPackage(FqName packageFqName, byte[] bytes) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Collection ktFiles2;
            Collection collection = (Collection)this.bindingContext.get(BindingContext.PACKAGE_TO_FILES, packageFqName);
            if (collection == null) {
                collection = CollectionsKt.emptyList();
            }
            Collection collection2 = ktFiles2 = collection;
            Intrinsics.checkExpressionValueIsNotNull(collection2, "ktFiles");
            Iterable iterable = $receiver$iv = (Iterable)collection2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                KtFile ktFile = (KtFile)item$iv$iv;
                Collection collection3 = destination$iv$iv;
                void v2 = it;
                Intrinsics.checkExpressionValueIsNotNull(v2, "it");
                File file2 = VfsUtilCore.virtualToIoFile(v2.getVirtualFile());
                collection3.add(file2);
            }
            List sourceFiles2 = (List)destination$iv$iv;
            String relativePath = this.config.getModuleId() + '/' + JsSerializerProtocol.INSTANCE.getKjsmFilePath(packageFqName);
            return new SimpleOutputBinaryFile(sourceFiles2, relativePath, bytes);
        }

        private final void getCode(TextOutput output, SourceLocationConsumer sourceLocationConsumer) {
            SourceLocationConsumer sourceLocationConsumer2 = sourceLocationConsumer;
            if (sourceLocationConsumer2 == null) {
                sourceLocationConsumer2 = NoOpSourceLocationConsumer.INSTANCE;
            }
            this.program.accept(new JsToStringGenerationVisitor(output, sourceLocationConsumer2));
        }

        @NotNull
        public final JsProgram getProgram() {
            return this.program;
        }

        @NotNull
        public final ModuleDescriptor getModuleDescriptor() {
            return this.moduleDescriptor;
        }

        @NotNull
        public final BindingContext getBindingContext() {
            return this.bindingContext;
        }

        public Success(@NotNull JsConfig config, @NotNull List<? extends KtFile> files2, @NotNull JsProgram program, @NotNull Diagnostics diagnostics2, @NotNull List<String> importedModules, @NotNull ModuleDescriptor moduleDescriptor, @NotNull BindingContext bindingContext) {
            Intrinsics.checkParameterIsNotNull(config, "config");
            Intrinsics.checkParameterIsNotNull(files2, "files");
            Intrinsics.checkParameterIsNotNull(program, "program");
            Intrinsics.checkParameterIsNotNull(diagnostics2, "diagnostics");
            Intrinsics.checkParameterIsNotNull(importedModules, "importedModules");
            Intrinsics.checkParameterIsNotNull(moduleDescriptor, "moduleDescriptor");
            Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
            super(diagnostics2);
            this.config = config;
            this.files = files2;
            this.program = program;
            this.importedModules = importedModules;
            this.moduleDescriptor = moduleDescriptor;
            this.bindingContext = bindingContext;
        }
    }
}

