/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.lazy.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.NotFoundClasses;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.load.java.components.TypeUsage;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.LazyJavaAnnotations;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.LazyJavaResolverContext;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.TypeParameterResolver;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.JavaTypeAttributes;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.JavaTypeFlexibility;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.JavaTypeResolver;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.JavaTypeResolver$computeArguments$;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.JavaTypeResolverKt;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.RawSubstitution;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.RawTypeImpl;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaArrayType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClassifier;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClassifierType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaPrimitiveType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaTypeParameter;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaWildcardType;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.platform.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.LazyWrappedType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;

public final class JavaTypeResolver {
    private final LazyJavaResolverContext c;
    private final TypeParameterResolver typeParameterResolver;

    @NotNull
    public final KotlinType transformJavaType(@NotNull JavaType javaType, @NotNull JavaTypeAttributes attr) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)javaType, (String)"javaType");
        Intrinsics.checkParameterIsNotNull((Object)attr, (String)"attr");
        JavaType javaType2 = javaType;
        if (javaType2 instanceof JavaPrimitiveType) {
            PrimitiveType primitiveType = ((JavaPrimitiveType)javaType).getType();
            SimpleType simpleType2 = primitiveType != null ? this.c.getModule().getBuiltIns().getPrimitiveKotlinType(primitiveType) : this.c.getModule().getBuiltIns().getUnitType();
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"if (primitiveType != nul\u2026.module.builtIns.unitType");
            object = simpleType2;
        } else if (javaType2 instanceof JavaClassifierType) {
            object = this.transformJavaClassifierType((JavaClassifierType)javaType, attr);
        } else if (javaType2 instanceof JavaArrayType) {
            object = JavaTypeResolver.transformArrayType$default(this, (JavaArrayType)javaType, attr, false, 4, null);
        } else if (javaType2 instanceof JavaWildcardType) {
            Object object2;
            Object it;
            object = ((JavaWildcardType)javaType).getBound();
            if (object == null || (object = this.transformJavaType((JavaType)(it = (object2 = object)), attr)) == null) {
                SimpleType simpleType3 = this.c.getModule().getBuiltIns().getDefaultBound();
                Intrinsics.checkExpressionValueIsNotNull((Object)simpleType3, (String)"c.module.builtIns.defaultBound");
                object = simpleType3;
            }
        } else {
            throw (Throwable)new UnsupportedOperationException("Unsupported type: " + javaType);
        }
        return object;
    }

    @NotNull
    public final KotlinType transformArrayType(@NotNull JavaArrayType arrayType, @NotNull JavaTypeAttributes attr, boolean isVararg) {
        PrimitiveType primitiveType;
        Intrinsics.checkParameterIsNotNull((Object)arrayType, (String)"arrayType");
        Intrinsics.checkParameterIsNotNull((Object)attr, (String)"attr");
        JavaType javaComponentType = arrayType.getComponentType();
        JavaType javaType = javaComponentType;
        if (!(javaType instanceof JavaPrimitiveType)) {
            javaType = null;
        }
        JavaPrimitiveType javaPrimitiveType = (JavaPrimitiveType)javaType;
        PrimitiveType primitiveType2 = primitiveType = javaPrimitiveType != null ? javaPrimitiveType.getType() : null;
        if (primitiveType != null) {
            KotlinType kotlinType;
            SimpleType jetType = this.c.getModule().getBuiltIns().getPrimitiveArrayKotlinType(primitiveType);
            if (attr.isForAnnotationParameter()) {
                SimpleType simpleType2 = jetType;
                Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"jetType");
                kotlinType = simpleType2;
            } else {
                SimpleType simpleType3 = jetType;
                Intrinsics.checkExpressionValueIsNotNull((Object)simpleType3, (String)"jetType");
                kotlinType = KotlinTypeFactory.flexibleType(simpleType3, jetType.makeNullableAsSpecified(true));
            }
            return kotlinType;
        }
        KotlinType componentType = this.transformJavaType(javaComponentType, JavaTypeResolverKt.toAttributes$default(TypeUsage.COMMON, attr.isForAnnotationParameter(), null, 2, null));
        if (attr.isForAnnotationParameter()) {
            Variance projectionKind = isVararg ? Variance.OUT_VARIANCE : Variance.INVARIANT;
            SimpleType simpleType4 = this.c.getModule().getBuiltIns().getArrayType(projectionKind, componentType);
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType4, (String)"c.module.builtIns.getArr\u2026ctionKind, componentType)");
            return simpleType4;
        }
        SimpleType simpleType5 = this.c.getModule().getBuiltIns().getArrayType(Variance.INVARIANT, componentType);
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType5, (String)"c.module.builtIns.getArr\u2026INVARIANT, componentType)");
        return KotlinTypeFactory.flexibleType(simpleType5, this.c.getModule().getBuiltIns().getArrayType(Variance.OUT_VARIANCE, componentType).makeNullableAsSpecified(true));
    }

    @NotNull
    public static /* bridge */ /* synthetic */ KotlinType transformArrayType$default(JavaTypeResolver javaTypeResolver, JavaArrayType javaArrayType, JavaTypeAttributes javaTypeAttributes, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return javaTypeResolver.transformArrayType(javaArrayType, javaTypeAttributes, bl);
    }

    private final KotlinType transformJavaClassifierType(JavaClassifierType javaType, JavaTypeAttributes attr) {
        Function0<SimpleType> errorType$ = new Function0<SimpleType>(javaType){
            final /* synthetic */ JavaClassifierType $javaType;

            @NotNull
            public final SimpleType invoke() {
                return ErrorUtils.createErrorType("Unresolved java class " + this.$javaType.getPresentableText());
            }
            {
                this.$javaType = javaClassifierType;
                super(0);
            }
        };
        boolean useFlexible = !attr.isForAnnotationParameter() && attr.getHowThisTypeIsUsed() != TypeUsage.SUPERTYPE;
        boolean isRaw = javaType.isRaw();
        if (!isRaw && !useFlexible) {
            KotlinType kotlinType;
            SimpleType simpleType2 = this.computeSimpleJavaClassifierType(javaType, attr, null);
            if (simpleType2 != null) {
                kotlinType = simpleType2;
            } else {
                Object object = errorType$.invoke();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"errorType()");
                kotlinType = (KotlinType)object;
            }
            return kotlinType;
        }
        SimpleType simpleType3 = this.computeSimpleJavaClassifierType(javaType, attr.withFlexibility(JavaTypeFlexibility.FLEXIBLE_LOWER_BOUND), null);
        if (simpleType3 == null) {
            Object object = errorType$.invoke();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"errorType()");
            return (KotlinType)object;
        }
        SimpleType lower = simpleType3;
        SimpleType simpleType4 = this.computeSimpleJavaClassifierType(javaType, attr.withFlexibility(JavaTypeFlexibility.FLEXIBLE_UPPER_BOUND), lower);
        if (simpleType4 == null) {
            Object object = errorType$.invoke();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"errorType()");
            return (KotlinType)object;
        }
        SimpleType upper = simpleType4;
        return isRaw ? (KotlinType)new RawTypeImpl(lower, upper) : (KotlinType)KotlinTypeFactory.flexibleType(lower, upper);
    }

    private final SimpleType computeSimpleJavaClassifierType(JavaClassifierType javaType, JavaTypeAttributes attr, SimpleType lowerResult) {
        Object object = lowerResult;
        if (object == null || (object = object.getAnnotations()) == null) {
            object = new LazyJavaAnnotations(this.c, javaType);
        }
        Object annotations2 = object;
        TypeConstructor typeConstructor2 = this.computeTypeConstructor(javaType, attr);
        if (typeConstructor2 == null) {
            return null;
        }
        TypeConstructor constructor = typeConstructor2;
        boolean isNullable = this.isNullable(attr);
        SimpleType simpleType2 = lowerResult;
        if (Intrinsics.areEqual((Object)(simpleType2 != null ? simpleType2.getConstructor() : null), (Object)constructor) && !javaType.isRaw() && isNullable) {
            return lowerResult.makeNullableAsSpecified(true);
        }
        List<TypeProjection> arguments2 = this.computeArguments(javaType, attr, constructor);
        return KotlinTypeFactory.simpleType((Annotations)annotations2, constructor, arguments2, isNullable);
    }

    private final TypeConstructor computeTypeConstructor(JavaClassifierType javaType, JavaTypeAttributes attr) {
        Object object;
        JavaClassifier classifier2;
        JavaClassifier javaClassifier = javaType.getClassifier();
        if (javaClassifier == null) {
            return this.createNotFoundClass(javaType);
        }
        JavaClassifier javaClassifier2 = classifier2 = javaClassifier;
        if (javaClassifier2 instanceof JavaClass) {
            ClassDescriptor classData;
            FqName $receiver$iv;
            FqName fqName2 = $receiver$iv = ((JavaClass)classifier2).getFqName();
            if (fqName2 == null) {
                String string;
                String string2 = string = "Class type should have a FQ name: " + classifier2;
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            FqName fqName3 = fqName2;
            ClassDescriptor classDescriptor = this.mapKotlinClass(javaType, attr, fqName3);
            if (classDescriptor == null) {
                classDescriptor = this.c.getComponents().getModuleClassResolver().resolveClass((JavaClass)classifier2);
            }
            if ((object = (classData = classDescriptor)) == null || (object = object.getTypeConstructor()) == null) {
                object = this.createNotFoundClass(javaType);
            }
        } else if (javaClassifier2 instanceof JavaTypeParameter) {
            TypeParameterDescriptor typeParameterDescriptor = this.typeParameterResolver.resolveTypeParameter((JavaTypeParameter)classifier2);
            object = typeParameterDescriptor != null ? typeParameterDescriptor.getTypeConstructor() : null;
        } else {
            throw (Throwable)new IllegalStateException("Unknown classifier kind: " + classifier2);
        }
        return object;
    }

    private final TypeConstructor createNotFoundClass(JavaClassifierType javaType) {
        ClassId classId = ClassId.topLevel(new FqName(javaType.getClassifierQualifiedName()));
        NotFoundClasses notFoundClasses = this.c.getComponents().getDeserializedDescriptorResolver().getComponents().getNotFoundClasses();
        ClassId classId2 = classId;
        Intrinsics.checkExpressionValueIsNotNull((Object)classId2, (String)"classId");
        TypeConstructor typeConstructor2 = notFoundClasses.getClass(classId2, CollectionsKt.listOf((Object)0)).getTypeConstructor();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor2, (String)"c.components.deserialize\u2026istOf(0)).typeConstructor");
        return typeConstructor2;
    }

    private final ClassDescriptor mapKotlinClass(JavaClassifierType javaType, JavaTypeAttributes attr, FqName fqName2) {
        if (attr.isForAnnotationParameter() && Intrinsics.areEqual((Object)fqName2, (Object)JavaTypeResolverKt.access$getJAVA_LANG_CLASS_FQ_NAME$p())) {
            return this.c.getComponents().getReflectionTypes().getKClass();
        }
        JavaToKotlinClassMap javaToKotlin = JavaToKotlinClassMap.INSTANCE;
        ClassDescriptor classDescriptor = javaToKotlin.mapJavaToKotlin(fqName2, this.c.getModule().getBuiltIns());
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor kotlinDescriptor = classDescriptor;
        if (javaToKotlin.isReadOnly(kotlinDescriptor) && (attr.getFlexibility() == JavaTypeFlexibility.FLEXIBLE_LOWER_BOUND || attr.getHowThisTypeIsUsed() == TypeUsage.SUPERTYPE || this.argumentsMakeSenseOnlyForMutableContainer(javaType, kotlinDescriptor))) {
            return javaToKotlin.convertReadOnlyToMutable(kotlinDescriptor);
        }
        return kotlinDescriptor;
    }

    private final boolean argumentsMakeSenseOnlyForMutableContainer(@NotNull JavaClassifierType $receiver, ClassDescriptor readOnlyContainer) {
        argumentsMakeSenseOnlyForMutableContainer.1 isSuperWildcard$ = argumentsMakeSenseOnlyForMutableContainer.1.INSTANCE;
        if (!isSuperWildcard$.invoke((JavaType)CollectionsKt.lastOrNull($receiver.getTypeArguments()))) {
            return false;
        }
        TypeConstructor typeConstructor2 = JavaToKotlinClassMap.INSTANCE.convertReadOnlyToMutable(readOnlyContainer).getTypeConstructor();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor2, (String)"JavaToKotlinClassMap.con\u2026         .typeConstructor");
        List<TypeParameterDescriptor> list = typeConstructor2.getParameters();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"JavaToKotlinClassMap.con\u2026ypeConstructor.parameters");
        Object object = (TypeParameterDescriptor)CollectionsKt.lastOrNull(list);
        if (object == null || (object = object.getVariance()) == null) {
            return false;
        }
        Object mutableLastParameterVariance = object;
        return mutableLastParameterVariance != Variance.OUT_VARIANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final List<TypeProjection> computeArguments(JavaClassifierType javaType, JavaTypeAttributes attr, TypeConstructor constructor) {
        Iterable $receiver$iv;
        boolean isRaw = javaType.isRaw();
        boolean eraseTypeParameters = isRaw || javaType.getTypeArguments().isEmpty() && !constructor.getParameters().isEmpty();
        List<TypeParameterDescriptor> typeParameters2 = constructor.getParameters();
        if (eraseTypeParameters) {
            void $receiver$iv$iv;
            Iterable $receiver$iv2;
            List<TypeParameterDescriptor> list = typeParameters2;
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"typeParameters");
            Iterable iterable = $receiver$iv2 = (Iterable)list;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void parameter;
                TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item$iv$iv;
                Collection collection = destination$iv$iv;
                LazyWrappedType erasedUpperBound = new LazyWrappedType(this.c.getStorageManager(), (Function0<? extends KotlinType>)((Function0)new Function0<KotlinType>((TypeParameterDescriptor)parameter, this, attr, constructor, isRaw){
                    final /* synthetic */ TypeParameterDescriptor $parameter;
                    final /* synthetic */ JavaTypeResolver this$0;
                    final /* synthetic */ JavaTypeAttributes $attr$inlined;
                    final /* synthetic */ TypeConstructor $constructor$inlined;
                    final /* synthetic */ boolean $isRaw$inlined;
                    {
                        this.$parameter = typeParameterDescriptor;
                        this.this$0 = javaTypeResolver;
                        this.$attr$inlined = javaTypeAttributes;
                        this.$constructor$inlined = typeConstructor2;
                        this.$isRaw$inlined = bl;
                        super(0);
                    }

                    @NotNull
                    public final KotlinType invoke() {
                        TypeParameterDescriptor typeParameterDescriptor = this.$parameter;
                        Intrinsics.checkExpressionValueIsNotNull((Object)typeParameterDescriptor, (String)"parameter");
                        return JavaTypeResolverKt.getErasedUpperBound(typeParameterDescriptor, this.$attr$inlined.getUpperBoundOfTypeParameter(), (Function0<? extends KotlinType>)((Function0)new Function0<KotlinType>(this){
                            final /* synthetic */ computeArguments$$inlined$map$lambda$1 this$0;
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }

                            @NotNull
                            public final KotlinType invoke() {
                                ClassifierDescriptor classifierDescriptor = this.this$0.$constructor$inlined.getDeclarationDescriptor();
                                if (classifierDescriptor == null) {
                                    Intrinsics.throwNpe();
                                }
                                Intrinsics.checkExpressionValueIsNotNull((Object)classifierDescriptor, (String)"constructor.declarationDescriptor!!");
                                SimpleType simpleType2 = classifierDescriptor.getDefaultType();
                                Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"constructor.declarationDescriptor!!.defaultType");
                                return TypeUtilsKt.replaceArgumentsWithStarProjections(simpleType2);
                            }
                        }));
                    }
                }));
                void v1 = parameter;
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"parameter");
                TypeProjection typeProjection = RawSubstitution.INSTANCE.computeProjection((TypeParameterDescriptor)v1, isRaw ? attr : attr.withFlexibility(JavaTypeFlexibility.INFLEXIBLE), erasedUpperBound);
                collection.add(typeProjection);
            }
            return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        }
        if (typeParameters2.size() != javaType.getTypeArguments().size()) {
            Iterable $receiver$iv3;
            List<TypeParameterDescriptor> list = typeParameters2;
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"typeParameters");
            Iterable $receiver$iv$iv = $receiver$iv3 = (Iterable)list;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void p;
                TypeParameterDescriptor parameter = (TypeParameterDescriptor)item$iv$iv;
                Collection collection = destination$iv$iv;
                void v3 = p;
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"p");
                TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(ErrorUtils.createErrorType(v3.getName().asString()));
                collection.add(typeProjectionImpl);
            }
            return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        }
        Iterable $receiver$iv$iv = $receiver$iv = CollectionsKt.withIndex((Iterable)javaType.getTypeArguments());
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void i;
            void indexedArgument;
            IndexedValue p = (IndexedValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            void $i$a$2$map = indexedArgument;
            int $i$f$mapTo = $i$a$2$map.component1();
            JavaType javaTypeArgument = (JavaType)$i$a$2$map.component2();
            boolean bl = $i$a$2$map = i < typeParameters2.size();
            if (_Assertions.ENABLED && !$i$a$2$map) {
                String string = "Argument index should be less then type parameters count, but " + (int)i + " > " + typeParameters2.size();
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            TypeParameterDescriptor parameter = typeParameters2.get((int)i);
            JavaTypeAttributes javaTypeAttributes = JavaTypeResolverKt.toAttributes$default(TypeUsage.COMMON, false, null, 3, null);
            TypeParameterDescriptor typeParameterDescriptor = parameter;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeParameterDescriptor, (String)"parameter");
            TypeProjection typeProjection = this.transformToTypeProjection(javaTypeArgument, javaTypeAttributes, typeParameterDescriptor);
            collection.add(typeProjection);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    private final TypeProjection transformToTypeProjection(JavaType javaType, JavaTypeAttributes attr, TypeParameterDescriptor typeParameter) {
        TypeProjection typeProjection;
        JavaType javaType2 = javaType;
        if (javaType2 instanceof JavaWildcardType) {
            Variance projectionKind;
            JavaType bound = ((JavaWildcardType)javaType).getBound();
            Variance variance = projectionKind = ((JavaWildcardType)javaType).isExtends() ? Variance.OUT_VARIANCE : Variance.IN_VARIANCE;
            typeProjection = bound == null || this.isConflictingArgumentFor(projectionKind, typeParameter) ? JavaTypeResolverKt.makeStarProjection(typeParameter, attr) : TypeUtilsKt.createProjection(this.transformJavaType(bound, JavaTypeResolverKt.toAttributes$default(TypeUsage.COMMON, false, null, 3, null)), projectionKind, typeParameter);
        } else {
            typeProjection = new TypeProjectionImpl(Variance.INVARIANT, this.transformJavaType(javaType, attr));
        }
        return typeProjection;
    }

    private final boolean isConflictingArgumentFor(@NotNull Variance $receiver, TypeParameterDescriptor typeParameter) {
        if (typeParameter.getVariance() == Variance.INVARIANT) {
            return false;
        }
        return $receiver != typeParameter.getVariance();
    }

    private final boolean isNullable(@NotNull JavaTypeAttributes $receiver) {
        if ($receiver.getFlexibility() == JavaTypeFlexibility.FLEXIBLE_LOWER_BOUND) {
            return false;
        }
        return !$receiver.isForAnnotationParameter() && $receiver.getHowThisTypeIsUsed() != TypeUsage.SUPERTYPE;
    }

    public JavaTypeResolver(@NotNull LazyJavaResolverContext c, @NotNull TypeParameterResolver typeParameterResolver) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        Intrinsics.checkParameterIsNotNull((Object)typeParameterResolver, (String)"typeParameterResolver");
        this.c = c;
        this.typeParameterResolver = typeParameterResolver;
    }
}

