/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.arguments;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.ArgumentParseErrors;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a$\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a\u0018\u0010\u0012\u001a\u00020\u0013*\u00020\u00142\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017H\u0002\u001a\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e*\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u0001*\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u001b\u001a\u000e\u0010\u001c\u001a\u0004\u0018\u00010\u0003*\u00020\u0014H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0007\u001a\u00020\u0003*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0018\u0010\n\u001a\u00020\u000b*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\f\u00a8\u0006\u001d"}, d2={"BACKSLASH", "", "EXPERIMENTAL_ARGFILE_ARGUMENT", "", "NEWLINE", "QUOTATION_MARK", "WHITESPACE", "argfilePath", "getArgfilePath", "(Ljava/lang/String;)Ljava/lang/String;", "isArgumentForArgfile", "", "(Ljava/lang/String;)Z", "preprocessCommandLineArguments", "", "args", "errors", "Lorg/jetbrains/kotlin/cli/common/arguments/ArgumentParseErrors;", "consumeRestOfEscapedSequence", "", "Ljava/io/Reader;", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "expand", "Ljava/io/File;", "nextChar", "(Ljava/io/Reader;)Ljava/lang/Character;", "parseNextArgument", "cli-common"})
public final class PreprocessCommandLineArgumentsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> preprocessCommandLineArguments(@NotNull List<String> args, @NotNull ArgumentParseErrors errors) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(args, "args");
        Intrinsics.checkParameterIsNotNull(errors, "errors");
        Iterable iterable = $receiver$iv = (Iterable)args;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            String it = (String)element$iv$iv;
            Iterable list$iv$iv = PreprocessCommandLineArgumentsKt.isArgumentForArgfile(it) ? PreprocessCommandLineArgumentsKt.expand(new File(PreprocessCommandLineArgumentsKt.getArgfilePath(it)), errors) : CollectionsKt.listOf(it);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List<String> expand(@NotNull File $receiver, ArgumentParseErrors errors) {
        List list2;
        try {
            List list3;
            Object object;
            list2 = $receiver;
            Object object2 = Charsets.UTF_8;
            int n = 8192;
            Object object3 = object = list2;
            object3 = new FileInputStream((File)object3);
            object = new InputStreamReader((InputStream)object3, (Charset)object2);
            list2 = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
            object2 = null;
            try {
                BufferedReader it = (BufferedReader)((Object)list2);
                list3 = SequencesKt.toList(SequencesKt.generateSequence((Function0)new Function0<String>(it){
                    final /* synthetic */ BufferedReader $it;

                    @Nullable
                    public final String invoke() {
                        return PreprocessCommandLineArgumentsKt.access$parseNextArgument(this.$it);
                    }
                    {
                        this.$it = bufferedReader;
                        super(0);
                    }
                }));
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)((Object)list2), (Throwable)object2);
            }
            list2 = list3;
        }
        catch (FileNotFoundException e) {
            Collection collection = errors.getArgfileErrors();
            String string = "Argfile not found: " + $receiver.getAbsolutePath();
            collection.add(string);
            list2 = CollectionsKt.emptyList();
        }
        catch (IOException e) {
            Collection collection = errors.getArgfileErrors();
            String string = "Error while reading argfile: " + e;
            collection.add(string);
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private static final String parseNextArgument(@NotNull Reader $receiver) {
        String string;
        String it;
        CharSequence charSequence;
        StringBuilder sb = new StringBuilder();
        Character r = PreprocessCommandLineArgumentsKt.nextChar($receiver);
        while (r != null) {
            char c = ' ';
            if (r.charValue() != c) {
                c = '\n';
                if (r.charValue() != c) break;
            }
            r = PreprocessCommandLineArgumentsKt.nextChar($receiver);
        }
        while (r != null) {
            Character c = r;
            char c2 = ' ';
            if (c.charValue() == c2) break;
            c2 = '\n';
            if (c.charValue() == c2) break;
            c2 = '\"';
            if (c.charValue() == c2) {
                PreprocessCommandLineArgumentsKt.consumeRestOfEscapedSequence($receiver, sb);
            } else {
                c2 = '\\';
                if (c.charValue() == c2) {
                    if (PreprocessCommandLineArgumentsKt.nextChar($receiver) != null) {
                        Character c3;
                        charSequence = sb;
                        char p1 = c3.charValue();
                        ((StringBuilder)charSequence).append(p1);
                    }
                } else {
                    sb.append(r.charValue());
                }
            }
            r = PreprocessCommandLineArgumentsKt.nextChar($receiver);
        }
        String string2 = it = (string = sb.toString());
        Intrinsics.checkExpressionValueIsNotNull(string2, "it");
        charSequence = string2;
        return charSequence.length() > 0 ? string : null;
    }

    private static final void consumeRestOfEscapedSequence(@NotNull Reader $receiver, StringBuilder sb) {
        Character ch = PreprocessCommandLineArgumentsKt.nextChar($receiver);
        while (ch != null) {
            char c = '\"';
            if (ch.charValue() == c) break;
            c = '\\';
            if (ch.charValue() == c) {
                if (PreprocessCommandLineArgumentsKt.nextChar($receiver) != null) {
                    Character c2;
                    StringBuilder stringBuilder = sb;
                    char p1 = c2.charValue();
                    stringBuilder.append(p1);
                }
            } else {
                sb.append(ch.charValue());
            }
            ch = PreprocessCommandLineArgumentsKt.nextChar($receiver);
        }
    }

    private static final Character nextChar(@NotNull Reader $receiver) {
        Integer n = $receiver.read();
        int it = ((Number)n).intValue();
        Integer n2 = !(it == -1) ? n : null;
        return n2 != null ? Character.valueOf((char)n2.intValue()) : null;
    }

    private static final String getArgfilePath(@NotNull String $receiver) {
        return StringsKt.removePrefix($receiver, (CharSequence)"-Xargfile=");
    }

    private static final boolean isArgumentForArgfile(@NotNull String $receiver) {
        return StringsKt.startsWith$default($receiver, "-Xargfile=", false, 2, null);
    }

    @Nullable
    public static final /* synthetic */ String access$parseNextArgument(@NotNull Reader $receiver) {
        return PreprocessCommandLineArgumentsKt.parseNextArgument($receiver);
    }
}

