/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.util;

import java.util.ArrayList;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.symbols.IrBindableSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrEnumEntrySymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.util.DeclarationStubGenerator;
import org.jetbrains.kotlin.ir.util.SymbolTable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/ir/util/ExternalDependenciesGenerator;", "", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/ir/util/SymbolTable;Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;)V", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "stubGenerator", "Lorg/jetbrains/kotlin/ir/util/DeclarationStubGenerator;", "getSymbolTable", "()Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "generateUnboundSymbolsAsDependencies", "", "irModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "DependencyGenerationTask", "ir.tree"})
public final class ExternalDependenciesGenerator {
    private final DeclarationStubGenerator stubGenerator;
    @NotNull
    private final SymbolTable symbolTable;
    @NotNull
    private final IrBuiltIns irBuiltIns;

    public final void generateUnboundSymbolsAsDependencies(@NotNull IrModuleFragment irModule) {
        Intrinsics.checkParameterIsNotNull(irModule, "irModule");
        new DependencyGenerationTask(irModule).run();
    }

    @NotNull
    public final SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    @NotNull
    public final IrBuiltIns getIrBuiltIns() {
        return this.irBuiltIns;
    }

    public ExternalDependenciesGenerator(@NotNull ModuleDescriptor moduleDescriptor, @NotNull SymbolTable symbolTable, @NotNull IrBuiltIns irBuiltIns) {
        Intrinsics.checkParameterIsNotNull(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkParameterIsNotNull(symbolTable, "symbolTable");
        Intrinsics.checkParameterIsNotNull(irBuiltIns, "irBuiltIns");
        this.symbolTable = symbolTable;
        this.irBuiltIns = irBuiltIns;
        this.stubGenerator = new DeclarationStubGenerator(moduleDescriptor, this.symbolTable, IrDeclarationOrigin.IR_EXTERNAL_DECLARATION_STUB.INSTANCE, this.irBuiltIns.getLanguageVersionSettings());
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/ir/util/ExternalDependenciesGenerator$DependencyGenerationTask;", "", "irModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "(Lorg/jetbrains/kotlin/ir/util/ExternalDependenciesGenerator;Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;)V", "getIrModule", "()Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "run", "", "ir.tree"})
    private final class DependencyGenerationTask {
        @NotNull
        private final IrModuleFragment irModule;

        public final void run() {
            Object object;
            IrBindableSymbol<ClassDescriptor, IrClass> it;
            ExternalDependenciesGenerator.this.stubGenerator.setUnboundSymbolGeneration$ir_tree(true);
            Iterable $receiver$iv = new ArrayList(ExternalDependenciesGenerator.this.getSymbolTable().getUnboundClasses());
            for (Object element$iv : $receiver$iv) {
                it = (IrClassSymbol)element$iv;
                ExternalDependenciesGenerator.this.stubGenerator.generateClassStub$ir_tree((ClassDescriptor)it.getDescriptor());
            }
            $receiver$iv = new ArrayList(ExternalDependenciesGenerator.this.getSymbolTable().getUnboundConstructors());
            for (Object element$iv : $receiver$iv) {
                it = (IrConstructorSymbol)element$iv;
                ExternalDependenciesGenerator.this.stubGenerator.generateConstructorStub$ir_tree((ClassConstructorDescriptor)((Object)it.getDescriptor()));
            }
            $receiver$iv = new ArrayList(ExternalDependenciesGenerator.this.getSymbolTable().getUnboundEnumEntries());
            for (Object element$iv : $receiver$iv) {
                it = (IrEnumEntrySymbol)element$iv;
                ExternalDependenciesGenerator.this.stubGenerator.generateEnumEntryStub$ir_tree(it.getDescriptor());
            }
            $receiver$iv = new ArrayList(ExternalDependenciesGenerator.this.getSymbolTable().getUnboundFields());
            for (Object element$iv : $receiver$iv) {
                it = (IrFieldSymbol)element$iv;
                ExternalDependenciesGenerator.this.stubGenerator.generatePropertyStub$ir_tree((PropertyDescriptor)((Object)it.getDescriptor()));
            }
            $receiver$iv = new ArrayList(ExternalDependenciesGenerator.this.getSymbolTable().getUnboundSimpleFunctions());
            for (Object element$iv : $receiver$iv) {
                it = (IrSimpleFunctionSymbol)element$iv;
                ExternalDependenciesGenerator.this.stubGenerator.generateFunctionStub((FunctionDescriptor)((Object)it.getDescriptor()));
            }
            $receiver$iv = new ArrayList(ExternalDependenciesGenerator.this.getSymbolTable().getUnboundTypeParameters());
            for (Object element$iv : $receiver$iv) {
                it = (IrTypeParameterSymbol)element$iv;
                ExternalDependenciesGenerator.this.stubGenerator.generateOrGetTypeParameterStub$ir_tree((TypeParameterDescriptor)((Object)it.getDescriptor()));
            }
            boolean bl = ExternalDependenciesGenerator.this.getSymbolTable().getUnboundClasses().isEmpty();
            if (_Assertions.ENABLED && !bl) {
                object = "Assertion failed";
                throw (Throwable)((Object)new AssertionError(object));
            }
            bl = ExternalDependenciesGenerator.this.getSymbolTable().getUnboundConstructors().isEmpty();
            if (_Assertions.ENABLED && !bl) {
                object = "Assertion failed";
                throw (Throwable)((Object)new AssertionError(object));
            }
            bl = ExternalDependenciesGenerator.this.getSymbolTable().getUnboundEnumEntries().isEmpty();
            if (_Assertions.ENABLED && !bl) {
                object = "Assertion failed";
                throw (Throwable)((Object)new AssertionError(object));
            }
            bl = ExternalDependenciesGenerator.this.getSymbolTable().getUnboundFields().isEmpty();
            if (_Assertions.ENABLED && !bl) {
                object = "Assertion failed";
                throw (Throwable)((Object)new AssertionError(object));
            }
            bl = ExternalDependenciesGenerator.this.getSymbolTable().getUnboundSimpleFunctions().isEmpty();
            if (_Assertions.ENABLED && !bl) {
                object = "Assertion failed";
                throw (Throwable)((Object)new AssertionError(object));
            }
            bl = ExternalDependenciesGenerator.this.getSymbolTable().getUnboundTypeParameters().isEmpty();
            if (_Assertions.ENABLED && !bl) {
                object = "Assertion failed";
                throw (Throwable)((Object)new AssertionError(object));
            }
        }

        @NotNull
        public final IrModuleFragment getIrModule() {
            return this.irModule;
        }

        public DependencyGenerationTask(@NotNull IrModuleFragment irModule) {
            Intrinsics.checkParameterIsNotNull(irModule, "irModule");
            this.irModule = irModule;
        }
    }
}

