/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.inline;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\f\u0010\u0002\u001a\u00020\u0003*\u00020\u0004H\u0002\u001a\n\u0010\u0005\u001a\u00020\u0003*\u00020\u0006\u001a\n\u0010\u0007\u001a\u00020\u0003*\u00020\u0006\u001a\n\u0010\b\u001a\u00020\u0003*\u00020\u0006\u001a\f\u0010\t\u001a\u00020\u0003*\u00020\u0004H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"INLINE_ONLY_ANNOTATION_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "hasInlineOnlyAnnotation", "", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "isEffectivelyInlineOnly", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "isInlineOnly", "isInlineOnlyOrReifiable", "isReifiable", "frontend"})
public final class InlineOnlyKt {
    private static final FqName INLINE_ONLY_ANNOTATION_FQ_NAME = new FqName("kotlin.internal.InlineOnly");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInlineOnlyOrReifiable(@NotNull MemberDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        if (!($receiver instanceof CallableMemberDescriptor)) return false;
        if (InlineOnlyKt.isReifiable((CallableMemberDescriptor)$receiver)) return true;
        CallableMemberDescriptor callableMemberDescriptor = DescriptorUtils.getDirectMember((CallableMemberDescriptor)$receiver);
        Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor, "DescriptorUtils.getDirectMember(this)");
        if (InlineOnlyKt.isReifiable(callableMemberDescriptor)) return true;
        if (!InlineOnlyKt.isInlineOnly($receiver)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isEffectivelyInlineOnly(@NotNull MemberDescriptor $receiver) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        if (InlineOnlyKt.isInlineOnlyOrReifiable($receiver)) return true;
        if (!($receiver instanceof FunctionDescriptor)) return false;
        if (!((FunctionDescriptor)$receiver).isSuspend()) return false;
        if (!((FunctionDescriptor)$receiver).isInline()) return false;
        List<ValueParameterDescriptor> list2 = ((FunctionDescriptor)$receiver).getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "valueParameters");
        Iterable $receiver$iv = list2;
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $receiver$iv) {
                ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                if (!it.isCrossinline()) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        if (!Intrinsics.areEqual(((FunctionDescriptor)$receiver).getVisibility(), Visibilities.PRIVATE)) return false;
        return true;
    }

    public static final boolean isInlineOnly(@NotNull MemberDescriptor $receiver) {
        block5: {
            block4: {
                Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
                if (!($receiver instanceof FunctionDescriptor)) break block4;
                if (InlineOnlyKt.hasInlineOnlyAnnotation((CallableMemberDescriptor)$receiver)) break block5;
                CallableMemberDescriptor callableMemberDescriptor = DescriptorUtils.getDirectMember((CallableMemberDescriptor)$receiver);
                Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor, "DescriptorUtils.getDirectMember(this)");
                if (InlineOnlyKt.hasInlineOnlyAnnotation(callableMemberDescriptor)) break block5;
            }
            return false;
        }
        boolean bl = ((FunctionDescriptor)$receiver).isInline();
        if (_Assertions.ENABLED && !bl) {
            String string = "Function is not inline: " + $receiver;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return true;
    }

    private static final boolean isReifiable(@NotNull CallableMemberDescriptor $receiver) {
        boolean bl;
        block3: {
            List<TypeParameterDescriptor> list2 = $receiver.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, "typeParameters");
            Iterable $receiver$iv = list2;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    TypeParameterDescriptor it;
                    TypeParameterDescriptor typeParameterDescriptor = it = (TypeParameterDescriptor)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "it");
                    if (!typeParameterDescriptor.isReified()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean hasInlineOnlyAnnotation(@NotNull CallableMemberDescriptor $receiver) {
        return $receiver.getAnnotations().hasAnnotation(INLINE_ONLY_ANNOTATION_FQ_NAME);
    }
}

