/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.Consumer;
import com.intellij.util.containers.ShareableKey;
import com.intellij.util.containers.hash.EqualityPolicy;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SLRUMap<K, V> {
    private final LinkedHashMap<K, V> myProtectedQueue;
    private final LinkedHashMap<K, V> myProbationalQueue;
    private final int myProtectedQueueSize;
    private final int myProbationalQueueSize;
    private int probationalHits;
    private int protectedHits;
    private int misses;
    private static final int FACTOR = Integer.getInteger("idea.slru.factor", 1);

    public SLRUMap(int protectedQueueSize, int probationalQueueSize) {
        this(protectedQueueSize, probationalQueueSize, EqualityPolicy.CANONICAL);
    }

    public SLRUMap(int protectedQueueSize, int probationalQueueSize, @NotNull EqualityPolicy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            SLRUMap.$$$reportNull$$$0(0);
        }
        this.myProtectedQueueSize = protectedQueueSize * FACTOR;
        this.myProbationalQueueSize = probationalQueueSize * FACTOR;
        this.myProtectedQueue = new LinkedHashMap<K, V>(10, 0.6f, hashingStrategy, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest, K key, V value) {
                if (this.size() > SLRUMap.this.myProtectedQueueSize) {
                    SLRUMap.this.myProbationalQueue.put(key, value);
                    return true;
                }
                return false;
            }
        };
        this.myProbationalQueue = new LinkedHashMap<K, V>(10, 0.6f, hashingStrategy, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest, K key, V value) {
                if (this.size() > SLRUMap.this.myProbationalQueueSize) {
                    SLRUMap.this.onDropFromCache(key, value);
                    return true;
                }
                return false;
            }
        };
    }

    @Nullable
    public V get(K key) {
        V value = this.myProtectedQueue.get(key);
        if (value != null) {
            ++this.protectedHits;
            return value;
        }
        value = this.myProbationalQueue.remove(key);
        if (value != null) {
            ++this.probationalHits;
            this.putToProtectedQueue(key, value);
            return value;
        }
        ++this.misses;
        return null;
    }

    protected void putToProtectedQueue(K key, @NotNull V value) {
        if (value == null) {
            SLRUMap.$$$reportNull$$$0(1);
        }
        this.myProtectedQueue.put(this.getStableKey(key), value);
    }

    public void put(K key, @NotNull V value) {
        V oldValue;
        if (value == null) {
            SLRUMap.$$$reportNull$$$0(2);
        }
        if ((oldValue = this.myProtectedQueue.remove(key)) != null) {
            this.onDropFromCache(key, oldValue);
        }
        if ((oldValue = this.myProbationalQueue.put(this.getStableKey(key), value)) != null) {
            this.onDropFromCache(key, oldValue);
        }
    }

    protected void onDropFromCache(K key, @NotNull V value) {
        if (value == null) {
            SLRUMap.$$$reportNull$$$0(3);
        }
    }

    public boolean remove(K key) {
        V value = this.myProtectedQueue.remove(key);
        if (value != null) {
            this.onDropFromCache(key, value);
            return true;
        }
        value = this.myProbationalQueue.remove(key);
        if (value != null) {
            this.onDropFromCache(key, value);
            return true;
        }
        return false;
    }

    public void iterateKeys(Consumer<? super K> keyConsumer) {
        for (K key : this.myProtectedQueue.keySet()) {
            keyConsumer.consume(key);
        }
        for (K key : this.myProbationalQueue.keySet()) {
            keyConsumer.consume(key);
        }
    }

    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> set = new HashSet<Map.Entry<K, V>>(this.myProtectedQueue.entrySet());
        set.addAll(this.myProbationalQueue.entrySet());
        return set;
    }

    public void clear() {
        try {
            if (!this.myProtectedQueue.isEmpty()) {
                for (Map.Entry<K, V> entry : this.myProtectedQueue.entrySet()) {
                    this.onDropFromCache(entry.getKey(), entry.getValue());
                }
            }
            if (!this.myProbationalQueue.isEmpty()) {
                for (Map.Entry<K, V> entry : this.myProbationalQueue.entrySet()) {
                    this.onDropFromCache(entry.getKey(), entry.getValue());
                }
            }
        }
        finally {
            this.myProtectedQueue.clear();
            this.myProbationalQueue.clear();
        }
    }

    private K getStableKey(K key) {
        if (key instanceof ShareableKey) {
            return (K)((ShareableKey)key).getStableCopy();
        }
        return key;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/containers/SLRUMap";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "putToProtectedQueue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "put";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "onDropFromCache";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

