/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.lower.JvmBuiltinOptimizationLowering;
import org.jetbrains.kotlin.backend.jvm.lower.inlineclasses.InlineClassAbiKt;
import org.jetbrains.kotlin.codegen.intrinsics.Not;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionWithCopy;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrExpressionBase;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\rH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\n\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmBuiltinOptimizationLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "isObjectEquals", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Z", "getOperandsIfCallToEqeqOrEquals", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "hasNoSideEffectsForNullCompare", "expression", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Companion", "backend.jvm"})
public final class JvmBuiltinOptimizationLowering
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    public static final Companion Companion = new Companion(null);

    private final boolean hasNoSideEffectsForNullCompare(IrExpression expression2) {
        return IrTypePredicatesKt.isPrimitiveType(expression2.getType()) && (expression2 instanceof IrConst || expression2 instanceof IrGetValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isObjectEquals(@NotNull IrFunction $this$isObjectEquals) {
        if (!Intrinsics.areEqual($this$isObjectEquals.getName().asString(), "equals")) return false;
        Collection collection = $this$isObjectEquals.getValueParameters();
        boolean bl = false;
        if (collection.size() != 1) return false;
        if (!IrTypePredicatesKt.isNullableAny($this$isObjectEquals.getValueParameters().get(0).getType())) return false;
        if ($this$isObjectEquals.getExtensionReceiverParameter() != null) return false;
        if ($this$isObjectEquals.getDispatchReceiverParameter() == null) return false;
        return true;
    }

    private final Pair<IrExpression, IrExpression> getOperandsIfCallToEqeqOrEquals(IrCall call2) {
        Pair<IrExpression, IrExpression> pair;
        if (Intrinsics.areEqual(call2.getSymbol(), this.context.getIrBuiltIns().getEqeqSymbol())) {
            IrExpression irExpression = call2.getValueArgument(0);
            if (irExpression == null) {
                Intrinsics.throwNpe();
            }
            IrExpression left = irExpression;
            IrExpression irExpression2 = call2.getValueArgument(1);
            if (irExpression2 == null) {
                Intrinsics.throwNpe();
            }
            IrExpression right = irExpression2;
            pair = TuplesKt.to(left, right);
        } else if (this.isObjectEquals(call2.getSymbol().getOwner())) {
            IrExpression irExpression = call2.getDispatchReceiver();
            if (irExpression == null) {
                Intrinsics.throwNpe();
            }
            IrExpression left = irExpression;
            IrExpression irExpression3 = call2.getValueArgument(0);
            if (irExpression3 == null) {
                Intrinsics.throwNpe();
            }
            IrExpression right = irExpression3;
            pair = TuplesKt.to(left, right);
        } else {
            pair = null;
        }
        return pair;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull(irFile, "irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, new IrElementTransformerVoid(this){
            final /* synthetic */ JvmBuiltinOptimizationLowering this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public IrExpression visitCall(@NotNull IrCall expression2) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                if (JvmBuiltinOptimizationLowering.Companion.isNegation(expression2, this.this$0.getContext())) {
                    IrExpression irExpression = expression2.getDispatchReceiver();
                    if (irExpression == null) {
                        Intrinsics.throwNpe();
                    }
                    if (JvmBuiltinOptimizationLowering.Companion.isNegation(irExpression, this.this$0.getContext())) {
                        IrExpression irExpression2 = expression2.getDispatchReceiver();
                        if (irExpression2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrCall");
                        }
                        IrExpression irExpression3 = ((IrCall)irExpression2).getDispatchReceiver();
                        if (irExpression3 == null) {
                            Intrinsics.throwNpe();
                        }
                        return irExpression3;
                    }
                }
                Pair pair = JvmBuiltinOptimizationLowering.access$getOperandsIfCallToEqeqOrEquals(this.this$0, expression2);
                if (pair != null) {
                    IrExpression irExpression;
                    void left;
                    Pair pair2 = pair;
                    boolean bl = false;
                    boolean bl2 = false;
                    Pair $dstr$left$right = pair2;
                    boolean bl3 = false;
                    IrExpression irExpression4 = (IrExpression)$dstr$left$right.component1();
                    IrExpression right = (IrExpression)$dstr$left$right.component2();
                    IrConstImpl<Boolean> constFalse = IrConstImpl.Companion.constFalse(expression2.getStartOffset(), expression2.getEndOffset(), this.this$0.getContext().getIrBuiltIns().getBooleanType());
                    if (IrUtilsKt.isNullConst((IrExpression)left) && IrUtilsKt.isNullConst(right)) {
                        irExpression = IrConstImpl.Companion.constTrue(expression2.getStartOffset(), expression2.getEndOffset(), this.this$0.getContext().getIrBuiltIns().getBooleanType());
                    } else if (IrUtilsKt.isNullConst((IrExpression)left) && right instanceof IrConst || IrUtilsKt.isNullConst(right) && left instanceof IrConst) {
                        irExpression = constFalse;
                    } else if (IrUtilsKt.isNullConst(right) && IrTypePredicatesKt.isPrimitiveType(InlineClassAbiKt.unboxInlineClass(left.getType())) || IrUtilsKt.isNullConst((IrExpression)left) && IrTypePredicatesKt.isPrimitiveType(InlineClassAbiKt.unboxInlineClass(right.getType()))) {
                        IrExpressionBase irExpressionBase;
                        IrExpression nonNullArgument;
                        Object object = nonNullArgument = IrUtilsKt.isNullConst((IrExpression)left) ? right : left;
                        if (JvmBuiltinOptimizationLowering.access$hasNoSideEffectsForNullCompare(this.this$0, nonNullArgument)) {
                            irExpressionBase = constFalse;
                        } else {
                            IrBlockImpl irBlockImpl = new IrBlockImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), expression2.getOrigin());
                            boolean bl4 = false;
                            boolean bl5 = false;
                            IrBlockImpl $this$apply = irBlockImpl;
                            boolean bl6 = false;
                            $this$apply.getStatements().add(IrUtilsKt.coerceToUnitIfNeeded(nonNullArgument, IrTypesKt.toKotlinType(nonNullArgument.getType()), this.this$0.getContext().getIrBuiltIns()));
                            $this$apply.getStatements().add(constFalse);
                            irExpressionBase = irBlockImpl;
                        }
                        irExpression = irExpressionBase;
                    } else {
                        irExpression = expression2;
                    }
                    return irExpression;
                }
                return expression2;
            }

            @NotNull
            public IrExpression visitWhen(@NotNull IrWhen expression2) {
                IrElement irElement;
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                boolean isCompilerGenerated = expression2.getOrigin() == null;
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                expression2.getBranches().removeIf((Predicate<IrBranch>)new Predicate<E>(isCompilerGenerated){
                    final /* synthetic */ boolean $isCompilerGenerated;

                    public final boolean test(@NotNull IrBranch it) {
                        Intrinsics.checkParameterIsNotNull(it, "it");
                        return IrUtilsKt.isFalseConst(it.getCondition()) && this.$isCompilerGenerated;
                    }
                    {
                        this.$isCompilerGenerated = bl;
                    }
                });
                if (Intrinsics.areEqual(expression2.getOrigin(), IrStatementOrigin.ANDAND.INSTANCE)) {
                    boolean bl = IrTypePredicatesKt.isBoolean(expression2.getType()) && expression2.getBranches().size() == 2 && IrUtilsKt.isTrueConst(expression2.getBranches().get(1).getCondition()) && IrUtilsKt.isFalseConst(expression2.getBranches().get(1).getResult());
                    boolean bl2 = false;
                    if (_Assertions.ENABLED && !bl) {
                        boolean $i$a$-assert-JvmBuiltinOptimizationLowering$lower$1$visitWhen$32 = false;
                        String $i$a$-assert-JvmBuiltinOptimizationLowering$lower$1$visitWhen$32 = "ANDAND condition should have an 'if true then false' body on its second branch. " + "Failing expression: " + DumpIrTreeKt.dump$default(expression2, false, 1, null);
                        throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-JvmBuiltinOptimizationLowering$lower$1$visitWhen$32));
                    }
                    IrCallImpl irCallImpl = new IrCallImpl(expression2.getStartOffset(), expression2.getEndOffset(), this.this$0.getContext().getIrBuiltIns().getBooleanType(), (IrFunctionSymbol)this.this$0.getContext().getIrBuiltIns().getAndandSymbol(), null, null, 48, null);
                    bl2 = false;
                    boolean $i$a$-assert-JvmBuiltinOptimizationLowering$lower$1$visitWhen$32 = false;
                    IrCallImpl $this$apply = irCallImpl;
                    boolean bl3 = false;
                    $this$apply.putValueArgument(0, expression2.getBranches().get(0).getCondition());
                    $this$apply.putValueArgument(1, expression2.getBranches().get(0).getResult());
                    return irCallImpl;
                }
                if (Intrinsics.areEqual(expression2.getOrigin(), IrStatementOrigin.OROR.INSTANCE)) {
                    boolean bl = IrTypePredicatesKt.isBoolean(expression2.getType()) && expression2.getBranches().size() == 2 && IrUtilsKt.isTrueConst(expression2.getBranches().get(0).getResult()) && IrUtilsKt.isTrueConst(expression2.getBranches().get(1).getCondition());
                    boolean bl4 = false;
                    if (_Assertions.ENABLED && !bl) {
                        boolean bl5 = false;
                        String string2 = "OROR condition should have an 'if a then true' body on its first branch, and an 'if true then b' body on its second branch. " + "Failing expression: " + DumpIrTreeKt.dump$default(expression2, false, 1, null);
                        throw (Throwable)((Object)new AssertionError((Object)string2));
                    }
                    IrCallImpl irCallImpl = new IrCallImpl(expression2.getStartOffset(), expression2.getEndOffset(), this.this$0.getContext().getIrBuiltIns().getBooleanType(), (IrFunctionSymbol)this.this$0.getContext().getIrBuiltIns().getOrorSymbol(), null, null, 48, null);
                    bl4 = false;
                    boolean bl6 = false;
                    IrCallImpl $this$apply = irCallImpl;
                    boolean bl7 = false;
                    $this$apply.putValueArgument(0, expression2.getBranches().get(0).getCondition());
                    $this$apply.putValueArgument(1, expression2.getBranches().get(1).getResult());
                    return irCallImpl;
                }
                if (expression2.getBranches().size() == 0) {
                    irElement = new IrBlockImpl(expression2.getStartOffset(), expression2.getEndOffset(), this.this$0.getContext().getIrBuiltIns().getUnitType(), null, 8, null);
                } else {
                    IrBranch irBranch = CollectionsKt.first(expression2.getBranches());
                    boolean bl = false;
                    boolean bl8 = false;
                    IrBranch it = irBranch;
                    boolean bl9 = false;
                    irElement = IrUtilsKt.isTrueConst(it.getCondition()) && isCompilerGenerated ? irBranch : null;
                    if (irElement == null || (irElement = irElement.getResult()) == null) {
                        irElement = expression2;
                    }
                }
                return irElement;
            }

            private final boolean isImmutableTemporaryVariableWithConstantValue(IrStatement statement2) {
                return statement2 instanceof IrVariable && Intrinsics.areEqual(((IrVariable)statement2).getOrigin(), IrDeclarationOrigin.IR_TEMPORARY_VARIABLE.INSTANCE) && !((IrVariable)statement2).isVar() && ((IrVariable)statement2).getInitializer() instanceof IrConst;
            }

            private final void removeUnnecessaryTemporaryVariables(List<IrStatement> statements) {
                block2: {
                    statements.removeIf((Predicate<IrStatement>)new Predicate<E>(this){
                        final /* synthetic */ lower.1 this$0;

                        public final boolean test(@NotNull IrStatement it) {
                            Intrinsics.checkParameterIsNotNull(it, "it");
                            return lower.1.access$isImmutableTemporaryVariableWithConstantValue(this.this$0, it);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                    if (statements.size() != 2) break block2;
                    IrStatement first2 = statements.get(0);
                    IrStatement second = statements.get(1);
                    if (first2 instanceof IrVariable && Intrinsics.areEqual(((IrVariable)first2).getOrigin(), IrDeclarationOrigin.IR_TEMPORARY_VARIABLE.INSTANCE) && second instanceof IrGetValue && Intrinsics.areEqual((IrVariableSymbol)((IrVariable)first2).getSymbol(), ((IrGetValue)second).getSymbol())) {
                        statements.clear();
                        IrExpression irExpression = ((IrVariable)first2).getInitializer();
                        if (irExpression != null) {
                            IrExpression irExpression2 = irExpression;
                            boolean bl = false;
                            boolean bl2 = false;
                            IrExpression it = irExpression2;
                            boolean bl3 = false;
                            statements.add(it);
                        }
                    }
                }
            }

            @NotNull
            public IrBody visitBlockBody(@NotNull IrBlockBody body2) {
                Intrinsics.checkParameterIsNotNull(body2, "body");
                IrElementTransformerVoidKt.transformChildrenVoid(body2, this);
                this.removeUnnecessaryTemporaryVariables(body2.getStatements());
                return body2;
            }

            @NotNull
            public IrExpression visitContainerExpression(@NotNull IrContainerExpression expression2) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                this.removeUnnecessaryTemporaryVariables(expression2.getStatements());
                return expression2;
            }

            @NotNull
            public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                IrExpressionWithCopy irExpressionWithCopy;
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                IrValueDeclaration variable2 = expression2.getSymbol().getOwner();
                if (this.isImmutableTemporaryVariableWithConstantValue(variable2)) {
                    IrValueDeclaration irValueDeclaration = variable2;
                    if (irValueDeclaration == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrVariable");
                    }
                    IrExpression irExpression = ((IrVariable)irValueDeclaration).getInitializer();
                    if (irExpression == null) {
                        Intrinsics.throwNpe();
                    }
                    if (irExpression == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConst<*>");
                    }
                    irExpressionWithCopy = ((IrConst)irExpression).copy();
                } else {
                    irExpressionWithCopy = expression2;
                }
                return irExpressionWithCopy;
            }
            {
                this.this$0 = $outer;
            }

            public static final /* synthetic */ boolean access$isImmutableTemporaryVariableWithConstantValue(lower.1 $this, IrStatement statement2) {
                return $this.isImmutableTemporaryVariableWithConstantValue(statement2);
            }
        });
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public JvmBuiltinOptimizationLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkParameterIsNotNull(context2, "context");
        this.context = context2;
    }

    public static final /* synthetic */ Pair access$getOperandsIfCallToEqeqOrEquals(JvmBuiltinOptimizationLowering $this, IrCall call2) {
        return $this.getOperandsIfCallToEqeqOrEquals(call2);
    }

    public static final /* synthetic */ boolean access$hasNoSideEffectsForNullCompare(JvmBuiltinOptimizationLowering $this, IrExpression expression2) {
        return $this.hasNoSideEffectsForNullCompare(expression2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmBuiltinOptimizationLowering$Companion;", "", "()V", "isNegation", "", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "backend.jvm"})
    public static final class Companion {
        public final boolean isNegation(@NotNull IrExpression expression2, @NotNull JvmBackendContext context2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            Intrinsics.checkParameterIsNotNull(context2, "context");
            return expression2 instanceof IrCall && context2.getState().getIntrinsics().getIntrinsic(((IrCall)expression2).getSymbol().getDescriptor()) instanceof Not;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

