/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.repl;

import com.google.common.base.Throwables;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.LineSeparator;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.repl.ReplCodeLine;
import org.jetbrains.kotlin.cli.common.repl.ReplUtilKt;
import org.jetbrains.kotlin.utils.repl.ReplEscapeType;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0001\u001a\u000e\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f\u001a*\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0003\"\b\b\u0000\u0010\u0011*\u00020\u0012*\b\u0012\u0004\u0012\u0002H\u00110\u00032\u0006\u0010\u0013\u001a\u00020\u0001H\u0000\u001a\u0012\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0003*\u00020\u0016H\u0000\u001a\u0012\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u0003*\u00020\u0018H\u0000\u001a\n\u0010\u0019\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u001a\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u001b\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u001c\u001a\u00020\u0001*\u00020\u0001\u001a\u0012\u0010\u001d\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u001f\u001a\n\u0010 \u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010!\u001a\u00020\u0001*\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"END_LINE", "", "SOURCE_CHARS", "", "XML_PREAMBLE", "XML_REPLACEMENTS", "makeScriptBaseName", "codeLine", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCodeLine;", "renderReplStackTrace", "cause", "", "startFromMethodName", "scriptResultFieldName", "lineNo", "", "ensureNotEmpty", "T", "", "error", "listAllUrlsAsFiles", "Ljava/io/File;", "Ljava/lang/ClassLoader;", "listLocalUrlsAsFiles", "Ljava/net/URLClassLoader;", "replAddLineBreak", "replEscapeLineBreaks", "replInputAsXml", "replNormalizeLineBreaks", "replOutputAsXml", "escapeType", "Lorg/jetbrains/kotlin/utils/repl/ReplEscapeType;", "replRemoveLineBreaksInTheEnd", "replUnescapeLineBreaks", "cli-common"})
public final class ReplUtilKt {
    private static final List<String> SOURCE_CHARS = CollectionsKt.listOf("\r", "\n", "#");
    private static final List<String> XML_REPLACEMENTS = CollectionsKt.listOf("#r", "#n", "#diez");
    private static final String END_LINE;

    @NotNull
    public static final String replUnescapeLineBreaks(@NotNull String $this$replUnescapeLineBreaks) {
        Intrinsics.checkParameterIsNotNull($this$replUnescapeLineBreaks, "$this$replUnescapeLineBreaks");
        String string2 = StringUtil.replace($this$replUnescapeLineBreaks, XML_REPLACEMENTS, SOURCE_CHARS);
        Intrinsics.checkExpressionValueIsNotNull(string2, "StringUtil.replace(this,\u2026PLACEMENTS, SOURCE_CHARS)");
        return string2;
    }

    @NotNull
    public static final String replEscapeLineBreaks(@NotNull String $this$replEscapeLineBreaks) {
        Intrinsics.checkParameterIsNotNull($this$replEscapeLineBreaks, "$this$replEscapeLineBreaks");
        String string2 = StringUtil.replace($this$replEscapeLineBreaks, SOURCE_CHARS, XML_REPLACEMENTS);
        Intrinsics.checkExpressionValueIsNotNull(string2, "StringUtil.replace(this,\u2026_CHARS, XML_REPLACEMENTS)");
        return string2;
    }

    @NotNull
    public static final String replOutputAsXml(@NotNull String $this$replOutputAsXml, @NotNull ReplEscapeType escapeType) {
        Intrinsics.checkParameterIsNotNull($this$replOutputAsXml, "$this$replOutputAsXml");
        Intrinsics.checkParameterIsNotNull((Object)escapeType, "escapeType");
        String escapedXml = StringUtil.escapeXml(ReplUtilKt.replEscapeLineBreaks($this$replOutputAsXml));
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><output type=\"" + (Object)((Object)escapeType) + "\">" + escapedXml + "</output>";
    }

    @NotNull
    public static final String replInputAsXml(@NotNull String $this$replInputAsXml) {
        Intrinsics.checkParameterIsNotNull($this$replInputAsXml, "$this$replInputAsXml");
        String escapedXml = StringUtil.escapeXml(ReplUtilKt.replEscapeLineBreaks($this$replInputAsXml));
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><input>" + escapedXml + "</input>";
    }

    @NotNull
    public static final String replAddLineBreak(@NotNull String $this$replAddLineBreak) {
        Intrinsics.checkParameterIsNotNull($this$replAddLineBreak, "$this$replAddLineBreak");
        return $this$replAddLineBreak + END_LINE;
    }

    @NotNull
    public static final String replRemoveLineBreaksInTheEnd(@NotNull String $this$replRemoveLineBreaksInTheEnd) {
        Intrinsics.checkParameterIsNotNull($this$replRemoveLineBreaksInTheEnd, "$this$replRemoveLineBreaksInTheEnd");
        String string2 = END_LINE;
        String string3 = $this$replRemoveLineBreaksInTheEnd;
        boolean bl = false;
        String string4 = string2;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        char[] cArray = string4.toCharArray();
        Intrinsics.checkExpressionValueIsNotNull(cArray, "(this as java.lang.String).toCharArray()");
        char[] cArray2 = cArray;
        return StringsKt.trimEnd(string3, Arrays.copyOf(cArray2, cArray2.length));
    }

    @NotNull
    public static final String replNormalizeLineBreaks(@NotNull String $this$replNormalizeLineBreaks) {
        Intrinsics.checkParameterIsNotNull($this$replNormalizeLineBreaks, "$this$replNormalizeLineBreaks");
        return StringsKt.replace$default($this$replNormalizeLineBreaks, END_LINE, "\n", false, 4, null);
    }

    @NotNull
    public static final String makeScriptBaseName(@NotNull ReplCodeLine codeLine) {
        Intrinsics.checkParameterIsNotNull(codeLine, "codeLine");
        return "Line_" + codeLine.getNo() + (codeLine.getGeneration() > 1 ? "_gen_" + codeLine.getGeneration() : "");
    }

    @NotNull
    public static final String scriptResultFieldName(int lineNo) {
        return "res" + lineNo;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String renderReplStackTrace(@NotNull Throwable cause, @NotNull String startFromMethodName) {
        void $this$toTypedArray$iv;
        Intrinsics.checkParameterIsNotNull(cause, "cause");
        Intrinsics.checkParameterIsNotNull(startFromMethodName, "startFromMethodName");
        boolean bl = false;
        ArrayList<StackTraceElement> newTrace = new ArrayList<StackTraceElement>();
        boolean skip2 = true;
        StackTraceElement[] stackTraceElementArray = cause.getStackTrace();
        Intrinsics.checkExpressionValueIsNotNull(stackTraceElementArray, "cause.stackTrace");
        for (StackTraceElement element : ArraysKt.reversed(stackTraceElementArray)) {
            StringBuilder stringBuilder2 = new StringBuilder();
            StackTraceElement stackTraceElement = element;
            Intrinsics.checkExpressionValueIsNotNull(stackTraceElement, "element");
            if (Intrinsics.areEqual(stringBuilder2.append(stackTraceElement.getClassName()).append('.').append(element.getMethodName()).toString(), startFromMethodName)) {
                skip2 = false;
            }
            if (skip2) continue;
            newTrace.add(element);
        }
        List resultingTrace = CollectionsKt.dropLast(CollectionsKt.reversed((Iterable)newTrace), 1);
        Object object = resultingTrace;
        Throwable throwable = cause;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        StackTraceElement[] stackTraceElementArray2 = thisCollection$iv.toArray(new StackTraceElement[0]);
        if (stackTraceElementArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        StackTraceElement[] stackTraceElementArray3 = stackTraceElementArray2;
        throwable.setStackTrace(stackTraceElementArray3);
        String string2 = Throwables.getStackTraceAsString(cause);
        Intrinsics.checkExpressionValueIsNotNull(string2, "Throwables.getStackTraceAsString(cause)");
        object = string2;
        boolean bl2 = false;
        Object object2 = object;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trimEnd((CharSequence)object2)).toString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<File> listAllUrlsAsFiles(@NotNull ClassLoader $this$listAllUrlsAsFiles) {
        void $this$fold$iv;
        Sequence<URLClassLoader> parents2;
        Intrinsics.checkParameterIsNotNull($this$listAllUrlsAsFiles, "$this$listAllUrlsAsFiles");
        Sequence<URLClassLoader> sequence2 = parents2 = SequencesKt.filterIsInstance(SequencesKt.generateSequence($this$listAllUrlsAsFiles, (Function1)listAllUrlsAsFiles.parents.1.INSTANCE), URLClassLoader.class);
        List initial$iv = CollectionsKt.emptyList();
        boolean $i$f$fold = false;
        List accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void loader;
            URLClassLoader uRLClassLoader = (URLClassLoader)element$iv;
            List accum = accumulator$iv;
            boolean bl = false;
            accumulator$iv = CollectionsKt.plus((Collection)ReplUtilKt.listLocalUrlsAsFiles((URLClassLoader)loader), (Iterable)accum);
        }
        return CollectionsKt.distinct(accumulator$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<File> listLocalUrlsAsFiles(@NotNull URLClassLoader $this$listLocalUrlsAsFiles) {
        void $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkParameterIsNotNull($this$listLocalUrlsAsFiles, "$this$listLocalUrlsAsFiles");
        URL[] uRLArray = $this$listLocalUrlsAsFiles.getURLs();
        Intrinsics.checkExpressionValueIsNotNull(uRLArray, "this.urLs");
        URL[] $this$mapNotNull$iv = uRLArray;
        boolean $i$f$mapNotNull = false;
        URL[] uRLArray2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        String string2 = $this$forEach$iv$iv$iv;
        int n = ((void)string2).length;
        for (int i = 0; i < n; ++i) {
            String string3;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = string2[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            String string4 = it.toString();
            Intrinsics.checkExpressionValueIsNotNull(string4, "it.toString()");
            if (StringsKt.removePrefix(string4, (CharSequence)"file:") == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string3;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p1;
            string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File file2 = new File((String)p1);
            collection.add(file2);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final <T> List<T> ensureNotEmpty(@NotNull List<? extends T> $this$ensureNotEmpty, @NotNull String error) {
        Intrinsics.checkParameterIsNotNull($this$ensureNotEmpty, "$this$ensureNotEmpty");
        Intrinsics.checkParameterIsNotNull(error, "error");
        if ($this$ensureNotEmpty.isEmpty()) {
            throw (Throwable)new IllegalStateException(error);
        }
        return $this$ensureNotEmpty;
    }

    static {
        LineSeparator lineSeparator = LineSeparator.getSystemLineSeparator();
        Intrinsics.checkExpressionValueIsNotNull((Object)lineSeparator, "LineSeparator.getSystemLineSeparator()");
        String string2 = lineSeparator.getSeparatorString();
        Intrinsics.checkExpressionValueIsNotNull(string2, "LineSeparator.getSystemL\u2026parator().separatorString");
        END_LINE = string2;
    }
}

