/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PsiPrecedenceUtil {
    public static final int PARENTHESIZED_PRECEDENCE = 0;
    public static final int LITERAL_PRECEDENCE = 0;
    public static final int METHOD_CALL_PRECEDENCE = 1;
    public static final int POSTFIX_PRECEDENCE = 2;
    public static final int PREFIX_PRECEDENCE = 3;
    public static final int TYPE_CAST_PRECEDENCE = 4;
    public static final int MULTIPLICATIVE_PRECEDENCE = 5;
    public static final int ADDITIVE_PRECEDENCE = 6;
    public static final int SHIFT_PRECEDENCE = 7;
    public static final int RELATIONAL_PRECEDENCE = 8;
    public static final int EQUALITY_PRECEDENCE = 9;
    public static final int BINARY_AND_PRECEDENCE = 10;
    public static final int BINARY_XOR_PRECEDENCE = 11;
    public static final int BINARY_OR_PRECEDENCE = 12;
    public static final int AND_PRECEDENCE = 13;
    public static final int OR_PRECEDENCE = 14;
    public static final int CONDITIONAL_PRECEDENCE = 15;
    public static final int ASSIGNMENT_PRECEDENCE = 16;
    public static final int LAMBDA_PRECEDENCE = 17;
    public static final int NUM_PRECEDENCES = 18;
    private static final Map<IElementType, Integer> s_binaryOperatorPrecedence = new HashMap<IElementType, Integer>(18);

    public static boolean isCommutativeOperator(@NotNull IElementType token) {
        if (token == null) {
            PsiPrecedenceUtil.$$$reportNull$$$0(0);
        }
        return token == JavaTokenType.PLUS || token == JavaTokenType.ASTERISK || token == JavaTokenType.EQEQ || token == JavaTokenType.NE || token == JavaTokenType.AND || token == JavaTokenType.OR || token == JavaTokenType.XOR;
    }

    public static boolean isCommutativeOperation(PsiPolyadicExpression expression2) {
        IElementType tokenType = expression2.getOperationTokenType();
        if (!PsiPrecedenceUtil.isCommutativeOperator(tokenType)) {
            return false;
        }
        PsiType type2 = expression2.getType();
        return type2 != null && !type2.equalsToText("java.lang.String");
    }

    public static boolean isAssociativeOperation(PsiPolyadicExpression expression2) {
        PsiPrimitiveType primitiveType;
        IElementType tokenType = expression2.getOperationTokenType();
        PsiType type2 = expression2.getType();
        if (type2 instanceof PsiClassType) {
            primitiveType = PsiPrimitiveType.getUnboxedType(type2);
            if (primitiveType == null) {
                return false;
            }
        } else if (type2 instanceof PsiPrimitiveType) {
            primitiveType = (PsiPrimitiveType)type2;
        } else {
            return false;
        }
        if (JavaTokenType.PLUS == tokenType || JavaTokenType.ASTERISK == tokenType) {
            return !PsiType.FLOAT.equals(primitiveType) && !PsiType.DOUBLE.equals(primitiveType);
        }
        if (JavaTokenType.EQEQ == tokenType || JavaTokenType.NE == tokenType) {
            return PsiType.BOOLEAN.equals(primitiveType);
        }
        if (JavaTokenType.AND == tokenType || JavaTokenType.OR == tokenType || JavaTokenType.XOR == tokenType) {
            return true;
        }
        return JavaTokenType.OROR == tokenType || JavaTokenType.ANDAND == tokenType;
    }

    public static int getPrecedence(PsiExpression expression2) {
        if (expression2 instanceof PsiThisExpression || expression2 instanceof PsiLiteralExpression || expression2 instanceof PsiSuperExpression || expression2 instanceof PsiClassObjectAccessExpression || expression2 instanceof PsiArrayAccessExpression || expression2 instanceof PsiArrayInitializerExpression) {
            return 0;
        }
        if (expression2 instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
            if (referenceExpression.getQualifier() != null) {
                return 1;
            }
            return 0;
        }
        if (expression2 instanceof PsiMethodCallExpression || expression2 instanceof PsiNewExpression) {
            return 1;
        }
        if (expression2 instanceof PsiTypeCastExpression) {
            return 4;
        }
        if (expression2 instanceof PsiPrefixExpression) {
            return 3;
        }
        if (expression2 instanceof PsiPostfixExpression || expression2 instanceof PsiSwitchExpression) {
            return 2;
        }
        if (expression2 instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
            return PsiPrecedenceUtil.getPrecedenceForOperator(polyadicExpression.getOperationTokenType());
        }
        if (expression2 instanceof PsiInstanceOfExpression) {
            return 8;
        }
        if (expression2 instanceof PsiConditionalExpression) {
            return 15;
        }
        if (expression2 instanceof PsiAssignmentExpression) {
            return 16;
        }
        if (expression2 instanceof PsiParenthesizedExpression) {
            return 0;
        }
        if (expression2 instanceof PsiLambdaExpression) {
            return 17;
        }
        return -1;
    }

    public static int getPrecedenceForOperator(@NotNull IElementType operator) {
        Integer precedence;
        if (operator == null) {
            PsiPrecedenceUtil.$$$reportNull$$$0(1);
        }
        if ((precedence = s_binaryOperatorPrecedence.get(operator)) == null) {
            throw new IllegalArgumentException("unknown operator: " + operator);
        }
        return precedence;
    }

    public static boolean areParenthesesNeeded(PsiParenthesizedExpression expression2, boolean ignoreClarifyingParentheses) {
        PsiElement parent2 = expression2.getParent();
        if (!(parent2 instanceof PsiExpression)) {
            return false;
        }
        PsiExpression child = expression2.getExpression();
        return child == null || PsiPrecedenceUtil.areParenthesesNeeded(child, (PsiExpression)parent2, ignoreClarifyingParentheses);
    }

    public static boolean areParenthesesNeeded(PsiExpression expression2, PsiExpression parentExpression, boolean ignoreClarifyingParentheses) {
        int childPrecedence;
        if (parentExpression instanceof PsiParenthesizedExpression || parentExpression instanceof PsiArrayInitializerExpression) {
            return false;
        }
        if (parentExpression instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)parentExpression;
            return PsiTreeUtil.isAncestor(arrayAccessExpression.getArrayExpression(), expression2, false);
        }
        int parentPrecedence = PsiPrecedenceUtil.getPrecedence(parentExpression);
        if (parentPrecedence > (childPrecedence = PsiPrecedenceUtil.getPrecedence(expression2))) {
            return ignoreClarifyingParentheses && (expression2 instanceof PsiPolyadicExpression ? parentExpression instanceof PsiPolyadicExpression || parentExpression instanceof PsiConditionalExpression || parentExpression instanceof PsiInstanceOfExpression : expression2 instanceof PsiInstanceOfExpression);
        }
        if (parentExpression instanceof PsiPolyadicExpression && expression2 instanceof PsiPolyadicExpression) {
            PsiExpression[] operands;
            PsiPolyadicExpression parentPolyadicExpression = (PsiPolyadicExpression)parentExpression;
            PsiType parentType = parentPolyadicExpression.getType();
            if (parentType == null) {
                return true;
            }
            PsiPolyadicExpression childPolyadicExpression = (PsiPolyadicExpression)expression2;
            PsiType childType = childPolyadicExpression.getType();
            if (!parentType.equals(childType)) {
                return true;
            }
            if (childType.equalsToText("java.lang.String") && !PsiTreeUtil.isAncestor(parentPolyadicExpression.getOperands()[0], childPolyadicExpression, true)) {
                for (PsiExpression operand : operands = childPolyadicExpression.getOperands()) {
                    if (childType.equals(operand.getType())) continue;
                    return true;
                }
            } else if (childType.equals(PsiType.BOOLEAN)) {
                for (PsiExpression operand : operands = childPolyadicExpression.getOperands()) {
                    if (PsiType.BOOLEAN.equals(operand.getType())) continue;
                    return true;
                }
            }
            IElementType parentOperator = parentPolyadicExpression.getOperationTokenType();
            IElementType childOperator = childPolyadicExpression.getOperationTokenType();
            if (ignoreClarifyingParentheses && !childOperator.equals(parentOperator)) {
                return true;
            }
            PsiExpression[] parentOperands = parentPolyadicExpression.getOperands();
            if (!(PsiTreeUtil.isAncestor(parentOperands[0], expression2, false) || PsiPrecedenceUtil.isAssociativeOperation(parentPolyadicExpression) && JavaTokenType.DIV != childOperator && JavaTokenType.PERC != childOperator)) {
                return true;
            }
        } else {
            if (parentExpression instanceof PsiConditionalExpression && expression2 instanceof PsiConditionalExpression) {
                PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)parentExpression;
                PsiExpression condition = conditionalExpression.getCondition();
                return PsiTreeUtil.isAncestor(condition, expression2, true);
            }
            if (expression2 instanceof PsiLambdaExpression) {
                if (parentExpression instanceof PsiTypeCastExpression) {
                    return false;
                }
                if (parentExpression instanceof PsiConditionalExpression) {
                    PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)parentExpression;
                    return PsiTreeUtil.isAncestor(conditionalExpression.getCondition(), expression2, true);
                }
            }
        }
        return parentPrecedence < childPrecedence;
    }

    public static boolean areParenthesesNeeded(PsiJavaToken compoundAssignmentToken, PsiExpression rhs) {
        if (rhs instanceof PsiPolyadicExpression) {
            IElementType signTokenType;
            IElementType newOperatorToken;
            int precedence2;
            PsiPolyadicExpression binaryExpression = (PsiPolyadicExpression)rhs;
            int precedence1 = PsiPrecedenceUtil.getPrecedenceForOperator(binaryExpression.getOperationTokenType());
            return precedence1 >= (precedence2 = PsiPrecedenceUtil.getPrecedenceForOperator(newOperatorToken = TypeConversionUtil.convertEQtoOperation(signTokenType = compoundAssignmentToken.getTokenType()))) || !PsiPrecedenceUtil.isCommutativeOperator(newOperatorToken);
        }
        return rhs instanceof PsiConditionalExpression;
    }

    static {
        s_binaryOperatorPrecedence.put(JavaTokenType.PLUS, 6);
        s_binaryOperatorPrecedence.put(JavaTokenType.MINUS, 6);
        s_binaryOperatorPrecedence.put(JavaTokenType.ASTERISK, 5);
        s_binaryOperatorPrecedence.put(JavaTokenType.DIV, 5);
        s_binaryOperatorPrecedence.put(JavaTokenType.PERC, 5);
        s_binaryOperatorPrecedence.put(JavaTokenType.ANDAND, 13);
        s_binaryOperatorPrecedence.put(JavaTokenType.OROR, 14);
        s_binaryOperatorPrecedence.put(JavaTokenType.AND, 10);
        s_binaryOperatorPrecedence.put(JavaTokenType.OR, 12);
        s_binaryOperatorPrecedence.put(JavaTokenType.XOR, 11);
        s_binaryOperatorPrecedence.put(JavaTokenType.LTLT, 7);
        s_binaryOperatorPrecedence.put(JavaTokenType.GTGT, 7);
        s_binaryOperatorPrecedence.put(JavaTokenType.GTGTGT, 7);
        s_binaryOperatorPrecedence.put(JavaTokenType.GT, 8);
        s_binaryOperatorPrecedence.put(JavaTokenType.GE, 8);
        s_binaryOperatorPrecedence.put(JavaTokenType.LT, 8);
        s_binaryOperatorPrecedence.put(JavaTokenType.LE, 8);
        s_binaryOperatorPrecedence.put(JavaTokenType.EQEQ, 9);
        s_binaryOperatorPrecedence.put(JavaTokenType.NE, 9);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operator";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/util/PsiPrecedenceUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isCommutativeOperator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getPrecedenceForOperator";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

