/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.ivy.core.module.id;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.kotlin.org.apache.ivy.plugins.matcher.ExactPatternMatcher;
import org.jetbrains.kotlin.org.apache.ivy.plugins.matcher.MapMatcher;

public class MatcherLookup {
    private Map<String, List<MapMatcher>> lookup = new HashMap<String, List<MapMatcher>>();
    private List<MapMatcher> nonExactMatchers = new ArrayList<MapMatcher>();

    public void add(MapMatcher matcher) {
        if (!(matcher.getPatternMatcher() instanceof ExactPatternMatcher)) {
            this.nonExactMatchers.add(matcher);
            return;
        }
        String key = this.key(matcher.getAttributes());
        List<MapMatcher> exactMatchers = this.lookup.get(key);
        if (exactMatchers == null) {
            exactMatchers = new ArrayList<MapMatcher>();
            this.lookup.put(key, exactMatchers);
        }
        exactMatchers.add(matcher);
    }

    public List<MapMatcher> get(Map<String, String> attrs) {
        List<MapMatcher> defaultExactMatchers;
        String key;
        List<MapMatcher> exactMatchers;
        ArrayList<MapMatcher> matchers = new ArrayList<MapMatcher>();
        if (!this.nonExactMatchers.isEmpty()) {
            for (MapMatcher matcher : this.nonExactMatchers) {
                if (!matcher.matches(attrs)) continue;
                matchers.add(matcher);
            }
        }
        if ((exactMatchers = this.lookup.get(key = this.key(attrs))) != null) {
            for (MapMatcher matcher : exactMatchers) {
                if (!matcher.matches(attrs)) continue;
                matchers.add(matcher);
            }
        }
        if (!"{org:default, module:default}".equals(key) && (defaultExactMatchers = this.lookup.get("{org:default, module:default}")) != null) {
            for (MapMatcher matcher : defaultExactMatchers) {
                if (!matcher.matches(attrs)) continue;
                matchers.add(matcher);
            }
        }
        return matchers;
    }

    private String key(Map<String, String> attrs) {
        String org = attrs.get("organisation");
        String module = attrs.get("module");
        if (org == null || "*".equals(org) || module == null || "*".equals(module)) {
            return "{org:default, module:default}";
        }
        return "{org:" + org + ", module:" + module + "}";
    }
}

