/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extended;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.FirSourceChildrenKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory0;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/RedundantModalityModifierChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirMemberDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers"})
public final class RedundantModalityModifierChecker
extends FirDeclarationChecker<FirMemberDeclaration> {
    @NotNull
    public static final RedundantModalityModifierChecker INSTANCE;

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirMemberDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        block6: {
            void $this$report$iv;
            Modality implicitModality;
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(context2, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            FirSourceElement firSourceElement = declaration2.getSource();
            if ((firSourceElement != null ? firSourceElement.getKind() : null) instanceof FirFakeSourceElementKind) {
                return;
            }
            FirMemberDeclaration $this$modality$iv = declaration2;
            boolean $i$f$getModality = false;
            Modality modality = $this$modality$iv.getStatus().getModality();
            if (modality == null) {
                return;
            }
            Modality modality2 = modality;
            if (modality2 == Modality.FINAL) {
                FirDeclaration firDeclaration = CollectionsKt.last(context2.getContainingDeclarations());
                if (!(firDeclaration instanceof FirClass)) {
                    firDeclaration = null;
                }
                FirClass firClass = (FirClass)firDeclaration;
                if ((firClass != null ? firClass.getClassKind() : null) == ClassKind.INTERFACE) {
                    return;
                }
            }
            if (modality2 != (implicitModality = FirHelpersKt.implicitModality(declaration2, context2))) {
                return;
            }
            FirSourceElement firSourceElement2 = declaration2.getSource();
            FirSourceElement modalityModifierSource = firSourceElement2 != null ? FirSourceChildrenKt.getChild$default(firSourceElement2, FirHelpersKt.toToken(modality2), 0, 2, 2, null) : null;
            DiagnosticReporter diagnosticReporter = reporter;
            FirDiagnosticFactory0<FirSourceElement, PsiElement> factory$iv = FirErrors.INSTANCE.getREDUNDANT_MODALITY_MODIFIER();
            boolean $i$f$report = false;
            FirSourceElement firSourceElement3 = modalityModifierSource;
            if (firSourceElement3 == null) break block6;
            FirSourceElement firSourceElement4 = firSourceElement3;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it$iv = firSourceElement4;
            boolean bl3 = false;
            $this$report$iv.report((FirDiagnostic)factory$iv.on(it$iv));
        }
    }

    private RedundantModalityModifierChecker() {
    }

    static {
        RedundantModalityModifierChecker redundantModalityModifierChecker;
        INSTANCE = redundantModalityModifierChecker = new RedundantModalityModifierChecker();
    }
}

