/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.NotNull;

public final class BoundedTaskExecutor
extends AbstractExecutorService {
    private static final Logger LOG = Logger.getInstance(BoundedTaskExecutor.class);
    private volatile boolean myShutdown;
    @NotNull
    private final String myName;
    private final Executor myBackendExecutor;
    private final int myMaxThreads;
    private final AtomicLong myStatus;
    private final BlockingQueue<Runnable> myTaskQueue;
    private final boolean myChangeThreadName;

    BoundedTaskExecutor(@NotNull String name, @NotNull Executor backendExecutor, int maxThreads, boolean changeThreadName) {
        if (name == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(0);
        }
        if (backendExecutor == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(1);
        }
        this.myStatus = new AtomicLong();
        this.myTaskQueue = new LinkedBlockingQueue<Runnable>();
        this.myName = name;
        this.myBackendExecutor = backendExecutor;
        if (maxThreads < 1) {
            throw new IllegalArgumentException("maxThreads must be >=1 but got: " + maxThreads);
        }
        if (backendExecutor instanceof BoundedTaskExecutor) {
            throw new IllegalArgumentException("backendExecutor is already BoundedTaskExecutor: " + backendExecutor);
        }
        this.myMaxThreads = maxThreads;
        this.myChangeThreadName = changeThreadName;
    }

    BoundedTaskExecutor(@NotNull String name, @NotNull Executor backendExecutor, int maxSimultaneousTasks, @NotNull Disposable parent2) {
        if (name == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(3);
        }
        if (backendExecutor == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(4);
        }
        if (parent2 == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(5);
        }
        this(name, backendExecutor, maxSimultaneousTasks, true);
        Disposer.register(parent2, () -> this.shutdownNow());
    }

    static Object info(Runnable info) {
        Runnable task = info;
        String extra = null;
        if (task instanceof FutureTask) {
            extra = ((FutureTask)task).isCancelled() ? " (future cancelled)" : (((FutureTask)task).isDone() ? " (future done)" : null);
            task = ObjectUtils.chooseNotNull(ReflectionUtil.getField(task.getClass(), task, Callable.class, "callable"), task);
        }
        if (task instanceof Callable && task.getClass().getName().equals("java.util.concurrent.Executors$RunnableAdapter")) {
            task = ObjectUtils.chooseNotNull(ReflectionUtil.getField(task.getClass(), task, Runnable.class, "task"), task);
        }
        return extra == null ? task : task.getClass() + extra;
    }

    @Override
    public void shutdown() {
        if (this.myShutdown) {
            throw new IllegalStateException("Already shut down: " + this);
        }
        this.myShutdown = true;
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        this.shutdown();
        List<Runnable> list2 = this.clearAndCancelAll();
        if (list2 == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @Override
    public boolean isShutdown() {
        return this.myShutdown;
    }

    @Override
    public boolean isTerminated() {
        return this.myShutdown;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean awaitTermination(long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException {
        if (timeUnit == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(7);
        }
        if (!this.isShutdown()) {
            throw new IllegalStateException("you must call shutdown() or shutdownNow() first");
        }
        try {
            void unit;
            this.waitAllTasksExecuted(timeout, (TimeUnit)unit);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (TimeoutException e) {
            return false;
        }
        return true;
    }

    @Override
    public void execute(@NotNull @Async.Schedule Runnable task) {
        if (task == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(8);
        }
        if (this.isShutdown() && !(task instanceof LastTask)) {
            throw new RejectedExecutionException("Already shutdown");
        }
        long status2 = this.incrementCounterAndTimestamp();
        int inProgress = (int)status2;
        assert (inProgress > 0) : inProgress;
        if (inProgress <= this.myMaxThreads) {
            this.wrapAndExecute(task, status2);
            return;
        }
        if (!this.myTaskQueue.offer(task)) {
            throw new RejectedExecutionException();
        }
        Runnable next = this.pollOrGiveUp(status2);
        if (next != null) {
            this.wrapAndExecute(next, status2);
        }
    }

    private long incrementCounterAndTimestamp() {
        return this.myStatus.updateAndGet(status2 -> status2 + 1L + 0x100000000L & Long.MAX_VALUE);
    }

    private Runnable pollOrGiveUp(long status2) {
        while (true) {
            Runnable next;
            int inProgress = (int)status2;
            assert (inProgress > 0) : inProgress;
            if (inProgress <= this.myMaxThreads && (next = (Runnable)this.myTaskQueue.poll()) != null) {
                return next;
            }
            if (this.myStatus.compareAndSet(status2, status2 - 1L)) break;
            status2 = this.myStatus.get();
        }
        return null;
    }

    private void wrapAndExecute(@NotNull Runnable firstTask, final long status2) {
        if (firstTask == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(9);
        }
        try {
            final AtomicReference<Runnable> currentTask = new AtomicReference<Runnable>(firstTask);
            this.myBackendExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    if (BoundedTaskExecutor.this.myChangeThreadName) {
                        String name = BoundedTaskExecutor.this.myName;
                        if (StartUpMeasurer.isEnabled()) {
                            name = name + "[" + Thread.currentThread().getName() + "]";
                        }
                        ConcurrencyUtil.runUnderThreadName(name, this::execute);
                    } else {
                        this.execute();
                    }
                }

                private void execute() {
                    Runnable task = (Runnable)currentTask.get();
                    do {
                        currentTask.set(task);
                        BoundedTaskExecutor.doRun(task);
                    } while ((task = BoundedTaskExecutor.this.pollOrGiveUp(status2)) != null);
                }

                public String toString() {
                    return String.valueOf(BoundedTaskExecutor.info((Runnable)currentTask.get()));
                }
            });
        }
        catch (Error | RuntimeException e) {
            this.myStatus.decrementAndGet();
            throw e;
        }
    }

    private static void doRun(@Async.Execute Runnable task) {
        block4: {
            try {
                task.run();
            }
            catch (Throwable e) {
                if (e instanceof ControlFlowException) break block4;
                try {
                    LOG.error(e);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void waitAllTasksExecuted(long timeout, @NotNull TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
        void unit;
        if (timeUnit == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(10);
        }
        CountDownLatch started = new CountDownLatch(this.myMaxThreads);
        CountDownLatch readyToFinish = new CountDownLatch(1);
        Runnable runnable = () -> {
            try {
                started.countDown();
                readyToFinish.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        };
        List<Future> futures = ContainerUtil.map(Collections.nCopies(this.myMaxThreads, null), __ -> {
            LastTask wait = new LastTask(runnable);
            this.execute(wait);
            return wait;
        });
        try {
            if (!started.await(timeout, (TimeUnit)unit)) {
                throw new TimeoutException("Interrupted by timeout. " + this);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            readyToFinish.countDown();
        }
        for (Future future : futures) {
            future.get(timeout, (TimeUnit)unit);
        }
    }

    public boolean isEmpty() {
        return (int)this.myStatus.get() == 0;
    }

    @NotNull
    public List<Runnable> clearAndCancelAll() {
        ArrayList<Runnable> queued = new ArrayList<Runnable>();
        this.myTaskQueue.drainTo(queued);
        for (Runnable task : queued) {
            if (!(task instanceof FutureTask)) continue;
            ((FutureTask)task).cancel(false);
        }
        ArrayList<Runnable> arrayList = queued;
        if (arrayList == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    public String toString() {
        return "BoundedExecutor(" + this.myMaxThreads + ")" + (this.isShutdown() ? " SHUTDOWN " : "") + "; inProgress: " + (int)this.myStatus.get() + (this.myTaskQueue.isEmpty() ? "" : "; queue: " + this.myTaskQueue.size() + "[" + ContainerUtil.map(this.myTaskQueue, BoundedTaskExecutor::info) + "]") + "; name: " + this.myName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backendExecutor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/concurrency/BoundedTaskExecutor";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/concurrency/BoundedTaskExecutor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "shutdownNow";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "clearAndCancelAll";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "awaitTermination";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "wrapAndExecute";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "waitAllTasksExecuted";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LastTask
    extends FutureTask<Void> {
        LastTask(@NotNull Runnable runnable) {
            if (runnable == null) {
                LastTask.$$$reportNull$$$0(0);
            }
            super(runnable, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/util/concurrency/BoundedTaskExecutor$LastTask", "<init>"));
        }
    }
}

