/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentIntKeyWeakValueHashMap;
import com.intellij.util.containers.ConcurrentIntObjectHashMap;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ConcurrentLongObjectHashMap;
import com.intellij.util.containers.ConcurrentLongObjectMap;
import com.intellij.util.containers.ConcurrentSoftHashMap;
import com.intellij.util.containers.ConcurrentSoftKeySoftValueHashMap;
import com.intellij.util.containers.ConcurrentSoftValueHashMap;
import com.intellij.util.containers.ConcurrentWeakHashMap;
import com.intellij.util.containers.ConcurrentWeakKeySoftValueHashMap;
import com.intellij.util.containers.ConcurrentWeakKeyWeakValueHashMap;
import com.intellij.util.containers.ConcurrentWeakValueHashMap;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.FilteringIterator;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.LockFreeCopyOnWriteArrayList;
import com.intellij.util.containers.SequenceIterator;
import com.intellij.util.containers.SoftHashMap;
import com.intellij.util.containers.WeakHashMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntIterator;
import gnu.trove.TObjectHashingStrategy;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainerUtil
extends ContainerUtilRt {
    @NotNull
    @Contract(pure=true)
    public static <T> TObjectHashingStrategy<T> canonicalStrategy() {
        TObjectHashingStrategy tObjectHashingStrategy = TObjectHashingStrategy.CANONICAL;
        if (tObjectHashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(16);
        }
        return tObjectHashingStrategy;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TObjectHashingStrategy<T> identityStrategy() {
        TObjectHashingStrategy tObjectHashingStrategy = TObjectHashingStrategy.IDENTITY;
        if (tObjectHashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(17);
        }
        return tObjectHashingStrategy;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> IdentityHashMap<K, V> newIdentityHashMap() {
        return new IdentityHashMap();
    }

    @SafeVarargs
    @NotNull
    @Contract(pure=true)
    public static <E> ArrayList<E> newArrayList(E ... array) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(20);
        }
        return new ArrayList<E>(Arrays.asList(array));
    }

    @NotNull
    @Contract(pure=true)
    public static <E> ArrayList<E> newArrayList(@NotNull Iterable<? extends E> iterable) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(22);
        }
        ArrayList<? extends E> arrayList = ContainerUtilRt.newArrayList(iterable);
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> newArrayList(final T @NotNull [] elements, final int start, final int end) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(24);
        }
        if (start < 0 || start > end || end > elements.length) {
            throw new IllegalArgumentException("start:" + start + " end:" + end + " length:" + elements.length);
        }
        return new AbstractList<T>(){
            private final int size;
            {
                this.size = end - start;
            }

            @Override
            public T get(int index2) {
                if (index2 < 0 || index2 >= this.size) {
                    throw new IndexOutOfBoundsException("index:" + index2 + " size:" + this.size);
                }
                return elements[start + index2];
            }

            @Override
            public int size() {
                return this.size;
            }
        };
    }

    @SafeVarargs
    @NotNull
    @Contract(pure=true)
    public static <T> HashSet<T> newHashSet(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(39);
        }
        return new HashSet<T>(Arrays.asList(elements));
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedHashSet<T> newLinkedHashSet(@NotNull Iterable<? extends T> elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(46);
        }
        LinkedHashSet linkedHashSet = ContainerUtil.copy(new LinkedHashSet(), elements);
        if (linkedHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(47);
        }
        return linkedHashSet;
    }

    @SafeVarargs
    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(51);
        }
        return new THashSet(Arrays.asList(elements));
    }

    @SafeVarargs
    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet(@NotNull TObjectHashingStrategy<T> strategy, T ... elements) {
        if (strategy == null) {
            ContainerUtil.$$$reportNull$$$0(52);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(53);
        }
        return new THashSet(Arrays.asList(elements), strategy);
    }

    @NotNull
    @Contract(pure=true)
    public static <K> THashSet<K> newIdentityTroveSet() {
        return new THashSet(ContainerUtil.identityStrategy());
    }

    @NotNull
    @Contract(pure=true)
    public static <K> THashSet<K> newIdentityTroveSet(int initialCapacity) {
        return new THashSet(initialCapacity, ContainerUtil.identityStrategy());
    }

    @NotNull
    @Contract(pure=true)
    public static <K> THashSet<K> newIdentityTroveSet(@NotNull Collection<? extends K> collection) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(57);
        }
        return new THashSet(collection, ContainerUtil.identityStrategy());
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> THashMap<K, V> newIdentityTroveMap() {
        return new THashMap(ContainerUtil.identityStrategy());
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> newConcurrentSet() {
        Set set = Collections.newSetFromMap(ContainerUtil.newConcurrentMap());
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(58);
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> newConcurrentMap() {
        return new ConcurrentHashMap();
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> newConcurrentMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
    }

    @NotNull
    @Contract(pure=true)
    public static <E> List<E> reverse(final @NotNull List<? extends E> elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(59);
        }
        if (elements.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        return new AbstractList<E>(){

            @Override
            public E get(int index2) {
                return elements.get(elements.size() - 1 - index2);
            }

            @Override
            public int size() {
                return elements.size();
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> union(@NotNull Collection<? extends T> set, @NotNull Collection<? extends T> set2) {
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(65);
        }
        if (set2 == null) {
            ContainerUtil.$$$reportNull$$$0(66);
        }
        THashSet result2 = new THashSet(set.size() + set2.size());
        result2.addAll(set);
        result2.addAll(set2);
        THashSet tHashSet = result2;
        if (tHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(67);
        }
        return tHashSet;
    }

    @SafeVarargs
    @NotNull
    @Contract(pure=true)
    public static <E> Set<E> immutableSet(E ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(68);
        }
        switch (elements.length) {
            case 0: {
                Set set = Collections.emptySet();
                if (set == null) {
                    ContainerUtil.$$$reportNull$$$0(69);
                }
                return set;
            }
            case 1: {
                Set<E> set = Collections.singleton(elements[0]);
                if (set == null) {
                    ContainerUtil.$$$reportNull$$$0(70);
                }
                return set;
            }
        }
        Set<E> set = Collections.unmodifiableSet(ContainerUtil.newTroveSet(elements));
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(71);
        }
        return set;
    }

    @SafeVarargs
    @NotNull
    @Contract(pure=true)
    public static <E> ImmutableList<E> immutableList(E ... array) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(72);
        }
        return new ImmutableListBackedByArray(array);
    }

    @NotNull
    @Contract(pure=true)
    public static <E> ImmutableList<E> immutableSingletonList(E element) {
        ImmutableList<E> immutableList = ImmutableList.singleton(element);
        if (immutableList == null) {
            ContainerUtil.$$$reportNull$$$0(73);
        }
        return immutableList;
    }

    @NotNull
    @Contract(pure=true)
    public static <U> Iterator<U> mapIterator(final @NotNull TIntIterator iterator2, final @NotNull IntFunction<? extends U> mapper) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(79);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(80);
        }
        return new Iterator<U>(){

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public U next() {
                return mapper.apply(iterator2.next());
            }

            @Override
            public void remove() {
                iterator2.remove();
            }
        };
    }

    public static <T> void addAll(@NotNull Collection<? super T> collection, @NotNull Iterator<? extends T> iterator2) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(101);
        }
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(102);
        }
        while (iterator2.hasNext()) {
            T o = iterator2.next();
            collection.add(o);
        }
    }

    public static <T> void addAllNotNull(@NotNull Collection<? super T> collection, @NotNull Iterable<? extends T> elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(103);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(104);
        }
        ContainerUtil.addAllNotNull(collection, elements.iterator());
    }

    public static <T> void addAllNotNull(@NotNull Collection<? super T> collection, @NotNull Iterator<? extends T> elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(105);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(106);
        }
        while (elements.hasNext()) {
            T o = elements.next();
            if (o == null) continue;
            collection.add(o);
        }
    }

    @Contract(pure=true)
    public static <T> T find(T @NotNull [] array, @NotNull Condition<? super T> condition) {
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(123);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(124);
        }
        for (T element : array) {
            if (!condition.value(element)) continue;
            return element;
        }
        return null;
    }

    public static <T> boolean process(@NotNull Iterable<? extends T> iterable, @NotNull Processor<? super T> processor2) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(125);
        }
        if (processor2 == null) {
            ContainerUtil.$$$reportNull$$$0(126);
        }
        for (T t : iterable) {
            if (processor2.process(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(@NotNull List<? extends T> list2, @NotNull Processor<? super T> processor2) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(127);
        }
        if (processor2 == null) {
            ContainerUtil.$$$reportNull$$$0(128);
        }
        int size = list2.size();
        for (int i = 0; i < size; ++i) {
            T t = list2.get(i);
            if (processor2.process(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(T @NotNull [] iterable, @NotNull Processor<? super T> processor2) {
        if (processor2 == null) {
            ContainerUtil.$$$reportNull$$$0(129);
        }
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(130);
        }
        for (T t : iterable) {
            if (processor2.process(t)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static <T> T find(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(133);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(134);
        }
        return ContainerUtil.find(iterable.iterator(), condition);
    }

    public static <T> T find(@NotNull Iterator<? extends T> iterator2, @NotNull Condition<? super T> condition) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(139);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(140);
        }
        while (iterator2.hasNext()) {
            T value2 = iterator2.next();
            if (!condition.value(value2)) continue;
            return value2;
        }
        return null;
    }

    @Contract(pure=true)
    public static <T, V> V @NotNull [] map2Array(T @NotNull [] array, @NotNull Class<V> aClass2, @NotNull Function<? super T, ? extends V> mapper) {
        if (aClass2 == null) {
            ContainerUtil.$$$reportNull$$$0(159);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(160);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(161);
        }
        V[] result2 = ArrayUtil.newArray(aClass2, array.length);
        for (int i = 0; i < array.length; ++i) {
            result2[i] = mapper.fun(array[i]);
        }
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(162);
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> filter(T @NotNull [] collection, @NotNull Condition<? super T> condition) {
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(171);
        }
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(172);
        }
        return ContainerUtil.findAll(collection, condition);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> findAll(T @NotNull [] collection, @NotNull Condition<? super T> condition) {
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(176);
        }
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(177);
        }
        SmartList<T> result2 = new SmartList<T>();
        for (T t : collection) {
            if (!condition.value(t)) continue;
            result2.add(t);
        }
        SmartList<T> smartList = result2;
        if (smartList == null) {
            ContainerUtil.$$$reportNull$$$0(178);
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> filter(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(181);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(182);
        }
        return ContainerUtil.findAll(collection, condition);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> findAll(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(186);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(187);
        }
        if (collection.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        SmartList<T> result2 = new SmartList<T>();
        for (T t : collection) {
            if (!condition.value(t)) continue;
            result2.add(t);
        }
        SmartList<T> smartList = result2;
        if (smartList == null) {
            ContainerUtil.$$$reportNull$$$0(188);
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> skipNulls(@NotNull Collection<? extends T> collection) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(189);
        }
        return ContainerUtil.findAll(collection, Conditions.notNull());
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> iterate(T @NotNull [] arrays, @NotNull Condition<? super T> condition) {
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(214);
        }
        if (arrays == null) {
            ContainerUtil.$$$reportNull$$$0(215);
        }
        return ContainerUtil.iterate(Arrays.asList(arrays), condition);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> iterate(final @NotNull Collection<? extends T> collection, final @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(216);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(217);
        }
        if (collection.isEmpty()) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                ContainerUtil.$$$reportNull$$$0(218);
            }
            return list2;
        }
        Iterable iterable = () -> new Iterator<T>(){
            private final Iterator impl;
            private Object next;
            {
                this.impl = collection.iterator();
                this.next = this.findNext();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public T next() {
                Object result2 = this.next;
                this.next = this.findNext();
                return result2;
            }

            @Nullable
            private T findNext() {
                while (this.impl.hasNext()) {
                    Object each = this.impl.next();
                    if (!condition.value(each)) continue;
                    return each;
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(219);
        }
        return iterable;
    }

    public static <E> void swapElements(@NotNull List<E> list2, int index1, int index2) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(225);
        }
        E e1 = list2.get(index1);
        E e2 = list2.get(index2);
        list2.set(index1, e2);
        list2.set(index2, e1);
    }

    @SafeVarargs
    @NotNull
    public static <T, C extends Collection<? super T>> C addAll(@NotNull C collection, T ... elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(230);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(231);
        }
        for (T element : elements) {
            collection.add(element);
        }
        C c = collection;
        if (c == null) {
            ContainerUtil.$$$reportNull$$$0(232);
        }
        return c;
    }

    @SafeVarargs
    @NotNull
    public static <T, C extends Collection<T>> C addAllNotNull(@NotNull C collection, T ... elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(233);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(234);
        }
        for (T element : elements) {
            if (element == null) continue;
            collection.add(element);
        }
        C c = collection;
        if (c == null) {
            ContainerUtil.$$$reportNull$$$0(235);
        }
        return c;
    }

    @Contract(pure=true)
    public static <T, U extends T> U findInstance(@NotNull Iterable<? extends T> iterable, @NotNull Class<? extends U> aClass2) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(240);
        }
        if (aClass2 == null) {
            ContainerUtil.$$$reportNull$$$0(241);
        }
        return ContainerUtil.findInstance(iterable.iterator(), aClass2);
    }

    public static <T, U extends T> U findInstance(@NotNull Iterator<? extends T> iterator2, @NotNull Class<? extends U> aClass2) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(242);
        }
        if (aClass2 == null) {
            ContainerUtil.$$$reportNull$$$0(243);
        }
        return (U)ContainerUtil.find(iterator2, FilteringIterator.instanceOf(aClass2));
    }

    @Contract(pure=true)
    public static <T, U extends T> U findInstance(T @NotNull [] array, @NotNull Class<? extends U> aClass2) {
        if (aClass2 == null) {
            ContainerUtil.$$$reportNull$$$0(244);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(245);
        }
        return (U)ContainerUtil.find(array, FilteringIterator.instanceOf(aClass2));
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<T> concat(V @NotNull [] array, @NotNull Function<? super V, ? extends Collection<? extends T>> fun) {
        if (fun == null) {
            ContainerUtil.$$$reportNull$$$0(246);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(247);
        }
        return ContainerUtil.concat(Arrays.asList(array), fun);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> concat(final @NotNull List<? extends T> list1, final @NotNull List<? extends T> list2) {
        if (list1 == null) {
            ContainerUtil.$$$reportNull$$$0(254);
        }
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(255);
        }
        if (list1.isEmpty() && list2.isEmpty()) {
            List list3 = Collections.emptyList();
            if (list3 == null) {
                ContainerUtil.$$$reportNull$$$0(256);
            }
            return list3;
        }
        if (list1.isEmpty()) {
            List<T> list4 = list2;
            if (list4 == null) {
                ContainerUtil.$$$reportNull$$$0(257);
            }
            return list4;
        }
        if (list2.isEmpty()) {
            List<T> list5 = list1;
            if (list5 == null) {
                ContainerUtil.$$$reportNull$$$0(258);
            }
            return list5;
        }
        final int size1 = list1.size();
        final int size = size1 + list2.size();
        return new AbstractList<T>(){

            @Override
            public T get(int index2) {
                if (index2 < size1) {
                    return list1.get(index2);
                }
                return list2.get(index2 - size1);
            }

            @Override
            public int size() {
                return size;
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> concat(final @NotNull Iterable<? extends T> it1, final @NotNull Iterable<? extends T> it2) {
        if (it1 == null) {
            ContainerUtil.$$$reportNull$$$0(259);
        }
        if (it2 == null) {
            ContainerUtil.$$$reportNull$$$0(260);
        }
        return new Iterable<T>(){

            @Override
            public void forEach(Consumer<? super T> action) {
                it1.forEach(action);
                it2.forEach(action);
            }

            @Override
            @NotNull
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    Iterator<? extends T> it;
                    boolean firstFinished;
                    {
                        this.it = it1.iterator();
                        this.advance();
                    }

                    @Override
                    public boolean hasNext() {
                        return !this.firstFinished || this.it.hasNext();
                    }

                    @Override
                    public T next() {
                        Object value2 = this.it.next();
                        this.advance();
                        return value2;
                    }

                    private void advance() {
                        if (!this.firstFinished && !this.it.hasNext()) {
                            this.it = it2.iterator();
                            this.firstFinished = true;
                        }
                    }
                };
            }
        };
    }

    @SafeVarargs
    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> concat(Iterable<? extends T> ... iterables) {
        if (iterables == null) {
            ContainerUtil.$$$reportNull$$$0(261);
        }
        if (iterables.length == 0) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                ContainerUtil.$$$reportNull$$$0(262);
            }
            return list2;
        }
        if (iterables.length == 1) {
            Iterable<? extends T> iterable = iterables[0];
            if (iterable == null) {
                ContainerUtil.$$$reportNull$$$0(263);
            }
            return iterable;
        }
        Iterable iterable = () -> {
            Iterator[] iterators = new Iterator[iterables.length];
            for (int i = 0; i < iterables.length; ++i) {
                Iterable iterable = iterables[i];
                iterators[i] = iterable.iterator();
            }
            return ContainerUtil.concatIterators(iterators);
        };
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(264);
        }
        return iterable;
    }

    @SafeVarargs
    @NotNull
    @Contract(pure=true)
    public static <T> Iterator<T> concatIterators(Iterator<? extends T> ... iterators) {
        if (iterators == null) {
            ContainerUtil.$$$reportNull$$$0(265);
        }
        return new SequenceIterator<T>(iterators);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> concat(@NotNull Iterable<? extends T> list2, @NotNull Function<? super T, ? extends Collection<? extends V>> listGenerator) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(270);
        }
        if (listGenerator == null) {
            ContainerUtil.$$$reportNull$$$0(271);
        }
        ArrayList<T> result2 = new ArrayList<T>();
        for (T v : list2) {
            result2.addAll(listGenerator.fun(v));
        }
        List<T> list3 = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list3 == null) {
            ContainerUtil.$$$reportNull$$$0(272);
        }
        return list3;
    }

    @Contract(pure=true)
    public static <T> boolean intersects(@NotNull Collection<? extends T> collection1, @NotNull Collection<? extends T> collection2) {
        if (collection1 == null) {
            ContainerUtil.$$$reportNull$$$0(273);
        }
        if (collection2 == null) {
            ContainerUtil.$$$reportNull$$$0(274);
        }
        if (collection1.size() <= collection2.size()) {
            for (T t : collection1) {
                if (!collection2.contains(t)) continue;
                return true;
            }
        } else {
            for (T t : collection2) {
                if (!collection1.contains(t)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Collection<T> intersection(@NotNull Collection<? extends T> collection1, @NotNull Collection<? extends T> collection2) {
        if (collection1 == null) {
            ContainerUtil.$$$reportNull$$$0(275);
        }
        if (collection2 == null) {
            ContainerUtil.$$$reportNull$$$0(276);
        }
        ArrayList<T> result2 = new ArrayList<T>();
        for (T t : collection1) {
            if (!collection2.contains(t)) continue;
            result2.add(t);
        }
        List<T> list2 = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(277);
        }
        return list2;
    }

    @Contract(pure=true)
    public static <T> T getFirstItem(@Nullable Collection<? extends T> items) {
        return ContainerUtil.getFirstItem(items, null);
    }

    @Contract(pure=true)
    public static <T> T getFirstItem(@Nullable List<? extends T> items) {
        return items == null || items.isEmpty() ? null : (T)items.get(0);
    }

    @Contract(pure=true)
    public static <T> T getFirstItem(@Nullable Collection<? extends T> items, @Nullable T defaultResult) {
        return items == null || items.isEmpty() ? defaultResult : items.iterator().next();
    }

    @Contract(pure=true)
    public static <T> T getOnlyItem(@Nullable Collection<? extends T> items) {
        return ContainerUtil.getOnlyItem(items, null);
    }

    @Contract(pure=true)
    public static <T> T getOnlyItem(@Nullable Collection<? extends T> items, @Nullable T defaultResult) {
        return items == null || items.size() != 1 ? defaultResult : items.iterator().next();
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> getFirstItems(@NotNull List<T> items, int maxItems) {
        if (items == null) {
            ContainerUtil.$$$reportNull$$$0(281);
        }
        if (maxItems < 0) {
            throw new IllegalArgumentException("Expected non-negative maxItems; got: " + maxItems);
        }
        List<T> list2 = maxItems >= items.size() ? items : items.subList(0, maxItems);
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(282);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, U> Iterator<U> mapIterator(final @NotNull Iterator<? extends T> iterator2, final @NotNull Function<? super T, ? extends U> mapper) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(284);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(285);
        }
        return new Iterator<U>(){

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public U next() {
                return mapper.fun(iterator2.next());
            }

            @Override
            public void remove() {
                iterator2.remove();
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterator<T> filterIterator(final @NotNull Iterator<? extends T> iterator2, final @NotNull Condition<? super T> filter2) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(286);
        }
        if (filter2 == null) {
            ContainerUtil.$$$reportNull$$$0(287);
        }
        return new Iterator<T>(){
            T next;
            boolean hasNext;
            {
                this.findNext();
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            private void findNext() {
                this.hasNext = false;
                while (iterator2.hasNext()) {
                    Object t = iterator2.next();
                    if (!filter2.value(t)) continue;
                    this.next = t;
                    this.hasNext = true;
                    break;
                }
            }

            @Override
            public T next() {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                Object result2 = this.next;
                this.findNext();
                return result2;
            }

            @Override
            public void remove() {
                iterator2.remove();
            }
        };
    }

    @Contract(pure=true)
    public static <T> T @NotNull [] toArray(@NotNull Collection<T> c, @NotNull ArrayFactory<? extends T> factory2) {
        if (c == null) {
            ContainerUtil.$$$reportNull$$$0(291);
        }
        if (factory2 == null) {
            ContainerUtil.$$$reportNull$$$0(292);
        }
        T[] a = factory2.create(c.size());
        T[] TArray = c.toArray(a);
        if (TArray == null) {
            ContainerUtil.$$$reportNull$$$0(293);
        }
        return TArray;
    }

    public static <T> void sort(@NotNull List<T> list2, @NotNull Comparator<? super T> comparator) {
        int size;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(303);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(304);
        }
        if ((size = list2.size()) < 2) {
            return;
        }
        if (size == 2) {
            T t1;
            T t0 = list2.get(0);
            if (comparator.compare(t0, t1 = list2.get(1)) > 0) {
                list2.set(0, t1);
                list2.set(1, t0);
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    T tj;
                    T ti = list2.get(i);
                    if (comparator.compare(ti, tj = list2.get(j)) >= 0) continue;
                    list2.set(i, tj);
                    list2.set(j, ti);
                }
            }
        } else {
            list2.sort(comparator);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map(@NotNull Iterable<? extends T> iterable, @NotNull Function<? super T, ? extends V> mapping2) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(314);
        }
        if (mapping2 == null) {
            ContainerUtil.$$$reportNull$$$0(315);
        }
        ArrayList<T> result2 = new ArrayList<T>();
        for (T t : iterable) {
            result2.add(mapping2.fun(t));
        }
        List<T> list2 = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(316);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapping2) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(317);
        }
        if (mapping2 == null) {
            ContainerUtil.$$$reportNull$$$0(318);
        }
        if (collection.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        ArrayList<V> list2 = new ArrayList<V>(collection.size());
        for (T t : collection) {
            list2.add(mapping2.fun(t));
        }
        ArrayList<V> arrayList = list2;
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(319);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> @NotNull List<@NotNull V> mapNotNull(T @NotNull [] array, @NotNull Function<? super T, ? extends V> mapping2) {
        if (mapping2 == null) {
            ContainerUtil.$$$reportNull$$$0(320);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(321);
        }
        if (array.length == 0) {
            return ContainerUtil.emptyList();
        }
        ArrayList<T> result2 = new ArrayList<T>(array.length);
        for (T t : array) {
            V o = mapping2.fun(t);
            if (o == null) continue;
            result2.add(o);
        }
        List<T> list2 = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(322);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> @NotNull List<@NotNull V> mapNotNull(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapping2) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(331);
        }
        if (mapping2 == null) {
            ContainerUtil.$$$reportNull$$$0(332);
        }
        if (collection.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        ArrayList<T> result2 = new ArrayList<T>(collection.size());
        for (T t : collection) {
            V o = mapping2.fun(t);
            if (o == null) continue;
            result2.add(o);
        }
        List<T> list2 = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(333);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map(T @NotNull [] array, @NotNull Function<? super T, ? extends V> mapping2) {
        if (mapping2 == null) {
            ContainerUtil.$$$reportNull$$$0(336);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(337);
        }
        ArrayList<T> result2 = new ArrayList<T>(array.length);
        for (T t : array) {
            result2.add(mapping2.fun(t));
        }
        List<T> list2 = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(338);
        }
        return list2;
    }

    @SafeVarargs
    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> set(T ... items) {
        if (items == null) {
            ContainerUtil.$$$reportNull$$$0(344);
        }
        return new HashSet<T>(Arrays.asList(items));
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> createMaybeSingletonList(@Nullable T element) {
        List<T> list2 = element == null ? ContainerUtil.emptyList() : Collections.singletonList(element);
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(351);
        }
        return list2;
    }

    @Contract(pure=true)
    public static <T> boolean and(T @NotNull [] iterable, @NotNull Condition<? super T> condition) {
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(361);
        }
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(362);
        }
        for (T t : iterable) {
            if (condition.value(t)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static <T> boolean and(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(363);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(364);
        }
        for (T t : iterable) {
            if (condition.value(t)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static <T> boolean exists(T @NotNull [] array, @NotNull Condition<? super T> condition) {
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(365);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(366);
        }
        for (T t : array) {
            if (!condition.value(t)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static <T> boolean exists(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(367);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(368);
        }
        return ContainerUtil.or(iterable, condition);
    }

    @Contract(pure=true)
    public static <T> boolean or(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(371);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(372);
        }
        for (T t : iterable) {
            if (!condition.value(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> void quickSort(@NotNull List<? extends T> list2, @NotNull Comparator<? super T> comparator) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(377);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(378);
        }
        ContainerUtil.quickSort(list2, comparator, 0, list2.size());
    }

    private static <T> void quickSort(@NotNull List<? extends T> x, @NotNull Comparator<? super T> comparator, int off, int len) {
        int c;
        int a;
        if (x == null) {
            ContainerUtil.$$$reportNull$$$0(379);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(380);
        }
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && comparator.compare(x.get(j), x.get(j - 1)) < 0; --j) {
                    ContainerUtil.swapElements(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = ContainerUtil.med3(x, comparator, l, l + s, l + 2 * s);
                m = ContainerUtil.med3(x, comparator, m - s, m, m + s);
                n = ContainerUtil.med3(x, comparator, n - 2 * s, n - s, n);
            }
            m = ContainerUtil.med3(x, comparator, l, m, n);
        }
        T v = x.get(m);
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && comparator.compare(x.get(b), v) <= 0) {
                if (comparator.compare(x.get(b), v) == 0) {
                    ContainerUtil.swapElements(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && comparator.compare(v, x.get(c)) <= 0) {
                if (comparator.compare(x.get(c), v) == 0) {
                    ContainerUtil.swapElements(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            ContainerUtil.swapElements(x, b++, c--);
        }
        int s = Math.min(a - off, b - a);
        ContainerUtil.vecswap(x, off, b - s, s);
        int n = off + len;
        s = Math.min(d - c, n - d - 1);
        ContainerUtil.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            ContainerUtil.quickSort(x, comparator, off, s);
        }
        if ((s = d - c) > 1) {
            ContainerUtil.quickSort(x, comparator, n - s, s);
        }
    }

    private static <T> int med3(@NotNull List<? extends T> x, @NotNull Comparator<? super T> comparator, int a, int b, int c) {
        if (x == null) {
            ContainerUtil.$$$reportNull$$$0(381);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(382);
        }
        return comparator.compare(x.get(a), x.get(b)) < 0 ? (comparator.compare(x.get(b), x.get(c)) < 0 ? b : (comparator.compare(x.get(a), x.get(c)) < 0 ? c : a)) : (comparator.compare(x.get(c), x.get(b)) < 0 ? b : (comparator.compare(x.get(c), x.get(a)) < 0 ? c : a));
    }

    private static <T> void vecswap(List<T> x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            ContainerUtil.swapElements(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <E> List<E> flatten(@NotNull Iterable<? extends Collection<? extends E>> collections) {
        if (collections == null) {
            ContainerUtil.$$$reportNull$$$0(389);
        }
        int totalSize = 0;
        for (Collection<E> list2 : collections) {
            totalSize += list2.size();
        }
        ArrayList result2 = new ArrayList(totalSize);
        for (Collection<E> collection : collections) {
            result2.addAll(collection);
        }
        List list2 = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(390);
        }
        return list2;
    }

    @Contract(pure=true)
    public static <T> int indexOfIdentity(@NotNull List<? extends T> list2, T element) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(401);
        }
        int listSize = list2.size();
        for (int i = 0; i < listSize; ++i) {
            if (list2.get(i) != element) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T> int indexOf(@NotNull List<? extends T> list2, @NotNull Condition<? super T> condition) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(404);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(405);
        }
        int listSize = list2.size();
        for (int i = 0; i < listSize; ++i) {
            T t = list2.get(i);
            if (!condition.value(t)) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> emptyList() {
        List list2 = ContainerUtilRt.emptyList();
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(414);
        }
        return list2;
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <T> List<T> createLockFreeCopyOnWriteList() {
        return ContainerUtil.createConcurrentList();
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <V> ConcurrentIntObjectMap<V> createConcurrentIntObjectMap() {
        return new ConcurrentIntObjectHashMap();
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <V> ConcurrentLongObjectMap<V> createConcurrentLongObjectMap() {
        return new ConcurrentLongObjectHashMap();
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakValueMap() {
        return new ConcurrentWeakValueHashMap();
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <V> ConcurrentIntObjectMap<V> createConcurrentIntObjectWeakValueMap() {
        return new ConcurrentIntKeyWeakValueHashMap();
    }

    @NotNull
    @Contract(value="_,_,_,_ -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeySoftValueMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(416);
        }
        return new ConcurrentWeakKeySoftValueHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftKeySoftValueMap() {
        return ContainerUtil.createConcurrentSoftKeySoftValueMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), ContainerUtil.canonicalStrategy());
    }

    @NotNull
    @Contract(value="_,_,_,_ -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftKeySoftValueMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(417);
        }
        return new ConcurrentSoftKeySoftValueHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeySoftValueMap() {
        return ContainerUtil.createConcurrentWeakKeySoftValueMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), ContainerUtil.canonicalStrategy());
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeyWeakValueMap() {
        return ContainerUtil.createConcurrentWeakKeyWeakValueMap(ContainerUtil.canonicalStrategy());
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeyWeakValueMap(@NotNull TObjectHashingStrategy<? super K> strategy) {
        if (strategy == null) {
            ContainerUtil.$$$reportNull$$$0(418);
        }
        return new ConcurrentWeakKeyWeakValueHashMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), strategy);
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftValueMap() {
        return new ConcurrentSoftValueHashMap();
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftMap() {
        return new ConcurrentSoftHashMap();
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakMap() {
        return new ConcurrentWeakHashMap(0.75f);
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakMap(@NotNull TObjectHashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(421);
        }
        return new ConcurrentWeakHashMap(hashingStrategy);
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <T> ConcurrentList<T> createConcurrentList() {
        return new LockFreeCopyOnWriteArrayList();
    }

    public static <T> void addIfNotNull(@NotNull Collection<? super T> result2, @Nullable T element) {
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(424);
        }
        if (element != null) {
            result2.add(element);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> Set<V> map2Set(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(437);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(438);
        }
        if (collection.isEmpty()) {
            Set set = Collections.emptySet();
            if (set == null) {
                ContainerUtil.$$$reportNull$$$0(439);
            }
            return set;
        }
        HashSet<V> set = new HashSet<V>(collection.size());
        for (T t : collection) {
            set.add(mapper.fun(t));
        }
        HashSet<V> hashSet = set;
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(440);
        }
        return hashSet;
    }

    public static <T> T @NotNull [] copyAndClear(@NotNull Collection<? extends T> collection, @NotNull ArrayFactory<? extends T> factory2, boolean clear) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(455);
        }
        if (factory2 == null) {
            ContainerUtil.$$$reportNull$$$0(456);
        }
        int size = collection.size();
        T[] a = factory2.create(size);
        if (size > 0) {
            a = collection.toArray(a);
            if (clear) {
                collection.clear();
            }
        }
        if (a == null) {
            ContainerUtil.$$$reportNull$$$0(457);
        }
        return a;
    }

    @Contract(value="null -> true", pure=true)
    public static <T> boolean isEmpty(@Nullable Collection<? extends T> collection) {
        return collection == null || collection.isEmpty();
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> notNullize(@Nullable List<T> list2) {
        List<T> list3 = list2 == null ? ContainerUtil.emptyList() : list2;
        if (list3 == null) {
            ContainerUtil.$$$reportNull$$$0(464);
        }
        return list3;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> notNullize(@Nullable Set<T> set) {
        Set set2 = set == null ? Collections.emptySet() : set;
        if (set2 == null) {
            ContainerUtil.$$$reportNull$$$0(465);
        }
        return set2;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSoftMap() {
        return new SoftHashMap(4);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createWeakMap() {
        return ContainerUtil.createWeakMap(4);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createWeakMap(int initialCapacity) {
        return ContainerUtil.createWeakMap(initialCapacity, 0.8f, ContainerUtil.canonicalStrategy());
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createWeakMap(int initialCapacity, float loadFactor, @NotNull TObjectHashingStrategy<? super K> strategy) {
        if (strategy == null) {
            ContainerUtil.$$$reportNull$$$0(477);
        }
        return new WeakHashMap(initialCapacity, loadFactor, strategy);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T> List<T> freeze(@NotNull List<? extends T> list2) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(478);
        }
        if (list2.isEmpty()) {
            List list3 = Collections.emptyList();
            if (list3 == null) {
                ContainerUtil.$$$reportNull$$$0(479);
            }
            return list3;
        }
        if (list2.size() == 1) {
            return ContainerUtil.immutableSingletonList(list2.get(0));
        }
        return ContainerUtil.immutableList(list2.toArray());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 23: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 41: 
            case 44: 
            case 45: 
            case 47: 
            case 58: 
            case 62: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 77: 
            case 83: 
            case 86: 
            case 94: 
            case 96: 
            case 108: 
            case 111: 
            case 114: 
            case 120: 
            case 121: 
            case 122: 
            case 147: 
            case 152: 
            case 154: 
            case 162: 
            case 166: 
            case 170: 
            case 175: 
            case 178: 
            case 185: 
            case 188: 
            case 192: 
            case 195: 
            case 198: 
            case 201: 
            case 202: 
            case 205: 
            case 210: 
            case 212: 
            case 218: 
            case 219: 
            case 221: 
            case 224: 
            case 232: 
            case 235: 
            case 249: 
            case 256: 
            case 257: 
            case 258: 
            case 262: 
            case 263: 
            case 264: 
            case 267: 
            case 272: 
            case 277: 
            case 280: 
            case 282: 
            case 290: 
            case 293: 
            case 297: 
            case 301: 
            case 310: 
            case 316: 
            case 319: 
            case 322: 
            case 326: 
            case 327: 
            case 330: 
            case 333: 
            case 335: 
            case 338: 
            case 342: 
            case 343: 
            case 351: 
            case 352: 
            case 355: 
            case 360: 
            case 376: 
            case 384: 
            case 388: 
            case 390: 
            case 392: 
            case 395: 
            case 399: 
            case 413: 
            case 414: 
            case 427: 
            case 430: 
            case 432: 
            case 435: 
            case 436: 
            case 439: 
            case 440: 
            case 443: 
            case 444: 
            case 447: 
            case 448: 
            case 451: 
            case 454: 
            case 457: 
            case 459: 
            case 462: 
            case 463: 
            case 464: 
            case 465: 
            case 466: 
            case 475: 
            case 479: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 23: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 41: 
            case 44: 
            case 45: 
            case 47: 
            case 58: 
            case 62: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 77: 
            case 83: 
            case 86: 
            case 94: 
            case 96: 
            case 108: 
            case 111: 
            case 114: 
            case 120: 
            case 121: 
            case 122: 
            case 147: 
            case 152: 
            case 154: 
            case 162: 
            case 166: 
            case 170: 
            case 175: 
            case 178: 
            case 185: 
            case 188: 
            case 192: 
            case 195: 
            case 198: 
            case 201: 
            case 202: 
            case 205: 
            case 210: 
            case 212: 
            case 218: 
            case 219: 
            case 221: 
            case 224: 
            case 232: 
            case 235: 
            case 249: 
            case 256: 
            case 257: 
            case 258: 
            case 262: 
            case 263: 
            case 264: 
            case 267: 
            case 272: 
            case 277: 
            case 280: 
            case 282: 
            case 290: 
            case 293: 
            case 297: 
            case 301: 
            case 310: 
            case 316: 
            case 319: 
            case 322: 
            case 326: 
            case 327: 
            case 330: 
            case 333: 
            case 335: 
            case 338: 
            case 342: 
            case 343: 
            case 351: 
            case 352: 
            case 355: 
            case 360: 
            case 376: 
            case 384: 
            case 388: 
            case 390: 
            case 392: 
            case 395: 
            case 399: 
            case 413: 
            case 414: 
            case 427: 
            case 430: 
            case 432: 
            case 435: 
            case 436: 
            case 439: 
            case 440: 
            case 443: 
            case 444: 
            case 447: 
            case 448: 
            case 451: 
            case 454: 
            case 457: 
            case 459: 
            case 462: 
            case 463: 
            case 464: 
            case 465: 
            case 466: 
            case 475: 
            case 479: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 23: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 41: 
            case 44: 
            case 45: 
            case 47: 
            case 58: 
            case 62: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 77: 
            case 83: 
            case 86: 
            case 94: 
            case 96: 
            case 108: 
            case 111: 
            case 114: 
            case 120: 
            case 121: 
            case 122: 
            case 147: 
            case 152: 
            case 154: 
            case 162: 
            case 166: 
            case 170: 
            case 175: 
            case 178: 
            case 185: 
            case 188: 
            case 192: 
            case 195: 
            case 198: 
            case 201: 
            case 202: 
            case 205: 
            case 210: 
            case 212: 
            case 218: 
            case 219: 
            case 221: 
            case 224: 
            case 232: 
            case 235: 
            case 249: 
            case 256: 
            case 257: 
            case 258: 
            case 262: 
            case 263: 
            case 264: 
            case 267: 
            case 272: 
            case 277: 
            case 280: 
            case 282: 
            case 290: 
            case 293: 
            case 297: 
            case 301: 
            case 310: 
            case 316: 
            case 319: 
            case 322: 
            case 326: 
            case 327: 
            case 330: 
            case 333: 
            case 335: 
            case 338: 
            case 342: 
            case 343: 
            case 351: 
            case 352: 
            case 355: 
            case 360: 
            case 376: 
            case 384: 
            case 388: 
            case 390: 
            case 392: 
            case 395: 
            case 399: 
            case 413: 
            case 414: 
            case 427: 
            case 430: 
            case 432: 
            case 435: 
            case 436: 
            case 439: 
            case 440: 
            case 443: 
            case 444: 
            case 447: 
            case 448: 
            case 451: 
            case 454: 
            case 457: 
            case 459: 
            case 462: 
            case 463: 
            case 464: 
            case 465: 
            case 466: 
            case 475: 
            case 479: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/ContainerUtil";
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 60: 
            case 115: 
            case 183: 
            case 358: 
            case 412: 
            case 431: 
            case 474: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 6: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 7: 
            case 112: 
            case 116: 
            case 251: 
            case 253: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 14: 
            case 50: 
            case 52: 
            case 54: 
            case 383: 
            case 418: 
            case 476: 
            case 477: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyType";
                break;
            }
            case 20: 
            case 72: 
            case 124: 
            case 156: 
            case 157: 
            case 161: 
            case 191: 
            case 211: 
            case 245: 
            case 247: 
            case 321: 
            case 324: 
            case 337: 
            case 366: 
            case 426: 
            case 434: 
            case 450: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 21: 
            case 22: 
            case 40: 
            case 125: 
            case 130: 
            case 133: 
            case 135: 
            case 240: 
            case 314: 
            case 328: 
            case 362: 
            case 363: 
            case 367: 
            case 370: 
            case 371: 
            case 373: 
            case 393: 
            case 460: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalList";
                break;
            }
            case 28: 
            case 30: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 42: 
            case 57: 
            case 75: 
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 144: 
            case 145: 
            case 149: 
            case 150: 
            case 153: 
            case 163: 
            case 167: 
            case 172: 
            case 174: 
            case 177: 
            case 179: 
            case 181: 
            case 186: 
            case 189: 
            case 194: 
            case 196: 
            case 200: 
            case 203: 
            case 206: 
            case 208: 
            case 216: 
            case 228: 
            case 230: 
            case 233: 
            case 236: 
            case 238: 
            case 317: 
            case 331: 
            case 422: 
            case 428: 
            case 437: 
            case 441: 
            case 445: 
            case 449: 
            case 455: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 43: 
            case 79: 
            case 102: 
            case 107: 
            case 118: 
            case 131: 
            case 137: 
            case 139: 
            case 226: 
            case 242: 
            case 284: 
            case 286: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 61: 
            case 82: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map2";
                break;
            }
            case 63: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 64: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set2";
                break;
            }
            case 74: 
            case 95: 
            case 127: 
            case 141: 
            case 220: 
            case 225: 
            case 248: 
            case 250: 
            case 252: 
            case 270: 
            case 302: 
            case 303: 
            case 306: 
            case 308: 
            case 311: 
            case 377: 
            case 386: 
            case 400: 
            case 401: 
            case 404: 
            case 406: 
            case 408: 
            case 410: 
            case 458: 
            case 467: 
            case 478: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grouper";
                break;
            }
            case 80: 
            case 143: 
            case 146: 
            case 148: 
            case 151: 
            case 155: 
            case 158: 
            case 160: 
            case 165: 
            case 168: 
            case 285: 
            case 425: 
            case 429: 
            case 433: 
            case 438: 
            case 442: 
            case 446: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 81: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map1";
                break;
            }
            case 87: 
            case 91: 
            case 254: 
            case 402: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list1";
                break;
            }
            case 88: 
            case 92: 
            case 255: 
            case 403: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list2";
                break;
            }
            case 89: 
            case 93: 
            case 304: 
            case 307: 
            case 309: 
            case 312: 
            case 378: 
            case 380: 
            case 382: 
            case 387: 
            case 473: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 90: 
            case 126: 
            case 128: 
            case 129: 
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appendix";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueConvertor";
                break;
            }
            case 113: 
            case 117: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyConvertor";
                break;
            }
            case 123: 
            case 134: 
            case 140: 
            case 142: 
            case 171: 
            case 173: 
            case 176: 
            case 182: 
            case 187: 
            case 207: 
            case 214: 
            case 217: 
            case 239: 
            case 361: 
            case 364: 
            case 365: 
            case 368: 
            case 369: 
            case 372: 
            case 374: 
            case 405: 
            case 407: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 136: 
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equalTo";
                break;
            }
            case 159: 
            case 164: 
            case 180: 
            case 241: 
            case 243: 
            case 244: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 169: 
            case 398: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 184: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyFilter";
                break;
            }
            case 190: 
            case 193: 
            case 197: 
            case 199: 
            case 204: 
            case 227: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceOf";
                break;
            }
            case 209: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyValues";
                break;
            }
            case 213: 
            case 229: 
            case 461: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumeration";
                break;
            }
            case 215: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrays";
                break;
            }
            case 222: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable1";
                break;
            }
            case 223: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable2";
                break;
            }
            case 246: 
            case 396: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 259: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it1";
                break;
            }
            case 260: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it2";
                break;
            }
            case 261: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterables";
                break;
            }
            case 265: 
            case 266: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterators";
                break;
            }
            case 268: 
            case 269: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lists";
                break;
            }
            case 271: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listGenerator";
                break;
            }
            case 273: 
            case 275: 
            case 278: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection1";
                break;
            }
            case 274: 
            case 276: 
            case 279: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection2";
                break;
            }
            case 281: 
            case 283: 
            case 344: 
            case 375: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 287: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 288: 
            case 397: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 289: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 291: 
            case 415: 
            case 452: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 292: 
            case 296: 
            case 300: 
            case 357: 
            case 456: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 294: 
            case 298: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c1";
                break;
            }
            case 295: 
            case 299: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c2";
                break;
            }
            case 305: 
            case 313: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 315: 
            case 318: 
            case 320: 
            case 323: 
            case 329: 
            case 332: 
            case 336: 
            case 339: 
            case 394: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 325: 
            case 341: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyArray";
                break;
            }
            case 340: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arr";
                break;
            }
            case 345: 
            case 346: 
            case 347: 
            case 348: 
            case 349: 
            case 353: 
            case 356: 
            case 423: 
            case 424: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 350: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 354: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 359: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defValue";
                break;
            }
            case 379: 
            case 381: {
                objectArray2 = objectArray3;
                objectArray3[0] = "x";
                break;
            }
            case 385: 
            case 389: 
            case 391: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collections";
                break;
            }
            case 409: 
            case 411: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 416: 
            case 417: 
            case 419: 
            case 420: 
            case 421: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
            case 453: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sample";
                break;
            }
            case 468: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 469: 
            case 471: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o1";
                break;
            }
            case 470: 
            case 472: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/ContainerUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "ar";
                break;
            }
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "newHashMap";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedHashMap";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "canonicalStrategy";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "identityStrategy";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedList";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "newArrayList";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "newUnmodifiableList";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "unmodifiableOrEmptyCollection";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "unmodifiableOrEmptyList";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "unmodifiableOrEmptySet";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "unmodifiableOrEmptyMap";
                break;
            }
            case 41: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "newHashSet";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "newHashOrEmptySet";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedHashSet";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "newConcurrentSet";
                break;
            }
            case 62: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "union";
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "immutableSet";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "immutableSingletonList";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "groupBy";
                break;
            }
            case 83: 
            case 277: 
            case 280: {
                objectArray = objectArray2;
                objectArray2[1] = "intersection";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "diff";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeSortedLists";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "subList";
                break;
            }
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "collect";
                break;
            }
            case 111: {
                objectArray = objectArray2;
                objectArray2[1] = "newMapFromKeys";
                break;
            }
            case 114: {
                objectArray = objectArray2;
                objectArray2[1] = "newMapFromValues";
                break;
            }
            case 120: {
                objectArray = objectArray2;
                objectArray2[1] = "classify";
                break;
            }
            case 121: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyIterator";
                break;
            }
            case 122: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyIterable";
                break;
            }
            case 147: 
            case 154: {
                objectArray = objectArray2;
                objectArray2[1] = "map2Map";
                break;
            }
            case 152: {
                objectArray = objectArray2;
                objectArray2[1] = "map2MapNotNull";
                break;
            }
            case 162: 
            case 166: 
            case 170: {
                objectArray = objectArray2;
                objectArray2[1] = "map2Array";
                break;
            }
            case 175: 
            case 185: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
            case 178: 
            case 188: 
            case 192: 
            case 205: {
                objectArray = objectArray2;
                objectArray2[1] = "findAll";
                break;
            }
            case 195: 
            case 198: 
            case 201: 
            case 202: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllAsArray";
                break;
            }
            case 210: {
                objectArray = objectArray2;
                objectArray2[1] = "stringMap";
                break;
            }
            case 212: 
            case 218: 
            case 219: {
                objectArray = objectArray2;
                objectArray2[1] = "iterate";
                break;
            }
            case 221: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateBackward";
                break;
            }
            case 224: {
                objectArray = objectArray2;
                objectArray2[1] = "zip";
                break;
            }
            case 232: {
                objectArray = objectArray2;
                objectArray2[1] = "addAll";
                break;
            }
            case 235: {
                objectArray = objectArray2;
                objectArray2[1] = "addAllNotNull";
                break;
            }
            case 249: 
            case 256: 
            case 257: 
            case 258: 
            case 262: 
            case 263: 
            case 264: 
            case 267: 
            case 272: {
                objectArray = objectArray2;
                objectArray2[1] = "concat";
                break;
            }
            case 282: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstItems";
                break;
            }
            case 290: {
                objectArray = objectArray2;
                objectArray2[1] = "subtract";
                break;
            }
            case 293: 
            case 297: 
            case 451: 
            case 454: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
            case 301: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeCollectionsToArray";
                break;
            }
            case 310: {
                objectArray = objectArray2;
                objectArray2[1] = "sorted";
                break;
            }
            case 316: 
            case 319: 
            case 338: 
            case 342: 
            case 343: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
            case 322: 
            case 326: 
            case 327: 
            case 330: 
            case 333: {
                objectArray = objectArray2;
                objectArray2[1] = "mapNotNull";
                break;
            }
            case 335: {
                objectArray = objectArray2;
                objectArray2[1] = "packNullables";
                break;
            }
            case 351: {
                objectArray = objectArray2;
                objectArray2[1] = "createMaybeSingletonList";
                break;
            }
            case 352: {
                objectArray = objectArray2;
                objectArray2[1] = "createMaybeSingletonSet";
                break;
            }
            case 355: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
            case 360: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrElse";
                break;
            }
            case 376: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 384: {
                objectArray = objectArray2;
                objectArray2[1] = "singleton";
                break;
            }
            case 388: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDuplicatesFromSorted";
                break;
            }
            case 390: {
                objectArray = objectArray2;
                objectArray2[1] = "flatten";
                break;
            }
            case 392: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenIterables";
                break;
            }
            case 395: {
                objectArray = objectArray2;
                objectArray2[1] = "flatMap";
                break;
            }
            case 399: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
            case 413: {
                objectArray = objectArray2;
                objectArray2[1] = "reverseMap";
                break;
            }
            case 414: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyList";
                break;
            }
            case 427: 
            case 430: 
            case 432: {
                objectArray = objectArray2;
                objectArray2[1] = "map2List";
                break;
            }
            case 435: 
            case 436: 
            case 439: 
            case 440: {
                objectArray = objectArray2;
                objectArray2[1] = "map2Set";
                break;
            }
            case 443: 
            case 444: {
                objectArray = objectArray2;
                objectArray2[1] = "map2LinkedSet";
                break;
            }
            case 447: 
            case 448: {
                objectArray = objectArray2;
                objectArray2[1] = "map2SetNotNull";
                break;
            }
            case 457: {
                objectArray = objectArray2;
                objectArray2[1] = "copyAndClear";
                break;
            }
            case 459: {
                objectArray = objectArray2;
                objectArray2[1] = "copyList";
                break;
            }
            case 462: 
            case 463: {
                objectArray = objectArray2;
                objectArray2[1] = "toList";
                break;
            }
            case 464: 
            case 465: 
            case 466: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
            case 475: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 479: {
                objectArray = objectArray2;
                objectArray2[1] = "freeze";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "ar";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 23: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 41: 
            case 44: 
            case 45: 
            case 47: 
            case 58: 
            case 62: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 77: 
            case 83: 
            case 86: 
            case 94: 
            case 96: 
            case 108: 
            case 111: 
            case 114: 
            case 120: 
            case 121: 
            case 122: 
            case 147: 
            case 152: 
            case 154: 
            case 162: 
            case 166: 
            case 170: 
            case 175: 
            case 178: 
            case 185: 
            case 188: 
            case 192: 
            case 195: 
            case 198: 
            case 201: 
            case 202: 
            case 205: 
            case 210: 
            case 212: 
            case 218: 
            case 219: 
            case 221: 
            case 224: 
            case 232: 
            case 235: 
            case 249: 
            case 256: 
            case 257: 
            case 258: 
            case 262: 
            case 263: 
            case 264: 
            case 267: 
            case 272: 
            case 277: 
            case 280: 
            case 282: 
            case 290: 
            case 293: 
            case 297: 
            case 301: 
            case 310: 
            case 316: 
            case 319: 
            case 322: 
            case 326: 
            case 327: 
            case 330: 
            case 333: 
            case 335: 
            case 338: 
            case 342: 
            case 343: 
            case 351: 
            case 352: 
            case 355: 
            case 360: 
            case 376: 
            case 384: 
            case 388: 
            case 390: 
            case 392: 
            case 395: 
            case 399: 
            case 413: 
            case 414: 
            case 427: 
            case 430: 
            case 432: 
            case 435: 
            case 436: 
            case 439: 
            case 440: 
            case 443: 
            case 444: 
            case 447: 
            case 448: 
            case 451: 
            case 454: 
            case 457: 
            case 459: 
            case 462: 
            case 463: 
            case 464: 
            case 465: 
            case 466: 
            case 475: 
            case 479: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "newHashMap";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "newTreeMap";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedHashMap";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "newTroveMap";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "newEnumMap";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedList";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "newArrayList";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "newUnmodifiableList";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "unmodifiableOrEmptyCollection";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "unmodifiableOrEmptyList";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "unmodifiableOrEmptySet";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "unmodifiableOrEmptyMap";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "newSmartList";
                break;
            }
            case 39: 
            case 40: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "newHashSet";
                break;
            }
            case 46: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedHashSet";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "newTroveSet";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "newIdentityTroveSet";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "reverse";
                break;
            }
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "immutableSet";
                break;
            }
            case 72: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "immutableList";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "groupBy";
                break;
            }
            case 78: 
            case 358: 
            case 359: {
                objectArray = objectArray;
                objectArray[2] = "getOrElse";
                break;
            }
            case 79: 
            case 80: 
            case 284: 
            case 285: {
                objectArray = objectArray;
                objectArray[2] = "mapIterator";
                break;
            }
            case 81: 
            case 82: 
            case 275: 
            case 276: 
            case 278: 
            case 279: {
                objectArray = objectArray;
                objectArray[2] = "intersection";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "diff";
                break;
            }
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "processSortedListsInOrder";
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "mergeSortedLists";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "subList";
                break;
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 228: 
            case 229: 
            case 230: 
            case 231: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 233: 
            case 234: {
                objectArray = objectArray;
                objectArray[2] = "addAllNotNull";
                break;
            }
            case 107: 
            case 226: 
            case 227: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "newMapFromKeys";
                break;
            }
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "newMapFromValues";
                break;
            }
            case 115: 
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "fillMapWithValues";
                break;
            }
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "classify";
                break;
            }
            case 123: 
            case 124: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 141: 
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "findLast";
                break;
            }
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "map2Map";
                break;
            }
            case 148: 
            case 149: 
            case 150: 
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "map2MapNotNull";
                break;
            }
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 163: 
            case 164: 
            case 165: 
            case 167: 
            case 168: 
            case 169: {
                objectArray = objectArray;
                objectArray[2] = "map2Array";
                break;
            }
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 181: 
            case 182: 
            case 183: 
            case 184: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 176: 
            case 177: 
            case 186: 
            case 187: 
            case 190: 
            case 191: 
            case 203: 
            case 204: {
                objectArray = objectArray;
                objectArray[2] = "findAll";
                break;
            }
            case 179: 
            case 180: {
                objectArray = objectArray;
                objectArray[2] = "filterIsInstance";
                break;
            }
            case 189: {
                objectArray = objectArray;
                objectArray[2] = "skipNulls";
                break;
            }
            case 193: 
            case 194: 
            case 196: 
            case 197: 
            case 199: 
            case 200: {
                objectArray = objectArray;
                objectArray[2] = "findAllAsArray";
                break;
            }
            case 206: 
            case 207: {
                objectArray = objectArray;
                objectArray[2] = "all";
                break;
            }
            case 208: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicates";
                break;
            }
            case 209: {
                objectArray = objectArray;
                objectArray[2] = "stringMap";
                break;
            }
            case 211: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: {
                objectArray = objectArray;
                objectArray[2] = "iterate";
                break;
            }
            case 220: {
                objectArray = objectArray;
                objectArray[2] = "iterateBackward";
                break;
            }
            case 222: 
            case 223: {
                objectArray = objectArray;
                objectArray[2] = "zip";
                break;
            }
            case 225: {
                objectArray = objectArray;
                objectArray[2] = "swapElements";
                break;
            }
            case 236: 
            case 237: {
                objectArray = objectArray;
                objectArray[2] = "removeAll";
                break;
            }
            case 238: 
            case 239: {
                objectArray = objectArray;
                objectArray[2] = "retainAll";
                break;
            }
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: {
                objectArray = objectArray;
                objectArray[2] = "findInstance";
                break;
            }
            case 246: 
            case 247: 
            case 248: 
            case 254: 
            case 255: 
            case 259: 
            case 260: 
            case 261: 
            case 268: 
            case 269: 
            case 270: 
            case 271: {
                objectArray = objectArray;
                objectArray[2] = "concat";
                break;
            }
            case 250: 
            case 251: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 252: 
            case 253: {
                objectArray = objectArray;
                objectArray[2] = "prepend";
                break;
            }
            case 265: 
            case 266: {
                objectArray = objectArray;
                objectArray[2] = "concatIterators";
                break;
            }
            case 273: 
            case 274: {
                objectArray = objectArray;
                objectArray[2] = "intersects";
                break;
            }
            case 281: {
                objectArray = objectArray;
                objectArray[2] = "getFirstItems";
                break;
            }
            case 283: {
                objectArray = objectArray;
                objectArray[2] = "iterateAndGetLastItem";
                break;
            }
            case 286: 
            case 287: {
                objectArray = objectArray;
                objectArray[2] = "filterIterator";
                break;
            }
            case 288: 
            case 289: {
                objectArray = objectArray;
                objectArray[2] = "subtract";
                break;
            }
            case 291: 
            case 292: 
            case 294: 
            case 295: 
            case 296: 
            case 449: 
            case 450: 
            case 452: 
            case 453: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
            case 298: 
            case 299: 
            case 300: {
                objectArray = objectArray;
                objectArray[2] = "mergeCollectionsToArray";
                break;
            }
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 312: 
            case 313: {
                objectArray = objectArray;
                objectArray[2] = "sort";
                break;
            }
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 311: {
                objectArray = objectArray;
                objectArray[2] = "sorted";
                break;
            }
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 336: 
            case 337: 
            case 339: 
            case 340: 
            case 341: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 320: 
            case 321: 
            case 323: 
            case 324: 
            case 325: 
            case 328: 
            case 329: 
            case 331: 
            case 332: {
                objectArray = objectArray;
                objectArray[2] = "mapNotNull";
                break;
            }
            case 334: {
                objectArray = objectArray;
                objectArray[2] = "packNullables";
                break;
            }
            case 344: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 345: {
                objectArray = objectArray;
                objectArray[2] = "putIfAbsent";
                break;
            }
            case 346: 
            case 347: 
            case 348: {
                objectArray = objectArray;
                objectArray[2] = "putIfNotNull";
                break;
            }
            case 349: 
            case 350: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 353: 
            case 354: 
            case 356: 
            case 357: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 361: 
            case 362: 
            case 363: 
            case 364: {
                objectArray = objectArray;
                objectArray[2] = "and";
                break;
            }
            case 365: 
            case 366: 
            case 367: 
            case 368: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 369: 
            case 370: 
            case 371: 
            case 372: {
                objectArray = objectArray;
                objectArray[2] = "or";
                break;
            }
            case 373: 
            case 374: {
                objectArray = objectArray;
                objectArray[2] = "count";
                break;
            }
            case 375: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 377: 
            case 378: 
            case 379: 
            case 380: {
                objectArray = objectArray;
                objectArray[2] = "quickSort";
                break;
            }
            case 381: 
            case 382: {
                objectArray = objectArray;
                objectArray[2] = "med3";
                break;
            }
            case 383: {
                objectArray = objectArray;
                objectArray[2] = "singleton";
                break;
            }
            case 385: 
            case 389: {
                objectArray = objectArray;
                objectArray[2] = "flatten";
                break;
            }
            case 386: 
            case 387: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicatesFromSorted";
                break;
            }
            case 391: {
                objectArray = objectArray;
                objectArray[2] = "flattenIterables";
                break;
            }
            case 393: 
            case 394: {
                objectArray = objectArray;
                objectArray[2] = "flatMap";
                break;
            }
            case 396: 
            case 397: 
            case 398: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 400: {
                objectArray = objectArray;
                objectArray[2] = "containsIdentity";
                break;
            }
            case 401: {
                objectArray = objectArray;
                objectArray[2] = "indexOfIdentity";
                break;
            }
            case 402: 
            case 403: {
                objectArray = objectArray;
                objectArray[2] = "equalsIdentity";
                break;
            }
            case 404: 
            case 405: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 406: 
            case 407: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 408: 
            case 409: {
                objectArray = objectArray;
                objectArray[2] = "findLastInstance";
                break;
            }
            case 410: 
            case 411: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOfInstance";
                break;
            }
            case 412: {
                objectArray = objectArray;
                objectArray[2] = "reverseMap";
                break;
            }
            case 415: {
                objectArray = objectArray;
                objectArray[2] = "createLockFreeCopyOnWriteList";
                break;
            }
            case 416: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentWeakKeySoftValueMap";
                break;
            }
            case 417: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentSoftKeySoftValueMap";
                break;
            }
            case 418: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentWeakKeyWeakValueMap";
                break;
            }
            case 419: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentSoftMap";
                break;
            }
            case 420: 
            case 421: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentWeakMap";
                break;
            }
            case 422: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentList";
                break;
            }
            case 423: 
            case 424: {
                objectArray = objectArray;
                objectArray[2] = "addIfNotNull";
                break;
            }
            case 425: 
            case 426: 
            case 428: 
            case 429: 
            case 431: {
                objectArray = objectArray;
                objectArray[2] = "map2List";
                break;
            }
            case 433: 
            case 434: 
            case 437: 
            case 438: {
                objectArray = objectArray;
                objectArray[2] = "map2Set";
                break;
            }
            case 441: 
            case 442: {
                objectArray = objectArray;
                objectArray[2] = "map2LinkedSet";
                break;
            }
            case 445: 
            case 446: {
                objectArray = objectArray;
                objectArray[2] = "map2SetNotNull";
                break;
            }
            case 455: 
            case 456: {
                objectArray = objectArray;
                objectArray[2] = "copyAndClear";
                break;
            }
            case 458: {
                objectArray = objectArray;
                objectArray[2] = "copyList";
                break;
            }
            case 460: {
                objectArray = objectArray;
                objectArray[2] = "toCollection";
                break;
            }
            case 461: {
                objectArray = objectArray;
                objectArray[2] = "toList";
                break;
            }
            case 467: 
            case 468: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 469: 
            case 470: 
            case 471: 
            case 472: 
            case 473: {
                objectArray = objectArray;
                objectArray[2] = "compareLexicographically";
                break;
            }
            case 474: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 476: {
                objectArray = objectArray;
                objectArray[2] = "createSoftMap";
                break;
            }
            case 477: {
                objectArray = objectArray;
                objectArray[2] = "createWeakMap";
                break;
            }
            case 478: {
                objectArray = objectArray;
                objectArray[2] = "freeze";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 23: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 41: 
            case 44: 
            case 45: 
            case 47: 
            case 58: 
            case 62: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 77: 
            case 83: 
            case 86: 
            case 94: 
            case 96: 
            case 108: 
            case 111: 
            case 114: 
            case 120: 
            case 121: 
            case 122: 
            case 147: 
            case 152: 
            case 154: 
            case 162: 
            case 166: 
            case 170: 
            case 175: 
            case 178: 
            case 185: 
            case 188: 
            case 192: 
            case 195: 
            case 198: 
            case 201: 
            case 202: 
            case 205: 
            case 210: 
            case 212: 
            case 218: 
            case 219: 
            case 221: 
            case 224: 
            case 232: 
            case 235: 
            case 249: 
            case 256: 
            case 257: 
            case 258: 
            case 262: 
            case 263: 
            case 264: 
            case 267: 
            case 272: 
            case 277: 
            case 280: 
            case 282: 
            case 290: 
            case 293: 
            case 297: 
            case 301: 
            case 310: 
            case 316: 
            case 319: 
            case 322: 
            case 326: 
            case 327: 
            case 330: 
            case 333: 
            case 335: 
            case 338: 
            case 342: 
            case 343: 
            case 351: 
            case 352: 
            case 355: 
            case 360: 
            case 376: 
            case 384: 
            case 388: 
            case 390: 
            case 392: 
            case 395: 
            case 399: 
            case 413: 
            case 414: 
            case 427: 
            case 430: 
            case 432: 
            case 435: 
            case 436: 
            case 439: 
            case 440: 
            case 443: 
            case 444: 
            case 447: 
            case 448: 
            case 451: 
            case 454: 
            case 457: 
            case 459: 
            case 462: 
            case 463: 
            case 464: 
            case 465: 
            case 466: 
            case 475: 
            case 479: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ImmutableListBackedByArray<E>
    extends ImmutableList<E> {
        private final E[] myStore;

        private ImmutableListBackedByArray(E @NotNull [] array) {
            if (array == null) {
                ImmutableListBackedByArray.$$$reportNull$$$0(0);
            }
            this.myStore = array;
        }

        @Override
        public E get(int index2) {
            return this.myStore[index2];
        }

        @Override
        public int size() {
            return this.myStore.length;
        }

        @Override
        public <T> T @NotNull [] toArray(T @NotNull [] a) {
            int size;
            if (a == null) {
                ImmutableListBackedByArray.$$$reportNull$$$0(1);
            }
            T[] result2 = a.length >= (size = this.size()) ? a : ArrayUtil.newArray(ArrayUtil.getComponentType(a), size);
            System.arraycopy(this.myStore, 0, result2, 0, size);
            if (result2.length > size) {
                result2[size] = null;
            }
            if (result2 == null) {
                ImmutableListBackedByArray.$$$reportNull$$$0(2);
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "array";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "a";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/ContainerUtil$ImmutableListBackedByArray";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/ContainerUtil$ImmutableListBackedByArray";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toArray";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "toArray";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

