/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeAmbiguityError;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r*\u00020\u000e2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u000e*\u00020\u000eH\u0002J\u0016\u0010\u0011\u001a\u00020\u0006*\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0016\u0010\u0014\u001a\u00020\u0006*\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0016\u0010\u0015\u001a\u00020\u0006*\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirCommonConstructorDelegationIssuesChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirMemberDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "findCycle", "", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "knownCyclicConstructors", "getDelegated", "reportCyclicConstructorDelegationCall", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "reportExplicitDelegationCallRequired", "reportPrimaryConstructorDelegationCallExpected", "checkers"})
public final class FirCommonConstructorDelegationIssuesChecker
extends FirDeclarationChecker<FirMemberDeclaration> {
    @NotNull
    public static final FirCommonConstructorDelegationIssuesChecker INSTANCE;

    @Override
    public void check(@NotNull FirMemberDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (!(declaration2 instanceof FirRegularClass)) {
            return;
        }
        boolean bl = false;
        Set cyclicConstructors = new LinkedHashSet();
        boolean hasPrimaryConstructor = false;
        boolean bl2 = false;
        Set otherConstructors = new LinkedHashSet();
        for (FirDeclaration it2 : ((FirRegularClass)declaration2).getDeclarations()) {
            if (!(it2 instanceof FirConstructor)) continue;
            if (!((FirConstructor)it2).isPrimary()) {
                Set<FirConstructor> set = otherConstructors;
                boolean bl3 = false;
                set.add((FirConstructor)it2);
                Set<FirConstructor> set2 = this.findCycle((FirConstructor)it2, cyclicConstructors);
                if (set2 != null) {
                    set = set2;
                    bl3 = false;
                    boolean bl4 = false;
                    Set<FirConstructor> visited2 = set;
                    boolean bl5 = false;
                    Collection collection = cyclicConstructors;
                    boolean bl6 = false;
                    CollectionsKt.addAll(collection, (Iterable)visited2);
                }
                continue;
            }
            hasPrimaryConstructor = true;
        }
        Object it2 = otherConstructors;
        boolean bl7 = false;
        CollectionsKt.removeAll(it2, cyclicConstructors);
        if (hasPrimaryConstructor) {
            for (Object it2 : otherConstructors) {
                FirDelegatedConstructorCall firDelegatedConstructorCall = ((FirConstructor)it2).getDelegatedConstructor();
                if (firDelegatedConstructorCall != null && firDelegatedConstructorCall.isThis()) continue;
                FirDelegatedConstructorCall firDelegatedConstructorCall2 = ((FirConstructor)it2).getDelegatedConstructor();
                if ((firDelegatedConstructorCall2 != null ? firDelegatedConstructorCall2.getSource() : null) != null) {
                    FirDelegatedConstructorCall firDelegatedConstructorCall3 = ((FirConstructor)it2).getDelegatedConstructor();
                    this.reportPrimaryConstructorDelegationCallExpected(reporter, firDelegatedConstructorCall3 != null ? firDelegatedConstructorCall3.getSource() : null);
                    continue;
                }
                this.reportPrimaryConstructorDelegationCallExpected(reporter, ((FirConstructor)it2).getSource());
            }
        } else {
            for (Object it2 : otherConstructors) {
                Object object;
                FirDelegatedConstructorCall firDelegatedConstructorCall = ((FirConstructor)it2).getDelegatedConstructor();
                FirReference callee = firDelegatedConstructorCall != null ? firDelegatedConstructorCall.getCalleeReference() : null;
                if (!(callee instanceof FirErrorNamedReference) || !(((FirErrorNamedReference)callee).getDiagnostic() instanceof ConeAmbiguityError) || !(((object = ((FirConstructor)it2).getDelegatedConstructor()) != null && (object = ((FirDelegatedConstructorCall)object).getSource()) != null ? ((FirSourceElement)object).getKind() : null) instanceof FirFakeSourceElementKind)) continue;
                this.reportExplicitDelegationCallRequired(reporter, ((FirConstructor)it2).getSource());
            }
        }
        Iterable $this$forEach$iv = cyclicConstructors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirConstructor it3 = (FirConstructor)element$iv;
            boolean bl8 = false;
            FirDelegatedConstructorCall firDelegatedConstructorCall = it3.getDelegatedConstructor();
            INSTANCE.reportCyclicConstructorDelegationCall(reporter, firDelegatedConstructorCall != null ? firDelegatedConstructorCall.getSource() : null);
        }
    }

    private final Set<FirConstructor> findCycle(FirConstructor $this$findCycle, Set<? extends FirConstructor> knownCyclicConstructors) {
        Set<FirConstructor> visitedConstructors = SetsKt.mutableSetOf($this$findCycle);
        FirConstructor it = $this$findCycle;
        FirConstructor delegated = this.getDelegated($this$findCycle);
        while (!it.isPrimary() && delegated != null) {
            if (visitedConstructors.contains(delegated) || knownCyclicConstructors.contains(delegated)) {
                return visitedConstructors;
            }
            it = delegated;
            delegated = this.getDelegated(delegated);
            visitedConstructors.add(it);
        }
        return null;
    }

    private final FirConstructor getDelegated(FirConstructor $this$getDelegated) {
        Object object;
        FirDelegatedConstructorCall firDelegatedConstructorCall = $this$getDelegated.getDelegatedConstructor();
        FirReference $this$safeAs$iv = firDelegatedConstructorCall != null ? firDelegatedConstructorCall.getCalleeReference() : null;
        boolean $i$f$safeAs = false;
        FirReference firReference = $this$safeAs$iv;
        if (!(firReference instanceof FirResolvedNamedReference)) {
            firReference = null;
        }
        $this$safeAs$iv = (object = (FirResolvedNamedReference)firReference) != null && (object = ((FirResolvedNamedReference)object).getResolvedSymbol()) != null ? ((AbstractFirBasedSymbol)object).getFir() : null;
        $i$f$safeAs = false;
        FirReference firReference2 = $this$safeAs$iv;
        if (!(firReference2 instanceof FirConstructor)) {
            firReference2 = null;
        }
        return (FirConstructor)((Object)firReference2);
    }

    private final void reportCyclicConstructorDelegationCall(DiagnosticReporter $this$reportCyclicConstructorDelegationCall, FirSourceElement source) {
        block0: {
            FirSourceElement firSourceElement = source;
            if (firSourceElement == null) break block0;
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$reportCyclicConstructorDelegationCall.report((FirDiagnostic)FirErrors.INSTANCE.getCYCLIC_CONSTRUCTOR_DELEGATION_CALL().on(it));
        }
    }

    private final void reportPrimaryConstructorDelegationCallExpected(DiagnosticReporter $this$reportPrimaryConstructorDelegationCallExpected, FirSourceElement source) {
        block0: {
            FirSourceElement firSourceElement = source;
            if (firSourceElement == null) break block0;
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$reportPrimaryConstructorDelegationCallExpected.report((FirDiagnostic)FirErrors.INSTANCE.getPRIMARY_CONSTRUCTOR_DELEGATION_CALL_EXPECTED().on(it));
        }
    }

    private final void reportExplicitDelegationCallRequired(DiagnosticReporter $this$reportExplicitDelegationCallRequired, FirSourceElement source) {
        block0: {
            FirSourceElement firSourceElement = source;
            if (firSourceElement == null) break block0;
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$reportExplicitDelegationCallRequired.report((FirDiagnostic)FirErrors.INSTANCE.getEXPLICIT_DELEGATION_CALL_REQUIRED().on(it));
        }
    }

    private FirCommonConstructorDelegationIssuesChecker() {
    }

    static {
        FirCommonConstructorDelegationIssuesChecker firCommonConstructorDelegationIssuesChecker;
        INSTANCE = firCommonConstructorDelegationIssuesChecker = new FirCommonConstructorDelegationIssuesChecker();
    }
}

