/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics.rendering;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.RenderingContext;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001:\u0001\u000fB\u0019\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ$\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/diagnostics/rendering/LanguageFeatureMessageRenderer;", "Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticParameterRenderer;", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "type", "Lorg/jetbrains/kotlin/diagnostics/rendering/LanguageFeatureMessageRenderer$Type;", "useHtml", "", "(Lorg/jetbrains/kotlin/diagnostics/rendering/LanguageFeatureMessageRenderer$Type;Z)V", "render", "", "obj", "renderingContext", "Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext;", "Type", "frontend"})
public final class LanguageFeatureMessageRenderer
implements DiagnosticParameterRenderer<Pair<? extends LanguageFeature, ? extends LanguageVersionSettings>> {
    @NotNull
    private final Type type;
    private final boolean useHtml;

    @JvmOverloads
    public LanguageFeatureMessageRenderer(@NotNull Type type2, boolean useHtml) {
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        this.type = type2;
        this.useHtml = useHtml;
    }

    public /* synthetic */ LanguageFeatureMessageRenderer(Type type2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(type2, bl);
    }

    @Override
    @NotNull
    public String render(@NotNull Pair<? extends LanguageFeature, ? extends LanguageVersionSettings> obj, @NotNull RenderingContext renderingContext) {
        Intrinsics.checkNotNullParameter(obj, "obj");
        Intrinsics.checkNotNullParameter(renderingContext, "renderingContext");
        Pair<? extends LanguageFeature, ? extends LanguageVersionSettings> pair = obj;
        LanguageFeature feature = pair.component1();
        LanguageVersionSettings settings = pair.component2();
        LanguageVersion since = feature.getSinceVersion();
        StringBuilder sb = new StringBuilder();
        sb.append("The feature \"").append(feature.getPresentableName()).append("\" is ");
        Type type2 = this.type;
        int n = WhenMappings.$EnumSwitchMapping$0[type2.ordinal()];
        switch (n) {
            case 1: {
                if (since == null) {
                    sb.append("experimental and should be enabled explicitly");
                    break;
                }
                if (since.compareTo((Enum)settings.getLanguageVersion()) > 0) {
                    sb.append("only available since language version ").append(since.getVersionString());
                    break;
                }
                if (feature.getSinceApiVersion().compareTo(settings.getApiVersion()) > 0) {
                    sb.append("only available since API version ").append(feature.getSinceApiVersion().getVersionString());
                    break;
                }
                sb.append("disabled");
                break;
            }
            case 2: {
                sb.append("experimental");
                break;
            }
            case 3: {
                sb.append("experimental and disabled");
            }
        }
        String hintUrl = feature.getHintUrl();
        if (hintUrl != null) {
            if (this.useHtml) {
                sb.append(" (").append("see more <a href=\"").append(hintUrl).append("\">here</a>)");
            } else {
                sb.append(" (see: ").append(hintUrl).append(")");
            }
        }
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "sb.toString()");
        return string2;
    }

    @JvmOverloads
    public LanguageFeatureMessageRenderer(@NotNull Type type2) {
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        this(type2, false, 2, null);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/diagnostics/rendering/LanguageFeatureMessageRenderer$Type;", "", "(Ljava/lang/String;I)V", "UNSUPPORTED", "WARNING", "ERROR", "frontend"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type UNSUPPORTED = new Type();
        public static final /* enum */ Type WARNING = new Type();
        public static final /* enum */ Type ERROR = new Type();
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            Type[] typeArray = $VALUES;
            Type[] typeArray2 = new Type[typeArray.length];
            System.arraycopy(typeArray, 0, typeArray2, 0, typeArray.length);
            return typeArray2;
        }

        public static Type valueOf(String value2) {
            Intrinsics.checkNotNullParameter(value2, "value");
            return Enum.valueOf(Type.class, value2);
        }

        static {
            Type[] typeArray = new Type[]{UNSUPPORTED, WARNING, ERROR};
            $VALUES = typeArray;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Type.values().length];
            nArray[Type.UNSUPPORTED.ordinal()] = 1;
            nArray[Type.WARNING.ordinal()] = 2;
            nArray[Type.ERROR.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

