/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrNamer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H&J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H&J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH&J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\f\u0010 \u001a\u00020\u000b*\u00020!H\u0004R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/IrNamerBase;", "Lorg/jetbrains/kotlin/ir/backend/js/utils/IrNamer;", "()V", "associatedObjectKeyMap", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "", "getAssociatedObjectKey", "irClass", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Ljava/lang/Integer;", "getNameForClass", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "klass", "getNameForConstructor", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "getNameForField", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getNameForMemberField", "getNameForMemberFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getNameForProperty", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "getNameForStaticDeclaration", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "getNameForStaticFunction", "getRefForExternalClass", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "toJsName", "", "backend.js"})
public abstract class IrNamerBase
implements IrNamer {
    @NotNull
    private final Map<IrClass, Integer> associatedObjectKeyMap;

    public IrNamerBase() {
        boolean bl = false;
        this.associatedObjectKeyMap = new LinkedHashMap();
    }

    @Override
    @NotNull
    public abstract JsName getNameForMemberFunction(@NotNull IrSimpleFunction var1);

    @Override
    @NotNull
    public abstract JsName getNameForMemberField(@NotNull IrField var1);

    @Override
    @NotNull
    public abstract JsName getNameForStaticDeclaration(@NotNull IrDeclarationWithName var1);

    @NotNull
    protected final JsName toJsName(@NotNull String $this$toJsName) {
        Intrinsics.checkNotNullParameter($this$toJsName, "<this>");
        return new JsName($this$toJsName);
    }

    @Override
    @NotNull
    public JsName getNameForStaticFunction(@NotNull IrSimpleFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        return this.getNameForStaticDeclaration(function2);
    }

    @Override
    @NotNull
    public JsName getNameForField(@NotNull IrField field) {
        Intrinsics.checkNotNullParameter(field, "field");
        return field.isStatic() || field.getParent() instanceof IrScript ? this.getNameForStaticDeclaration(field) : this.getNameForMemberField(field);
    }

    @Override
    @NotNull
    public JsName getNameForConstructor(@NotNull IrConstructor constructor2) {
        Intrinsics.checkNotNullParameter(constructor2, "constructor");
        return this.getNameForStaticDeclaration(IrUtilsKt.getParentAsClass(constructor2));
    }

    @Override
    @NotNull
    public JsName getNameForClass(@NotNull IrClass klass) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        return this.getNameForStaticDeclaration(klass);
    }

    @Override
    @NotNull
    public JsNameRef getRefForExternalClass(@NotNull IrClass klass) {
        JsNameRef jsNameRef;
        Intrinsics.checkNotNullParameter(klass, "klass");
        IrDeclarationParent parent2 = klass.getParent();
        if (klass.isCompanion()) {
            return this.getRefForExternalClass((IrClass)parent2);
        }
        Object object = AnnotationUtilsKt.getJsNameOrKotlinName(klass).getIdentifier();
        Intrinsics.checkNotNullExpressionValue(object, "klass.getJsNameOrKotlinName().identifier");
        String currentClassName = object;
        object = parent2;
        if (object instanceof IrClass) {
            jsNameRef = new JsNameRef(currentClassName, (JsExpression)this.getRefForExternalClass((IrClass)parent2));
        } else if (object instanceof IrPackageFragment) {
            JsNameRef jsNameRef2 = this.getNameForStaticDeclaration(klass).makeRef();
            Intrinsics.checkNotNullExpressionValue(jsNameRef2, "{\n                getNameForStaticDeclaration(klass).makeRef()\n            }");
            jsNameRef = jsNameRef2;
        } else {
            String string2 = Intrinsics.stringPlus("Unsupported external class parent ", parent2);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return jsNameRef;
    }

    @Override
    @NotNull
    public JsName getNameForProperty(@NotNull IrProperty property2) {
        JsName jsName;
        Intrinsics.checkNotNullParameter(property2, "property");
        if (property2.getParent() instanceof IrClass) {
            String string2 = AnnotationUtilsKt.getJsNameOrKotlinName(property2).asString();
            Intrinsics.checkNotNullExpressionValue(string2, "property.getJsNameOrKotlinName().asString()");
            jsName = this.toJsName(string2);
        } else {
            jsName = this.getNameForStaticDeclaration(property2);
        }
        return jsName;
    }

    @Override
    @Nullable
    public Integer getAssociatedObjectKey(@NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        if (AnnotationUtilsKt.isAssociatedObjectAnnotatedAnnotation(irClass2)) {
            Integer n;
            Map<IrClass, Integer> $this$getOrPut$iv = this.associatedObjectKeyMap;
            boolean $i$f$getOrPut = false;
            Integer value$iv = $this$getOrPut$iv.get(irClass2);
            if (value$iv == null) {
                boolean bl = false;
                Integer answer$iv = this.associatedObjectKeyMap.size();
                $this$getOrPut$iv.put(irClass2, answer$iv);
                n = answer$iv;
            } else {
                n = value$iv;
            }
            return n;
        }
        return null;
    }
}

