/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.BitUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.JBIterableClassTraverser;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReflectionUtil {
    private static final Logger LOG = Logger.getInstance(ReflectionUtil.class);

    private ReflectionUtil() {
    }

    @NotNull
    public static List<Field> collectFields(@NotNull Class<?> clazz) {
        if (clazz == null) {
            ReflectionUtil.$$$reportNull$$$0(14);
        }
        ArrayList<Field> result2 = new ArrayList<Field>();
        for (Class clazz2 : JBIterableClassTraverser.classTraverser(clazz)) {
            ContainerUtil.addAll(result2, clazz2.getDeclaredFields());
        }
        ArrayList<Field> arrayList = result2;
        if (arrayList == null) {
            ReflectionUtil.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    public static Field findField(@NotNull Class<?> clazz, @Nullable Class<?> type2, @NotNull String name) throws NoSuchFieldException {
        Field result2;
        if (clazz == null) {
            ReflectionUtil.$$$reportNull$$$0(16);
        }
        if (name == null) {
            ReflectionUtil.$$$reportNull$$$0(17);
        }
        if ((result2 = ReflectionUtil.findFieldInHierarchy(clazz, field2 -> name.equals(field2.getName()) && (type2 == null || field2.getType().equals(type2)))) != null) {
            Field field3 = result2;
            if (field3 == null) {
                ReflectionUtil.$$$reportNull$$$0(18);
            }
            return field3;
        }
        throw new NoSuchFieldException("Class: " + clazz + " name: " + name + " type: " + type2);
    }

    @NotNull
    public static Field findAssignableField(@NotNull Class<?> clazz, @Nullable(value="null means any type") @Nullable(value="null means any type") Class<?> fieldType, @NotNull String fieldName) throws NoSuchFieldException {
        Field result2;
        if (clazz == null) {
            ReflectionUtil.$$$reportNull$$$0(19);
        }
        if (fieldName == null) {
            ReflectionUtil.$$$reportNull$$$0(20);
        }
        if ((result2 = ReflectionUtil.findFieldInHierarchy(clazz, field2 -> fieldName.equals(field2.getName()) && (fieldType == null || fieldType.isAssignableFrom(field2.getType())))) != null) {
            Field field3 = result2;
            if (field3 == null) {
                ReflectionUtil.$$$reportNull$$$0(21);
            }
            return field3;
        }
        throw new NoSuchFieldException("Class: " + clazz + " fieldName: " + fieldName + " fieldType: " + fieldType);
    }

    @Nullable
    public static Field findFieldInHierarchy(@NotNull Class<?> rootClass, @NotNull Predicate<? super Field> checker) {
        if (rootClass == null) {
            ReflectionUtil.$$$reportNull$$$0(22);
        }
        if (checker == null) {
            ReflectionUtil.$$$reportNull$$$0(23);
        }
        for (Class<?> aClass = rootClass; aClass != null; aClass = aClass.getSuperclass()) {
            for (Field field2 : aClass.getDeclaredFields()) {
                if (!checker.test(field2)) continue;
                field2.setAccessible(true);
                return field2;
            }
        }
        return ReflectionUtil.processInterfaces(rootClass.getInterfaces(), new HashSet(), checker);
    }

    @Nullable
    private static Field processInterfaces(Class<?> @NotNull [] interfaces, @NotNull Set<Class<?>> visited2, @NotNull Predicate<? super Field> checker) {
        if (visited2 == null) {
            ReflectionUtil.$$$reportNull$$$0(24);
        }
        if (checker == null) {
            ReflectionUtil.$$$reportNull$$$0(25);
        }
        if (interfaces == null) {
            ReflectionUtil.$$$reportNull$$$0(26);
        }
        for (Class<?> anInterface : interfaces) {
            if (!visited2.add(anInterface)) continue;
            for (Field field2 : anInterface.getDeclaredFields()) {
                if (!checker.test(field2)) continue;
                field2.setAccessible(true);
                return field2;
            }
            Field field3 = ReflectionUtil.processInterfaces(anInterface.getInterfaces(), visited2, checker);
            if (field3 == null) continue;
            return field3;
        }
        return null;
    }

    public static void resetField(@NotNull Class<?> clazz, @Nullable(value="null means of any type") @Nullable(value="null means of any type") Class<?> type2, @NotNull String name) {
        if (clazz == null) {
            ReflectionUtil.$$$reportNull$$$0(27);
        }
        if (name == null) {
            ReflectionUtil.$$$reportNull$$$0(28);
        }
        try {
            ReflectionUtil.resetField(null, ReflectionUtil.findField(clazz, type2, name));
        }
        catch (NoSuchFieldException e) {
            LOG.info(e);
        }
    }

    public static void resetField(@Nullable Object object, @NotNull Field field2) {
        if (field2 == null) {
            ReflectionUtil.$$$reportNull$$$0(33);
        }
        field2.setAccessible(true);
        Class<?> type2 = field2.getType();
        try {
            if (type2.isPrimitive()) {
                if (Boolean.TYPE.equals(type2)) {
                    field2.set(object, Boolean.FALSE);
                } else if (Integer.TYPE.equals(type2)) {
                    field2.set(object, 0);
                } else if (Double.TYPE.equals(type2)) {
                    field2.set(object, 0.0);
                } else if (Float.TYPE.equals(type2)) {
                    field2.set(object, Float.valueOf(0.0f));
                }
            } else {
                field2.set(object, null);
            }
        }
        catch (IllegalAccessException e) {
            LOG.info(e);
        }
    }

    private static Method makeAccessible(Method method) {
        method.setAccessible(true);
        return method;
    }

    @Nullable
    public static Method getMethod(@NotNull Class<?> aClass, @NonNls @NotNull String name, Class<?> ... parameters2) {
        if (aClass == null) {
            ReflectionUtil.$$$reportNull$$$0(37);
        }
        if (name == null) {
            ReflectionUtil.$$$reportNull$$$0(38);
        }
        if (parameters2 == null) {
            ReflectionUtil.$$$reportNull$$$0(39);
        }
        try {
            return ReflectionUtil.makeAccessible(aClass.getMethod(name, parameters2));
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @Nullable
    public static Method getDeclaredMethod(@NotNull Class<?> aClass, @NonNls @NotNull String name, Class<?> ... parameters2) {
        if (aClass == null) {
            ReflectionUtil.$$$reportNull$$$0(40);
        }
        if (name == null) {
            ReflectionUtil.$$$reportNull$$$0(41);
        }
        if (parameters2 == null) {
            ReflectionUtil.$$$reportNull$$$0(42);
        }
        try {
            return ReflectionUtil.makeAccessible(aClass.getDeclaredMethod(name, parameters2));
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @Nullable
    public static Field getDeclaredField(@NotNull Class<?> aClass, @NonNls @NotNull String name) {
        if (aClass == null) {
            ReflectionUtil.$$$reportNull$$$0(43);
        }
        if (name == null) {
            ReflectionUtil.$$$reportNull$$$0(44);
        }
        return ReflectionUtil.findFieldInHierarchy(aClass, field2 -> name.equals(field2.getName()));
    }

    @Nullable
    public static Class<?> getMethodDeclaringClass(@NotNull Class<?> instanceClass, @NonNls @NotNull String methodName, Class<?> ... parameters2) {
        Method method;
        if (instanceClass == null) {
            ReflectionUtil.$$$reportNull$$$0(53);
        }
        if (methodName == null) {
            ReflectionUtil.$$$reportNull$$$0(54);
        }
        if (parameters2 == null) {
            ReflectionUtil.$$$reportNull$$$0(55);
        }
        return (method = ReflectionUtil.getMethod(instanceClass, methodName, parameters2)) == null ? null : method.getDeclaringClass();
    }

    public static <T> T getField(@NotNull Class<?> objectClass, @Nullable Object object, @Nullable(value="null means any type") @Nullable(value="null means any type") Class<T> fieldType, @NotNull @NonNls String fieldName) {
        if (objectClass == null) {
            ReflectionUtil.$$$reportNull$$$0(56);
        }
        if (fieldName == null) {
            ReflectionUtil.$$$reportNull$$$0(57);
        }
        try {
            Field field2 = ReflectionUtil.findAssignableField(objectClass, fieldType, fieldName);
            return ReflectionUtil.getFieldValue(field2, object);
        }
        catch (NoSuchFieldException e) {
            LOG.debug(e);
            return null;
        }
    }

    public static <T> T getStaticFieldValue(@NotNull Class<?> objectClass, @Nullable(value="null means any type") @Nullable(value="null means any type") Class<T> fieldType, @NotNull @NonNls String fieldName) {
        if (objectClass == null) {
            ReflectionUtil.$$$reportNull$$$0(58);
        }
        if (fieldName == null) {
            ReflectionUtil.$$$reportNull$$$0(59);
        }
        try {
            Field field2 = ReflectionUtil.findAssignableField(objectClass, fieldType, fieldName);
            if (ReflectionUtil.isInstanceField(field2)) {
                throw new IllegalArgumentException("Field " + objectClass + "." + fieldName + " is not static");
            }
            return ReflectionUtil.getFieldValue(field2, null);
        }
        catch (NoSuchFieldException e) {
            LOG.debug(e);
            return null;
        }
    }

    @Nullable
    public static <T> T getFieldValue(@NotNull Field field2, @Nullable Object object) {
        if (field2 == null) {
            ReflectionUtil.$$$reportNull$$$0(60);
        }
        try {
            return (T)field2.get(object);
        }
        catch (IllegalAccessException e) {
            LOG.debug(e);
            return null;
        }
    }

    public static boolean isInstanceField(@NotNull Field field2) {
        if (field2 == null) {
            ReflectionUtil.$$$reportNull$$$0(61);
        }
        return !Modifier.isStatic(field2.getModifiers());
    }

    @NotNull
    public static <T> T newInstance(@NotNull Class<T> aClass) {
        if (aClass == null) {
            ReflectionUtil.$$$reportNull$$$0(68);
        }
        return ReflectionUtil.newInstance(aClass, true);
    }

    @NotNull
    public static <T> T newInstance(@NotNull Class<T> aClass, boolean isKotlinDataClassesSupported) {
        Constructor<T> constructor2;
        if (aClass == null) {
            ReflectionUtil.$$$reportNull$$$0(69);
        }
        try {
            constructor2 = aClass.getDeclaredConstructor(new Class[0]);
            try {
                constructor2.setAccessible(true);
            }
            catch (SecurityException e) {
                T t = aClass.newInstance();
                if (t == null) {
                    ReflectionUtil.$$$reportNull$$$0(70);
                }
                return t;
            }
        }
        catch (Exception e) {
            T t;
            Throwable targetException;
            if (e instanceof InvocationTargetException && (targetException = ((InvocationTargetException)e).getTargetException()) instanceof ControlFlowException && targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            if (isKotlinDataClassesSupported && (t = ReflectionUtil.createAsDataClass(aClass)) != null) {
                T t2 = t;
                if (t2 == null) {
                    ReflectionUtil.$$$reportNull$$$0(72);
                }
                return t2;
            }
            ExceptionUtil.rethrow(e);
            if (null == null) {
                ReflectionUtil.$$$reportNull$$$0(73);
            }
            return null;
        }
        T t = constructor2.newInstance(new Object[0]);
        if (t == null) {
            ReflectionUtil.$$$reportNull$$$0(71);
        }
        return t;
    }

    @Nullable
    private static <T> T createAsDataClass(@NotNull Class<T> aClass) {
        if (aClass == null) {
            ReflectionUtil.$$$reportNull$$$0(74);
        }
        for (Annotation annotation2 : aClass.getAnnotations()) {
            String name = annotation2.annotationType().getName();
            if (!name.equals("kotlin.Metadata") && !name.equals("kotlin.jvm.internal.KotlinClass")) continue;
            Constructor<?>[] constructors2 = aClass.getDeclaredConstructors();
            Exception exception = null;
            SmartList defaultCtors = new SmartList();
            for (Constructor<?> constructor2 : constructors2) {
                try {
                    block15: {
                        Class<?>[] parameterTypes;
                        try {
                            constructor2.setAccessible(true);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (constructor2.getParameterCount() == 0) {
                            return (T)constructor2.newInstance(new Object[0]);
                        }
                        for (Class<?> type2 : parameterTypes = constructor2.getParameterTypes()) {
                            if (!type2.getName().equals("kotlin.jvm.internal.DefaultConstructorMarker")) {
                                continue;
                            }
                            break block15;
                        }
                        return (T)constructor2.newInstance(new Object[parameterTypes.length]);
                    }
                    defaultCtors.add(constructor2);
                }
                catch (Exception e) {
                    exception = e;
                }
            }
            for (Constructor constructor2 : defaultCtors) {
                try {
                    try {
                        constructor2.setAccessible(true);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return constructor2.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    exception = e;
                }
            }
            if (exception == null) continue;
            ExceptionUtil.rethrow(exception);
        }
        return null;
    }

    @NotNull
    public static <T> T createInstance(@NotNull Constructor<T> constructor2, Object ... args) {
        T t;
        if (constructor2 == null) {
            ReflectionUtil.$$$reportNull$$$0(75);
        }
        if (args == null) {
            ReflectionUtil.$$$reportNull$$$0(76);
        }
        try {
            t = constructor2.newInstance(args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (t == null) {
            ReflectionUtil.$$$reportNull$$$0(77);
        }
        return t;
    }

    @NotNull
    public static <T, V> Field getTheOnlyVolatileInstanceFieldOfClass(@NotNull Class<T> ownerClass, @NotNull Class<V> fieldType) {
        if (ownerClass == null) {
            ReflectionUtil.$$$reportNull$$$0(97);
        }
        if (fieldType == null) {
            ReflectionUtil.$$$reportNull$$$0(98);
        }
        Field[] declaredFields = ownerClass.getDeclaredFields();
        Field found = null;
        for (Field field2 : declaredFields) {
            int modifiers2 = field2.getModifiers();
            if (BitUtil.isSet(modifiers2, 8) || !BitUtil.isSet(modifiers2, 64) || !fieldType.isAssignableFrom(field2.getType())) continue;
            if (found == null) {
                found = field2;
                continue;
            }
            throw new IllegalArgumentException("Two fields of " + fieldType + " found in the " + ownerClass + ": " + found + " and " + field2);
        }
        if (found == null) {
            throw new IllegalArgumentException("No (non-static, non-final) field of " + fieldType + " found in the " + ownerClass);
        }
        Field field3 = found;
        if (field3 == null) {
            ReflectionUtil.$$$reportNull$$$0(99);
        }
        return field3;
    }

    @Nullable
    public static Class<?> findCallerClass(int framesToSkip) {
        try {
            Class<?>[] stack = MySecurityManager.INSTANCE.getStack();
            int indexFromTop = 1 + framesToSkip;
            return stack.length > indexFromTop ? stack[indexFromTop] : null;
        }
        catch (Exception e) {
            LOG.warn(e);
            return null;
        }
    }

    public static boolean isAssignable(@NotNull Class<?> ancestor, @NotNull Class<?> descendant) {
        if (ancestor == null) {
            ReflectionUtil.$$$reportNull$$$0(100);
        }
        if (descendant == null) {
            ReflectionUtil.$$$reportNull$$$0(101);
        }
        return ancestor == descendant || ancestor.isAssignableFrom(descendant);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 18: 
            case 21: 
            case 50: 
            case 52: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 77: 
            case 93: 
            case 95: 
            case 96: 
            case 99: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 18: 
            case 21: 
            case 50: 
            case 52: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 77: 
            case 93: 
            case 95: 
            case 96: 
            case 99: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 1: 
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anInterface";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 18: 
            case 21: 
            case 50: 
            case 52: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 77: 
            case 93: 
            case 95: 
            case 96: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ReflectionUtil";
                break;
            }
            case 6: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterizedType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericType";
                break;
            }
            case 14: 
            case 16: 
            case 19: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 17: 
            case 28: 
            case 30: 
            case 32: 
            case 35: 
            case 38: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 20: 
            case 57: 
            case 59: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootClass";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checker";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaces";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 33: 
            case 60: 
            case 61: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 34: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 36: 
            case 39: 
            case 42: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 37: 
            case 40: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceClass";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 56: 
            case 58: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectClass";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 78: 
            case 81: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 79: 
            case 82: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 80: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultSettings";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSettings";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "useField";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerClass";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldType";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descendant";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ReflectionUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "declarationToString";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualTypeArguments";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFields";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findField";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findAssignableField";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassDeclaredFields";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "filterRealMethods";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultConstructor";
                break;
            }
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "newInstance";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "createInstance";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "forName";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "boxType";
                break;
            }
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "getTheOnlyVolatileInstanceFieldOfClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveVariable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "declarationToString";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 18: 
            case 21: 
            case 50: 
            case 52: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 77: 
            case 93: 
            case 95: 
            case 96: 
            case 99: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRawType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getActualTypeArguments";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "substituteGenericType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectFields";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findField";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findAssignableField";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findFieldInHierarchy";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "processInterfaces";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "resetField";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findMethod";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getMethod";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredMethod";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredField";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getClassPublicMethods";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getClassDeclaredMethods";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getClassDeclaredFields";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "filterRealMethods";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getMethodDeclaringClass";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getField";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getStaticFieldValue";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getFieldValue";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "isInstanceField";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "setField";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "resolveVariableInHierarchy";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultConstructor";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "newInstance";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "createAsDataClass";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "copyFields";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "comparePublicNonFinalFields";
                break;
            }
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "compareFields";
                break;
            }
            case 89: 
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "copyFieldValue";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "forName";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "boxType";
                break;
            }
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "getTheOnlyVolatileInstanceFieldOfClass";
                break;
            }
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "isAssignable";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 18: 
            case 21: 
            case 50: 
            case 52: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 77: 
            case 93: 
            case 95: 
            case 96: 
            case 99: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MySecurityManager
    extends SecurityManager {
        private static final MySecurityManager INSTANCE = new MySecurityManager();

        private MySecurityManager() {
        }

        Class<?>[] getStack() {
            return this.getClassContext();
        }
    }
}

