/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics.rendering;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters3;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters4;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \b2\u00020\u0001:\u0004\b\t\n\u000bB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0006H\u00a6\u0002\u00a2\u0006\u0002\u0010\u0007\u0082\u0001\u0002\f\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext;", "", "()V", "get", "T", "key", "Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext$Key;", "(Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext$Key;)Ljava/lang/Object;", "Companion", "Empty", "Impl", "Key", "Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext$Impl;", "Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext$Empty;", "frontend"})
public abstract class RenderingContext {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private RenderingContext() {
    }

    public abstract <T> T get(@NotNull Key<? extends T> var1);

    @JvmStatic
    @NotNull
    public static final RenderingContext of(Object ... objectsToRender) {
        return Companion.of(objectsToRender);
    }

    @JvmStatic
    @NotNull
    public static final List<Object> parameters(@NotNull Diagnostic d) {
        return Companion.parameters(d);
    }

    @JvmStatic
    @NotNull
    public static final RenderingContext fromDiagnostic(@NotNull Diagnostic d) {
        return Companion.fromDiagnostic(d);
    }

    public /* synthetic */ RenderingContext(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0002\b&\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001d\u0010\b\u001a\u00028\u00002\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\nH&\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext$Key;", "T", "", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "compute", "objectsToRender", "", "(Ljava/util/Collection;)Ljava/lang/Object;", "frontend"})
    public static abstract class Key<T> {
        @NotNull
        private final String name;

        public Key(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            this.name = name;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public abstract T compute(@NotNull Collection<? extends Object> var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\"\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\bH\u0096\u0002\u00a2\u0006\u0002\u0010\rR6\u0010\u0006\u001a*\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0007j\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0006\u0012\u0004\u0018\u00010\u0004`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext$Impl;", "Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext;", "objectsToRender", "", "", "(Ljava/util/Collection;)V", "data", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext$Key;", "Lkotlin/collections/LinkedHashMap;", "get", "T", "key", "(Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext$Key;)Ljava/lang/Object;", "frontend"})
    public static final class Impl
    extends RenderingContext {
        @NotNull
        private final Collection<Object> objectsToRender;
        @NotNull
        private final LinkedHashMap<Key<?>, Object> data;

        public Impl(@NotNull Collection<? extends Object> objectsToRender) {
            Intrinsics.checkNotNullParameter(objectsToRender, "objectsToRender");
            super(null);
            this.objectsToRender = objectsToRender;
            boolean bl = false;
            this.data = new LinkedHashMap();
        }

        @Override
        public <T> T get(@NotNull Key<? extends T> key) {
            Object object;
            Object object2;
            Intrinsics.checkNotNullParameter(key, "key");
            Object object3 = this.data.get(key);
            if (object3 == null) {
                // empty if block
            }
            if ((object2 = object3) == null) {
                object3 = key.compute(this.objectsToRender);
                boolean bl = false;
                boolean bl2 = false;
                Object it = object3;
                boolean bl3 = false;
                Map map = this.data;
                boolean bl4 = false;
                map.put(key, it);
                object = object3;
            } else {
                object = object2;
            }
            return (T)object;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0006H\u0096\u0002\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext$Empty;", "Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext;", "()V", "get", "T", "key", "Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext$Key;", "(Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext$Key;)Ljava/lang/Object;", "frontend"})
    public static final class Empty
    extends RenderingContext {
        @NotNull
        public static final Empty INSTANCE = new Empty();

        private Empty() {
            super(null);
        }

        @Override
        public <T> T get(@NotNull Key<? extends T> key) {
            Intrinsics.checkNotNullParameter(key, "key");
            return key.compute(CollectionsKt.emptyList());
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J%\u0010\u0007\u001a\u00020\u00042\u0016\u0010\b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\t\"\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext$Companion;", "", "()V", "fromDiagnostic", "Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext;", "d", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "of", "objectsToRender", "", "([Ljava/lang/Object;)Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext;", "parameters", "", "frontend"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final RenderingContext of(Object ... objectsToRender) {
            Intrinsics.checkNotNullParameter(objectsToRender, "objectsToRender");
            return new Impl((Collection<? extends Object>)ArraysKt.toList(objectsToRender));
        }

        @JvmStatic
        @NotNull
        public final List<Object> parameters(@NotNull Diagnostic d) {
            List<Object> list2;
            Intrinsics.checkNotNullParameter(d, "d");
            Diagnostic diagnostic = d;
            if (diagnostic instanceof SimpleDiagnostic) {
                boolean bl = false;
                list2 = CollectionsKt.emptyList();
            } else if (diagnostic instanceof DiagnosticWithParameters1) {
                list2 = CollectionsKt.listOf(((DiagnosticWithParameters1)d).getA());
            } else if (diagnostic instanceof DiagnosticWithParameters2) {
                Object[] objectArray = new Object[]{((DiagnosticWithParameters2)d).getA(), ((DiagnosticWithParameters2)d).getB()};
                list2 = CollectionsKt.listOf(objectArray);
            } else if (diagnostic instanceof DiagnosticWithParameters3) {
                Object[] objectArray = new Object[]{((DiagnosticWithParameters3)d).getA(), ((DiagnosticWithParameters3)d).getB(), ((DiagnosticWithParameters3)d).getC()};
                list2 = CollectionsKt.listOf(objectArray);
            } else if (diagnostic instanceof DiagnosticWithParameters4) {
                Object[] objectArray = new Object[]{((DiagnosticWithParameters4)d).getA(), ((DiagnosticWithParameters4)d).getB(), ((DiagnosticWithParameters4)d).getC(), ((DiagnosticWithParameters4)d).getD()};
                list2 = CollectionsKt.listOf(objectArray);
            } else {
                if (diagnostic instanceof ParametrizedDiagnostic) {
                    String string2 = Intrinsics.stringPlus("Unexpected diagnostic: ", d.getClass());
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                boolean bl = false;
                list2 = CollectionsKt.emptyList();
            }
            return list2;
        }

        @JvmStatic
        @NotNull
        public final RenderingContext fromDiagnostic(@NotNull Diagnostic d) {
            Intrinsics.checkNotNullParameter(d, "d");
            return new Impl((Collection<? extends Object>)this.parameters(d));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

