/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.substitution;

import java.util.ArrayList;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeConflictingProjection;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.ConeTypeContext;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypesKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\tH&J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u000e\u0010\u000f\u001a\u0004\u0018\u00010\t*\u00020\tH\u0002J\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0011H\u0002J\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u0013H\u0002J\u000e\u0010\u0014\u001a\u0004\u0018\u00010\t*\u00020\u0015H\u0002J\u000e\u0010\u0016\u001a\u0004\u0018\u00010\t*\u00020\tH\u0002J\u0016\u0010\u0017\u001a\u0004\u0018\u00010\t*\u0004\u0018\u00010\t2\u0006\u0010\u0018\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019\u00b2\u0006\u0012\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u001bX\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/substitution/AbstractConeSubstitutor;", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "typeContext", "Lorg/jetbrains/kotlin/fir/types/ConeTypeContext;", "(Lorg/jetbrains/kotlin/fir/types/ConeTypeContext;)V", "substituteArgument", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "projection", "substituteOrNull", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "type", "substituteType", "wrapProjection", "old", "newType", "substituteArguments", "substituteBounds", "Lorg/jetbrains/kotlin/fir/types/ConeFlexibleType;", "substituteIntersectedTypes", "Lorg/jetbrains/kotlin/fir/types/ConeIntersectionType;", "substituteOriginal", "Lorg/jetbrains/kotlin/fir/types/ConeDefinitelyNotNullType;", "substituteRecursive", "updateNullabilityIfNeeded", "originalType", "resolve", "newArguments", ""})
public abstract class AbstractConeSubstitutor
extends ConeSubstitutor {
    @NotNull
    private final ConeTypeContext typeContext;

    public AbstractConeSubstitutor(@NotNull ConeTypeContext typeContext2) {
        Intrinsics.checkNotNullParameter(typeContext2, "typeContext");
        this.typeContext = typeContext2;
    }

    private final ConeTypeProjection wrapProjection(ConeTypeProjection old, ConeKotlinType newType) {
        ConeTypeProjection coneTypeProjection = old;
        return coneTypeProjection instanceof ConeStarProjection ? old : (coneTypeProjection instanceof ConeKotlinTypeProjectionIn ? (ConeTypeProjection)new ConeKotlinTypeProjectionIn(newType) : (coneTypeProjection instanceof ConeKotlinTypeProjectionOut ? (ConeTypeProjection)new ConeKotlinTypeProjectionOut(newType) : (coneTypeProjection instanceof ConeKotlinTypeConflictingProjection ? (ConeTypeProjection)new ConeKotlinTypeConflictingProjection(newType) : (coneTypeProjection instanceof ConeKotlinType ? (ConeTypeProjection)newType : old))));
    }

    @Nullable
    public abstract ConeKotlinType substituteType(@NotNull ConeKotlinType var1);

    @Nullable
    public ConeTypeProjection substituteArgument(@NotNull ConeTypeProjection projection) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter(projection, "projection");
        ConeKotlinTypeProjection coneKotlinTypeProjection = projection instanceof ConeKotlinTypeProjection ? (ConeKotlinTypeProjection)projection : null;
        ConeKotlinType coneKotlinType2 = coneKotlinType = coneKotlinTypeProjection == null ? null : coneKotlinTypeProjection.getType();
        if (coneKotlinType == null) {
            return null;
        }
        ConeKotlinType type2 = coneKotlinType;
        coneKotlinTypeProjection = this.substituteOrNull(type2);
        if (coneKotlinTypeProjection == null) {
            return null;
        }
        ConeKotlinTypeProjection newType = coneKotlinTypeProjection;
        return this.wrapProjection(projection, (ConeKotlinType)newType);
    }

    @Nullable
    public final ConeKotlinType updateNullabilityIfNeeded(@Nullable ConeKotlinType $this$updateNullabilityIfNeeded, @NotNull ConeKotlinType originalType) {
        ConeKotlinType coneKotlinType;
        ConeKotlinType coneKotlinType2;
        Intrinsics.checkNotNullParameter(originalType, "originalType");
        Object object = originalType instanceof ConeDefinitelyNotNullType ? ((coneKotlinType2 = $this$updateNullabilityIfNeeded) == null ? null : TypeUtilsKt.withNullability$default(coneKotlinType2, ConeNullability.NOT_NULL, this.typeContext, null, 4, null)) : (ConeTypeUtilsKt.isMarkedNullable(originalType) ? ((coneKotlinType = $this$updateNullabilityIfNeeded) == null ? null : TypeUtilsKt.withNullability$default(coneKotlinType, ConeNullability.NULLABLE, this.typeContext, null, 4, null)) : $this$updateNullabilityIfNeeded);
        return object;
    }

    @Override
    @Nullable
    public ConeKotlinType substituteOrNull(@NotNull ConeKotlinType type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        ConeKotlinType newType = this.substituteType(type2);
        if (newType != null && type2 instanceof ConeDefinitelyNotNullType) {
            return TypeUtilsKt.makeConeTypeDefinitelyNotNullOrNotNull(newType, this.typeContext);
        }
        ConeKotlinType coneKotlinType = newType;
        return coneKotlinType == null ? this.substituteRecursive(type2) : coneKotlinType;
    }

    private final ConeKotlinType substituteRecursive(ConeKotlinType $this$substituteRecursive) {
        ConeKotlinType coneKotlinType;
        ConeKotlinType coneKotlinType2 = $this$substituteRecursive;
        if (coneKotlinType2 instanceof ConeClassErrorType) {
            return null;
        }
        if (coneKotlinType2 instanceof ConeClassLikeType) {
            coneKotlinType = this.substituteArguments($this$substituteRecursive);
        } else {
            if (coneKotlinType2 instanceof ConeLookupTagBasedType) {
                return null;
            }
            if (coneKotlinType2 instanceof ConeFlexibleType) {
                ConeFlexibleType coneFlexibleType = this.substituteBounds((ConeFlexibleType)$this$substituteRecursive);
                if (coneFlexibleType == null) {
                    coneKotlinType = null;
                } else {
                    ConeFlexibleType coneFlexibleType2 = coneFlexibleType;
                    boolean bl = false;
                    boolean bl2 = false;
                    ConeFlexibleType it = coneFlexibleType2;
                    boolean bl3 = false;
                    coneKotlinType = Intrinsics.areEqual(it.getLowerBound(), it.getUpperBound()) ? it.getLowerBound() : (ConeKotlinType)it;
                }
            } else {
                if (coneKotlinType2 instanceof ConeCapturedType) {
                    return null;
                }
                if (coneKotlinType2 instanceof ConeDefinitelyNotNullType) {
                    coneKotlinType = this.substituteOriginal((ConeDefinitelyNotNullType)$this$substituteRecursive);
                } else if (coneKotlinType2 instanceof ConeIntersectionType) {
                    coneKotlinType = this.substituteIntersectedTypes((ConeIntersectionType)$this$substituteRecursive);
                } else {
                    if (coneKotlinType2 instanceof ConeStubType) {
                        return null;
                    }
                    if (coneKotlinType2 instanceof ConeIntegerLiteralType) {
                        return null;
                    }
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return coneKotlinType;
    }

    private final ConeIntersectionType substituteIntersectedTypes(ConeIntersectionType $this$substituteIntersectedTypes) {
        ArrayList substitutedTypes = new ArrayList($this$substituteIntersectedTypes.getIntersectedTypes().size());
        boolean somethingIsSubstituted = false;
        for (ConeKotlinType type2 : $this$substituteIntersectedTypes.getIntersectedTypes()) {
            ConeKotlinType coneKotlinType;
            Object object = this.substituteOrNull(type2);
            if (object == null) {
                coneKotlinType = type2;
            } else {
                ConeKotlinType coneKotlinType2;
                ConeKotlinType coneKotlinType3 = object;
                boolean bl = false;
                boolean bl2 = false;
                ConeKotlinType it = coneKotlinType3;
                boolean bl3 = false;
                somethingIsSubstituted = true;
                coneKotlinType = coneKotlinType2 = coneKotlinType3;
            }
            ConeKotlinType substitutedType = coneKotlinType;
            object = substitutedTypes;
            boolean bl = false;
            object.add(substitutedType);
        }
        if (!somethingIsSubstituted) {
            return null;
        }
        return new ConeIntersectionType(substitutedTypes, null, 2, null);
    }

    private final ConeKotlinType substituteOriginal(ConeDefinitelyNotNullType $this$substituteOriginal) {
        ConeKotlinType coneKotlinType;
        ConeKotlinType coneKotlinType2 = this.substituteOrNull($this$substituteOriginal.getOriginal());
        ConeKotlinType coneKotlinType3 = coneKotlinType = coneKotlinType2 == null ? null : TypeUtilsKt.withNullability$default(coneKotlinType2, ConeNullability.NOT_NULL, this.typeContext, null, 4, null);
        if (coneKotlinType == null) {
            return null;
        }
        ConeKotlinType substituted = coneKotlinType;
        return (coneKotlinType = TypeUtilsKt.create$default(ConeDefinitelyNotNullType.Companion, substituted, this.typeContext, false, 4, null)) == null ? substituted : coneKotlinType;
    }

    private final ConeFlexibleType substituteBounds(ConeFlexibleType $this$substituteBounds) {
        ConeKotlinType newLowerBound = this.substituteOrNull($this$substituteBounds.getLowerBound());
        ConeKotlinType newUpperBound = this.substituteOrNull($this$substituteBounds.getUpperBound());
        if (newLowerBound != null || newUpperBound != null) {
            ConeKotlinType coneKotlinType = newLowerBound;
            ConeKotlinType coneKotlinType2 = coneKotlinType == null ? null : ConeTypesKt.lowerBoundIfFlexible(coneKotlinType);
            ConeKotlinType coneKotlinType3 = coneKotlinType2 == null ? $this$substituteBounds.getLowerBound() : coneKotlinType2;
            coneKotlinType = newUpperBound;
            coneKotlinType2 = coneKotlinType == null ? null : ConeTypesKt.upperBoundIfFlexible(coneKotlinType);
            return new ConeFlexibleType(coneKotlinType3, coneKotlinType2 == null ? $this$substituteBounds.getUpperBound() : coneKotlinType2);
        }
        return null;
    }

    private final ConeKotlinType substituteArguments(ConeKotlinType $this$substituteArguments) {
        ConeTypeProjection typeArgument;
        int index2;
        Lazy<ConeTypeProjection[]> newArguments$delegate = LazyKt.lazy((Function0)new Function0<ConeTypeProjection[]>($this$substituteArguments){
            final /* synthetic */ ConeKotlinType $this_substituteArguments;
            {
                this.$this_substituteArguments = $receiver;
                super(0);
            }

            @NotNull
            public final ConeTypeProjection[] invoke() {
                return new ConeTypeProjection[this.$this_substituteArguments.getTypeArguments().length];
            }
        });
        boolean initialized = false;
        Object object = $this$substituteArguments.getTypeArguments();
        int n = 0;
        int n2 = ((ConeTypeProjection[])object).length;
        while (n < n2) {
            ConeTypeProjection coneTypeProjection;
            index2 = n;
            typeArgument = object[n];
            ++n;
            ConeTypeProjection[] coneTypeProjectionArray = AbstractConeSubstitutor.substituteArguments$lambda-2(newArguments$delegate);
            int n3 = index2;
            ConeTypeProjection coneTypeProjection2 = this.substituteArgument(typeArgument);
            if (coneTypeProjection2 == null) {
                coneTypeProjection = null;
            } else {
                ConeTypeProjection coneTypeProjection3 = coneTypeProjection2;
                boolean bl = false;
                boolean bl2 = false;
                ConeTypeProjection coneTypeProjection4 = coneTypeProjection3;
                int n4 = n3;
                ConeTypeProjection[] coneTypeProjectionArray2 = coneTypeProjectionArray;
                boolean bl3 = false;
                initialized = true;
                Unit unit = Unit.INSTANCE;
                coneTypeProjectionArray = coneTypeProjectionArray2;
                n3 = n4;
                coneTypeProjection = coneTypeProjection3;
            }
            coneTypeProjectionArray[n3] = coneTypeProjection;
        }
        if (initialized) {
            object = $this$substituteArguments.getTypeArguments();
            n2 = ((ConeTypeProjection[])object).length;
            for (n = 0; n < n2; ++n) {
                index2 = n;
                typeArgument = object[n];
                if (AbstractConeSubstitutor.substituteArguments$lambda-2(newArguments$delegate)[index2] != null) continue;
                AbstractConeSubstitutor.substituteArguments$lambda-2(newArguments$delegate)[index2] = typeArgument;
            }
            object = $this$substituteArguments;
            if (!(object instanceof ConeClassLikeTypeImpl)) {
                if (object instanceof ConeClassLikeType) {
                    String string2 = "Unknown class-like type to substitute: " + $this$substituteArguments + ", " + Reflection.getOrCreateKotlinClass($this$substituteArguments.getClass());
                    n2 = 0;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                String string3 = "Unknown type to substitute: " + $this$substituteArguments + ", " + Reflection.getOrCreateKotlinClass($this$substituteArguments.getClass());
                n2 = 0;
                throw (Throwable)new IllegalStateException(string3.toString());
            }
            return new ConeClassLikeTypeImpl(((ConeClassLikeTypeImpl)$this$substituteArguments).getLookupTag(), AbstractConeSubstitutor.substituteArguments$lambda-2(newArguments$delegate), $this$substituteArguments.getNullability().isNullable(), $this$substituteArguments.getAttributes());
        }
        return null;
    }

    private static final ConeTypeProjection[] substituteArguments$lambda-2(Lazy<ConeTypeProjection[]> newArguments$delegate) {
        Lazy<ConeTypeProjection[]> lazy = newArguments$delegate;
        Object var2_2 = null;
        Object var3_3 = null;
        boolean bl = false;
        return lazy.getValue();
    }
}

