/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.stack.Variable;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.Wrapper;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b`\u0018\u00002\u00020\u0001J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u00142\b\u0010\u001b\u001a\u0004\u0018\u00010\u0014H\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u0004\u0018\u00010\tX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/Complex;", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "outerClass", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Variable;", "getOuterClass", "()Lorg/jetbrains/kotlin/ir/interpreter/stack/Variable;", "setOuterClass", "(Lorg/jetbrains/kotlin/ir/interpreter/stack/Variable;)V", "superWrapperClass", "Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;", "getSuperWrapperClass", "()Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;", "setSuperWrapperClass", "(Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;)V", "getIrFunctionByIrCall", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "getIrFunctionFromGivenClass", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "getOverridden", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "owner", "getThisOrSuperReceiver", "superIrClass", "irClassFqName", "", "ir.interpreter"})
public interface Complex
extends State {
    @Nullable
    public Wrapper getSuperWrapperClass();

    public void setSuperWrapperClass(@Nullable Wrapper var1);

    @Nullable
    public Variable getOuterClass();

    public void setOuterClass(@Nullable Variable var1);

    @NotNull
    public String irClassFqName();

    @NotNull
    public IrSimpleFunction getOverridden(@NotNull IrSimpleFunction var1);

    @Override
    @Nullable
    public IrFunction getIrFunctionByIrCall(@NotNull IrCall var1);

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static String irClassFqName(@NotNull Complex this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            String string2 = AdditionalIrUtilsKt.getFqNameForIrSerialization(this_.getIrClass()).toString();
            Intrinsics.checkNotNullExpressionValue(string2, "irClass.fqNameForIrSerialization.toString()");
            return string2;
        }

        /*
         * WARNING - void declaration
         */
        private static IrFunction getIrFunctionFromGivenClass(Complex this_, IrClass irClass2, IrFunctionSymbol symbol2) {
            Object v1;
            block6: {
                void $this$filterIsInstanceTo$iv$iv;
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                void $this$filterIsInstanceTo$iv$iv2;
                boolean bl;
                Object element$iv$iv$iv2;
                void $this$mapNotNullTo$iv$iv2;
                void $this$mapNotNull$iv2;
                void $this$filterIsInstanceTo$iv$iv3;
                Iterable $this$filterIsInstance$iv = irClass2.getDeclarations();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Iterable<IrSimpleFunction> destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv3) {
                    if (!(element$iv$iv instanceof IrProperty)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$mapNotNull = false;
                $this$filterIsInstanceTo$iv$iv3 = $this$mapNotNull$iv2;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
                boolean $i$f$forEach = false;
                for (Object element$iv$iv$iv2 : $this$forEach$iv$iv$iv) {
                    IrSimpleFunction irSimpleFunction;
                    Object element$iv$iv = element$iv$iv$iv2;
                    boolean bl2 = false;
                    IrProperty it = (IrProperty)element$iv$iv;
                    boolean bl3 = false;
                    if (it.getGetter() == null) continue;
                    boolean bl4 = false;
                    bl = false;
                    IrSimpleFunction it$iv$iv = irSimpleFunction;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List propertyGetters = (List)destination$iv$iv;
                Iterable $this$filterIsInstance$iv2 = irClass2.getDeclarations();
                boolean $i$f$filterIsInstance2 = false;
                destination$iv$iv = $this$filterIsInstance$iv2;
                Iterable<IrSimpleFunction> destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterIsInstanceTo2 = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
                    if (!(element$iv$iv instanceof IrProperty)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filterIsInstance$iv2 = (List)destination$iv$iv2;
                boolean $i$f$mapNotNull2 = false;
                $this$filterIsInstanceTo$iv$iv2 = $this$mapNotNull$iv;
                destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo2 = false;
                void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach2 = false;
                element$iv$iv$iv2 = $this$forEach$iv$iv$iv2.iterator();
                while (element$iv$iv$iv2.hasNext()) {
                    IrSimpleFunction irSimpleFunction;
                    Object element$iv$iv$iv3;
                    Object element$iv$iv = element$iv$iv$iv3 = element$iv$iv$iv2.next();
                    boolean bl6 = false;
                    IrProperty it = (IrProperty)element$iv$iv;
                    boolean bl7 = false;
                    if (it.getSetter() == null) continue;
                    bl = false;
                    boolean bl8 = false;
                    IrSimpleFunction it$iv$iv = irSimpleFunction;
                    boolean bl9 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                List propertySetters = (List)destination$iv$iv2;
                Iterable $this$filterIsInstance$iv3 = irClass2.getDeclarations();
                boolean $i$f$filterIsInstance3 = false;
                destination$iv$iv2 = $this$filterIsInstance$iv3;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterIsInstanceTo3 = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof IrFunction)) continue;
                    destination$iv$iv3.add(element$iv$iv);
                }
                List functions2 = (List)destination$iv$iv3;
                Iterable $this$firstOrNull$iv = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)propertyGetters, (Iterable)propertySetters), (Iterable)functions2);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    IrFunction it = (IrFunction)element$iv;
                    boolean bl10 = false;
                    IrFunction owner = symbol2.getOwner();
                    boolean bl11 = it instanceof IrSimpleFunction && owner instanceof IrSimpleFunction ? AdditionalIrUtilsKt.overrides((IrSimpleFunction)it, (IrSimpleFunction)owner) || AdditionalIrUtilsKt.overrides((IrSimpleFunction)owner, (IrSimpleFunction)it) : Intrinsics.areEqual(it, symbol2.getOwner());
                    if (!bl11) continue;
                    v1 = element$iv;
                    break block6;
                }
                v1 = null;
            }
            return v1;
        }

        /*
         * WARNING - void declaration
         */
        private static IrClass getThisOrSuperReceiver(Complex this_, IrClass superIrClass) {
            IrClass irClass2;
            if (superIrClass == null) {
                irClass2 = this_.getIrClass();
            } else if (IrUtilsKt.isInterface(superIrClass)) {
                irClass2 = superIrClass;
            } else {
                Object v1;
                block7: {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = this_.getIrClass().getSuperTypes();
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        IrType irType = (IrType)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull((IrType)it);
                        IrClass irClass3 = irClassSymbol == null ? null : (IrClass)irClassSymbol.getOwner();
                        collection.add(irClass3);
                    }
                    Iterable $this$singleOrNull$iv = (List)destination$iv$iv;
                    boolean $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (Object element$iv : $this$singleOrNull$iv) {
                        IrClass it = (IrClass)element$iv;
                        boolean bl = false;
                        IrClass irClass4 = it;
                        if (!(irClass4 == null ? false : !IrUtilsKt.isInterface(irClass4))) continue;
                        if (found$iv) {
                            v1 = null;
                            break block7;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v1 = !found$iv ? null : single$iv;
                }
                irClass2 = v1;
            }
            return irClass2;
        }

        @NotNull
        public static IrSimpleFunction getOverridden(@NotNull Complex this_, @NotNull IrSimpleFunction owner) {
            IrSimpleFunction irSimpleFunction;
            Object v0;
            List it;
            boolean bl;
            Object object;
            block6: {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(owner, "owner");
                Wrapper wrapper = this_.getSuperWrapperClass();
                if (Intrinsics.areEqual(owner.getParent(), wrapper == null ? null : wrapper.getIrClass())) {
                    return owner;
                }
                if (!owner.isFakeOverride() || owner.getBody() != null || IrTypePredicatesKt.isAny(IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass(owner)))) {
                    return owner;
                }
                object = owner.getOverriddenSymbols();
                boolean bl2 = false;
                bl = false;
                it = object;
                boolean bl3 = false;
                Iterable $this$singleOrNull$iv = it;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    IrSimpleFunctionSymbol it2 = (IrSimpleFunctionSymbol)element$iv;
                    boolean bl4 = false;
                    if (!(((IrSimpleFunction)it2.getOwner()).getBody() != null)) continue;
                    if (found$iv) {
                        v0 = null;
                        break block6;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v0 = !found$iv ? null : single$iv;
            }
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = v0;
            IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = irSimpleFunctionSymbol == null ? (IrSimpleFunctionSymbol)CollectionsKt.singleOrNull(it) : irSimpleFunctionSymbol;
            IrSimpleFunction overriddenOwner = irSimpleFunctionSymbol2 == null ? null : (IrSimpleFunction)irSimpleFunctionSymbol2.getOwner();
            object = overriddenOwner;
            if (object == null) {
                irSimpleFunction = null;
            } else {
                Object object2 = object;
                bl = false;
                boolean bl5 = false;
                Object it3 = object2;
                boolean bl6 = false;
                irSimpleFunction = this_.getOverridden((IrSimpleFunction)it3);
            }
            irSimpleFunctionSymbol2 = irSimpleFunction;
            return irSimpleFunctionSymbol2 == null ? (IrSimpleFunction)UtilsKt.getLastOverridden(owner) : irSimpleFunctionSymbol2;
        }

        @Nullable
        public static IrFunction getIrFunctionByIrCall(@NotNull Complex this_, @NotNull IrCall expression2) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Object object = expression2.getSuperQualifierSymbol();
            IrClass irClass2 = DefaultImpls.getThisOrSuperReceiver(this_, object == null ? null : (IrClass)object.getOwner());
            if (irClass2 == null) {
                return null;
            }
            IrClass receiver = irClass2;
            object = DefaultImpls.getIrFunctionFromGivenClass(this_, receiver, expression2.getSymbol());
            if (object == null) {
                return null;
            }
            Object irFunction2 = object;
            return this_.getOverridden((IrSimpleFunction)irFunction2);
        }

        @Nullable
        public static State getField(@NotNull Complex this_, @NotNull IrSymbol symbol2) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(symbol2, "symbol");
            return State.DefaultImpls.getField(this_, symbol2);
        }

        public static void setField(@NotNull Complex this_, @NotNull Variable newVar) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(newVar, "newVar");
            State.DefaultImpls.setField(this_, newVar);
        }
    }
}

