/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils.fileUtils;

import java.io.File;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u00a8\u0006\u0007"}, d2={"descendantRelativeTo", "Ljava/io/File;", "base", "withReplacedExtensionOrNull", "oldExt", "", "newExt", "util"})
public final class FileUtilsKt {
    @Nullable
    public static final File withReplacedExtensionOrNull(@NotNull File $this$withReplacedExtensionOrNull, @NotNull String oldExt, @NotNull String newExt) {
        Intrinsics.checkNotNullParameter($this$withReplacedExtensionOrNull, "<this>");
        Intrinsics.checkNotNullParameter(oldExt, "oldExt");
        Intrinsics.checkNotNullParameter(newExt, "newExt");
        String string2 = $this$withReplacedExtensionOrNull.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "name");
        if (StringsKt.endsWith$default(string2, oldExt, false, 2, null)) {
            String path2 = $this$withReplacedExtensionOrNull.getPath();
            Intrinsics.checkNotNullExpressionValue(path2, "path");
            String string3 = path2;
            int n = 0;
            int n2 = path2.length() - oldExt.length();
            boolean bl = false;
            String string4 = string3.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String pathWithoutExt = string4;
            String pathWithNewExt = Intrinsics.stringPlus(pathWithoutExt, newExt);
            return new File(pathWithNewExt);
        }
        return null;
    }

    @NotNull
    public static final File descendantRelativeTo(@NotNull File $this$descendantRelativeTo, @NotNull File base) {
        Intrinsics.checkNotNullParameter($this$descendantRelativeTo, "<this>");
        Intrinsics.checkNotNullParameter(base, "base");
        boolean bl = base.isAbsolute();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-FileUtilsKt$descendantRelativeTo$32 = false;
            String $i$a$-assert-FileUtilsKt$descendantRelativeTo$32 = String.valueOf(base);
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-FileUtilsKt$descendantRelativeTo$32));
        }
        bl = base.isDirectory();
        bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = String.valueOf(base);
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        File cwd = FilesKt.normalize(base);
        File file2 = $this$descendantRelativeTo.getAbsoluteFile();
        Intrinsics.checkNotNullExpressionValue(file2, "this.absoluteFile");
        File filePath = FilesKt.normalize(file2);
        return FilesKt.startsWith(filePath, cwd) ? FilesKt.relativeTo(filePath, cwd) : $this$descendantRelativeTo;
    }
}

