/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.ir;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.UnsignedType;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.ReferenceSymbolTable;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b,\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b7\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001e\n\u0002\b+\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\r\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u00c0\u0001\u001a\u00020\b2\b\u0010\u00c1\u0001\u001a\u00030\u00c2\u0001H\u0016J\"\u0010\u00c3\u0001\u001a\u00020\u000e2\u0007\u0010\u00c4\u0001\u001a\u00020\u001e2\u0007\u0010\u00c5\u0001\u001a\u00020\u001f2\u0007\u0010\u00c6\u0001\u001a\u00020\u001fJ2\u0010\u00c7\u0001\u001a\u00020\b2\u0007\u0010\u00c4\u0001\u001a\u00020\u001e2\u0018\b\u0002\u0010\u00c8\u0001\u001a\f\u0012\u0007\b\u0001\u0012\u00030\u00ca\u00010\u00c9\u0001\"\u00030\u00ca\u0001H\u0002\u00a2\u0006\u0003\u0010\u00cb\u0001J\u0019\u0010\u00cc\u0001\u001a\u00020\u000e2\u0007\u0010\u00c4\u0001\u001a\u00020\u001e2\u0007\u0010\u00cd\u0001\u001a\u00020\u001fJ\u0007\u0010\u00ce\u0001\u001a\u00020\bJ\u0007\u0010\u00cf\u0001\u001a\u00020\bJ\u0007\u0010\u00d0\u0001\u001a\u00020\bJ\u0007\u0010\u00d1\u0001\u001a\u00020\bJ\u0007\u0010\u00d2\u0001\u001a\u00020\bJ\u0007\u0010\u00d3\u0001\u001a\u00020\bJ\u0013\u0010\u00d4\u0001\u001a\u00020\b2\b\u0010\u00c4\u0001\u001a\u00030\u00ca\u0001H\u0002J\u0015\u0010\u00d5\u0001\u001a\u0004\u0018\u00010\b2\b\u0010\u00c4\u0001\u001a\u00030\u00ca\u0001H\u0002J\u0013\u0010\u00d6\u0001\u001a\u00020\b2\b\u0010\u00c1\u0001\u001a\u00030\u00c2\u0001H\u0016R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR,\u0010\u001b\u001a \u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f0\u001d\u0012\u0004\u0012\u00020\u000e0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010 \u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\nR\u0011\u0010\"\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\nR\u0011\u0010(\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\nR\u0011\u0010*\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010%R\u0011\u0010,\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\nR\u0011\u0010.\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\nR\u0011\u00100\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b1\u0010%R\u0011\u00102\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\nR\u0011\u00104\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\nR\u0011\u00106\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\nR\u0011\u00108\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010\nR\u0011\u0010:\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b;\u0010\nR\u0011\u0010<\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b=\u0010\nR\u0011\u0010>\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b?\u0010\nR\u0011\u0010@\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\bA\u0010\nR\u0011\u0010B\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\bC\u0010%R\u0011\u0010D\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\bE\u0010\u0010R\u0014\u0010F\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u0010HR\u0011\u0010I\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\bJ\u0010\nR\u0011\u0010K\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\bL\u0010\nR\u0011\u0010M\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\bN\u0010%R \u0010O\u001a\u000e\u0012\u0004\u0012\u00020Q\u0012\u0004\u0012\u00020\u000e0PX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u0010SR\u0011\u0010T\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\bU\u0010\nR\u0011\u0010V\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\bW\u0010\nR\u0011\u0010X\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\bY\u0010%R\u0011\u0010Z\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b[\u0010\nR\u0011\u0010\\\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b]\u0010\nR\u0017\u0010^\u001a\b\u0012\u0004\u0012\u00020\b0\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b_\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b`\u0010aR\u0011\u0010b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\bc\u0010\nR\u0011\u0010d\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\be\u0010\nR\u0011\u0010f\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\bg\u0010\nR\u0011\u0010h\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\bi\u0010\nR\u0011\u0010j\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\bk\u0010\nR\u0011\u0010l\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\bm\u0010\nR\u0011\u0010n\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\bo\u0010%R\u0011\u0010p\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\bq\u0010\nR\u0011\u0010r\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\bs\u0010\nR\u0011\u0010t\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\bu\u0010\nR\u0011\u0010v\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\bw\u0010\nR\u0011\u0010x\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\by\u0010\nR\u0011\u0010z\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b{\u0010\nR\u0011\u0010|\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b}\u0010\nR\u0011\u0010~\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u007f\u0010\nR\u0013\u0010\u0080\u0001\u001a\u00020\b8F\u00a2\u0006\u0007\u001a\u0005\b\u0081\u0001\u0010\nR\u0013\u0010\u0082\u0001\u001a\u00020\b8F\u00a2\u0006\u0007\u001a\u0005\b\u0083\u0001\u0010\nR\u0013\u0010\u0084\u0001\u001a\u00020\b8F\u00a2\u0006\u0007\u001a\u0005\b\u0085\u0001\u0010\nR\u0013\u0010\u0086\u0001\u001a\u00020\b8F\u00a2\u0006\u0007\u001a\u0005\b\u0087\u0001\u0010\nR \u0010\u0088\u0001\u001a\u000f\u0012\u0004\u0012\u00020\b\u0012\u0005\u0012\u00030\u0089\u00010P8F\u00a2\u0006\u0007\u001a\u0005\b\u008a\u0001\u0010SR \u0010\u008b\u0001\u001a\u000f\u0012\u0005\u0012\u00030\u0089\u0001\u0012\u0004\u0012\u00020\b0P\u00a2\u0006\t\n\u0000\u001a\u0005\b\u008c\u0001\u0010SR \u0010\u008d\u0001\u001a\u000f\u0012\u0005\u0012\u00030\u0089\u0001\u0012\u0004\u0012\u00020\b0P8F\u00a2\u0006\u0007\u001a\u0005\b\u008e\u0001\u0010SR\u0019\u0010\u008f\u0001\u001a\b\u0012\u0004\u0012\u00020\b0\u0014\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0090\u0001\u0010\u0016R'\u0010\u0091\u0001\u001a\t\u0012\u0004\u0012\u00020\u001f0\u0092\u00018FX\u0086\u0084\u0002\u00a2\u0006\u0010\n\u0006\b\u0095\u0001\u0010\u0096\u0001\u001a\u0006\b\u0093\u0001\u0010\u0094\u0001R\u0019\u0010\u0097\u0001\u001a\b\u0012\u0004\u0012\u00020\b0\u0014\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0098\u0001\u0010\u0016R\u0015\u0010\u0099\u0001\u001a\u0004\u0018\u00010\b\u00a2\u0006\t\n\u0000\u001a\u0005\b\u009a\u0001\u0010\nR\u0013\u0010\u009b\u0001\u001a\u00020\b8F\u00a2\u0006\u0007\u001a\u0005\b\u009c\u0001\u0010\nR\u0013\u0010\u009d\u0001\u001a\u00020\b8F\u00a2\u0006\u0007\u001a\u0005\b\u009e\u0001\u0010\nR\u0013\u0010\u009f\u0001\u001a\u00020\b8F\u00a2\u0006\u0007\u001a\u0005\b\u00a0\u0001\u0010\nR\u0013\u0010\u00a1\u0001\u001a\u00020#8F\u00a2\u0006\u0007\u001a\u0005\b\u00a2\u0001\u0010%R\u0013\u0010\u00a3\u0001\u001a\u00020\b\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00a4\u0001\u0010\nR\u0013\u0010\u00a5\u0001\u001a\u00020\u000e8F\u00a2\u0006\u0007\u001a\u0005\b\u00a6\u0001\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u00a7\u0001\u001a\u000e\u0012\u0004\u0012\u00020Q\u0012\u0004\u0012\u00020\u000e0P\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00a8\u0001\u0010SR\u001f\u0010\u00a9\u0001\u001a\u000e\u0012\u0004\u0012\u00020Q\u0012\u0004\u0012\u00020\u000e0P\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00aa\u0001\u0010SR\u0018\u0010\u00ab\u0001\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00ac\u0001\u0010\nR\u0018\u0010\u00ad\u0001\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00ae\u0001\u0010\nR\u0015\u0010\u00af\u0001\u001a\u0004\u0018\u00010\b\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00b0\u0001\u0010\nR\u0015\u0010\u00b1\u0001\u001a\u0004\u0018\u00010\b\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00b2\u0001\u0010\nR\u0018\u0010\u00b3\u0001\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00b4\u0001\u0010\nR\u0015\u0010\u00b5\u0001\u001a\u0004\u0018\u00010\b\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00b6\u0001\u0010\nR\u0015\u0010\u00b7\u0001\u001a\u0004\u0018\u00010\b\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00b8\u0001\u0010\nR\u0018\u0010\u00b9\u0001\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00ba\u0001\u0010\nR\u0013\u0010\u00bb\u0001\u001a\u00020\b8F\u00a2\u0006\u0007\u001a\u0005\b\u00bc\u0001\u0010\nR \u0010\u00bd\u0001\u001a\u000f\u0012\u0005\u0012\u00030\u00be\u0001\u0012\u0004\u0012\u00020\b0P8F\u00a2\u0006\u0007\u001a\u0005\b\u00bf\u0001\u0010S\u00a8\u0006\u00d7\u0001"}, d2={"Lorg/jetbrains/kotlin/backend/common/ir/BuiltinSymbolsBase;", "", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;", "(Lorg/jetbrains/kotlin/ir/IrBuiltIns;Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;)V", "any", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "getAny", "()Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "array", "getArray", "arrayOf", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "getArrayOf", "()Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "arrayOfNulls", "getArrayOfNulls", "arrays", "", "getArrays", "()Ljava/util/List;", "asserts", "", "getAsserts", "()Ljava/lang/Iterable;", "binaryOperatorCache", "", "Lkotlin/Triple;", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "booleanArray", "getBooleanArray", "booleanArrayType", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "getBooleanArrayType", "()Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "byte", "getByte", "byteArray", "getByteArray", "byteArrayType", "getByteArrayType", "char", "getChar", "charArray", "getCharArray", "charArrayType", "getCharArrayType", "charProgression", "getCharProgression", "charRange", "getCharRange", "charSequence", "getCharSequence", "closedRange", "getClosedRange", "collection", "getCollection", "comparable", "getComparable", "double", "getDouble", "doubleArray", "getDoubleArray", "doubleArrayType", "getDoubleArrayType", "extensionToString", "getExtensionToString", "externalSymbolTable", "getExternalSymbolTable", "()Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;", "float", "getFloat", "floatArray", "getFloatArray", "floatArrayType", "getFloatArrayType", "getProgressionLastElementByReturnType", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "getGetProgressionLastElementByReturnType", "()Ljava/util/Map;", "int", "getInt", "intArray", "getIntArray", "intArrayType", "getIntArrayType", "intProgression", "getIntProgression", "intRange", "getIntRange", "integerClasses", "getIntegerClasses", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "iterable", "getIterable", "iterator", "getIterator", "list", "getList", "listIterator", "getListIterator", "long", "getLong", "longArray", "getLongArray", "longArrayType", "getLongArrayType", "longProgression", "getLongProgression", "longRange", "getLongRange", "map", "getMap", "mapEntry", "getMapEntry", "mutableCollection", "getMutableCollection", "mutableIterable", "getMutableIterable", "mutableIterator", "getMutableIterator", "mutableList", "getMutableList", "mutableListIterator", "getMutableListIterator", "mutableMap", "getMutableMap", "mutableMapEntry", "getMutableMapEntry", "mutableSet", "getMutableSet", "primitiveArraysToPrimitiveTypes", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "getPrimitiveArraysToPrimitiveTypes", "primitiveIteratorsByType", "getPrimitiveIteratorsByType", "primitiveTypesToPrimitiveArrays", "getPrimitiveTypesToPrimitiveArrays", "progressionClasses", "getProgressionClasses", "progressionElementTypes", "", "getProgressionElementTypes", "()Ljava/util/Collection;", "progressionElementTypes$delegate", "Lkotlin/Lazy;", "rangeClasses", "getRangeClasses", "sequence", "getSequence", "set", "getSet", "short", "getShort", "shortArray", "getShortArray", "shortArrayType", "getShortArrayType", "string", "getString", "stringPlus", "getStringPlus", "toUIntByExtensionReceiver", "getToUIntByExtensionReceiver", "toULongByExtensionReceiver", "getToULongByExtensionReceiver", "uByte", "getUByte", "uInt", "getUInt", "uIntProgression", "getUIntProgression", "uIntRange", "getUIntRange", "uLong", "getULong", "uLongProgression", "getULongProgression", "uLongRange", "getULongRange", "uShort", "getUShort", "unit", "getUnit", "unsignedTypesToUnsignedArrays", "Lorg/jetbrains/kotlin/builtins/UnsignedType;", "getUnsignedTypesToUnsignedArrays", "functionN", "n", "", "getBinaryOperator", "name", "lhsType", "rhsType", "getClass", "packageNameSegments", "", "", "(Lorg/jetbrains/kotlin/name/Name;[Ljava/lang/String;)Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "getUnaryOperator", "receiverType", "kmutableproperty0", "kmutableproperty1", "kmutableproperty2", "kproperty0", "kproperty1", "kproperty2", "progression", "progressionOrNull", "suspendFunctionN", "ir.backend.common"})
public class BuiltinSymbolsBase {
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @NotNull
    private final ReferenceSymbolTable symbolTable;
    @NotNull
    private final IrClassSymbol iterator;
    @NotNull
    private final IrClassSymbol charSequence;
    @NotNull
    private final IrClassSymbol string;
    @NotNull
    private final Map<PrimitiveType, IrClassSymbol> primitiveIteratorsByType;
    @NotNull
    private final Iterable<IrSimpleFunctionSymbol> asserts;
    @Nullable
    private final IrClassSymbol uByte;
    @Nullable
    private final IrClassSymbol uShort;
    @Nullable
    private final IrClassSymbol uInt;
    @Nullable
    private final IrClassSymbol uLong;
    @Nullable
    private final IrClassSymbol uIntProgression;
    @Nullable
    private final IrClassSymbol uLongProgression;
    @Nullable
    private final IrClassSymbol uIntRange;
    @Nullable
    private final IrClassSymbol uLongRange;
    @Nullable
    private final IrClassSymbol sequence;
    @NotNull
    private final IrClassSymbol charProgression;
    @NotNull
    private final IrClassSymbol intProgression;
    @NotNull
    private final IrClassSymbol longProgression;
    @NotNull
    private final List<IrClassSymbol> progressionClasses;
    @NotNull
    private final IrClassSymbol charRange;
    @NotNull
    private final IrClassSymbol intRange;
    @NotNull
    private final IrClassSymbol longRange;
    @NotNull
    private final List<IrClassSymbol> rangeClasses;
    @NotNull
    private final IrClassSymbol closedRange;
    @NotNull
    private final Map<IrClassifierSymbol, IrSimpleFunctionSymbol> getProgressionLastElementByReturnType;
    @NotNull
    private final Map<IrClassifierSymbol, IrSimpleFunctionSymbol> toUIntByExtensionReceiver;
    @NotNull
    private final Map<IrClassifierSymbol, IrSimpleFunctionSymbol> toULongByExtensionReceiver;
    @NotNull
    private final List<IrClassSymbol> integerClasses;
    @NotNull
    private final Lazy progressionElementTypes$delegate;
    @NotNull
    private final Map<Triple<Name, IrType, IrType>, IrSimpleFunctionSymbol> binaryOperatorCache;

    /*
     * WARNING - void declaration
     */
    public BuiltinSymbolsBase(@NotNull IrBuiltIns irBuiltIns, @NotNull ReferenceSymbolTable symbolTable) {
        Map map;
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Intrinsics.checkNotNullParameter(irBuiltIns, "irBuiltIns");
        Intrinsics.checkNotNullParameter(symbolTable, "symbolTable");
        this.irBuiltIns = irBuiltIns;
        this.symbolTable = symbolTable;
        Object object = Name.identifier("Iterator");
        Intrinsics.checkNotNullExpressionValue(object, "identifier(\"Iterator\")");
        String[] stringArray = object;
        object = new String[]{"kotlin", "collections"};
        this.iterator = this.getClass((Name)stringArray, (String)object);
        object = Name.identifier("CharSequence");
        Intrinsics.checkNotNullExpressionValue(object, "identifier(\"CharSequence\")");
        String[] stringArray2 = object;
        object = new String[]{"kotlin"};
        this.charSequence = this.getClass((Name)stringArray2, (String)object);
        object = Name.identifier("String");
        Intrinsics.checkNotNullExpressionValue(object, "identifier(\"String\")");
        String[] stringArray3 = object;
        object = new String[]{"kotlin"};
        this.string = this.getClass((Name)stringArray3, (String)object);
        object = PrimitiveType.values();
        BuiltinSymbolsBase builtinSymbolsBase = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(((void)$this$associate$iv).length), 16);
        void var6_7 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (void element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            void type2 = element$iv$iv;
            boolean bl = false;
            String[] stringArray4 = Name.identifier(Intrinsics.stringPlus(type2.getTypeName().asString(), "Iterator"));
            Intrinsics.checkNotNullExpressionValue(stringArray4, "identifier(type.typeName.asString() + \"Iterator\")");
            String[] stringArray5 = stringArray4;
            stringArray4 = new String[]{"kotlin", "collections"};
            IrClassSymbol iteratorClass = this.getClass((Name)stringArray5, stringArray4);
            Pair<void, IrClassSymbol> pair = TuplesKt.to(type2, iteratorClass);
            map2.put(pair.getFirst(), pair.getSecond());
        }
        builtinSymbolsBase.primitiveIteratorsByType = map = destination$iv$iv;
        object = Name.identifier("assert");
        Intrinsics.checkNotNullExpressionValue(object, "identifier(\"assert\")");
        String[] stringArray6 = object;
        object = new String[]{"kotlin"};
        this.asserts = this.irBuiltIns.findFunctions((Name)stringArray6, (String)object);
        object = Name.identifier("UByte");
        Intrinsics.checkNotNullExpressionValue(object, "identifier(\"UByte\")");
        String[] stringArray7 = object;
        object = new String[]{"kotlin"};
        this.uByte = this.irBuiltIns.findClass((Name)stringArray7, (String)object);
        object = Name.identifier("UShort");
        Intrinsics.checkNotNullExpressionValue(object, "identifier(\"UShort\")");
        String[] stringArray8 = object;
        object = new String[]{"kotlin"};
        this.uShort = this.irBuiltIns.findClass((Name)stringArray8, (String)object);
        object = Name.identifier("UInt");
        Intrinsics.checkNotNullExpressionValue(object, "identifier(\"UInt\")");
        String[] stringArray9 = object;
        object = new String[]{"kotlin"};
        this.uInt = this.irBuiltIns.findClass((Name)stringArray9, (String)object);
        object = Name.identifier("ULong");
        Intrinsics.checkNotNullExpressionValue(object, "identifier(\"ULong\")");
        String[] stringArray10 = object;
        object = new String[]{"kotlin"};
        this.uLong = this.irBuiltIns.findClass((Name)stringArray10, (String)object);
        this.uIntProgression = this.progressionOrNull("UIntProgression");
        this.uLongProgression = this.progressionOrNull("ULongProgression");
        this.uIntRange = this.progressionOrNull("UIntRange");
        this.uLongRange = this.progressionOrNull("ULongRange");
        object = Name.identifier("Sequence");
        Intrinsics.checkNotNullExpressionValue(object, "identifier(\"Sequence\")");
        String[] stringArray11 = object;
        object = new String[]{"kotlin", "sequences"};
        this.sequence = this.irBuiltIns.findClass((Name)stringArray11, (String)object);
        this.charProgression = this.progression("CharProgression");
        this.intProgression = this.progression("IntProgression");
        this.longProgression = this.progression("LongProgression");
        object = new IrClassSymbol[]{this.charProgression, this.intProgression, this.longProgression, this.uIntProgression, this.uLongProgression};
        this.progressionClasses = CollectionsKt.listOfNotNull(object);
        this.charRange = this.progression("CharRange");
        this.intRange = this.progression("IntRange");
        this.longRange = this.progression("LongRange");
        object = new IrClassSymbol[]{this.charRange, this.intRange, this.longRange, this.uIntRange, this.uLongRange};
        this.rangeClasses = CollectionsKt.listOfNotNull(object);
        this.closedRange = this.progression("ClosedRange");
        object = Name.identifier("getProgressionLastElement");
        Intrinsics.checkNotNullExpressionValue(object, "identifier(\"getProgressionLastElement\")");
        String[] stringArray12 = object;
        object = new String[]{"kotlin", "internal"};
        this.getProgressionLastElementByReturnType = this.irBuiltIns.getNonBuiltinFunctionsByReturnType((Name)stringArray12, (String)object);
        object = Name.identifier("toUInt");
        Intrinsics.checkNotNullExpressionValue(object, "identifier(\"toUInt\")");
        String[] stringArray13 = object;
        object = new String[]{"kotlin"};
        this.toUIntByExtensionReceiver = this.irBuiltIns.getNonBuiltInFunctionsByExtensionReceiver((Name)stringArray13, (String)object);
        object = Name.identifier("toULong");
        Intrinsics.checkNotNullExpressionValue(object, "identifier(\"toULong\")");
        String[] stringArray14 = object;
        object = new String[]{"kotlin"};
        this.toULongByExtensionReceiver = this.irBuiltIns.getNonBuiltInFunctionsByExtensionReceiver((Name)stringArray14, (String)object);
        object = new IrClassSymbol[]{this.getByte(), this.getShort(), this.getInt(), this.getLong()};
        this.integerClasses = CollectionsKt.listOf(object);
        this.progressionElementTypes$delegate = LazyKt.lazy((Function0)new Function0<List<? extends IrType>>(this){
            final /* synthetic */ BuiltinSymbolsBase this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<IrType> invoke() {
                void $this$mapTo$iv$iv;
                IrClassSymbol[] irClassSymbolArray = new IrClassSymbol[]{this.this$0.getByte(), this.this$0.getShort(), this.this$0.getInt(), this.this$0.getLong(), this.this$0.getChar(), this.this$0.getUByte(), this.this$0.getUShort(), this.this$0.getUInt(), this.this$0.getULong()};
                Iterable $this$map$iv = CollectionsKt.listOfNotNull(irClassSymbolArray);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    IrClassSymbol irClassSymbol = (IrClassSymbol)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    IrType irType = IrTypesKt.getDefaultType((IrClassifierSymbol)it);
                    collection.add(irType);
                }
                return (List)destination$iv$iv;
            }
        });
        this.binaryOperatorCache = new LinkedHashMap();
    }

    @NotNull
    public final IrBuiltIns getIrBuiltIns() {
        return this.irBuiltIns;
    }

    private final IrClassSymbol getClass(Name name, String ... packageNameSegments) {
        IrClassSymbol irClassSymbol = this.irBuiltIns.findClass(name, Arrays.copyOf(packageNameSegments, packageNameSegments.length));
        if (irClassSymbol == null) {
            throw new IllegalStateException(("Class '" + name + "' not found in package '" + ArraysKt.joinToString$default(packageNameSegments, (CharSequence)".", null, null, 0, null, null, 62, null) + '\'').toString());
        }
        return irClassSymbol;
    }

    @NotNull
    public ReferenceSymbolTable getExternalSymbolTable() {
        return this.symbolTable;
    }

    @NotNull
    public final IrClassSymbol getIterator() {
        return this.iterator;
    }

    @NotNull
    public final IrClassSymbol getCharSequence() {
        return this.charSequence;
    }

    @NotNull
    public final IrClassSymbol getString() {
        return this.string;
    }

    @NotNull
    public final Map<PrimitiveType, IrClassSymbol> getPrimitiveIteratorsByType() {
        return this.primitiveIteratorsByType;
    }

    @NotNull
    public final Iterable<IrSimpleFunctionSymbol> getAsserts() {
        return this.asserts;
    }

    private final IrClassSymbol progression(String name) {
        String[] stringArray = Name.identifier(name);
        Intrinsics.checkNotNullExpressionValue(stringArray, "identifier(name)");
        String[] stringArray2 = stringArray;
        stringArray = new String[]{"kotlin", "ranges"};
        return this.getClass((Name)stringArray2, stringArray);
    }

    private final IrClassSymbol progressionOrNull(String name) {
        String[] stringArray = Name.identifier(name);
        Intrinsics.checkNotNullExpressionValue(stringArray, "identifier(name)");
        String[] stringArray2 = stringArray;
        stringArray = new String[]{"kotlin", "ranges"};
        return this.irBuiltIns.findClass((Name)stringArray2, stringArray);
    }

    @Nullable
    public IrClassSymbol getUByte() {
        return this.uByte;
    }

    @Nullable
    public IrClassSymbol getUShort() {
        return this.uShort;
    }

    @Nullable
    public IrClassSymbol getUInt() {
        return this.uInt;
    }

    @Nullable
    public IrClassSymbol getULong() {
        return this.uLong;
    }

    @Nullable
    public final IrClassSymbol getUIntProgression() {
        return this.uIntProgression;
    }

    @Nullable
    public final IrClassSymbol getULongProgression() {
        return this.uLongProgression;
    }

    @Nullable
    public final IrClassSymbol getUIntRange() {
        return this.uIntRange;
    }

    @Nullable
    public final IrClassSymbol getULongRange() {
        return this.uLongRange;
    }

    @Nullable
    public final IrClassSymbol getSequence() {
        return this.sequence;
    }

    @NotNull
    public final IrClassSymbol getCharProgression() {
        return this.charProgression;
    }

    @NotNull
    public final IrClassSymbol getIntProgression() {
        return this.intProgression;
    }

    @NotNull
    public final IrClassSymbol getLongProgression() {
        return this.longProgression;
    }

    @NotNull
    public final List<IrClassSymbol> getProgressionClasses() {
        return this.progressionClasses;
    }

    @NotNull
    public final IrClassSymbol getCharRange() {
        return this.charRange;
    }

    @NotNull
    public final IrClassSymbol getIntRange() {
        return this.intRange;
    }

    @NotNull
    public final IrClassSymbol getLongRange() {
        return this.longRange;
    }

    @NotNull
    public final List<IrClassSymbol> getRangeClasses() {
        return this.rangeClasses;
    }

    @NotNull
    public final IrClassSymbol getClosedRange() {
        return this.closedRange;
    }

    @NotNull
    public Map<IrClassifierSymbol, IrSimpleFunctionSymbol> getGetProgressionLastElementByReturnType() {
        return this.getProgressionLastElementByReturnType;
    }

    @NotNull
    public final Map<IrClassifierSymbol, IrSimpleFunctionSymbol> getToUIntByExtensionReceiver() {
        return this.toUIntByExtensionReceiver;
    }

    @NotNull
    public final Map<IrClassifierSymbol, IrSimpleFunctionSymbol> getToULongByExtensionReceiver() {
        return this.toULongByExtensionReceiver;
    }

    @NotNull
    public final IrClassSymbol getAny() {
        return this.irBuiltIns.getAnyClass();
    }

    @NotNull
    public final IrClassSymbol getUnit() {
        return this.irBuiltIns.getUnitClass();
    }

    @NotNull
    public final IrClassSymbol getChar() {
        return this.irBuiltIns.getCharClass();
    }

    @NotNull
    public final IrClassSymbol getByte() {
        return this.irBuiltIns.getByteClass();
    }

    @NotNull
    public final IrClassSymbol getShort() {
        return this.irBuiltIns.getShortClass();
    }

    @NotNull
    public final IrClassSymbol getInt() {
        return this.irBuiltIns.getIntClass();
    }

    @NotNull
    public final IrClassSymbol getLong() {
        return this.irBuiltIns.getLongClass();
    }

    @NotNull
    public final IrClassSymbol getFloat() {
        return this.irBuiltIns.getFloatClass();
    }

    @NotNull
    public final IrClassSymbol getDouble() {
        return this.irBuiltIns.getDoubleClass();
    }

    @NotNull
    public final List<IrClassSymbol> getIntegerClasses() {
        return this.integerClasses;
    }

    @NotNull
    public final Collection<IrType> getProgressionElementTypes() {
        Lazy lazy = this.progressionElementTypes$delegate;
        Object var2_2 = null;
        return (Collection)lazy.getValue();
    }

    @NotNull
    public final IrSimpleFunctionSymbol getArrayOf() {
        return this.irBuiltIns.getArrayOf();
    }

    @NotNull
    public final IrSimpleFunctionSymbol getArrayOfNulls() {
        return this.irBuiltIns.getArrayOfNulls();
    }

    @NotNull
    public final IrClassSymbol getArray() {
        return this.irBuiltIns.getArrayClass();
    }

    @NotNull
    public final IrClassSymbol getByteArray() {
        return this.irBuiltIns.getByteArray();
    }

    @NotNull
    public final IrClassSymbol getCharArray() {
        return this.irBuiltIns.getCharArray();
    }

    @NotNull
    public final IrClassSymbol getShortArray() {
        return this.irBuiltIns.getShortArray();
    }

    @NotNull
    public final IrClassSymbol getIntArray() {
        return this.irBuiltIns.getIntArray();
    }

    @NotNull
    public final IrClassSymbol getLongArray() {
        return this.irBuiltIns.getLongArray();
    }

    @NotNull
    public final IrClassSymbol getFloatArray() {
        return this.irBuiltIns.getFloatArray();
    }

    @NotNull
    public final IrClassSymbol getDoubleArray() {
        return this.irBuiltIns.getDoubleArray();
    }

    @NotNull
    public final IrClassSymbol getBooleanArray() {
        return this.irBuiltIns.getBooleanArray();
    }

    @NotNull
    public final IrSimpleType getByteArrayType() {
        return IrUtilsKt.getDefaultType((IrClass)this.getByteArray().getOwner());
    }

    @NotNull
    public final IrSimpleType getCharArrayType() {
        return IrUtilsKt.getDefaultType((IrClass)this.getCharArray().getOwner());
    }

    @NotNull
    public final IrSimpleType getShortArrayType() {
        return IrUtilsKt.getDefaultType((IrClass)this.getShortArray().getOwner());
    }

    @NotNull
    public final IrSimpleType getIntArrayType() {
        return IrUtilsKt.getDefaultType((IrClass)this.getIntArray().getOwner());
    }

    @NotNull
    public final IrSimpleType getLongArrayType() {
        return IrUtilsKt.getDefaultType((IrClass)this.getLongArray().getOwner());
    }

    @NotNull
    public final IrSimpleType getFloatArrayType() {
        return IrUtilsKt.getDefaultType((IrClass)this.getFloatArray().getOwner());
    }

    @NotNull
    public final IrSimpleType getDoubleArrayType() {
        return IrUtilsKt.getDefaultType((IrClass)this.getDoubleArray().getOwner());
    }

    @NotNull
    public final IrSimpleType getBooleanArrayType() {
        return IrUtilsKt.getDefaultType((IrClass)this.getBooleanArray().getOwner());
    }

    @NotNull
    public final Map<PrimitiveType, IrClassSymbol> getPrimitiveTypesToPrimitiveArrays() {
        return this.irBuiltIns.getPrimitiveTypesToPrimitiveArrays();
    }

    @NotNull
    public final Map<IrClassSymbol, PrimitiveType> getPrimitiveArraysToPrimitiveTypes() {
        return this.irBuiltIns.getPrimitiveArraysToPrimitiveTypes();
    }

    @NotNull
    public final Map<UnsignedType, IrClassSymbol> getUnsignedTypesToUnsignedArrays() {
        return this.irBuiltIns.getUnsignedTypesToUnsignedArrays();
    }

    @NotNull
    public final List<IrClassSymbol> getArrays() {
        return CollectionsKt.plus((Collection)CollectionsKt.plus(this.getPrimitiveTypesToPrimitiveArrays().values(), (Iterable)this.getUnsignedTypesToUnsignedArrays().values()), this.getArray());
    }

    @NotNull
    public final IrClassSymbol getCollection() {
        return this.irBuiltIns.getCollectionClass();
    }

    @NotNull
    public final IrClassSymbol getSet() {
        return this.irBuiltIns.getSetClass();
    }

    @NotNull
    public final IrClassSymbol getList() {
        return this.irBuiltIns.getListClass();
    }

    @NotNull
    public final IrClassSymbol getMap() {
        return this.irBuiltIns.getMapClass();
    }

    @NotNull
    public final IrClassSymbol getMapEntry() {
        return this.irBuiltIns.getMapEntryClass();
    }

    @NotNull
    public final IrClassSymbol getIterable() {
        return this.irBuiltIns.getIterableClass();
    }

    @NotNull
    public final IrClassSymbol getListIterator() {
        return this.irBuiltIns.getListIteratorClass();
    }

    @NotNull
    public final IrClassSymbol getMutableCollection() {
        return this.irBuiltIns.getMutableCollectionClass();
    }

    @NotNull
    public final IrClassSymbol getMutableSet() {
        return this.irBuiltIns.getMutableSetClass();
    }

    @NotNull
    public final IrClassSymbol getMutableList() {
        return this.irBuiltIns.getMutableListClass();
    }

    @NotNull
    public final IrClassSymbol getMutableMap() {
        return this.irBuiltIns.getMutableMapClass();
    }

    @NotNull
    public final IrClassSymbol getMutableMapEntry() {
        return this.irBuiltIns.getMutableMapEntryClass();
    }

    @NotNull
    public final IrClassSymbol getMutableIterable() {
        return this.irBuiltIns.getMutableIterableClass();
    }

    @NotNull
    public final IrClassSymbol getMutableIterator() {
        return this.irBuiltIns.getMutableIteratorClass();
    }

    @NotNull
    public final IrClassSymbol getMutableListIterator() {
        return this.irBuiltIns.getMutableListIteratorClass();
    }

    @NotNull
    public final IrClassSymbol getComparable() {
        return this.irBuiltIns.getComparableClass();
    }

    @NotNull
    public final IrSimpleFunctionSymbol getBinaryOperator(@NotNull Name name, @NotNull IrType lhsType, @NotNull IrType rhsType) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(lhsType, "lhsType");
        Intrinsics.checkNotNullParameter(rhsType, "rhsType");
        return this.irBuiltIns.getBinaryOperator(name, lhsType, rhsType);
    }

    @NotNull
    public final IrSimpleFunctionSymbol getUnaryOperator(@NotNull Name name, @NotNull IrType receiverType) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(receiverType, "receiverType");
        return this.irBuiltIns.getUnaryOperator(name, receiverType);
    }

    @NotNull
    public IrClassSymbol functionN(int n) {
        return this.irBuiltIns.functionN(n).getSymbol();
    }

    @NotNull
    public IrClassSymbol suspendFunctionN(int n) {
        return this.irBuiltIns.suspendFunctionN(n).getSymbol();
    }

    @NotNull
    public final IrClassSymbol kproperty0() {
        return this.irBuiltIns.getKProperty0Class();
    }

    @NotNull
    public final IrClassSymbol kproperty1() {
        return this.irBuiltIns.getKProperty1Class();
    }

    @NotNull
    public final IrClassSymbol kproperty2() {
        return this.irBuiltIns.getKProperty2Class();
    }

    @NotNull
    public final IrClassSymbol kmutableproperty0() {
        return this.irBuiltIns.getKMutableProperty0Class();
    }

    @NotNull
    public final IrClassSymbol kmutableproperty1() {
        return this.irBuiltIns.getKMutableProperty1Class();
    }

    @NotNull
    public final IrClassSymbol kmutableproperty2() {
        return this.irBuiltIns.getKMutableProperty2Class();
    }

    @NotNull
    public final IrSimpleFunctionSymbol getExtensionToString() {
        return this.irBuiltIns.getExtensionToString();
    }

    @NotNull
    public final IrSimpleFunctionSymbol getStringPlus() {
        return this.irBuiltIns.getStringPlus();
    }
}

