/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.diagnostics;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.PositioningStrategy;
import org.jetbrains.kotlin.fir.FirPsiSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirPsiPositioningStrategy;
import org.jetbrains.kotlin.fir.analysis.diagnostics.LightTreePositioningStrategy;
import org.jetbrains.kotlin.fir.analysis.diagnostics.SourceElementPositioningStrategies;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\b*\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\f*\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/diagnostics/SourceElementPositioningStrategy;", "", "lightTreeStrategy", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/LightTreePositioningStrategy;", "psiStrategy", "Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "(Lorg/jetbrains/kotlin/fir/analysis/diagnostics/LightTreePositioningStrategy;Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;)V", "isValid", "", "element", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "markDiagnostic", "", "Lcom/intellij/openapi/util/TextRange;", "diagnostic", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnostic;", "hackyIsValid", "psi", "Lcom/intellij/psi/PsiElement;", "hackyMark", "Companion", "checkers"})
public final class SourceElementPositioningStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LightTreePositioningStrategy lightTreeStrategy;
    @NotNull
    private final PositioningStrategy<?> psiStrategy;
    @NotNull
    private static final SourceElementPositioningStrategy DEFAULT = SourceElementPositioningStrategies.INSTANCE.getDEFAULT();

    public SourceElementPositioningStrategy(@NotNull LightTreePositioningStrategy lightTreeStrategy, @NotNull PositioningStrategy<?> psiStrategy) {
        Intrinsics.checkNotNullParameter(lightTreeStrategy, "lightTreeStrategy");
        Intrinsics.checkNotNullParameter(psiStrategy, "psiStrategy");
        this.lightTreeStrategy = lightTreeStrategy;
        this.psiStrategy = psiStrategy;
    }

    @NotNull
    public final List<TextRange> markDiagnostic(@NotNull FirDiagnostic diagnostic) {
        Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
        FirSourceElement element = diagnostic.getElement();
        if (element instanceof FirPsiSourceElement) {
            return this.psiStrategy instanceof FirPsiPositioningStrategy ? ((FirPsiPositioningStrategy)this.psiStrategy).markFirDiagnostic(element, diagnostic) : this.hackyMark(this.psiStrategy, ((FirPsiSourceElement)element).getPsi());
        }
        return this.lightTreeStrategy.markFirDiagnostic(element, diagnostic);
    }

    public final boolean isValid(@NotNull FirSourceElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        if (element instanceof FirPsiSourceElement) {
            return this.hackyIsValid(this.psiStrategy, ((FirPsiSourceElement)element).getPsi());
        }
        return this.lightTreeStrategy.isValid(element.getLighterASTNode(), element.getTreeStructure());
    }

    private final List<TextRange> hackyMark(PositioningStrategy<?> $this$hackyMark, PsiElement psi) {
        return $this$hackyMark.mark(psi);
    }

    private final boolean hackyIsValid(PositioningStrategy<?> $this$hackyIsValid, PsiElement psi) {
        return $this$hackyIsValid.isValid(psi);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/diagnostics/SourceElementPositioningStrategy$Companion;", "", "()V", "DEFAULT", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/SourceElementPositioningStrategy;", "getDEFAULT", "()Lorg/jetbrains/kotlin/fir/analysis/diagnostics/SourceElementPositioningStrategy;", "checkers"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SourceElementPositioningStrategy getDEFAULT() {
            return DEFAULT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

