/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.FirAbstractTreeTransformer;
import org.jetbrains.kotlin.fir.scopes.FirCompositeScope;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.ScopesKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirDeclaredMemberScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirMemberTypeParameterScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeWithSubstitutionKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0002H\u0004J\u001a\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0002H\u0016J/\u0010 \u001a\u0002H!\"\u0004\b\u0000\u0010!2\u0006\u0010\u001f\u001a\u00020\n2\u000e\b\u0004\u0010\"\u001a\b\u0012\u0004\u0012\u0002H!0#H\u0084\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$J'\u0010%\u001a\u0002H!\"\u0004\b\u0000\u0010!2\u000e\b\u0004\u0010\"\u001a\b\u0012\u0004\u0012\u0002H!0#H\u0084\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&J\f\u0010'\u001a\u00020(*\u00020)H\u0004R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirAbstractTreeTransformerWithSuperTypes;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirAbstractTreeTransformer;", "", "phase", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "(Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)V", "classDeclarationsStack", "Lkotlin/collections/ArrayDeque;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "getClassDeclarationsStack", "()Lkotlin/collections/ArrayDeque;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "scopes", "", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "getScopes", "()Ljava/util/List;", "towerScope", "Lorg/jetbrains/kotlin/fir/scopes/FirCompositeScope;", "getTowerScope", "()Lorg/jetbrains/kotlin/fir/scopes/FirCompositeScope;", "resolveNestedClassesSupertypes", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "firClass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "data", "transformDeclarationContent", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "declaration", "withClassDeclarationCleanup", "T", "l", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "withScopeCleanup", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "addTypeParametersScope", "", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "resolve"})
public abstract class FirAbstractTreeTransformerWithSuperTypes
extends FirAbstractTreeTransformer<Object> {
    @NotNull
    private final ScopeSession scopeSession;
    @NotNull
    private final List<FirScope> scopes;
    @NotNull
    private final ArrayDeque<FirRegularClass> classDeclarationsStack;
    @NotNull
    private final FirCompositeScope towerScope;

    public FirAbstractTreeTransformerWithSuperTypes(@NotNull FirResolvePhase phase, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter((Object)phase, "phase");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        super(phase);
        this.scopeSession = scopeSession;
        this.scopes = new ArrayList();
        this.classDeclarationsStack = new ArrayDeque();
        this.towerScope = new FirCompositeScope((Iterable<? extends FirScope>)CollectionsKt.asReversedMutable(this.scopes));
    }

    @NotNull
    protected final ScopeSession getScopeSession() {
        return this.scopeSession;
    }

    @NotNull
    protected final List<FirScope> getScopes() {
        return this.scopes;
    }

    @NotNull
    protected final ArrayDeque<FirRegularClass> getClassDeclarationsStack() {
        return this.classDeclarationsStack;
    }

    @NotNull
    protected final FirCompositeScope getTowerScope() {
        return this.towerScope;
    }

    protected final <T> T withScopeCleanup(@NotNull Function0<? extends T> l) {
        int n;
        Intrinsics.checkNotNullParameter(l, "l");
        boolean $i$f$withScopeCleanup = false;
        int sizeBefore = this.scopes.size();
        T result2 = l.invoke();
        int size = this.scopes.size();
        int n2 = n = size >= sizeBefore ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        n = size - sizeBefore;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            int it = n4 = n3++;
            boolean bl = false;
            this.scopes.remove(CollectionsKt.getLastIndex(this.scopes));
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final <T> T withClassDeclarationCleanup(@NotNull FirRegularClass declaration2, @NotNull Function0<? extends T> l) {
        T t;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(l, "l");
        boolean $i$f$withClassDeclarationCleanup = false;
        ArrayDeque classDeclarations$iv = this.classDeclarationsStack;
        boolean $i$f$withClassDeclarationCleanup2 = false;
        classDeclarations$iv.addLast(declaration2);
        try {
            boolean bl = false;
            t = l.invoke();
        }
        catch (Throwable throwable) {
            InlineMarker.finallyStart(1);
            classDeclarations$iv.removeLast();
            InlineMarker.finallyEnd(1);
            throw throwable;
        }
        InlineMarker.finallyStart(2);
        classDeclarations$iv.removeLast();
        InlineMarker.finallyEnd(2);
        return t;
    }

    @NotNull
    protected final FirStatement resolveNestedClassesSupertypes(@NotNull FirClass firClass, @Nullable Object data) {
        int n;
        Object object;
        Object object2;
        Object object3;
        Intrinsics.checkNotNullParameter(firClass, "firClass");
        FirAbstractTreeTransformerWithSuperTypes this_$iv = this;
        boolean $i$f$withScopeCleanup = false;
        int sizeBefore$iv = this_$iv.scopes.size();
        boolean bl = false;
        firClass.transformAnnotations(this, null);
        Object object4 = this.getSession();
        List superTypes2 = CollectionsKt.asReversed(SupertypeUtilsKt.lookupSuperTypes$default(firClass, false, true, (FirSession)object4, null, true, 16, null));
        object4 = superTypes2.iterator();
        while (object4.hasNext()) {
            ConeClassLikeType superType2 = (ConeClassLikeType)object4.next();
            object3 = ScopesKt.getNestedClassifierScope(superType2.getLookupTag(), this.getSession(), this.getScopeSession());
            if (object3 == null) continue;
            object2 = object3;
            FirScope nestedClassifierScope = object2;
            boolean bl2 = false;
            FirScope scope2 = FirNestedClassifierScopeWithSubstitutionKt.wrapNestedClassifierScopeWithSubstitutionForSuperType(nestedClassifierScope, superType2, this.getSession());
            this.getScopes().add(scope2);
        }
        if (firClass instanceof FirRegularClass) {
            this.addTypeParametersScope((FirMemberDeclaration)((Object)firClass));
            FirRegularClass companionObject = ((FirRegularClass)firClass).getCompanionObject();
            if (companionObject != null && (object = FirDeclaredMemberScopeProviderKt.nestedClassifierScope(this.getSession(), companionObject)) != null) {
                object3 = object;
                object2 = this.getScopes();
                FirScope p0 = (FirScope)object3;
                boolean bl3 = false;
                object2.add(p0);
            }
        }
        if ((object4 = FirDeclaredMemberScopeProviderKt.nestedClassifierScope(this.getSession(), firClass)) != null) {
            object = object4;
            object3 = this.getScopes();
            FirScope p0 = (FirScope)object;
            boolean bl4 = false;
            object3.add(p0);
        }
        FirClass result$iv = (FirClass)this.transformDeclarationContent(firClass, data);
        int size$iv = this_$iv.scopes.size();
        int n2 = n = size$iv >= sizeBefore$iv ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        n = size$iv - sizeBefore$iv;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            int it$iv = n4 = n3++;
            boolean bl5 = false;
            this_$iv.scopes.remove(CollectionsKt.getLastIndex(this_$iv.scopes));
        }
        return result$iv;
    }

    protected final void addTypeParametersScope(@NotNull FirMemberDeclaration $this$addTypeParametersScope) {
        Intrinsics.checkNotNullParameter($this$addTypeParametersScope, "<this>");
        if (!((Collection)$this$addTypeParametersScope.getTypeParameters()).isEmpty()) {
            this.scopes.add(new FirMemberTypeParameterScope($this$addTypeParametersScope));
        }
    }

    @NotNull
    public FirDeclaration transformDeclarationContent(@NotNull FirDeclaration declaration2, @Nullable Object data) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        return (FirDeclaration)this.transformElement((FirElement)declaration2, data);
    }
}

