/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers.plugin;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnnotatedDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.extensions.FirExtensionServiceKt;
import org.jetbrains.kotlin.fir.extensions.FirPredicateBasedProvider;
import org.jetbrains.kotlin.fir.extensions.FirPredicateBasedProviderKt;
import org.jetbrains.kotlin.fir.extensions.FirStatusTransformerExtension;
import org.jetbrains.kotlin.fir.extensions.FirStatusTransformerExtensionKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.transformers.FirTransformerBasedResolveProcessor;
import org.jetbrains.kotlin.fir.resolve.transformers.plugin.ReplaceStatus;
import org.jetbrains.kotlin.fir.visitors.FirDefaultTransformer;
import org.jetbrains.kotlin.fir.visitors.FirTransformer;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u001c\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/FirTransformerBasedExtensionStatusProcessor;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirTransformerBasedResolveProcessor;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)V", "transformer", "Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;", "", "getTransformer", "()Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;", "StatusUpdater", "resolve"})
public final class FirTransformerBasedExtensionStatusProcessor
extends FirTransformerBasedResolveProcessor {
    @NotNull
    private final FirTransformer transformer;

    public FirTransformerBasedExtensionStatusProcessor(@NotNull FirSession session2, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        super(session2, scopeSession);
        this.transformer = new StatusUpdater();
    }

    @Override
    @NotNull
    public FirTransformer getTransformer() {
        return this.transformer;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0016J)\u0010\r\u001a\u0002H\u000e\"\b\b\u0000\u0010\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u0002H\u000e2\b\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\b\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\b\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\b\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\b\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\b\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0016J\f\u0010%\u001a\u00020&*\u00020'H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/FirTransformerBasedExtensionStatusProcessor$StatusUpdater;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultTransformer;", "", "(Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/FirTransformerBasedExtensionStatusProcessor;)V", "extensions", "", "Lorg/jetbrains/kotlin/fir/extensions/FirStatusTransformerExtension;", "predicateBasedProvider", "Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProvider;", "transformConstructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "constructor", "data", "transformElement", "E", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Void;)Lorg/jetbrains/kotlin/fir/FirElement;", "transformEnumEntry", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "enumEntry", "transformField", "Lorg/jetbrains/kotlin/fir/declarations/FirField;", "field", "transformProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "property", "transformRegularClass", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "transformSimpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "simpleFunction", "transformTypeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "typeAlias", "updateStatus", "", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "resolve"})
    private final class StatusUpdater
    extends FirDefaultTransformer {
        @NotNull
        private final List<FirStatusTransformerExtension> extensions;
        @NotNull
        private final FirPredicateBasedProvider predicateBasedProvider;

        public StatusUpdater() {
            Intrinsics.checkNotNullParameter(FirTransformerBasedExtensionStatusProcessor.this, "this$0");
            this.extensions = FirStatusTransformerExtensionKt.getStatusTransformerExtensions(FirExtensionServiceKt.getExtensionService(FirTransformerBasedExtensionStatusProcessor.this.getSession()));
            this.predicateBasedProvider = FirPredicateBasedProviderKt.getPredicateBasedProvider(FirTransformerBasedExtensionStatusProcessor.this.getSession());
        }

        private final void updateStatus(FirMemberDeclaration $this$updateStatus) {
            if (this.extensions.isEmpty()) {
                return;
            }
            List<FirAnnotatedDeclaration> owners = this.predicateBasedProvider.getOwnersOfDeclaration((FirAnnotatedDeclaration)((Object)$this$updateStatus));
            if (owners == null) {
                String string2 = "Required value was null.";
                throw new IllegalArgumentException(string2.toString());
            }
            FirDeclarationStatus status2 = $this$updateStatus.getStatus();
            for (FirStatusTransformerExtension extension : this.extensions) {
                status2 = extension.transformStatus((FirDeclaration)((Object)$this$updateStatus), owners, status2);
            }
            $this$updateStatus.transformStatus(ReplaceStatus.INSTANCE, status2);
        }

        @Override
        @NotNull
        public <E extends FirElement> E transformElement(@NotNull E element, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(element, "element");
            return element;
        }

        @NotNull
        public FirTypeAlias transformTypeAlias(@NotNull FirTypeAlias typeAlias, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(typeAlias, "typeAlias");
            this.updateStatus(typeAlias);
            return typeAlias;
        }

        @Override
        @NotNull
        public FirStatement transformRegularClass(@NotNull FirRegularClass regularClass, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(regularClass, "regularClass");
            this.updateStatus(regularClass);
            regularClass.transformDeclarations(this, data);
            return regularClass;
        }

        @NotNull
        public FirConstructor transformConstructor(@NotNull FirConstructor constructor2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(constructor2, "constructor");
            this.updateStatus(constructor2);
            return constructor2;
        }

        @NotNull
        public FirProperty transformProperty(@NotNull FirProperty property2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(property2, "property");
            this.updateStatus(property2);
            property2.transformGetter(this, data);
            property2.transformSetter(this, data);
            return property2;
        }

        @NotNull
        public FirField transformField(@NotNull FirField field2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(field2, "field");
            this.updateStatus(field2);
            return field2;
        }

        @NotNull
        public FirEnumEntry transformEnumEntry(@NotNull FirEnumEntry enumEntry, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(enumEntry, "enumEntry");
            this.updateStatus(enumEntry);
            return enumEntry;
        }

        @NotNull
        public FirSimpleFunction transformSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(simpleFunction, "simpleFunction");
            this.updateStatus(simpleFunction);
            return simpleFunction;
        }
    }
}

