/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\u001a\u001e\u0010\u001c\u001a\u00020\b*\u00020\u00042\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u001e\u001a0\u0010\u001c\u001a\u00020\b*\u00020\u00042\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u001e2\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010 H\u0002\u001a\u001a\u0010!\u001a\u00020\b*\u00020\u00042\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u001a#\u0010#\u001a\u00020\b*\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00022\b\u0010\u0012\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0002\u0010$\u001a\n\u0010%\u001a\u00020&*\u00020&\u001a\u0012\u0010'\u001a\u00020(*\u00020\u00042\u0006\u0010)\u001a\u00020*\u001a\u001f\u0010+\u001a\u00020&*\u00020&2\u000e\u0010,\u001a\n\u0012\u0006\b\u0001\u0012\u00020(0-\u00a2\u0006\u0002\u0010.\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0003\u001a\u0004\u0018\u00010\u0002*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0015\u0010\u0007\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\t\"\u0015\u0010\n\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\t\"\u0015\u0010\u000b\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\"\u0015\u0010\f\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\t\"\u0015\u0010\r\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\t\"\u0015\u0010\u000e\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\t\"\u0015\u0010\u000f\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\t\"\u0015\u0010\u0010\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\t\"\u0015\u0010\u0011\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\t\"\u0015\u0010\u0012\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\t\"\u0015\u0010\u0013\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\t\"\u0015\u0010\u0014\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\t\"\u0015\u0010\u0015\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\t\"\u0015\u0010\u0016\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\t\"\u0015\u0010\u0017\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\t\"\u0015\u0010\u0018\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\t\"\u0015\u0010\u0019\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\t\"\u0015\u0010\u001a\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\t\"\u0015\u0010\u001b\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\t\u00a8\u0006/"}, d2={"builtinIntegerTypes", "", "Lorg/jetbrains/kotlin/name/ClassId;", "classId", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getClassId", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Lorg/jetbrains/kotlin/name/ClassId;", "isAny", "", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Z", "isArrayType", "isBoolean", "isBooleanOrNullableBoolean", "isEnum", "isIntegerTypeOrNullableIntegerTypeOfAnySize", "isMarkedNullable", "isNonPrimitiveArray", "isNothing", "isNullable", "isNullableAny", "isNullableNothing", "isPrimitive", "isPrimitiveArray", "isPrimitiveOrNullablePrimitive", "isString", "isUnit", "isUnsignedType", "isUnsignedTypeOrNullableUnsignedType", "contains", "predicate", "Lkotlin/Function1;", "visited", "Lorg/jetbrains/kotlin/utils/SmartSet;", "isAnyOfBuiltinType", "classIds", "isBuiltinType", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/name/ClassId;Ljava/lang/Boolean;)Z", "replaceArgumentsWithStarProjections", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "toTypeProjection", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "variance", "Lorg/jetbrains/kotlin/types/Variance;", "withArguments", "typeArguments", "", "(Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;[Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;)Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "cones"})
public final class ConeTypeUtilsKt {
    @NotNull
    private static final Set<ClassId> builtinIntegerTypes;

    public static final boolean isNullable(@NotNull ConeKotlinType $this$isNullable) {
        Intrinsics.checkNotNullParameter($this$isNullable, "<this>");
        return $this$isNullable.getNullability() != ConeNullability.NOT_NULL;
    }

    public static final boolean isMarkedNullable(@NotNull ConeKotlinType $this$isMarkedNullable) {
        Intrinsics.checkNotNullParameter($this$isMarkedNullable, "<this>");
        return $this$isMarkedNullable.getNullability() == ConeNullability.NULLABLE;
    }

    @Nullable
    public static final ClassId getClassId(@NotNull ConeKotlinType $this$classId) {
        ClassId classId;
        ConeClassLikeType coneClassLikeType;
        Intrinsics.checkNotNullParameter($this$classId, "<this>");
        ConeKotlinType $this$safeAs$iv = $this$classId;
        boolean $i$f$safeAs = false;
        ConeKotlinType coneKotlinType = $this$safeAs$iv;
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        if ((coneClassLikeType = (ConeClassLikeType)coneKotlinType) == null) {
            classId = null;
        } else {
            ConeClassLikeLookupTag coneClassLikeLookupTag = coneClassLikeType.getLookupTag();
            classId = coneClassLikeLookupTag.getClassId();
        }
        return classId;
    }

    public static final boolean contains(@NotNull ConeKotlinType $this$contains, @NotNull Function1<? super ConeKotlinType, Boolean> predicate) {
        Intrinsics.checkNotNullParameter($this$contains, "<this>");
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        return ConeTypeUtilsKt.contains($this$contains, predicate, null);
    }

    private static final boolean contains(ConeKotlinType $this$contains, Function1<? super ConeKotlinType, Boolean> predicate, SmartSet<ConeKotlinType> visited2) {
        boolean bl;
        block12: {
            SmartSet<ConeKotlinType> smartSet = visited2;
            if (smartSet == null ? false : smartSet.contains($this$contains)) {
                return false;
            }
            if (predicate.invoke($this$contains).booleanValue()) {
                return true;
            }
            SmartSet<ConeKotlinType> smartSet2 = visited2;
            SmartSet<ConeKotlinType> visited3 = smartSet2 == null ? SmartSet.Companion.create() : smartSet2;
            smartSet2 = visited3;
            smartSet2.add($this$contains);
            smartSet2 = $this$contains;
            if (smartSet2 instanceof ConeFlexibleType) {
                bl = ConeTypeUtilsKt.contains(((ConeFlexibleType)$this$contains).getLowerBound(), predicate, visited3) || ConeTypeUtilsKt.contains(((ConeFlexibleType)$this$contains).getUpperBound(), predicate, visited3);
            } else if (smartSet2 instanceof ConeDefinitelyNotNullType) {
                bl = ConeTypeUtilsKt.contains(((ConeDefinitelyNotNullType)$this$contains).getOriginal(), predicate, visited3);
            } else if (smartSet2 instanceof ConeIntersectionType) {
                Iterable $this$any$iv = ((ConeIntersectionType)$this$contains).getIntersectedTypes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ConeKotlinType it = (ConeKotlinType)element$iv;
                        boolean bl2 = false;
                        if (!ConeTypeUtilsKt.contains(it, predicate, visited3)) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
            } else {
                ConeTypeProjection[] $this$any$iv = $this$contains.getTypeArguments();
                boolean $i$f$any = false;
                for (ConeTypeProjection element$iv : $this$any$iv) {
                    ConeTypeProjection it = element$iv;
                    boolean bl3 = false;
                    if (!(it instanceof ConeKotlinTypeProjection && ConeTypeUtilsKt.contains(((ConeKotlinTypeProjection)it).getType(), predicate, visited3))) continue;
                    bl = true;
                    break block12;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public static final ConeClassLikeType withArguments(@NotNull ConeClassLikeType $this$withArguments, @NotNull ConeTypeProjection[] typeArguments2) {
        ConeClassLikeType coneClassLikeType;
        Intrinsics.checkNotNullParameter($this$withArguments, "<this>");
        Intrinsics.checkNotNullParameter(typeArguments2, "typeArguments");
        ConeClassLikeType coneClassLikeType2 = $this$withArguments;
        if (coneClassLikeType2 instanceof ConeClassLikeTypeImpl) {
            coneClassLikeType = new ConeClassLikeTypeImpl($this$withArguments.getLookupTag(), typeArguments2, ConeTypeUtilsKt.isNullable($this$withArguments), $this$withArguments.getAttributes());
        } else if (coneClassLikeType2 instanceof ConeClassErrorType) {
            coneClassLikeType = $this$withArguments;
        } else {
            throw new IllegalStateException(Intrinsics.stringPlus("Unknown cone type: ", Reflection.getOrCreateKotlinClass($this$withArguments.getClass())).toString());
        }
        return coneClassLikeType;
    }

    @NotNull
    public static final ConeTypeProjection toTypeProjection(@NotNull ConeKotlinType $this$toTypeProjection, @NotNull Variance variance) {
        ConeTypeProjection coneTypeProjection;
        Intrinsics.checkNotNullParameter($this$toTypeProjection, "<this>");
        Intrinsics.checkNotNullParameter((Object)variance, "variance");
        Variance variance2 = variance;
        int n = WhenMappings.$EnumSwitchMapping$0[variance2.ordinal()];
        switch (n) {
            case 1: {
                coneTypeProjection = $this$toTypeProjection;
                break;
            }
            case 2: {
                coneTypeProjection = new ConeKotlinTypeProjectionIn($this$toTypeProjection);
                break;
            }
            case 3: {
                coneTypeProjection = new ConeKotlinTypeProjectionOut($this$toTypeProjection);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return coneTypeProjection;
    }

    @NotNull
    public static final ConeClassLikeType replaceArgumentsWithStarProjections(@NotNull ConeClassLikeType $this$replaceArgumentsWithStarProjections) {
        Intrinsics.checkNotNullParameter($this$replaceArgumentsWithStarProjections, "<this>");
        if ($this$replaceArgumentsWithStarProjections.getTypeArguments().length == 0) {
            return $this$replaceArgumentsWithStarProjections;
        }
        int n = 0;
        int n2 = $this$replaceArgumentsWithStarProjections.getTypeArguments().length;
        ConeStarProjection[] coneStarProjectionArray = new ConeStarProjection[n2];
        while (n < n2) {
            int n3 = n++;
            coneStarProjectionArray[n3] = ConeStarProjection.INSTANCE;
        }
        ConeStarProjection[] newArguments2 = coneStarProjectionArray;
        return ConeTypeUtilsKt.withArguments($this$replaceArgumentsWithStarProjections, newArguments2);
    }

    public static final boolean isAny(@NotNull ConeKotlinType $this$isAny) {
        Intrinsics.checkNotNullParameter($this$isAny, "<this>");
        return ConeTypeUtilsKt.isBuiltinType($this$isAny, StandardClassIds.INSTANCE.getAny(), false);
    }

    public static final boolean isNullableAny(@NotNull ConeKotlinType $this$isNullableAny) {
        Intrinsics.checkNotNullParameter($this$isNullableAny, "<this>");
        return ConeTypeUtilsKt.isBuiltinType($this$isNullableAny, StandardClassIds.INSTANCE.getAny(), true);
    }

    public static final boolean isNothing(@NotNull ConeKotlinType $this$isNothing) {
        Intrinsics.checkNotNullParameter($this$isNothing, "<this>");
        return ConeTypeUtilsKt.isBuiltinType($this$isNothing, StandardClassIds.INSTANCE.getNothing(), false);
    }

    public static final boolean isNullableNothing(@NotNull ConeKotlinType $this$isNullableNothing) {
        Intrinsics.checkNotNullParameter($this$isNullableNothing, "<this>");
        return ConeTypeUtilsKt.isBuiltinType($this$isNullableNothing, StandardClassIds.INSTANCE.getNothing(), true);
    }

    public static final boolean isUnit(@NotNull ConeKotlinType $this$isUnit) {
        Intrinsics.checkNotNullParameter($this$isUnit, "<this>");
        return ConeTypeUtilsKt.isBuiltinType($this$isUnit, StandardClassIds.INSTANCE.getUnit(), false);
    }

    public static final boolean isBoolean(@NotNull ConeKotlinType $this$isBoolean) {
        Intrinsics.checkNotNullParameter($this$isBoolean, "<this>");
        return ConeTypeUtilsKt.isBuiltinType($this$isBoolean, StandardClassIds.INSTANCE.getBoolean(), false);
    }

    public static final boolean isBooleanOrNullableBoolean(@NotNull ConeKotlinType $this$isBooleanOrNullableBoolean) {
        Intrinsics.checkNotNullParameter($this$isBooleanOrNullableBoolean, "<this>");
        return ConeTypeUtilsKt.isAnyOfBuiltinType($this$isBooleanOrNullableBoolean, SetsKt.setOf(StandardClassIds.INSTANCE.getBoolean()));
    }

    public static final boolean isEnum(@NotNull ConeKotlinType $this$isEnum) {
        Intrinsics.checkNotNullParameter($this$isEnum, "<this>");
        return ConeTypeUtilsKt.isBuiltinType($this$isEnum, StandardClassIds.INSTANCE.getEnum(), false);
    }

    public static final boolean isString(@NotNull ConeKotlinType $this$isString) {
        Intrinsics.checkNotNullParameter($this$isString, "<this>");
        return ConeTypeUtilsKt.isBuiltinType($this$isString, StandardClassIds.INSTANCE.getString(), false);
    }

    public static final boolean isPrimitiveOrNullablePrimitive(@NotNull ConeKotlinType $this$isPrimitiveOrNullablePrimitive) {
        Intrinsics.checkNotNullParameter($this$isPrimitiveOrNullablePrimitive, "<this>");
        return ConeTypeUtilsKt.isAnyOfBuiltinType($this$isPrimitiveOrNullablePrimitive, StandardClassIds.INSTANCE.getPrimitiveTypes());
    }

    public static final boolean isPrimitive(@NotNull ConeKotlinType $this$isPrimitive) {
        Intrinsics.checkNotNullParameter($this$isPrimitive, "<this>");
        return ConeTypeUtilsKt.isPrimitiveOrNullablePrimitive($this$isPrimitive) && $this$isPrimitive.getNullability() == ConeNullability.NOT_NULL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isArrayType(@NotNull ConeKotlinType $this$isArrayType) {
        ClassId it;
        Intrinsics.checkNotNullParameter($this$isArrayType, "<this>");
        if (ConeTypeUtilsKt.isBuiltinType($this$isArrayType, StandardClassIds.INSTANCE.getArray(), false)) return true;
        Iterable $this$any$iv = StandardClassIds.INSTANCE.getPrimitiveArrayTypeByElementType().values();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (ClassId)element$iv;
            boolean bl = false;
        } while (!ConeTypeUtilsKt.isBuiltinType($this$isArrayType, it, false));
        return true;
    }

    public static final boolean isNonPrimitiveArray(@NotNull ConeKotlinType $this$isNonPrimitiveArray) {
        Intrinsics.checkNotNullParameter($this$isNonPrimitiveArray, "<this>");
        return $this$isNonPrimitiveArray instanceof ConeClassLikeType && Intrinsics.areEqual(((ConeClassLikeType)$this$isNonPrimitiveArray).getLookupTag().getClassId(), StandardClassIds.INSTANCE.getArray());
    }

    public static final boolean isPrimitiveArray(@NotNull ConeKotlinType $this$isPrimitiveArray) {
        Intrinsics.checkNotNullParameter($this$isPrimitiveArray, "<this>");
        return $this$isPrimitiveArray instanceof ConeClassLikeType && StandardClassIds.INSTANCE.getPrimitiveArrayTypeByElementType().values().contains(((ConeClassLikeType)$this$isPrimitiveArray).getLookupTag().getClassId());
    }

    public static final boolean isUnsignedTypeOrNullableUnsignedType(@NotNull ConeKotlinType $this$isUnsignedTypeOrNullableUnsignedType) {
        Intrinsics.checkNotNullParameter($this$isUnsignedTypeOrNullableUnsignedType, "<this>");
        return ConeTypeUtilsKt.isAnyOfBuiltinType($this$isUnsignedTypeOrNullableUnsignedType, StandardClassIds.INSTANCE.getUnsignedTypes());
    }

    public static final boolean isUnsignedType(@NotNull ConeKotlinType $this$isUnsignedType) {
        Intrinsics.checkNotNullParameter($this$isUnsignedType, "<this>");
        return ConeTypeUtilsKt.isUnsignedTypeOrNullableUnsignedType($this$isUnsignedType) && $this$isUnsignedType.getNullability() == ConeNullability.NOT_NULL;
    }

    public static final boolean isIntegerTypeOrNullableIntegerTypeOfAnySize(@NotNull ConeKotlinType $this$isIntegerTypeOrNullableIntegerTypeOfAnySize) {
        Intrinsics.checkNotNullParameter($this$isIntegerTypeOrNullableIntegerTypeOfAnySize, "<this>");
        return ConeTypeUtilsKt.isAnyOfBuiltinType($this$isIntegerTypeOrNullableIntegerTypeOfAnySize, builtinIntegerTypes);
    }

    private static final boolean isBuiltinType(ConeKotlinType $this$isBuiltinType, ClassId classId, Boolean isNullable) {
        if (!($this$isBuiltinType instanceof ConeClassLikeType)) {
            return false;
        }
        return Intrinsics.areEqual(((ConeClassLikeType)$this$isBuiltinType).getLookupTag().getClassId(), classId) && (isNullable == null || Intrinsics.areEqual(ConeTypeUtilsKt.isNullable($this$isBuiltinType.getType()), isNullable));
    }

    private static final boolean isAnyOfBuiltinType(ConeKotlinType $this$isAnyOfBuiltinType, Set<ClassId> classIds) {
        if (!($this$isAnyOfBuiltinType instanceof ConeClassLikeType)) {
            return false;
        }
        return classIds.contains(((ConeClassLikeType)$this$isAnyOfBuiltinType).getLookupTag().getClassId());
    }

    static {
        ClassId[] classIdArray = new ClassId[]{StandardClassIds.INSTANCE.getInt(), StandardClassIds.INSTANCE.getByte(), StandardClassIds.INSTANCE.getLong(), StandardClassIds.INSTANCE.getShort()};
        builtinIntegerTypes = SetsKt.setOf(classIdArray);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Variance.values().length];
            nArray[Variance.INVARIANT.ordinal()] = 1;
            nArray[Variance.IN_VARIANCE.ordinal()] = 2;
            nArray[Variance.OUT_VARIANCE.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

