/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.Substitutable;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.AnnotationsKt;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.SinceKotlinAccessibility;
import org.jetbrains.kotlin.resolve.SinceKotlinValue;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForTypeAliasObject;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\t\u001a\u0004\u0018\u00010\u0001*\u00020\u0006H\u0002\u001a\u0012\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b*\u00020\u0006H\u0002\u00a8\u0006\r"}, d2={"getSinceKotlinVersionByOverridden", "Lorg/jetbrains/kotlin/resolve/SinceKotlinValue;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "checkSinceKotlinVersionAccessibility", "Lorg/jetbrains/kotlin/resolve/SinceKotlinAccessibility;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getOwnSinceKotlinVersion", "loadWasExperimentalMarkerClasses", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "frontend"})
public final class SinceKotlinUtilKt {
    @NotNull
    public static final SinceKotlinAccessibility checkSinceKotlinVersionAccessibility(@NotNull DeclarationDescriptor $this$checkSinceKotlinVersionAccessibility, @NotNull LanguageVersionSettings languageVersionSettings) {
        ApiVersion version;
        SinceKotlinValue value2;
        Intrinsics.checkNotNullParameter($this$checkSinceKotlinVersionAccessibility, "<this>");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        SinceKotlinValue sinceKotlinValue = value2 = $this$checkSinceKotlinVersionAccessibility instanceof CallableMemberDescriptor && !((CallableMemberDescriptor)$this$checkSinceKotlinVersionAccessibility).getKind().isReal() ? SinceKotlinUtilKt.getSinceKotlinVersionByOverridden((CallableMemberDescriptor)$this$checkSinceKotlinVersionAccessibility) : SinceKotlinUtilKt.getOwnSinceKotlinVersion($this$checkSinceKotlinVersionAccessibility);
        ApiVersion apiVersion = version = sinceKotlinValue == null ? null : sinceKotlinValue.getApiVersion();
        if (version == null || version.compareTo(languageVersionSettings.getApiVersion()) <= 0) {
            return SinceKotlinAccessibility.Accessible.INSTANCE;
        }
        List<ClassDescriptor> wasExperimentalFqNames = value2.getWasExperimentalMarkerClasses();
        if (!((Collection)wasExperimentalFqNames).isEmpty()) {
            return new SinceKotlinAccessibility.NotAccessibleButWasExperimental(version, wasExperimentalFqNames);
        }
        return new SinceKotlinAccessibility.NotAccessible(version);
    }

    /*
     * WARNING - void declaration
     */
    private static final SinceKotlinValue getSinceKotlinVersionByOverridden(CallableMemberDescriptor descriptor2) {
        Object v0;
        void $this$mapTo$iv$iv;
        Set<CallableMemberDescriptor> set = DescriptorUtils.getAllOverriddenDeclarations(descriptor2);
        Intrinsics.checkNotNullExpressionValue(set, "getAllOverriddenDeclarations(descriptor)");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            SinceKotlinValue sinceKotlinValue = SinceKotlinUtilKt.getOwnSinceKotlinVersion((DeclarationDescriptor)it);
            if (sinceKotlinValue == null) {
                return null;
            }
            SinceKotlinValue sinceKotlinValue2 = sinceKotlinValue;
            collection.add(sinceKotlinValue2);
        }
        Iterable $this$minByOrNull$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                SinceKotlinValue it = (SinceKotlinValue)minElem$iv;
                boolean bl = false;
                Comparable minValue$iv = it.getApiVersion();
                do {
                    Object e$iv = iterator$iv.next();
                    SinceKotlinValue it2 = (SinceKotlinValue)e$iv;
                    $i$a$-minByOrNull-SinceKotlinUtilKt$getSinceKotlinVersionByOverridden$2 = false;
                    Comparable v$iv = it2.getApiVersion();
                    if (minValue$iv.compareTo(v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        return v0;
    }

    private static final SinceKotlinValue getOwnSinceKotlinVersion(DeclarationDescriptor $this$getOwnSinceKotlinVersion) {
        Substitutable<ClassifierDescriptorWithTypeParameters> typeAlias;
        Substitutable<ClassifierDescriptorWithTypeParameters> substitutable;
        Substitutable<CallableDescriptor> substitutable2;
        Substitutable<ClassifierDescriptorWithTypeParameters> substitutable3;
        FunctionDescriptor functionDescriptor;
        Ref.ObjectRef<SinceKotlinValue> result2 = new Ref.ObjectRef<SinceKotlinValue>();
        SinceKotlinUtilKt.getOwnSinceKotlinVersion$consider($this$getOwnSinceKotlinVersion, result2);
        FunctionDescriptor functionDescriptor2 = functionDescriptor = $this$getOwnSinceKotlinVersion instanceof ConstructorDescriptor ? (ConstructorDescriptor)$this$getOwnSinceKotlinVersion : null;
        if (functionDescriptor != null) {
            substitutable3 = functionDescriptor.getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue(substitutable3, "containingDeclaration");
            SinceKotlinUtilKt.getOwnSinceKotlinVersion$consider((DeclarationDescriptor)((Object)substitutable3), result2);
        }
        FunctionDescriptor functionDescriptor3 = functionDescriptor = $this$getOwnSinceKotlinVersion instanceof PropertyAccessorDescriptor ? (PropertyAccessorDescriptor)$this$getOwnSinceKotlinVersion : null;
        if (functionDescriptor != null) {
            substitutable3 = functionDescriptor.getCorrespondingProperty();
            Intrinsics.checkNotNullExpressionValue(substitutable3, "correspondingProperty");
            SinceKotlinUtilKt.getOwnSinceKotlinVersion$consider((DeclarationDescriptor)((Object)substitutable3), result2);
        }
        Substitutable<ClassifierDescriptorWithTypeParameters> substitutable4 = substitutable3 = $this$getOwnSinceKotlinVersion instanceof TypeAliasDescriptor ? (TypeAliasDescriptor)$this$getOwnSinceKotlinVersion : null;
        if (substitutable3 == null) {
            TypeAliasConstructorDescriptor typeAliasConstructorDescriptor = substitutable2 = $this$getOwnSinceKotlinVersion instanceof TypeAliasConstructorDescriptor ? (TypeAliasConstructorDescriptor)$this$getOwnSinceKotlinVersion : null;
            if (substitutable2 == null) {
                FakeCallableDescriptorForTypeAliasObject fakeCallableDescriptorForTypeAliasObject;
                FakeCallableDescriptorForTypeAliasObject fakeCallableDescriptorForTypeAliasObject2 = fakeCallableDescriptorForTypeAliasObject = $this$getOwnSinceKotlinVersion instanceof FakeCallableDescriptorForTypeAliasObject ? (FakeCallableDescriptorForTypeAliasObject)$this$getOwnSinceKotlinVersion : null;
                substitutable = fakeCallableDescriptorForTypeAliasObject == null ? null : fakeCallableDescriptorForTypeAliasObject.getTypeAliasDescriptor();
            } else {
                substitutable = substitutable2.getTypeAliasDescriptor();
            }
        } else {
            substitutable = substitutable3;
        }
        substitutable3 = typeAlias = substitutable;
        if (substitutable3 != null) {
            SinceKotlinUtilKt.getOwnSinceKotlinVersion$consider((DeclarationDescriptor)((Object)substitutable3), result2);
        }
        substitutable3 = typeAlias;
        if (substitutable3 != null && (substitutable2 = substitutable3.getClassDescriptor()) != null) {
            SinceKotlinUtilKt.getOwnSinceKotlinVersion$consider(substitutable2, result2);
        }
        Substitutable<CallableDescriptor> substitutable5 = substitutable3 = $this$getOwnSinceKotlinVersion instanceof TypeAliasConstructorDescriptor ? (TypeAliasConstructorDescriptor)$this$getOwnSinceKotlinVersion : null;
        if (substitutable3 != null) {
            substitutable2 = substitutable3.getUnderlyingConstructorDescriptor();
            SinceKotlinUtilKt.getOwnSinceKotlinVersion$consider(substitutable2, result2);
        }
        DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility = substitutable3 = $this$getOwnSinceKotlinVersion instanceof FakeCallableDescriptorForTypeAliasObject ? (FakeCallableDescriptorForTypeAliasObject)$this$getOwnSinceKotlinVersion : null;
        if (substitutable3 != null) {
            substitutable2 = ((FakeCallableDescriptorForObject)substitutable3).getReferencedObject();
            SinceKotlinUtilKt.getOwnSinceKotlinVersion$consider(substitutable2, result2);
        }
        return (SinceKotlinValue)result2.element;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ClassDescriptor> loadWasExperimentalMarkerClasses(DeclarationDescriptor $this$loadWasExperimentalMarkerClasses) {
        ConstantValue<?> annotationClasses;
        AnnotationDescriptor wasExperimental = $this$loadWasExperimentalMarkerClasses.getAnnotations().findAnnotation(OptInNames.INSTANCE.getWAS_EXPERIMENTAL_FQ_NAME());
        if (wasExperimental != null && (annotationClasses = wasExperimental.getAllValueArguments().get(OptInNames.INSTANCE.getWAS_EXPERIMENTAL_ANNOTATION_CLASS())) instanceof ArrayValue) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = (Iterable)((ArrayValue)annotationClasses).getValue();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                ClassDescriptor classDescriptor;
                ClassDescriptor classDescriptor2;
                ClassifierDescriptor classifierDescriptor;
                KClassValue kClassValue;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                ConstantValue annotationClass = (ConstantValue)element$iv$iv;
                boolean bl2 = false;
                KClassValue kClassValue2 = kClassValue = annotationClass instanceof KClassValue ? (KClassValue)annotationClass : null;
                if (kClassValue == null) {
                    classifierDescriptor = null;
                } else {
                    KotlinType kotlinType = kClassValue.getArgumentType(DescriptorUtilsKt.getModule($this$loadWasExperimentalMarkerClasses));
                    TypeConstructor typeConstructor2 = kotlinType.getConstructor();
                    classifierDescriptor = typeConstructor2.getDeclarationDescriptor();
                }
                ClassifierDescriptor classifierDescriptor2 = classifierDescriptor;
                ClassDescriptor classDescriptor3 = classDescriptor2 = classifierDescriptor2 instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor2 : null;
                if (classDescriptor2 == null) continue;
                ClassDescriptor it$iv$iv = classDescriptor = classDescriptor2;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.emptyList();
    }

    private static final void getOwnSinceKotlinVersion$consider(DeclarationDescriptor $this$getOwnSinceKotlinVersion_u24consider, Ref.ObjectRef<SinceKotlinValue> result2) {
        block5: {
            ApiVersion apiVersion;
            block6: {
                ApiVersion apiVersion2;
                String string2;
                Map<Name, ConstantValue<?>> map;
                Collection<ConstantValue<?>> collection;
                ConstantValue constantValue;
                Object object = $this$getOwnSinceKotlinVersion_u24consider.getAnnotations().findAnnotation(AnnotationsKt.getSINCE_KOTLIN_FQ_NAME());
                String string3 = object == null ? null : ((constantValue = (ConstantValue)CollectionsKt.singleOrNull((Iterable)(collection = (map = object.getAllValueArguments()).values()))) == null ? null : constantValue.getValue());
                String string4 = string2 = string3 instanceof String ? (String)string3 : null;
                if (string2 == null) {
                    apiVersion2 = null;
                } else {
                    string3 = string2;
                    object = ApiVersion.Companion;
                    String p0 = string3;
                    boolean bl = false;
                    apiVersion2 = ((ApiVersion.Companion)object).parse(p0);
                }
                apiVersion = apiVersion2;
                if (apiVersion == null) break block5;
                if (result2.element == null) break block6;
                Object t = result2.element;
                Intrinsics.checkNotNull(t);
                if (apiVersion.compareTo(((SinceKotlinValue)t).getApiVersion()) <= 0) break block5;
            }
            result2.element = new SinceKotlinValue(apiVersion, SinceKotlinUtilKt.loadWasExperimentalMarkerClasses($this$getOwnSinceKotlinVersion_u24consider));
        }
    }
}

