/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.SuspendLimitationsCheckerKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/SuspendLimitationsChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "UNSUPPORTED_OPERATOR_NAMES", "", "Lorg/jetbrains/kotlin/name/Name;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
public final class SuspendLimitationsChecker
implements DeclarationChecker {
    @NotNull
    public static final SuspendLimitationsChecker INSTANCE = new SuspendLimitationsChecker();
    @NotNull
    private static final Set<Name> UNSUPPORTED_OPERATOR_NAMES;

    private SuspendLimitationsChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        PsiElement psiElement;
        boolean bl;
        Object it;
        Object object;
        KtModifierList ktModifierList;
        block6: {
            PsiElement psiElement2;
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            Intrinsics.checkNotNullParameter(context2, "context");
            if (!(descriptor2 instanceof FunctionDescriptor) || !((FunctionDescriptor)descriptor2).isSuspend()) {
                return;
            }
            if (((FunctionDescriptor)descriptor2).isOperator() && UNSUPPORTED_OPERATOR_NAMES.contains(((FunctionDescriptor)descriptor2).getName()) && (ktModifierList = declaration2.getModifierList()) != null && (psiElement2 = ktModifierList.getModifier(KtTokens.OPERATOR_KEYWORD)) != null) {
                it = object = psiElement2;
                boolean bl2 = false;
                context2.getTrace().report(Errors.UNSUPPORTED.on((PsiElement)it, "suspend operator \"" + ((FunctionDescriptor)descriptor2).getName() + '\"'));
            }
            Iterable $this$any$iv = descriptor2.getAnnotations();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                object = $this$any$iv.iterator();
                while (object.hasNext()) {
                    Object element$iv = object.next();
                    AnnotationDescriptor p0 = (AnnotationDescriptor)element$iv;
                    boolean bl3 = false;
                    if (!SuspendLimitationsCheckerKt.access$isKotlinTestAnnotation(p0)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl && (ktModifierList = declaration2.getModifierList()) != null && (psiElement = ktModifierList.getModifier(KtTokens.SUSPEND_KEYWORD)) != null) {
            it = object = psiElement;
            boolean bl4 = false;
            context2.getTrace().report(Errors.UNSUPPORTED.on((PsiElement)it, "suspend test functions"));
        }
    }

    static {
        Name[] nameArray = new Name[]{OperatorNameConventions.CONTAINS, OperatorNameConventions.GET, OperatorNameConventions.SET, OperatorNameConventions.PROVIDE_DELEGATE, OperatorNameConventions.GET_VALUE, OperatorNameConventions.SET_VALUE};
        UNSUPPORTED_OPERATOR_NAMES = SetsKt.setOf(nameArray);
    }
}

