/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization.linkerissues;

import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.linkerissues.KotlinIrLinkerIssue;
import org.jetbrains.kotlin.backend.common.serialization.linkerissues.KotlinIrLinkerIssuesKt;
import org.jetbrains.kotlin.backend.common.serialization.linkerissues.UserVisibleIrModulesSupport;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.utils.ResolvedDependency;
import org.jetbrains.kotlin.utils.ResolvedDependencyId;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000f\u001a\u00020\fH\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/linkerissues/SignatureIdNotFoundInModuleWithDependencies;", "Lorg/jetbrains/kotlin/backend/common/serialization/linkerissues/KotlinIrLinkerIssue;", "idSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "problemModuleDeserializer", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;", "allModuleDeserializers", "", "userVisibleIrModulesSupport", "Lorg/jetbrains/kotlin/backend/common/serialization/linkerissues/UserVisibleIrModulesSupport;", "(Lorg/jetbrains/kotlin/ir/util/IdSignature;Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;Ljava/util/Collection;Lorg/jetbrains/kotlin/backend/common/serialization/linkerissues/UserVisibleIrModulesSupport;)V", "errorMessage", "", "getErrorMessage", "()Ljava/lang/String;", "computeErrorMessage", "ir.serialization.common"})
public final class SignatureIdNotFoundInModuleWithDependencies
extends KotlinIrLinkerIssue {
    @NotNull
    private final IdSignature idSignature;
    @NotNull
    private final IrModuleDeserializer problemModuleDeserializer;
    @NotNull
    private final Collection<IrModuleDeserializer> allModuleDeserializers;
    @NotNull
    private final UserVisibleIrModulesSupport userVisibleIrModulesSupport;
    @NotNull
    private final String errorMessage;

    /*
     * WARNING - void declaration
     */
    public SignatureIdNotFoundInModuleWithDependencies(@NotNull IdSignature idSignature, @NotNull IrModuleDeserializer problemModuleDeserializer, @NotNull Collection<? extends IrModuleDeserializer> allModuleDeserializers, @NotNull UserVisibleIrModulesSupport userVisibleIrModulesSupport) {
        String string2;
        Intrinsics.checkNotNullParameter(idSignature, "idSignature");
        Intrinsics.checkNotNullParameter(problemModuleDeserializer, "problemModuleDeserializer");
        Intrinsics.checkNotNullParameter(allModuleDeserializers, "allModuleDeserializers");
        Intrinsics.checkNotNullParameter(userVisibleIrModulesSupport, "userVisibleIrModulesSupport");
        this.idSignature = idSignature;
        this.problemModuleDeserializer = problemModuleDeserializer;
        this.allModuleDeserializers = allModuleDeserializers;
        this.userVisibleIrModulesSupport = userVisibleIrModulesSupport;
        SignatureIdNotFoundInModuleWithDependencies signatureIdNotFoundInModuleWithDependencies = this;
        try {
            SignatureIdNotFoundInModuleWithDependencies signatureIdNotFoundInModuleWithDependencies2 = signatureIdNotFoundInModuleWithDependencies;
            string2 = this.computeErrorMessage();
        }
        catch (Throwable throwable) {
            void $this$errorMessage_u24lambda_u2d0;
            StringBuilder stringBuilder2;
            StringBuilder stringBuilder3 = stringBuilder2 = new StringBuilder();
            boolean bl = false;
            StringBuilder stringBuilder4 = $this$errorMessage_u24lambda_u2d0.append("Failed to compute the detailed error message. See the root cause exception.");
            Intrinsics.checkNotNullExpressionValue(stringBuilder4, "append(value)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder4.append('\n'), "append('\\n')");
            Intrinsics.checkNotNullExpressionValue($this$errorMessage_u24lambda_u2d0.append('\n'), "append('\\n')");
            $this$errorMessage_u24lambda_u2d0.append("Shortly: The required symbol " + this.idSignature.render() + " is missing in the module or module dependencies.");
            $this$errorMessage_u24lambda_u2d0.append(" This could happen if the required dependency is missing in the project.");
            $this$errorMessage_u24lambda_u2d0.append(" Or if there is a dependency that has a different version (without the required symbol) in the project");
            $this$errorMessage_u24lambda_u2d0.append(" than the version (with the required symbol) that the module was initially compiled with.");
            SignatureIdNotFoundInModuleWithDependencies signatureIdNotFoundInModuleWithDependencies3 = signatureIdNotFoundInModuleWithDependencies;
            String string3 = stringBuilder2.toString();
            Intrinsics.checkNotNullExpressionValue(string3, "StringBuilder().apply(builderAction).toString()");
            String string4 = string3;
            throw new RuntimeException(string4);
        }
        signatureIdNotFoundInModuleWithDependencies2.errorMessage = string2;
    }

    @Override
    @NotNull
    protected String getErrorMessage() {
        return this.errorMessage;
    }

    private final String computeErrorMessage() {
        StringBuilder stringBuilder2;
        StringBuilder $this$computeErrorMessage_u24lambda_u2d1 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        Map<ResolvedDependencyId, ResolvedDependency> allModules2 = this.userVisibleIrModulesSupport.getUserVisibleModules(this.allModuleDeserializers);
        ResolvedDependencyId problemModuleId = KotlinIrLinkerIssuesKt.access$getProblemModuleId(this.userVisibleIrModulesSupport, this.problemModuleDeserializer, allModules2);
        String problemModuleIdWithVersion = MapsKt.getValue(allModules2, problemModuleId).getModuleIdWithVersion();
        $this$computeErrorMessage_u24lambda_u2d1.append("Module \"" + problemModuleId + "\" has a reference to symbol " + this.idSignature.render() + '.');
        $this$computeErrorMessage_u24lambda_u2d1.append(" Neither the module itself nor its dependencies contain such declaration.");
        $this$computeErrorMessage_u24lambda_u2d1.append("\n\nThis could happen if the required dependency is missing in the project.");
        $this$computeErrorMessage_u24lambda_u2d1.append(" Or if there is a dependency of \"" + problemModuleId + "\" that has a different version in the project");
        $this$computeErrorMessage_u24lambda_u2d1.append(" than the version that \"" + problemModuleIdWithVersion + "\" was initially compiled with.");
        $this$computeErrorMessage_u24lambda_u2d1.append(" Please check that the project configuration is correct and has consistent versions of all required dependencies.");
        KotlinIrLinkerIssuesKt.access$appendPotentiallyConflictingDependencies($this$computeErrorMessage_u24lambda_u2d1, "The list of \"" + problemModuleIdWithVersion + "\" dependencies that may lead to conflicts:", allModules2, KotlinIrLinkerIssuesKt.access$findPotentiallyConflictingOutgoingDependencies(problemModuleId, allModules2), this.userVisibleIrModulesSupport.getModuleIdComparator());
        KotlinIrLinkerIssuesKt.access$appendProjectDependencies($this$computeErrorMessage_u24lambda_u2d1, allModules2, SetsKt.setOf(problemModuleId), "This module requires symbol " + this.idSignature.render(), this.userVisibleIrModulesSupport.getSourceCodeModuleId(), this.userVisibleIrModulesSupport.getModuleIdComparator());
        String string2 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        return string2;
    }
}

